unit Unit64BitDetect;

interface

type T64BitDetect = class(TObject)
    public
        class function Is64Bit(controlH : THandle) : boolean;
end;

implementation

uses Winapi.Windows, UnitFrmDebug;

type
  TIsWow64Proccess = function( Handle: THandle; var Iret: BOOL ): Winapi.Windows.BOOL; stdcall;
var  IsWow64Process : TIsWow64Proccess;


class function T64BitDetect.Is64Bit(controlH : THandle) : boolean;
var procH : Thandle;
    procID : cardinal;
    lb : LongBool;
begin
    result := false;
    if not assigned(IsWow64Process) then EXIT;
    IsWow64Process(GetCurrentProcess, lb);
    if not lb then EXIT;


    // if we get here, the routine exists and this 32 program
    // is running on a Win64 system
    GetWindowThreadProcessId(controlH, procID);
    procH := OpenProcess(
        PROCESS_QUERY_INFORMATION,
        false,
        procID
    );
    result := false;


    if IsWow64Process(procH, lb) then begin
        result := not lb;
        // no emulation means a 64 bit process
    end;

    CloseHandle(procH);
end;


initialization
begin
    IsWow64Process := GetProcAddress(
        GetModuleHandle('kernel32.dll'),
        'IsWow64Process'
    );
end;

finalization
begin
    TFrmDebug.MeOnlyAppend('Unit64BitDetect', false);
end;

end.
