unit UnitACPopupClicks;

interface

uses UnitClipQueue, UnitFrmConfig, UnitFramePopup,UnitACPopupPrototype, System.Types;

type
    TOverrideClick = (
    OC_NONE,
    OC_STAY_OPEN,
    OC_RIGHT_CLICK,
    OC_PIN_TO_LIST,
    OC_TITLEBAR_SHORTCUTS
);
type TACPopupClicks = class(TObject)
    private
        fLastClip : TClipItem;
        fLastString : string;
        MenuPoint : TPoint;
        fACPopup : TACPopup;
        fLastJavaScriptErr : string;
        NoErrorCue : boolean;
    protected
        function IsKeypressExecute(p : TACPopupItem) : boolean;
        function KeystrokeActivate(p : TACPopupItem; action : TClickAction; RequirePasteClip : boolean = true) : boolean;
        //procedure SendText(s : string; ci : TClipItem=nil; ForceFormatted : boolean = false);
        procedure SendPlainText(s : string);
        procedure SendClip(ci : TClipItem; ForceFormatted : boolean = false);
        procedure PasteAndFocus(PasteMode : integer; s : string; ci : TClipITem = nil; ForceFormatted : boolean = false);
    public
        procedure SetPopup(acpopup : TACPopup);

        procedure SendPermanentText(s : string; showErrorCue : boolean = true);

        function HandleKeypress(ca: TClickAction; p : TACPopupItem): boolean;
        function OverrideClickType(p : TACPopupItem;RequirePasteClip : boolean = true) :  TOverrideClick;
    	function IsStayOpenOnClick(p : TACPopupItem;RequirePasteClip : boolean = true) : boolean;
        function RightClickAction(p : TACPopupItem;RequirePasteClip : boolean = true) : boolean;
        function IsPinClick(p : TACPopupItem;RequirePasteClip : boolean = true) : boolean;
        procedure StayOpenClick(p : TACPopupItem);

        procedure SetMenuPoint(p : TPoint);

    	procedure PasteAllClick(Sender : TObject);
        procedure PasteAllFilesClick(Sender : TObject);

        procedure PopupClipClick(Sender : TObject);
        procedure RemovedClicked(Sender : TObject);
        procedure PasteMethodClick(Sender : TObject);
        procedure PermanentClipClick(Sender : TObject);
        procedure PermanentGroupClick(Sender : TObject);

        procedure ProgramOptionDisableMonitoring(Sender : TOBject);
        procedure ProgramOptionDisableRightClickPopup(Sender : TObject);
        procedure ProgramOptionExplorerCompat(Sender : TObject);

        procedure ToggleClipboardBar(Sender : TObject);
       	procedure EraseHistory(Sender : TObject);
        procedure PopupClipRightClip(Sender : TObject);
        procedure OpenWindowCommand(Sender : TObject);
        procedure RightClickHello(Sender : TObject);
        procedure ClipTypeClick(Sender : TObject);
        procedure ConfigurationPerProgram(Sender: TObject);

        procedure ToolMoreLessClick(Sender : TObject);
        procedure ToolProgramOptionsClick(Sender : TObject);
        procedure ToolSystemMenuClick(Sender : TObject);
        procedure ToolFilterClick(Sender : TObject);

        property LastJavaScriptErr : string read fLastJavaScriptErr;
end;

var ACPopupClicks : TACPopupClicks;

implementation

uses Classes, UnitMisc, UnitPaste, Windows, UnitPopupGenerate,
StrUtils, SysUtils, UnitFrmPermanentNew, UnitFrmClipboardManager, Graphics, UnitFrmEditTextExternal,
UnitMenuItemTagdata, UnitFrmSysTrayMenu, Forms, UnitFrmAbout, UnitFrmSearch,
UnitFrmEditHistory, UnitFrmPasteSelected, UnitFrmDummyClipboardBar,
Clipbrd, dialogs, Controls, Menus, UnitKeyboardQuery,
  UnitFrmTooltipNew, ShlObj, UnitFrmDebug, UnitClipDatabase,
  {UnitJScript,} UnitToken, UnitThreadAttach, UnitFocusManager, UnitFrmTextInspector;

procedure TACPopupClicks.ToolFilterClick(Sender: TObject);
begin
    self.fACPopup.ShowFilter(TACPopupITem(Sender));
end;
procedure TACPopupClicks.SetPopup(acpopup : TACPopup);
begin
    self.fACPopup := acpopup;
end;

function TACPopupClicks.KeystrokeActivate(p : TACPopupItem; action : TClickAction; RequirePasteClip : boolean = true) : boolean;
begin
    result := false;
    if RequirePasteClip and not (p.ItemType in TPastesOnClickj) then
        EXIT;


    result := (p.CtrlPressed) and (FrmConfig.GetCtrlClickAction in [action]);
    result := result or
        ((p.ShiftPressed) and (FrmConfig.GetShiftClickAction in [action]));
    result := result or
        ((p.MiddleClicked) and (FrmConfig.GetMiddleClickAction in [action]));
    result := result or
        ((p.TabPressed) and (FrmConfig.GetTabClickAction in [action]));
    result := result or
        ((p.AltPressed) and (FrmConfig.GetAltClickAction in [action]));
    result := result or
        ((p.TabPressed) and (FrmConfig.GetTabClickAction in [action]));

end;


procedure TACPopupClicks.ToolMoreLessClick(Sender : TObject);
var p : TACPopupITem;
begin
    fACPopup.FullMode := not fACPopup.FullMode;
    FACPopup.RefreshMenuItems;
end;
procedure TACPopupClicks.ToolProgramOptionsClick(Sender : TObject);
begin
    frmSysTrayMenu.ShowPopup();
    if GetForegroundWindow <> fACPopup.Handle then begin
        fACPopup.DoForceHide;
    end;
end;
procedure TACPopupClicks.ToolSystemMenuClick(Sender : TObject);
begin
    frmSysTrayMenu.ShowPopup;
    if (GetForegroundWindow <> fACPopup.Handle) and
        (facpopup.PopupMode.getModeNoOverride <> pdmPinned) then begin
        fACPopup.DoForceHide;
    end;
end;


function TACPopupClicks.OverrideClickType(p : TACPopupItem;RequirePasteClip : boolean = true) :  TOverrideClick;
begin
    result := OC_NONE;
    if IsPinClick(p, RequirePasteClip) then begin
        result := OC_PIN_TO_LIST;
    end else if IsStayOpenOnClick(p, RequirePasteClip) then begin
        result := OC_STAY_OPEN;
    end else if RightClickAction(p, RequirePasteClip) then begin
        result := OC_RIGHT_CLICK;
    end else if KeystrokeActivate(p, CA_Show_Titlebar_Shortcut_Keys, RequirePasteClip) then begin
        result := OC_TITLEBAR_SHORTCUTS;
    end;
end;
function TACPopupClicks.IsPinClick(p : TACPopupItem;RequirePasteClip : boolean = true) : boolean;
begin
    result := KeystrokeActivate(p, CA_Pin_Unpin_Clip, RequirePasteClip);
end;
function TACPopupClicks.IsStayOpenOnClick(p : TACPopupItem;RequirePasteClip : boolean = true) : boolean;
begin
    result := KeystrokeActivate(p, CA_Paste_and_Keep_Popup_Open, RequirePasteClip);
end;
function TACPopupClicks.RightClickAction(p : TACPopupItem;RequirePasteClip : boolean = true) : boolean;
begin
    result := KeystrokeActivate(p, CA_Show_RightClick_Menu, RequirePasteClip);
end;

procedure TACPopupClicks.StayOpenClick(p : TACPopupItem);
begin
	if p.CtrlPressed then begin
    	p.CtrlPressed := false;
        Paste.SendCTRL_Release;
    end else if p.ShiftPressed then begin
    	p.ShiftPressed := false;
        Paste.SendShift_Release;
    end else if p.MiddleClicked then begin
        p.MiddleClicked := false;
    end else if p.AltPressed then begin
        p.AltPressed := false;
        Paste.SendALT_Release;
    end;

    p.OnClick(p);
end;
function TACPopupClicks.IsKeypressExecute(p : TACPopupItem): boolean;
var
    ca : TClickAction;
    function TestForMimicWait(ca : TClickAction; vk : integer) : boolean;
    begin
        result := false;
        if ca = CA_Paste_using_Mimic_Typing then begin
            KeyboardQuery.WaitUntilRelease(vk);
            result := true;
        end;
    end;
begin
    result := false;
    if p.ctrlpressed or p.shiftpressed or p.MiddleClicked or p.AltPressed or p.TabPressed then begin
        result := true;
        if p.ctrlpressed then begin
            ca := FrmConfig.GetCtrlClickAction;
            if not TestForMimicWait(ca, VK_CONTROL) then begin
                Paste.SendCTRL_Release;
            end;
            self.HandleKeypress(ca, p);
        end;
        if p.shiftpressed then begin
            ca := FrmConfig.GetShiftClickAction;
            if not TestForMimicWait(ca, VK_SHIFT) then begin
        	    Paste.SendShift_Release;
            end;
            self.HandleKeypress(ca, p);
        end;
        if p.AltPressed then begin
            ca := FrmConfig.GetAltClickAction;
            if not TestForMimicWait(ca, VK_MENU) then begin
                Paste.SendALT_Release;
            end;
            self.HandleKeypress(ca, p)
        end;
        if p.MiddleClicked then begin
            self.HandleKeypress(FrmConfig.GetMiddleClickAction, p);
        end;
        if p.TabPressed then begin
            self.HandleKeypress(frmconfig.GetTabClickAction, p);
        end;
    end;
end;

procedure TACPopupClicks.OpenWindowCommand(Sender: TObject);
var ow : TACOpenWindowFlag;
    procedure ShowForm(f : TForm);
    begin
        Windows.SetForegroundWindow(frmConfig.Handle);
        f.show;
        TFocusManager.ForceForeground(f.Handle )
    end;


begin
    FrmMainPopup.SkipFocusReturnOnce;
    with Sender as TACPopupItem do begin
        ow := TACOpenWindowFlag(IntegerData);
        case ow of
        owConfiguration: ShowForm(FrmConfig);
        owEditHistory: begin
            frmEditHistory.ShowPopup;
            ShowForm(frmEditHistory);
        end;
        owRemovedClips: begin
            frmEditHistory.ShowRemoved;
            ShowForm(frmEditHistory);
        end;
        owPermanentClips: begin
            if (PermanentGroupID = -1) then begin
                frmEditHistory.ShowPermanent;
            end else begin
                frmEditHistory.ShowPermanent(PermanentGroupID);
            end;

            ShowForm(frmEditHistory);
        end;
        owPasteSelected: FrmPasteSelected.ShowaAutomated;
        owSearch: begin
            frmSearch.ShowAutomatted(FrmMainPopup.TargetData.ForegroundWindow);
        end;
        owEditClipboard: begin
            frmEditTextExternal.EditClip(clip);
        end;
        owAbout: ShowForm(frmAbout);
        owTextInspector: begin
            FrmTextInspector.show;
        end;
        end;
    end;
end;

procedure TACPopupClicks.PasteAllClick(Sender: TObject);
var
	s : string;
	i : integer;
    ci : TClipItem;
begin
    with Sender as TACPopupItem do begin
        s := '';
        for i := 0 to (ClipQueue.GetQueueCount  - 1) do begin
            ci := ClipQueue.GetClipItem(i);

            s := s + ci.GetAsPlaintext;

            if (Cardinal(i) = (ClipQueue.GetQueueCount  - 1)) then begin
            end else begin
                s := s + #13#10;
            end;
        end;

        self.SendPlainText(s);
    end;
end;
procedure TACPopupClicks.PasteAllFilesClick(Sender : TObject);
var
	s : string;
	i, len : integer;
    ci : TClipItem;
    hGlobal : THandle;
    hdrop: PDropFiles;
begin
    with Sender as TACPopupItem do begin
        s := '';

        for i := 0 to (PinnedClipQueue.GetQueueCount  - 1) do begin
            ci := PinnedClipQueue.GetClipItem(i);

            if ci.GetFormatType = FT_FILE then begin
                s := s + ci.GetAsPlaintext + #0;
            end;
        end;
        for i := 0 to (ClipQueue.GetQueueCount  - 1) do begin
            ci := ClipQueue.GetClipItem(i);

            if ci.GetFormatType = FT_FILE then begin
                s := s + ci.GetAsPlaintext + #0;
            end;
        end;
        if (s <> '') then begin
            s := s + #0;
            len := Length(s) * SizeOf(char);

            hGlobal := GlobalAlloc(
                GMEM_SHARE or GMEM_MOVEABLE or GMEM_ZEROINIT, SizeOf(TDropFiles) + len
            );
            hdrop := GlobalLock(hGlobal);
                hdrop^.pFiles := SizeOf(TDropFiles);
                hdrop^.fWide := true;
                Move(s[1], (PByte(hdrop) + SizeOf(TDropFiles))^, Len);
            GlobalUnlock(hGlobal);
            Clipboard.SetAsHandle(CF_HDROP, hGlobal);
        end;
    end;
end;
procedure TACPopupClicks.PasteMethodClick(Sender: TObject);
begin
    with Sender as TACPopupItem do begin
        Paste.AssignPaste(FrmMainPopup.TargetData.ExeName,TPasteMethod(IntegerData));

        case TPasteMethod(IntegerData) of
        PASTE_DEFAULT: Paste.ClearOnceFlags;
        PASTE_CTRL_V: Paste.SetUsePasteCVOnce;
        PASTE_SHIFT_INS: paste.SetUsePasteSIOnce;
        PASTE_MIMIC: paste.SetKeyboardMimicOnce;
        PASTE_CLIPBOARD: paste.SetClipboardOnlyOnce;
        PASTE_PROGRAMCUSTOMMACRO:
            begin
                paste.SetUseCustomScriptOnce;
                paste.SetPasteMacro(frmSysTrayMenu.GetProgramMacro(FrmMainPopup.TargetData.ExeName) );
            end;
        end;
    end;
end;
procedure TACPopupClicks.SetMenuPoint(p : TPoint);
begin
    MenuPoint := p;
end;

procedure TACPopupClicks.PermanentClipClick(Sender: TObject);
var
    p : TACPopupItem;
    ci : TClipITem;
    location : string;
begin
    p := TACPopupItem(sender);
    with Sender as TACPopupItem do begin
        if IsKeypressExecute(p) then EXIT;

        location := FrmPermanent.GetPermanentPath;
        if PermanentGroupID <> -1 then begin
            location := FrmPermanent.PermFoldersGetItem(PermanentGroupID);
        end;
        ci := TPermanentClipItem.Create;;
        TClipDatabase.LoadPermanent(ci,PermanentID, location);

        //self.SendClip(ci);
        self.SendClip(ci, FrmConfig.rbFormattedOnly.Checked);
        myfree(ci);
    end;
end;
procedure TACPopupClicks.PermanentGroupClick(Sender: TObject);
begin
     with Sender as TACPopupItem do begin
         FrmPermanent.SetPermanentGroup(PermanentGroupID);
         FrmPermanent.AssignPIG(FrmMainPopup.TargetData.ExeName); 
     end;
end;
procedure TACPopupClicks.PopupClipClick(Sender: TObject);
var pasted : boolean;
begin


    with Sender as TACPopupItem do begin

    self.fLastClip := clip;
    if IsKeypressExecute(TACPopupItem(sender)) then EXIT;

    if clip.HasText or (clip.GetFormat = CF_HDROP)  then begin
        fLastString := clip.GetAsPlaintext;
    end else begin
        fLastString := '';
        //fLastString := clip.GetAsText;
    end;


    FrmDebug.AppendLog('MenuItem format=' + clip.GetFormatName );



    pasted := false;
    {Force as clip only if it's unicode, or if Formatted is the default}
    if (clip  <> nil) and (clip.GetFormatType  <> FT_UNKNOWN) then begin
        // handle FormattedOnly and PlainAndFormatted here
        if (not Paste.GetKeyboardMimicOnce) then begin
            if (not FrmConfig.rbPlainOnly.Checked) and
            (clip.GetFormatType in [FT_UNICODE, FT_RICHTEXT, FT_HTML]) then begin
                FrmDebug.AppendLog('Sending UNICODE or Formatted');
                self.SendClip(clip, FrmConfig.rbFormattedOnly.Checked);
                pasted := true;
            end;
        end;
    end;

    if (not pasted) then begin
        if fLastString = '' then begin
            FrmDebug.AppendLog('Sending as Normal clip');
            self.SendClip(clip);
        end else begin
        	FrmDebug.AppendLog('forching Plain text only (CF_HDROP)');
            self.SendPlainText(fLastString);
        end;
        FrmDebug.AppendLog('inserting done');
    end;

    if frmconfig.cbMoveFirst.Checked then
        ClipQueue.MoveToStart( ClipQueue.IndexOf(clip) );
    end;
end;

procedure TACPopupClicks.PopupClipRightClip(Sender: TObject);
begin
     with Sender as TACPopupItem do begin
     end;
end;

procedure TACPopupClicks.ProgramOptionDisableMonitoring(Sender: TOBject);
begin
    FrmSysTrayMenu.ToggletDisabledEXE(FrmMainPopup.TargetData.ExeName);
end;
procedure TACPopupClicks.ProgramOptionDisableRightClickPopup(Sender: TObject);
begin
    frmSysTrayMenu.ToggleNoRightClickEXE(FrmMainPopup.TargetData.ExeName);
end;
procedure TACPopupClicks.ProgramOptionExplorerCompat(Sender : TObject);
begin
    frmSysTrayMenu.ToggleExplorerCompatEXE(FrmMainPopup.TargetData.ExeName);
end;

procedure TACPopupClicks.RemovedClicked(Sender: TObject);
var
    pi : TACPopupItem;
    ci : TClipItem;
begin
    pi := TACPopupItem(sender);
    ci := RemovedQueue.GetItemClip(pi.IntegerData);

    if IsKeypressExecute(pi) then EXIT;
    self.SendClip(ci);

    myfree(ci);
end;

procedure TACPopupClicks.RightClickHello(Sender: TObject);
begin

end;

procedure TACPopupClicks.ToggleClipboardBar(Sender: TObject);
begin
    with Sender as TACPopupItem do begin
    if assigned(frmClipboardBar) then begin
        if checked then frmconfig.LoadClipboardBarState;
        frmClipboardBar.SetSizePos(
        	BoundRect.Right,frmClipboardBar.Top,
            frmClipboardBar.width,frmClipboardBar.height
        );

        frmClipboardBar.SetVisible(Checked);
    end;
    end;
end;
procedure TACPopupClicks.ClipTypeClick(Sender: TObject);
begin
    with Sender as TACPopupItem do begin
        SendClip(clip, TRUE);
    end;
end;

procedure TACPopupClicks.EraseHistory(Sender: TObject);
var s : string;
begin

    with Sender as TACPopupItem do begin
        case TPopupEraseFlag(IntegerData) of
        peCLipboard: s := 'the Clipboard';
        pePopupClips: s := 'the Popup Clips';
        peRemovedClips: s := 'the Removed Clips';
        peEverything: s := 'All Clips';
        end;

        if MessageDlg('Erase '+s+'?',mtConfirmation,mbYesNo, 0) <> Controls.mrYes then
        EXIT;

        case TPopupEraseFlag(IntegerData) of
        peCLipboard: begin
            frmClipboardManager.ClearClipboard;
        end;
        pePopupClips: begin
            frmEditHistory.FlushPopup;
        end;
        peRemovedClips: begin
            frmEditHistory.FlushRemoved;
        end;
        peEverything: begin
            frmClipboardManager.ClearClipboard;
            frmEditHistory.FlushPopup;
            frmEditHistory.FlushRemoved;
        end;
        end;
    end;
end;


///
/// Pasting Stuff
///
const
    PASTEMODE_TEXT = 1;
    PASTEMODE_CLIP = 2;
    PASTEMODE_PERMANENT = 3;

procedure TACPopupClicks.PasteAndFocus(PasteMode : integer; s : string; ci : TClipITem = nil; ForceFormatted : boolean = false);
var prefix : string;
    isMacro, isJavaScript, b, focus : boolean;
    tt : TFrmTooltipNew;
    pci : TPermanentClipItem;
    ta : TThreadAttach;
begin
    Windows.SetLastError(ERROR_SUCCESS);
    isMacro := false;
    isJavaScript := false;

    if (PasteMode = PASTEMODE_PERMANENT) then begin
        if (ci=nil) then begin
            pci := TPermanentClipItem.Create;
            pci.SetFromPlainText(s);
        end else begin
            pci := TPermanentClipItem(ci);
        end;
        isMacro := pci.ClipType = PCT_MACRO;
        isJavaScript := pci.ClipType = PCT_JAVASCRIPT;
        if isMacro then begin
            b := UnitToken.DeleteFromStart(s, KEYS_IGNORENL_STR) = '';
            if b then
                UnitToken.DeleteFromStart(s, KEYS_STR);
            Paste.SetIgnoreNewlines(not b);
            Paste.ParseMacro(s);
        end;
        if (ci=nil) then begin
            MyFree(pci);
        end;
    end;

    //
    // Since the popup may have stolen focus from the target,
    // it must be given keyboard focus again
    //
    focus := FrmMainPopup.GetNeedsFocus;
    case PasteMode of
    PASTEMODE_PERMANENT:
        begin
            if (ismacro) then begin
                focus := FrmMainPopup.GetNeedsFocus and paste.MacroRequiresFocus;
            end else if (isJavaScript) then begin
                focus := true;
                fLastJavaScriptErr := '';
            end
        end;
    else
        begin
            focus := FrmMainPopup.GetNeedsFocus;
        end;
    end;

    if (focus) then begin
        TFocusManager.SetOn(FrmMainPopup.TargetData.ForegroundWindow,FrmMainPopup.TargetData.focuscontrol);
    end;

    b := Paste.GetClipboardOnlyOnce {or paste.GetClipboardOnly};

    case PasteMode of
    PASTEMODE_PERMANENT:
        begin
            if (isMacro) then begin
                paste.ExecuteMacro;
            end else if (isJavaScript) then begin
                fLastJavaScriptErr := Paste.SendJavaScript(s, FrmMainPopup.TargetData.ForegroundWindow);
                if (fLastJavaScriptErr<>'') and (not NoErrorCue) then begin
                    FrmMainPopup.showCue('ArsClip' ,'error executing JavaScript');
                    FrmDebug.AppendLog('JavaScript: ' + fLastJavaScriptErr);
                end;
            end else begin
                Paste.SendClip(ci, ForceFormatted);
            end;
        end;
    PASTEMODE_TEXT:
        begin
            Paste.SendPlainText(s);
        end;
    PASTEMODE_CLIP:
        begin
            Paste.SendClip(ci, ForceFormatted);
        end;
    end;

    if (not isMacro) and (not isJavaScript) and (
        (Paste.GetPasteMethod(FrmMainPopup.TargetData.ExeName) = PASTE_CLIPBOARD)
        or b
    ) then begin
        FrmMainPopup.showCue('ArsClip',' Clipboard Only');
    end;

    FrmMainPopup.SkipFocusReturnOnce;
//    if (focus) then begin
//        ta.Detach;
//        myfree(ta);
//    end;
end;
procedure TACPopupClicks.SendPermanentText(s : string; ShowErrorCue : boolean=true);
var b : boolean;
begin
    NoErrorCue := not showErrorCue;
    PasteAndFocus(PASTEMODE_PERMANENT, s);
end;
procedure TACPopupClicks.SendClip(ci : TClipItem; ForceFormatted : boolean = false);
begin
    if (ci is TPermanentClipItem) then begin
        PasteAndFocus(PASTEMODE_PERMANENT, ci.GetAsPlaintext, ci, ForceFormatted);
    end else begin
        PasteAndFocus(PASTEMODE_CLIP, '', ci, ForceFormatted);
    end;

end;
procedure TACPopupClicks.SendPlainText(s : string);
begin
    PasteAndFocus(PASTEMODE_TEXT, s);
end;




function TACPopupClicks.HandleKeypress(ca: TClickAction; p : TACPopupItem): boolean;
var
    i : integer;
    ci : TClipItem;
    procedure MoveToFirstCheck;
    begin
        if not frmConfig.cbMoveFirst.Checked then EXIT;

        case p.ItemType of
        IT_POPUPCLIP:
                ClipQueue.MoveToStart( ClipQueue.IndexOf(p.Clip) );
        IT_TEMP:
                frmClipboardManager.DisablePasteProtectionOnce;
        end;
    end;
begin

    result := true;

    case p.ItemType of
    IT_TEMP :
        begin
            ci := RemovedQueue.GetItemClip(p.IntegerData);
        end;
    else
        begin
            ci := p.Clip;
        end;
    end;

    case ca of
        CA_Run:; //self.Run1Click(self);
        CA_RemoveUndelete: begin
            if (ci = nil) or (p.ItemType=IT_TEMP) then EXIT;

            if (ClipQueue.IndexOf(ci) = -1)  then begin
                // Can't Undelete or Remove
            end else begin
                i := ClipQueue.IndexOf(ci);
                 ClipQueue.DeleteItem(i);
            end;
        end;
        CA_Destroy_Clip: begin
            // Destroy Item -- bad programmer being lazy and re-using and old menu item
            if ci = nil then EXIT;

            TFocusManager.ForceForeground(FrmMainPopup.Handle);
            if (MessageDlg('Destroy: Permanently delete this item?', mtConfirmation, mbYesNo,0) = mrYes) then begin
                case p.ItemType of
                IT_POPUPCLIP:
                    begin
                        if ClipQueue.IndexOf(ci) <> -1 then begin
                            clipqueue.DestroyItem(ClipQueue.IndexOf(ci));
                        end;
                    end;
                IT_TEMP:
                    begin
                        RemovedQueue.DeleteItem(p.IntegerData);

                    end;

                end;
            end;
        end;                        //self.DestroyClick(self);
        CA_Edit_Clip: Begin
            frmEditTextExternal.EditClip(ci);
        end;                           //self.EditText1Click(self);
        CA_Edit_Clip_as_file: begin
            frmEditTextExternal.EditClip(ci);
        end;
        CA_Paste_using_Mimic_Typing: begin      {self.MimicTyping1Click(self); result := false;}
            Paste.SetKeyboardMimicOnce;
            self.SendClip(ci);
        end;
        CA_Paste_on_Clipboard_only: begin       {self.PasteusingMimicTyping1Click(self); result := false;}
            Paste.SetClipboardOnlyOnce;
            MoveToFirstCheck;
            self.SendClip(ci);
        end;
        CA_Paste_using_ShiftInsert: begin       {self.PasteusingSHIFTINS1Click(self); result := false;}
            Paste.SetUsePasteSIOnce;
            MoveToFirstCheck;
            self.SendClip(ci);
        end;
        CA_Paste_using_CtrlV: begin             {self.PasteusingCTRLV1Click(self); result := false;}
            paste.SetUsePasteCVOnce;
            MoveToFirstCheck;
            self.SendClip(ci);
        end;
        CA_Make_Permanent_Clip: begin
            if p.ItemType <> IT_PERMANENT then
                frmEditHistory.ShowPermanent(ci);
        end;
        CA_Make_Permanent_Clip_as_Plain_Text: begin
            if p.ItemType <> IT_PERMANENT then
                frmEditHistory.ShowPermenentAs(ci.GetAsPlaintext);
        end;
        CA_Show_RightClick_Menu: begin

        end;
        CA_Paste_as_Plaintext_only: begin
            MoveToFirstCheck;
            self.SendPlainText(ci.GetAsPlaintext);
        end;
        CA_Pin_Unpin_Clip: begin
            case p.ItemType of
            IT_POPUPCLIP: begin
                PinnedClipQueue.InsertAtStart(ci);
            end;
            IT_PINNED: begin
                PinnedClipQueue.DeleteItem( PinnedClipQueue.IndexOf(ci));
            end;
            end;
        end;
        CA_Paste_as_Formatted_only: begin
            ACPopupClicks.ClipTypeClick(p);
        end
    else
        result := false;
    end;

    case p.ItemType of
    IT_TEMP :
        begin
            myfree(ci);
        end;
    end;

end;
procedure TACPopupClicks.ConfigurationPerProgram(Sender: TObject);
begin
    frmconfig.pcPanels.ActivePageIndex := frmconfig.tsProgramOptions.PageIndex;
    frmconfig.SetSelectedProgram(FrmMainPopup.TargetData.ExeName);
    frmSysTrayMenu.ConfigureMenuItemClickEvent(self);


end;






initialization
begin
    ACPopupClicks := TACPopupClicks.Create;
end;

finalization
begin
    TFrmDebug.MeOnlyAppend('UnitACPopupClicks', false);
    myfree(ACPopupClicks);
end;
end.
