unit UnitACPopupConfig;

interface

uses Classes, Graphics;

type TACConfig = interface
    function getTooltipMaxWidth : integer;
    function getTooltipMaxHeight : integer;
    function getTooltipDelayMS : integer;
    function getAutoCollapse : boolean;
    function getAutoExpandOnHover : boolean;
    function getMenuMaxWidth : integer;
    function getMenuMinimumHeight : integer;
    function GetAccelAlphaNumeric : string;
    function getAccelSymbols : string;
    function getUseKeyboard : boolean;
    function getNeedsFocus : boolean;
    function getAltActionText : string;
    function getCtrlActionText : string;
    function getShiftActionText : string;
    function getFont : TFont;
    function getUseThumbnails : Boolean;
    function getReturnFocusWhenPinned : boolean;
    function getUseDoubleHeight : boolean;
end;

type TACDefaultConfig = class(TInterfacedObject, TACConfig)
    private
        fFont : TFont;
    public
        constructor Create;
        destructor Destroy; override;
        function getTooltipMaxWidth : integer;
        function getTooltipMaxHeight : integer;
        function getTooltipDelayMS : integer;
        function getAutoCollapse : boolean;
        function getAutoExpandOnHover : boolean;
        function getMenuMaxWidth : integer;
        function getMenuMinimumHeight : integer;
        function GetAccelAlphaNumeric : string;
        function getUseKeyboard : boolean;
        function getNeedsFocus : boolean;
        function getAltActionText : string;
        function getCtrlActionText : string;
        function getShiftActionText : string;
        function getFont : TFont;
        function getUseThumbnails : Boolean;
        function getReturnFocusWhenPinned : boolean;
        function getAccelSymbols : string;
        function getUseDoubleHeight : boolean;
end;
type TACPopupConfig = class(TInterfacedObject, TACConfig)
    private
        fFont : TFont;
    public
        constructor Create;
        destructor Destroy; override;
        function getTooltipMaxWidth : integer;
        function getTooltipMaxHeight : integer;
        function getTooltipDelayMS : integer;
        function getAutoCollapse : boolean;
        function getAutoExpandOnHover : boolean;
        function getMenuMaxWidth : integer;
        function getMenuMinimumHeight : integer;
        function GetAccelAlphaNumeric : string;
        function getUseKeyboard : boolean;
        function getNeedsFocus : boolean;
        function getAltActionText : string;
        function getCtrlActionText : string;
        function getShiftActionText : string;
        function getFont : TFont;
        function getUseThumbnails : Boolean;
        function getReturnFocusWhenPinned : boolean;
        function getAccelSymbols : string;
        function getUseDoubleHeight : boolean;
end;


implementation

uses Windows, SysUtils, UnitFrmConfig, UnitPopupGenerate, UnitMisc, UnitFrmDebug;

constructor TACDefaultConfig.Create;
begin
    fFont := TFont.Create;
    if (Win32MajorVersion >= 6) then begin
        fFont.Name :='Segoe UI';
    end else begin
        fFont.Name := 'Arial';
    end;
    fFont.Color := clWindowText;
    fFont.Size := 9;
end;
destructor TACDefaultConfig.Destroy;
begin
    MyFree(fFont);
end;
function TACDefaultConfig.getTooltipMaxWidth : integer;
begin
    Result := 320;
end;
function TACDefaultConfig.getTooltipMaxHeight : integer;
begin
    result := 320;
end;
function TACDefaultConfig.getTooltipDelayMS : integer;
begin
    Result := 500;
end;
function TACDefaultConfig.getAutoCollapse : boolean;
begin
    result := false;
end;
function TACDefaultConfig.getAutoExpandOnHover : boolean;
begin
    result := false;
end;
function TACDefaultConfig.getMenuMaxWidth : integer;
begin
    result := 320;
end;
function TACDefaultConfig.getMenuMinimumHeight : integer;
begin
    result := 16;
end;
function TACDefaultConfig.GetAccelAlphaNumeric : string;
begin
    Result := '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ';
end;
function TACDefaultConfig.getUseKeyboard : boolean;
begin
    result := true;
end;
function TACDefaultConfig.getNeedsFocus : boolean;
begin
    result := true;
end;
function TACDefaultConfig.getAltActionText : string;
begin
    result := ''
end;
function TACDefaultConfig.getCtrlActionText : string;
begin
    result := ''
end;
function TACDefaultConfig.getShiftActionText : string;
begin
    result := '';
end;
function TACDefaultConfig.getFont : TFont;
begin
    Result := fFont;
end;
function TACDefaultConfig.getUseThumbnails : Boolean;
begin
    Result := false;
end;
function TACDefaultConfig.getReturnFocusWhenPinned : boolean;
begin
    Result := true;
end;
function TACDefaultConfig.getAccelSymbols : string;
begin
    result := '-=[]\;'',./~!@#$%^&*()_+{}|:"<>?`';
end;
function TACDefaultConfig.getUseDoubleHeight : boolean;
begin
    result := false;
end;


constructor TACPopupConfig.Create;
begin
    fFont := TFont.Create;
    if (Win32MajorVersion >= 6) then begin
        fFont.Name :='Segoe UI';
    end else begin
        fFont.Name := 'Arial';
    end;
    fFont.Color := clWindowText;
    fFont.Size := 9;
end;
destructor TACPopupConfig.Destroy;
begin
    FrmDebug.AppendLog('UnitACPopupConfig Destroy', false);
    myfree(fFont);
end;
function TACPopupConfig.getTooltipMaxWidth : integer;
begin
    Result := frmConfig.UDToolWidth.Position;
end;
function TACPopupConfig.getTooltipMaxHeight : integer;
begin
    result := frmConfig.UDToolHeight.Position;
end;
function TACPopupConfig.getTooltipDelayMS : integer;
begin
    Result := FrmConfig.tbTooltipDelay.Position;
end;
function TACPopupConfig.getAutoCollapse : boolean;
begin
    result := true;
end;
function TACPopupConfig.getAutoExpandOnHover : boolean;
begin
    result := FrmConfig.cbAutoExpand.checked;
end;
function TACPopupConfig.getMenuMaxWidth : integer;
begin
    result := FrmConfig.UDWidth.Position;
end;
function TACPopupConfig.getMenuMinimumHeight : integer;
begin
    result := FrmConfig.udMinHeight.Position;
end;
function TACPopupConfig.GetAccelAlphaNumeric : string;
begin
    Result := frmconfig.GetAccelAlphaNumeric;
end;
function TACPopupConfig.getUseKeyboard : boolean;
begin
    result := frmconfig.cbUseKeyboard.Checked;
end;
function TACPopupConfig.getNeedsFocus : boolean;
begin
    result := FrmMainPopup.GetNeedsFocus;
end;
function TACPopupConfig.getAltActionText : string;
begin
    result := frmConfig.cbxAltClickAction.text
end;
function TACPopupConfig.getCtrlActionText : string;
begin
    result := frmConfig.cbxCtrlClickAction.text;
end;
function TACPopupConfig.getShiftActionText : string;
begin
    result := frmConfig.cbxShiftClickAction.text;
end;
function TACPopupConfig.getFont : TFont;
begin
    Result := FrmConfig.GetFont;
end;
function TACPopupConfig.getUseThumbnails : Boolean;
begin
    Result := not FrmConfig.cbNoThumbnails.Checked;
end;
function TACPopupConfig.getReturnFocusWhenPinned : boolean;
begin
    Result := frmConfig.getReturnPopupFocusWhenPinned;
end;
function TACPopupConfig.getAccelSymbols : string;
begin
    result := FrmConfig.GetAccelSymbols;
end;
function TACPopupConfig.getUseDoubleHeight : boolean;
begin
    result := FrmConfig.cbDoubleHeight.Checked;
end;



initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitACPopupCOnfig', false);
end;


end.
