unit UnitClipMenu2;

interface

uses UnitACPopupPrototype, UnitClipQueue, Classes, Graphics, UnitMenuItemTagdata;

type TClipMenu2 = class(TACPopupPrototype, TClipMenu)
    protected
        fci : TClipItem;
        fgroup, findex : integer;
        fformat : TClipFormatType;
        isPopup : boolean;

        fOnEditClip,
        fOnRemoveClip,
        fOnDestroyClip,
        fOnPasteClip,
        fOnMakePermanentClip,
        fOnFormMode,
        fOnHide : TNotifyEvent;

        fcmTop, fcmLeft : integer;

        facpopupitemX : TACPopupItem;
        fpopupItemType : TItemType;
        fpopupFormatType : TClipFormatType;
        fpopupIntegerData : integer;
        fpopupTop : integer;
        fpopupLeft : integer;
        ShowMoreMode : boolean;
        populated : boolean;
        procedure HandleCustomButton(Sender: TObject);
        procedure HandleButtonClick;

        procedure btnPinClick(Sender: Tobject);
        procedure btnDeleteClick(Sender: TObject);
        procedure btnPasteAsClick(Sender: TObject);
        procedure btnEditClick(Sender: TObject);
        procedure btnDestroyClick(Sender: TObject);
        procedure AsFormatClick(Sender: TObject);
        procedure AsFile1Click(Sender: TObject);
        procedure AsPlainClick(Sender: TObject);
        procedure ClipboardOnly1Click(Sender: TObject);
        procedure ShiftInsert1Click(Sender: TObject);
        procedure CTRLV1Click(Sender: TObject);
        procedure MimickTyping1Click(Sender: TObject);
        procedure btnPasteClick(Sender: TObject);
        procedure btnMoreClick(Sender: TObject);
        procedure asPlaintext1Click(Sender: TObject);
        procedure asClip1Click(Sender: TObject);


        procedure PreHandleCaptionViaKeystroke(p : TACPopupITem; key : char); override;

        procedure ExpandHandler(Sender : TObject);
    public
        constructor Create(AOwner: TComponent); override;
        procedure AutoPopulate;  override;

        procedure setOnEditClip(ne : TNotifyEvent);
        procedure setOnRemoveClip(ne : TNotifyEvent);
        procedure setOnDestroyClip(ne : TNotifyEvent);
        procedure setOnPasteClip(ne : TNotifyEvent);
        procedure setOnMakePermanentClip(ne : TNotifyEvent);
        procedure setOnFormMode(ne : TNotifyEvent);
        procedure setOnHide(ne : TNotifyEvent);



        procedure SetACPopupItem(p : TACPopupItem);
        function GetACPopupItem : TACPopupItem;
        procedure SetPermanentClip(group, index : integer; format : TClipFormatType);
        procedure SetPopupClipMode;
        procedure SetPermanentClipMode;
        procedure Show;
        procedure Hide;

        procedure ReportKeypress(key : Char); overload;
        procedure ReportKeypress(key : Word); overload;
        procedure SetCustomButton(index: integer; caption, clip : string);

        function MouseInMenu : boolean;

        procedure setTop(value : integer);
        procedure setLeft(value : integer);


        procedure ClipMenuShow(rightclick : boolean = false);  override;
        function ClipMenuVisible : boolean; override;
        procedure ClipMenuReportKey(key : Char); overload; override;
        procedure ClipMenuReportKey(key : word); overload; override;
        procedure ClipMenuHide; override;

        procedure PerformDefaultAction;
        procedure ShowEX(top, left : integer; showUnder : boolean = false);

end;

implementation

uses  UnitFrmConfig, System.Types, Vcl.Controls, SysUtils,
UnitToken, StrUtils, UnitPopupGenerate, UnitMisc, UnitACPopupClicks, UnitPaste,
UnitFrmClipboardManager, Windows, Vcl.Dialogs, UnitFrmEditTextExternal,
UnitFrmEditItem, UnitFrmEditHistory, UnitFrmPermanentNew, UnitDropFile,
UnitClipDatabase, UnitFocusManager, Math, Forms, UnitFrmDebug;


constructor TClipMenu2.Create(AOwner: TComponent);
begin
    inherited create(AOwner);
    fDisabledColor := clGrayText;
    self.fShowShadow := false;
    self.fCanFocus := false;
    self.showcaption := false;
    self.fUseExpandedShortcuts := false;
    self.populated := false;

    self.Width := 150;
    GetCanvas.font.Size := 9;
end;


procedure TClipMenu2.PerformDefaultAction;
begin
    case FrmConfig.GetIconClickAction of
    CBXICONCLICKACTION_EDIT:
        btnEditClick(self);
    CBXICONCLICKACTION_PIN:
        btnPinClick(self);
    CBXICONCLICKACTION_DELETE:
        btnDeleteClick(self);
    CBXICONCLICKACTION_DESTROY:
        btnDestroyClick(self);
    CBXICONCLICKACTION_CLIPBOARD:
        ClipboardOnly1Click(self);
    CBXICONCLICKACTION_MIMIC:
        MimickTyping1Click(self);
    CBXICONCLICKACTION_SHIFTINSERT:
        ShiftInsert1Click(self);
    CBXICONCLICKACTION_CTRLV:
        CTRLV1Click(self);
    end;
end;



procedure TClipMenu2.ClipMenuShow(rightclick: Boolean = False);
begin
end;
procedure TClipMenu2.ClipMenuReportKey(key: Char);
begin

end;
procedure TClipMenu2.ClipMenuReportKey(key : word);
begin

end;
procedure TClipMenu2.ClipMenuHide;
begin
end;
function TClipMenu2.ClipMenuVisible;
begin
    result := false;
end;

procedure TClipMenu2.AutoPopulate;
    procedure setCommon(p : TACPopupItem; caption : string);
    begin

        if Self.UseKeyboard then begin
            p.UseAutoPrefix := True;
            p.Caption := caption;
            DetectKeystroke(p, false);
        end else begin
            p.caption := StringReplace(caption,'&','',[rfReplaceAll]);
        end;
        p.ItemType := IT_NONE;
    end;
    procedure SetCommonSubButton(p : TACPopupItem; caption : string);
    begin
        setCommon(p, caption);
    end;
var
    p, pSub, pPlain, pFormat, pFile,
    pPin, pEdit, pDelete, pDestroy,
    pPermanent : TACPopupItem;
    PasteAsVisible : boolean;

    procedure MakeExpandable(pSub : TACPopupItem; caption : string; configedVisible : boolean);
    begin
        setCommon(pSub, caption);
        pSub.Visible := (configedVisible or showmoremode) or not IsPopup;
        pSub.IsExpandable := true;
        pSub.Expanded :=configedVisible;
        pSub.OnClick := ExpandHandler;
        if pSub.Visible then pSub.Expanded := true;
        if pSub.Expanded then pSub.SmallCaption := true;

        if pSub.Expanded then pSub.Disabled := true;
    end;
    procedure PinToListItem;
    begin
        p := self.Add;
        p.OnClick := self.btnPinClick;
        p.StayOpenOnClick := true;
        setCommon(p, 'P&in to List');
        p.Visible := (frmconfig.cbClipMenuPin.Checked or ShowMoreMode) and isPopup;
        pPin := p;

        p.CaptionBold := FrmConfig.GetIconClickAction = CBXICONCLICKACTION_PIN;
        if (isPopup) then begin
            if fpopupItemType = IT_CLIPBOARD then p.Visible := false;
            if fpopupItemType = IT_PINNED then begin
                setCommon(p, 'Unpin from &List');
            end;
        end;
    end;
    procedure EditItem;
    begin
        p := self.Add;
        p.OnClick := self.btnEditClick;
        SetCommon(p, '&Edit');
        p.Visible := FrmConfig.cbClipMenuEdit.Checked or ShowMoreMode;
        if not isPopup then begin
            p.Visible := true;
        end;
        pEdit := p;

        p.CaptionBold := FrmConfig.GetIconClickAction = CBXICONCLICKACTION_EDIT;
    end;
    procedure DeleteItem;
    begin
        p := self.Add;
        p.OnClick := self.btnDeleteClick;
        SetCommon(p,'&Delete');
        p.Visible := isPopup and (frmconfig.cbClipMenuDelete.Checked or ShowMoreMode);
        pDelete := p;
        p.CaptionBold := FrmConfig.GetIconClickAction = CBXICONCLICKACTION_DELETE;
    end;
    procedure DestroyItem;
    begin
        p := self.Add;
        p.OnClick := self.btnDestroyClick;
        SetCommon(p, 'De&stroy');
        p.Visible := isPopup and (frmconfig.cbClipMenuDestroy.Checked or ShowMoreMode);
        pDestroy := p;
        p.CaptionBold := FrmConfig.GetIconClickAction = CBXICONCLICKACTION_DESTROY;
        if (isPopup) then begin
            if fpopupItemType = IT_CLIPBOARD then p.Visible := false;
        end;
    end;

    procedure PasteUsingItem;
    var
        isText : boolean;
        isScript : Boolean;
        pc : TPermanentClipItem;
    begin


       pSub := self.Add;
       MakeExpandable(pSub, 'Paste &Using', frmconfig.cbClipMenuPasteUsing.Checked);
       pSub.ItemType := CM_PASTE_USING;

        isScript := false;
        if not isPopup then begin
            FrmPermanent.PermFolderPush;
            FrmPermanent.SetPermanentGroup(self.fgroup);
            pc := TPermanentClipItem( FrmPermanent.GetItemClip(self.findex) );
            isScript := pc.ClipType in [PCT_MACRO, PCT_JAVASCRIPT];
            FrmPermanent.PermFolderPop;
        end;

    pSub.Disabled := pSub.Expanded;
        p := pSub.Add;
        p.OnClick := self.MimickTyping1Click;
        SetCommonSubButton(p,'Mimic &Typing');
        p.CaptionBold := FrmConfig.GetIconClickAction = CBXICONCLICKACTION_MIMIC;
        p.Disabled := (isPopup and not fci.HasText) or
            (not isPopup and not (facpopupitemx.PermanentType in [FT_UNICODE, FT_TEXT]));
        if isScript then begin
            p.Disabled := true;
        end;
        p := pSub.Add;
        p.OnClick := self.ShiftInsert1Click;
        SetCommonSubButton(p,'Shift+&Insert');
        p.CaptionBold := FrmConfig.GetIconClickAction = CBXICONCLICKACTION_SHIFTINSERT;
        p.Disabled := isScript;

        p := pSub.Add;
        p.OnClick := self.CTRLV1Click;
        SetCommonSubButton(p,'Ctrl+&V');
        p.CaptionBold := FrmConfig.GetIconClickAction = CBXICONCLICKACTION_CTRLV;
        p.Disabled := isScript;

        p := pSub.Add;
        p.OnClick := self.ClipboardOnly1Click;
        SetCommonSubButton(p,'Clipboard &Only');
        p.CaptionBold := FrmConfig.GetIconClickAction = CBXICONCLICKACTION_CLIPBOARD;
        p.Disabled := isScript;
    end;
    procedure PasteAsItem;
    begin
        if not isPopup then EXIT;
       pSub := self.Add;;
       MakeExpandable(pSub, '&Paste As', frmconfig.cbClipMenuPasteAs.Checked);
       pSub.ItemType := CM_PASTE_AS;
        pSub.Visible := pSub.Visible and not (fci = nil);
        PasteAsVisible := pSub.Visible;

    pSub.OnClick := ExpandHandler;
    pSub.ItemType := CM_PASTE_AS;
        p := pSub.Add;
        p.OnClick := self.AsPlainClick;
        SetCommonSubButton(p,'Plai&ntext Only');
        p.Visible := false;
        pPlain := p;

        p := pSub.Add;
        p.OnClick := self.AsFormatClick;
        SetCommonSubButton(p,'Fo&rmat ');
        p.Visible := false;
        pFormat := p;


        p := pSub.Add;
        p.OnClick := self.AsFile1Click;
        SetCommonSubButton(p,'&File');
        pFile := p;
        p.visible := isPopup;


        if PasteAsVisible and not (fci.GetFormatType in [FT_UNICODE, FT_TEXT, FT_PICTURE])  then begin
            pPlain.Visible := true;
            case fci.GetFormatType of
            FT_HTML, FT_RICHTEXT: begin
                pPlain.Visible := true;
                pFormat.Caption := 'Fo&rmatted Text';
            end;
            FT_FILE:
                begin
                    pPlain.Visible := true;
                    pFormat.Caption := 'Fo&rmat: File(s)';
                    pFile.Visible := false;
                end
            else
                pFormat.Caption := 'Fo&rmat';
            end;
        end;
    end;
    procedure MakePermanentItem;
    var p2 : TACPopupItem;
    begin
        if not isPopup then EXIT;

        pSub := self.Add;
        MakeExpandable(pSub, '&Make Permanent', frmconfig.cbClipMenuPermanent.Checked);
        pSub.ItemType := CM_MAKE_PERMANENT;
        if pSub.Visible and not ShowMoreMode then begin
            pSub.Expanded := false;
            pSub.SmallCaption := False;
            pSub.Disabled := false;
        end;

        p := pSub.Add;
        p.OnClick := self.asPlaintext1Click;
        SetCommonSubButton(p,'as Plainte&xt');
        p2 := p;

        p := pSub.Add;
        p.OnClick := self.asClip1Click;
        SetCommonSubButton(p,'&as Clip');
        if isPopup then begin
            p.Caption := '[No Format Found]';
            case fci.GetFormatType of
            FT_UNICODE: begin
                p.Caption := '&as Unicode';
                p.Visible := false;
            end;
            FT_PICTURE: begin
                p.Caption := '&as Picture';
            end;
            FT_HTML: begin;
                p.Caption := '&as HTML';
            end;
            FT_RICHTEXT: begin
                p.Caption := '&as Rich Text';
            end;
            FT_FILE: begin
                p.Caption := '&as Files';
            end;
        end;

    end;
    end;

    procedure ShowMoreItem;
    begin
        p := self.Add;
        p.OnClick := self.btnMoreClick;
        if (ShowMoreMode) then begin
            setCommon(p, '&Configure ...');
        end else begin
            setCommon(p, 'S&how More +');
        end;
        p.Visible := isPopup;
        p.StayOpenOnClick := True;
    end;
    procedure MakeCustomMenus;
    var i, j : integer;
        b : TACPopupItem;
    begin
        j := 1;
        for i := 0 to FrmConfig.GetCustomCount-1 do begin
            b := self.Add;
            b.OnClick := self.HandleCustomButton;
            b.Visible := FrmConfig.GetCustomChecked(i) and isPopup;
            b.Hint := IntToStr(i);
            if b.Visible then begin
                if (j >=1) and (j<=9) then begin
                    setCommon(b, '&'+IntToStr(j) + '  ' + frmconfig.GetCustomCaption(i));
                end else begin
                    setCommon(b, frmconfig.GetCustomCaption(i));
                end;
                inc(j);
            end;
        end;
    end;
    procedure HandlePopupMode;
    begin
        if (isPopup) then begin
            case fpopupItemType of
            IT_TEMP: begin
               pDestroy.Disabled := true;
            end;
            IT_PINNED: begin
                pPin.Caption := 'Unpin from &List';
                pPin.Disabled := false;

                pEdit.Disabled := false;

                pDelete.Disabled := true;
                pDestroy.Disabled := true;
            end;
            IT_POPUPCLIP: begin
                pPin.Disabled := false;
                pPin.Caption := 'Pin to &List';
            end;
            IT_PERMANENT:begin
                pDelete.Disabled := true;
                pDestroy.Disabled := true;
                pPermanent.Disabled := true;
            end;
            IT_CLIPBOARD: begin
                pDestroy.Disabled := true;
            end;
            end;
        end;
    end;
begin
    self.Reset;
    self.populated := true;

    PinToListItem;
    if isPopup and pPin.visible then
        self.AddLine;

    EditItem;
    DeleteItem;
    DestroyItem;
    PasteUsingItem;
    PasteAsItem;
    p := self.Add;
    p.OnClick := self.AsFile1Click;
    SetCommon(p, 'Paste As: &File');
    p.Visible := false;
    MakePermanentItem;
    ShowMoreItem;
    if isPopup then
        self.AddLine;

    MakeCustomMenus;
end;

procedure TClipMenu2.setTop(value: Integer);
begin
    fcmTop := value;
end;
procedure TClipMenu2.setLeft(value: Integer);
begin
    fcmLeft := value;
end;
procedure TClipMenu2.setOnEditClip(ne: TNotifyEvent);
begin
    fOnEditClip := ne;
end;
procedure TClipMenu2.setOnRemoveClip(ne: TNotifyEvent);
begin
    fOnRemoveClip := ne;
end;
procedure TClipMenu2.setOnDestroyClip(ne: TNotifyEvent);
begin
    fOnDestroyClip := ne;
end;
procedure TClipMenu2.setOnPasteClip(ne: TNotifyEvent);
begin
    fOnPasteClip := ne;
end;
procedure TClipMenu2.setOnMakePermanentClip(ne: TNotifyEvent);
begin
    fOnMakePermanentClip := ne;
end;
procedure TClipMenu2.setOnFormMode(ne: TNotifyEvent);
begin
    fOnFormMode := ne;
end;
procedure TClipMenu2.setOnHide(ne: TNotifyEvent);
begin
    fOnHide := ne;
end;



procedure TClipMenu2.SetACPopupItem(p: TACPopupItem);
begin
    fpopupItemType := p.ItemType;
    fpopupFormatType := p.PermanentType;
    fci := p.Clip;
    if fpopupItemType in [IT_POPUPCLIP, IT_CLIPBOARD] then begin
        SetPopupClipMode;
    end;
    fpopupIntegerData := p.IntegerData;
    fpopupTop := p.Top;
    fpopupLeft := p.left;
    facpopupitemx := p;
end;
procedure TClipMenu2.SetPermanentClip(group: Integer; index: Integer;  format : TClipFormatType);
begin
    SetPermanentClipMode;
    self.fgroup := group;
    fformat := format;
    findex := index;
end;
procedure TClipMenu2.SetPopupClipMode;
begin
    self.isPopup := true;
end;
procedure TClipMenu2.SetPermanentClipMode;
begin
    self.isPopup := False;
end;
procedure TClipMenu2.Show;
begin
    if not fShowing then begin
        if not populated then self.AutoPopulate;
        self.ShowPopup(fcmLeft, fcmTop);
    end;
end;
procedure TClipMenu2.ShowEX(top, left : integer; showUnder : boolean = false);
    procedure CheckForVisibility;
    begin
        self.Top := (max(screen.DesktopRect.top, self.top));
        self.Left := (max(screen.DesktopRect.left, self.Left));

        if self.Width + self.Left > screen.DesktopRect.right  then begin
            self.left := screen.DesktopRect.right - self.Width;
        end;
        if self.Height + self.Top > screen.DesktopRect.bottom then begin
            self.top := screen.DesktopRect.bottom - self.Height;
        end;
    end;
    procedure setPosition;
    begin
        {under or leftside}
        self.AutoPopulate;
        self.CalcTotalSize();
        if ShowUnder then begin
            self.setTop(Top + fpopupTop);
            self.setLeft(mouse.CursorPos.X - 40);
        end else begin
            if (self.Top <> fpopupTop) then begin
                self.setTop(Top + fpopupTop-2);
                self.setLeft(left + fpopupLeft -  self.Width);
            end;
        end;

        CheckForVisibility;
    end;
begin
    if not showing then begin
        setPosition;
        self.ShowPopup(fcmLeft, fcmTop, TRUE);
    end;
end;

procedure TClipMenu2.HandleCustomButton(Sender: TObject);
var i,j : integer;
    s,s2,token : string;
begin
    i := StrToInt(TACPopupItem(Sender).hint);


    // INDEX and STAYOPEN are fake macro commands only used by the Custom Buttons
    //

    // TODO: handle Current Clipboard case

    s := uppercase( frmconfig.GetCustomData(i) );
    s2 := TokenString(s,'[INDEX=',false);
    if (s<>'') then begin
        //[INDEX=$i]
        token := TokenString(s,']',false);
        s := frmconfig.GetCustomData(i);
        s := StringReplace(s,'[index='+token+']', '',[rfReplaceAll,rfIgnoreCase]);
        s := StringReplace(s,token, IntToStr(fpopupIntegerData),[rfReplaceAll,rfIgnoreCase]);
    end else begin
        s := frmconfig.GetCustomData(i);
    end;


    self.Hide;
    if ContainsText(s,'[STAYOPEN]') then begin
        s := StringReplace(s,'[STAYOPEN]', '',[rfReplaceAll,rfIgnoreCase]);
        FrmMainPopup.SkipFocusReturnOnce;
        CallEventSafe(fOnFormMode, self);
        FrmMainPopup.SendCustomClip(s);
        CallEventSafe(fOnFormMode, self);
        CallEventSafe(fOnRemoveClip, self);
        //TODO: investigate this - fOnRemoveClip bug?
    end else begin
        FrmMainPopup.SendCustomClip(s);
    end;
end;

procedure TClipMenu2.Hide;
begin
    if fShowing then begin
        inherited Hide;
        self.populated := false;

        if assigned(OnHideEvent) then
            OnHideEvent(Self);

        ShowMoreMode := false;

        self.facpopupitemX := nil;

        //self.Reset;
        // Can't reset here, calling program may want data
        // after a hide call
    end;
end;
procedure TClipMenu2.ReportKeypress(key: Char);
begin
    Self.KeyDown(word(key),[]);
    Self.KeyUp(word(key),[]);
    self.KeyPress(key);
end;
procedure TClipMenu2.ReportKeypress(key: Word);
begin
    if key = VK_RIGHT then self.hide;

    self.ReportKeypress(Char(key));
end;
procedure TClipMenu2.SetCustomButton(index: Integer; caption: string; clip: string);
begin

end;

function TClipMenu2.GetACPopupItem;
begin
    result := facpopupitemx;
end;
function TClipMenu2.MouseInMenu : boolean;
begin
    result := PtInRect(self.BoundsRect, mouse.CursorPos)
end;
procedure TClipMenu2.PreHandleCaptionViaKeystroke(p : TACPopupITem; key : char);
begin

end;
procedure TClipMenu2.HandleButtonClick;
begin
    self.Hide;
end;

procedure TClipMenu2.btnPinClick(Sender: Tobject);
var i : integer;
begin

    case fpopupItemType of
    IT_POPUPCLIP: begin
        PinnedClipQueue.InsertAtStart(fci);
    end;
    IT_PINNED: begin
        PinnedClipQueue.DeleteItem( PinnedClipQueue.IndexOf(fci));
    end;
    end;

    self.Hide;
    CallEventSafe(fOnRemoveClip, Self);
end;
procedure TClipMenu2.btnDeleteClick(Sender: TObject);
var i, j : integer;
    procedure deletePopupClip;
        var i : integer;
    begin
        i := ClipQueue.IndexOf(fci);
        if (i <> -1) then begin
            ClipQueue.DeleteItem(i);
        end;
    end;
begin
	case fpopupItemType of
    IT_CLIPBOARD: begin
        frmClipboardManager.ClearClipboard;
    end;
    IT_POPUPCLIP: begin
        deletePopupClip;
    end;
    IT_PINNED: begin
        i := PinnedClipQueue.IndexOf(fci);
        j := ClipQueue.IndexOf(fci);
        if (i<> -1) then begin
            PinnedClipQueue.DeleteItem(i);
            // duplicate clip will be moved to top in ClipQueue, delete it
            if (j<>-1) then begin
                ClipQueue.DeleteItem(0);
            end;
        end;
    end;
    end;

    self.Hide;
    CallEventSafe(fOnRemoveClip, self);
end;
procedure TClipMenu2.btnDestroyClick(Sender: TObject);
    procedure destroyClip;
    begin
        if ClipQueue.IndexOf(fci) <> -1 then begin
            clipqueue.DestroyItem(ClipQueue.IndexOf(self.fci));
            CallEventSafe(fOnDestroyClip, self);
        end;
    end;
var i : integer;
begin
    Windows.SetForegroundWindow(self.Handle);

    if (MessageDlg('Destroy: Permanently delete this item?', mtConfirmation, [mbyes, mbno],0) = mrYes) then begin
        case fpopupItemType of
        IT_POPUPCLIP: begin
            destroyClip;
        end;
        IT_PINNED: begin
            i := PinnedClipQueue.IndexOf(fci);
            if (i<> -1) then begin
                PinnedClipQueue.DeleteItem(i);
                destroyClip;
            end;
        end;
        end;
    end;
end;
procedure TClipMenu2.btnEditClick(Sender: TObject);
begin
    FrmMainPopup.SkipFocusReturnOnce;
    CallEventSafe(fOnEditClip, self);
    self.HandleButtonClick;

    case fpopupItemType of
    IT_CLIPBOARD, IT_POPUPCLIP, IT_PINNED:
        begin
            if frmConfig.cbEditClipWindow.checked then begin
                FrmEditItem.SetText(fci.GetAsPlaintext, nil);
                FrmMainPopup.ShowPreviewEditForm;
            end else begin
                frmEditTextExternal.EditClip(self.fci);
            end;
        end;
    IT_PERMANENT:
        begin
            FrmEditHistory.ShowPermanent(fgroup, findex);
            TFocusManager.ForceForeground(frmEditHistory.Handle)
        end;
    end;

end;


procedure TClipMenu2.btnPasteAsClick(Sender: TObject);
begin

    //self.AutoSize := false;
    //ExpandPasteAsMenu;
   // RedoOrder;
    //self.AutoSize := true;

    //FixPosition;
end;
procedure TClipMenu2.AsPlainClick(Sender: TObject);
var s : string;
begin
    if isPopup then begin
        FrmMainPopup.SendPlainText(fci.GetAsPlaintext);
    end else begin
        s := FrmPermanent.GetItemText(findex, fgroup);
        FrmMainPopup.SendPlainText(s);
    end;
end;
procedure TClipMenu2.AsFile1Click(Sender: TObject);
var ci : TClipItem;
    s : string;
    procedure PasteClipAsFile(c : TClipItem);
    begin
        if FrmMainPopup.TargetData.DropFilesCompatible then begin
            UnitDropFile.DropFile(c,  FrmMainPopup.TargetData.ForegroundWindow);
        end else begin
            UnitDropFile.DropFile(c);
        end;
    end;
begin
    self.HandleButtonClick;
    CallEventSafe(fOnPasteClip, self);

    if isPopup then begin
        PasteClipAsFile(fci);
    end else begin
        ci := TClipItem.Create;
        TClipDatabase.LoadPermanent(ci, findex, FrmPermanent.PermFoldersGetItem(fgroup));
        PasteClipAsFile(ci);
        myfree(ci);
    end;
end;
procedure TClipMenu2.AsFormatClick(Sender: TObject);
begin
    self.HandleButtonClick;
    CallEventSafe(fOnPasteClip, self);
    Paste.SendClip(fci, TRUE);
end;

procedure TClipMenu2.btnPasteClick(Sender: TObject);
begin
end;
procedure TClipMenu2.MimickTyping1Click(Sender: TObject);
var
    s : string;
begin
    self.HandleButtonClick;
    CallEventSafe(fOnPasteClip, self);
//    FrmMainPopup.ShowPopupCallback(nil);  // close the popup

    MySleep(200);
    if isPopup then begin
        Paste.SetKeyboardMimicOnce;
        FrmMainPopup.SendPlainText(fci.GetAsPlaintext);
    end else begin
        s := FrmPermanent.GetItemText(findex,fgroup);

        Paste.SetKeyboardMimicOnce;
        FrmMainPopup.SendPlainText(s);
    end;
end;
procedure TClipMenu2.CTRLV1Click(Sender: TObject);
var
    s : string;
begin
    self.HandleButtonClick;
    CallEventSafe(fOnPasteClip, self);

    if isPopup then begin
        Paste.SetUsePasteCVOnce;
        FrmMainPopup.SendClip(fci);
    end else begin
        s := FrmPermanent.GetItemText(findex, fgroup);
        Paste.SetUsePasteCVOnce;
        FrmMainPopup.SendPlainText(s);
    end;
end;
procedure TClipMenu2.ShiftInsert1Click(Sender: TObject);
var
    s : string;
begin
    self.HandleButtonClick;
    CallEventSafe(fOnPasteClip, self);

    if isPopup then begin
        Paste.SetUsePasteSIOnce;
        FrmMainPopup.SendClip(fci);
    end else begin
        s := FrmPermanent.GetItemText(findex, fgroup);
        Paste.SetUsePasteSIOnce;
        FrmMainPopup.SendPlainText(s);
    end;
end;
procedure TClipMenu2.ClipboardOnly1Click(Sender: TObject);
var
    s : string;
    ci : TClipItem;
begin
    self.HandleButtonClick;
    CallEventSafe(fOnPasteClip, self);

    if isPopup then begin
        ci := fci;
    end else begin
        ci := FrmPermanent.GetItemClip(findex, fgroup);
    end;

    Paste.SetClipboardOnlyOnce;
    FrmMainPopup.SendClip(ci);

    // FrmPermanent owns the clip list
//    if (not isPopup) then begin
//        myfree(ci);
//    end;
end;


procedure TClipMenu2.asClip1Click(Sender: TObject);
begin
    CallEventSafe(fOnMakePermanentClip, self);
    self.HandleButtonClick;
    FrmEditHistory.showPermanent(fci);
end;
procedure TClipMenu2.asPlaintext1Click(Sender: TObject);
begin
    CallEventSafe(fOnMakePermanentClip, self);
    self.HandleButtonClick;
    frmEditHistory.ShowPermenentAs(fci.GetAsPlaintext);
end;


procedure TClipMenu2.btnMoreClick(Sender: TObject);
begin
    if ShowMoreMode then begin
        self.HandleButtonClick;

        FrmConfig.showPage(frmConfig.tsclipmenu);
        FrmConfig.Show;
        TFocusManager.ForceForeground(frmconfig.Handle);
    end else begin
        ShowMoreMode := true;
        self.RebuildPopup();

    end;
end;

procedure TClipMenu2.ExpandHandler(Sender : TObject);
var
    p : TACPopupItem;
begin
    p := TACPopupItem(Sender);

    if p.Expanded then begin
        p.Disabled := true;
        p.SmallCaption := true;
    end;
end;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitClipMenu', false);
end;


end.
