unit UnitDestinationList;

interface

uses UnitMiscCom;

type TDestinationList = class(TObject)
    private
        fdl : ICustomDestinationList;
        doa : IObjectArray;
        MaxSlots : Cardinal;
    public
        constructor Create;
        destructor Destroy; override;
        procedure BeginUpdate;
        procedure AddUserTasks(oa : IObjectArray);
        procedure EndUpdate;
end;

implementation

uses ComObj, UnitFrmDebug;

{ TDestinationList }

procedure TDestinationList.AddUserTasks(oa: IObjectArray);
begin
    fdl.AddUserTasks(oa);
end;

procedure TDestinationList.BeginUpdate;
begin
  doa := fdl.BeginList(MaxSlots, @IID_IObjectArray);
end;

constructor TDestinationList.Create;
begin
    inherited;
   fdl := CreateComObject(CLSID_CustomDestinationList) as ICustomDestinationList;
    {fdl.SetAppID('ArsClip_joejoesoft.com');}
end;

destructor TDestinationList.Destroy;
begin
    inherited;
end;

procedure TDestinationList.EndUpdate;
begin
    FrmDebug.AppendLog('UnitDestinationList', false);
    fdl.CommitList;
end;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitDestinationList', false);
end;

end.
