unit UnitEXCategoryPanel;

{
NOTE:

    Interceptor Class for TCategoryPanel
    - lets me do some custom drawing
}

interface




uses ExtCtrls, VCL.Graphics;

type TCategoryPanel = class(ExtCtrls.TCategoryPanel)
strict private
   fSpecialDraw : boolean;

   function isSPecialDraw : boolean;
protected
   procedure DrawCollapsedPanel(ACanvas: TCanvas); override;
   procedure DrawHeaderBackground(ACanvas: TCanvas); override;
   procedure DrawHeaderCaption(ACanvas: TCanvas); override;
   function GetCollapsedHeight: Integer; override;
   procedure DrawHeaderChevron(ACanvas: TCanvas); override;

public
    property SpecialDraw : boolean read fSpecialDraw write fSpecialDraw;

end;

implementation

uses System.Types;

function TCategoryPanel.isSPecialDraw : boolean;
begin
    //result := self.Name = 'cpNewGroup';
    result := fSpecialDraw;
end;
procedure TCategoryPanel.DrawHeaderCaption(ACanvas: TCanvas);
var cpg : TCategoryPanelGroup;
    r : TRect;
    left, top : integer;
begin
    if isSPecialDraw and self.Collapsed then begin
        cpg := TCategoryPanelGroup(self.Parent);

        ACanvas.Pen.Color := clBlack;
        top := (HeaderHeight - ACanvas.TextHeight(self.text)) div 2;

        left := 16+8;

        r.left := self.clientRect.left + left - 2;
        r.Top := self.clientrect.top + top;
        r.Height := ACanvas.TextHeight(self.text) + 2;
        r.Width := ACanvas.TextWidth(self.text) + 2;

        ACanvas.TextOut(self.ClientRect.left + left, self.ClientRect.top + top, self.text);

    end else begin
        inherited DrawHeaderCaption(ACanvas);
    end;
end;

procedure TCategoryPanel.DrawHeaderBackground(ACanvas: TCanvas);
var cpg : TCategoryPanelGroup;
    swidth : integer;
    r : TRect;
begin
    if (isSPecialDraw) then begin
        ACanvas.Brush.Color := clWhite;

        cpg := TCategoryPanelGroup(self.Parent);

        r := self.clientrect;
        r.Height := self.GetCollapsedHeight;

        ACanvas.FillRect(r);

    end else begin
        Inherited DrawHeaderBackground(ACanvas);
    end;
end;
procedure TCategoryPanel.DrawHeaderChevron(ACanvas: TCanvas);
begin
    if isSPecialDraw then begin

    end else begin
        inherited DrawHeaderChevron(ACanvas);
    end;
end;


procedure TCategoryPanel.DrawCollapsedPanel(ACanvas: TCanvas);
begin
    if isSPecialDraw then begin
        ACanvas.Brush.Color := clWhite;
        ACanvas.FillRect(self.ClientRect);
    end else begin
        inherited DrawCollapsedPanel(ACanvas);
    end;
end;

function TCategoryPanel.GetCollapsedHeight: Integer;
begin
    Result := HeaderHeight;
end;





end.
