unit UnitFolderMonitor;

interface

uses Windows, Classes, SysUtils, Messages, VCL.Dialogs;

type TFolderMonitorThread = class(TThread)
    private
        h : THandle;
        folder : string;
        fOnChange : TNotifyEvent;

        procedure DoNotification;
    public
        procedure Execute; override;
end;


type TFolderMonitor = class(TObject)
    private
        folder : string;
        thread : TFolderMonitorThread;
        fOnChange : TNotifyEvent;

    public
        procedure SetFolder(f : string);
        procedure Cancel;
        destructor Destroy; override;
    property
        OnChange :  TNotifyEvent read fOnChange write fOnChange;

end;


var FolderMonitor : TFolderMonitor;

implementation

uses UnitMisc, UnitFrmDebug;


destructor TFolderMonitor.Destroy;
begin
    if assigned(thread) then
        thread.Terminate;
    thread := nil;
    inherited;
end;
procedure TFolderMonitor.SetFolder(f : string);
begin
    f := IncludeTrailingBackslash(f);
    if (f <> '') then begin
        // kill thread and re-create each time

        if thread <> nil then begin
            thread.Terminate;
        end;
        thread := TFolderMonitorThread.Create(True);
        thread.folder := f;
        thread.FreeOnTerminate := true;
        self.folder := f;
        thread.fOnChange := self.fOnChange;

        thread.Start;
    end;

end;
procedure TFolderMonitor.Cancel;
begin
    if thread <> nil then
        self.thread.Terminate;
end;

procedure TFolderMonitorThread.DoNotification;
begin
    FrmDebug.AppendLog('Folder Monitor: End');
    if Assigned(fOnChange) then begin
        FOnChange(nil);
    end;
end;

// NOTE: NO VCL/GUI stuff without a Synch call

procedure TFolderMonitorThread.Execute;
var c : Cardinal;
    i : integer;
begin
    Synchronize(
        procedure
        begin
            FrmDebug.AppendLog('FolderMonitor: start');
        end
    );
    h := INVALID_HANDLE_VALUE;
    i := 0;
    while (h = INVALID_HANDLE_VALUE) do begin
        h := FindFirstChangeNotification(
            pchar(folder),
            false,
            {FILE_NOTIFY_CHANGE_ATTRIBUTES or}
            FILE_NOTIFY_CHANGE_FILE_NAME or
            FILE_NOTIFY_CHANGE_LAST_WRITE or
            FILE_NOTIFY_CHANGE_CREATION
        );
        inc(i);
        if (i=10) then BREAK;
        mysleep(100);
    end;

    if (h = INVALID_HANDLE_VALUE) then begin
        Synchronize(
            procedure
            begin
                FrmDebug.AppendLog('FolderMonitor: Unable to monitor folder');
            end
        );
    end else begin
        repeat
            c := WaitForSingleObject(h, 1000);
        until (c <> WAIT_TIMEOUT) or self.Terminated;

        FindCloseChangeNotification(h);

        if not self.Terminated then begin
            Synchronize(
                DoNotification
            );
        end;
        h := 0;
    end;
end;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFolderMonitor', false);
end;


end.
