unit UnitFrameHTMLEdit;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.OleCtrls, SHDocVw_TLB,
  Vcl.ExtCtrls, Vcl.StdCtrls;

type
  TFrameHTMLEdit = class(TFrame)
    WebBrowser1: TWebBrowser;
  private
    { Private declarations }
    htmlClip : string;
  public
    { Public declarations }
    procedure setHTMLFromClip(clip : string);
    procedure setAsPlaintext(text : string);
    function getHTMLClip : string;
    function getPlainTextClip : string;
    function extractHTMLfromClip(clip : string) : string;
  end;

implementation

{$R *.dfm}

uses SHDocVw, MSHTML, UnitToken, UnitMisc, System.StrUtils;


function TFrameHTMLEdit.extractHTMLfromClip(clip : string ): string;
var sr : TStreamReader;
    ss : TStringStream;
    line : string;
    idxStart, idxEnd, sz : integer;

    function extractNumber(s : string) : Integer;
    var numstr : string;
    begin
         numstr := UnitToken.TokenString(s, ':');
         try
            result := strtoint(s);
         except

         end;
    end;
begin
    ss := TStringStream.Create;
    ss.Clear;
    ss.WriteString(clip);
    ss.Position := 0;

    sr := TStreamReader.Create(ss);

    line := sr.ReadLine; // version
    line := sr.ReadLine; // start HTML
    idxStart := extractNumber(line);
    line := sr.ReadLine; // end HTML;
    idxEnd := extractNumber(line);
    sz :=  idxEnd - idxstart;

    result := System.StrUtils.MidStr(clip, idxStart+1, sz);

    myfree(ss);
    myfree(sr);

end;
function TFrameHTMLEdit.getPlainTextClip : string;
var hd2 : IHTMLDocument2;
    currentSelection : IHTMLSelectionObject;
    range : IHTMLTxtRange;
begin
    hd2 := (WebBrowser1.Document as IHTMLDocument2);
    result := hd2.body.innerText;

//    hd2.ExecCommand('SelectAll', false, 0);
//    currentSelection := hd2.selection;
//    range := currentSelection.createRange() as IHTMLTxtRange;
//    result := range.text;
end;
procedure TFrameHTMLEdit.setHTMLFromClip(clip : string);
var
    Doc: Variant;
begin
    if not Assigned(webBrowser1.Document) then begin
        webBrowser1.Navigate('about:blank');
    end;

    htmlClip := clip;

    // not Script errors
    WebBrowser1.Silent := true;

    Doc := webBrowser1.Document;
    Doc.Clear;
    Doc.Write( extractHTMLfromClip(clip) );
    Doc.designMode := 'on';
    Doc.Close;
end;
function TFrameHTMLEdit.getHTMLClip : string;
begin
    result := htmlClip;
end;
procedure TFrameHTMLEdit.setAsPlaintext(text : string);
var doc : Variant;
    ihd2 : IHTMLDocument2;
begin
    if not Assigned(webBrowser1.Document) then begin
        webBrowser1.Navigate('about:blank');
    end;
//    ihd2 := (webBrowser1.document as IHTMLDocument2);
//    ihd2.clear;
//    ihd2.write(text);
//    ihd2.close;

    // peforms all the conversions for us
    doc := WebBrowser1.Document;
    doc.Clear;
    doc.Write(text);
    doc.Close;
end;

end.
