unit UnitFramePermanentClips;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, UnitFrameClipDisplay,
  Vcl.Buttons, Vcl.ExtCtrls, Vcl.StdCtrls, Vcl.Menus,
{must be declared after Vcl.ExtCtrls}
  UnitEXCategoryPanel,
  UnitEXCategoryPanelGroup;

type
  TFramePermanentClips = class(TFrame)
    cpgGroups: TCategoryPanelGroup;
    cpNewGroup: TCategoryPanel;
    Label1: TLabel;
    txtPermGroup: TEdit;
    btnPermCreate: TButton;
    pnlHotkey: TPanel;
    btnSetHotkey: TSpeedButton;
    btnClearHotkey: TSpeedButton;
    pnl1: TPanel;
    Label2: TLabel;
    lblHotkey: TLabel;
    FramePermClip: TFrameClipDisplay;
    pmPermMenu: TPopupMenu;
    MIEdit1: TMenuItem;
    N2: TMenuItem;
    MIMoveTo1: TMenuItem;
    MIDelete1: TMenuItem;
    pnl3: TPanel;

    lblMacroHelp: TLabel;
    pmEditGroup: TPopupMenu;
    EGDelete1: TMenuItem;
    EGEditName1: TMenuItem;
    EGMoveUp1: TMenuItem;
    EGMoveDown1: TMenuItem;
    N1: TMenuItem;
    procedure btnPermCreateClick(Sender: TObject);
    procedure btnSetHotkeyClick(Sender: TObject);
    procedure btnClearHotkeyClick(Sender: TObject);
    procedure btnEditGroup(Sendder: TObject);
    procedure pmEditGroupPopup(Sender: TObject);
    procedure EGMoveUp1Click(Sender: TObject);
    procedure EGMoveDown1Click(Sender: TObject);
    procedure EGEditName1Click(Sender: TObject);
    procedure EGDelete1Click(Sender: TObject);
    procedure MIEdit1Click(Sender: TObject);
  private
    { Private declarations }

     slGroups : TStringList;
        lastGroup, lastHotkey : string;
        lastClip : integer;
        lastModeSingle : boolean;
        lastList : TListBox;
     scrollPos : integer;
    procedure pmPermMenuPopup(Sender: TObject);
    procedure txtPermGroupChange(Sender: TObject);

    procedure MINewClip1Click(Sender: TObject);

            procedure resetView;
        procedure showPermClip(index : integer);
        procedure btnPermEdit(Sender : TObject);
        procedure btnPermNew(Sender : TObject);

        procedure btnPermGroupDelete(Sender : TObject);

        procedure groupExpand(Sender : TObject);
        procedure permanentMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
        procedure permMenuItemClick(Sender : TObject);
        procedure permanentDoubleClick(Sender : TObject);

        procedure permanentDragDrop(Sender : TObject; Source:TObject; x : integer; y : integer);
        procedure permanentDragOver(Sender : TObject; Source:TObject; x : integer; y : integer; state : TDragState; var accept : boolean);
        procedure permanentKey(Sender : TObject; var Key : word; Shift : TShiftState);


        procedure btnPermDelete(Sender : TObject);
     procedure cpgGroupsMouseWheel(Sender: TObject;
      Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
      var Handled: Boolean);

        procedure ContextMenuSingleItem;
        procedure ContextMenuMultiItem;

        procedure ScrollPush;
        procedure ScrollPop;

        procedure lbExit(Sender: TObject);
        procedure lbEnter(Sender: TObject);
  protected
  public
    { Public declarations }
    procedure ShowPermGroup(group : string; clipIndex : integer=-1);
    procedure loadPermanent;
    procedure positionPermanentEdit;
    procedure Activation;
    procedure Cleanup;
  end;

implementation

{$R *.dfm}

uses UnitClipDatabase, UnitFrmPermanentEdit, UnitMisc, UnitFrmHotKey,
  UnitFrmPermanentNew, UnitClipQueue, Vcl.ComCtrls, Math;

const DEFAULT_HELP_TEXT = 'NOTE: Macro/JavaScript reference information is'+
    ' directly included in the Edit window for a clip.';

//
// Permanent Clips/Macros
//

type TListUsed = class(TListBox);


type TCategoryPanelGroupHelper = class helper for TCustomCategoryPanelGroup
    protected
  public
        procedure RemovePanel_(Panel: TCustomCategoryPanel);
  end;
procedure TCategoryPanelGroupHelper.RemovePanel_(Panel: TCustomCategoryPanel);
begin
  Self.RemovePanel(Panel);
end;


type TCategoryPanelHelper = class helper for TControl
    public
        procedure setHeight_(height : integer);
end;
procedure TCategoryPanelHelper.setHeight_(height : integer);
begin
    self.fheight := height;

end;

type TCategoryPanelHelper2 = class helper for TCategoryPanel
    public
        procedure setAutoSize(value : boolean);
end;

procedure TCategoryPanelHelper2.setAutoSize(value : boolean);
begin
   self.autosize := false;
end;
const NEW_GROUP_LABEL = '[ New Group ]';

procedure TFramePermanentClips.ScrollPush;
begin
    scrollPos := cpgGroups.VertScrollBar.Position;
end;
procedure TFramePermanentClips.ScrollPop;
begin
    if scrollPos <> -1 then begin
    cpgGroups.VertScrollBar.Position := scrollPos;
    end;
end;

procedure TFramePermanentClips.Activation;
begin

end;
procedure TFramePermanentClips.Cleanup;
begin
    if Assigned(slGroups) then MyFree(slGroups);
    lastList := nil;
end;

procedure TFramePermanentClips.positionPermanentEdit;
var
    pt : TPoint;
begin
    pt.X := self.Left;
    pt.Y := self.Top;

    pt := self.ClientToScreen(pt);
    FrmPermanentEdit.Top := pt.Y;
    FrmPermanentEdit.Left := pt.X;
end;
procedure TFramePermanentClips.loadPermanent;
var
    i : integer;
    s, key : string;
    mi : TMenuItem;
    procedure showGroup(group : string);
    var
        sl, keys : TStringList;
        s : string;
        pnl : TCategoryPanel;
        lb : TListUsed;
        li : TListItem;
        pnl2 : TPanel;
        btn, btn2 : TButton;
    begin
        pnl := TCategoryPanel.Create(cpgGroups);
        pnl.PanelGroup := cpgGroups;

        pnl.Caption := group;
        pnl.Hint := group;
        pnl.OnExpand := self.groupExpand;
        pnl.Padding.Top := 5;
        pnl.Visible := false;

        //if group = '_System' then pnl.SpecialDraw := true;




        lb := TListUsed.Create(pnl);
        lb.Parent := pnl;
        lb.OnMouseUp := self.permanentMouseUp;
        lb.OnDblClick := self.permanentDoubleClick;
        lb.OnDragDrop := self.permanentDragDrop;
        lb.OnDragOver := self.permanentDragOver;
        lb.OnKeyUp := self.permanentKey;
        lb.DragMode := dmAutomatic;
        lb.ParentFont := false;
        lb.Font := cpgGroups.Font;
        lb.font.size := 9;
        lb.BorderStyle := bsNone;


        lb.OnEnter := self.lbEnter;
        lb.OnExit := self.lbExit;

        lb.MultiSelect := True;

        sl := TStringList.Create;
        TClipDatabase.LoadPermanentNames(sl, group);
        keys := TStringList.Create;
        TClipDatabase.LoadPermanentHotkeys(keys, group);
        for s in sl do begin
            key := '';
            if keys.Count > lb.Items.count then  begin
                key := keys[lb.Items.Count];
            end;
            if (length(key) > 6) then begin
                delete(key,1,6);
                lb.Items.Add(s + '  ['+key+']');
            end else begin
                lb.Items.Add(s);
            end;
        end;
        MyFree(sl);
        MyFree(keys);

        i := trunc(lb.Canvas.TextHeight('ASDF') * 1.15);
        lb.height := max( i * (lb.Items.Count) + 8, 30 );



        pnl2 := TPanel.Create(pnl);
        pnl2.Parent := pnl;
        pnl2.BevelOuter := bvNone;


        btn := TButton.Create(pnl2);
        btn.Parent := pnl2;
        btn.Caption := 'New';
        btn.Align := alRight;
        btn.OnClick := self.btnPermNew;

        btn2 := TButton.Create(pnl2);
        btn2.Parent := pnl2;
        btn2.Caption := 'Edit Group';
        btn2.Align := alLeft;
        btn2.OnClick := self.btnEditGroup;
        btn2.Width := 90;
        btn2.Visible := True;

        pnl2.Height := 37;
        pnl2.Padding.Right := 20;
        pnl2.Padding.Left := 20;
        pnl2.Padding.Top := 10;
        pnl2.Padding.Bottom := 3;

        pnl2.Align := alTop;
        lb.Align := alTop;

        pnl.Invalidate;
        pnl.Visible := true;

        pnl.setHeight_(lb.height + (i*3) + pnl2.height );

        pnl.Collapsed := true;
    end;

var
    pnl : TCategoryPanel;
begin
    cpNewGroup.Caption := NEW_GROUP_LABEL;
    cpNewGroup.SpecialDraw := true;


    lastClip := -1;
    lastGroup := '';

    lblMacroHelp.Caption := DEFAULT_HELP_TEXT;

    if (slGroups = nil) then begin
        slGroups := TStringList.Create;
    end;
    cpgGroups.OnMouseWheel := self.cpgGroupsMouseWheel;

    MIDelete1.OnClick := btnPermDelete;
    MIEdit1.OnClick := btnPermEdit;
    btnPermCreate.OnClick := btnPermCreateClick;
    btnSetHotkey.OnClick := btnSetHotkeyClick;
    btnClearHotkey.OnClick := btnClearHotkeyClick;
    pmPermMenu.OnPopup := pmPermMenuPopup;

    cpNewGroup.OnExpand := self.groupExpand;
    cpNewGroup.Collapsed := true;

    cpgGroups.Invalidate;
    cpgGroups.Visible := False;


    for i:= cpgGroups.Panels.Count-1 downto 0 do begin
        pnl := cpgGroups.Panels[i];
        if (pnl.Caption <> NEW_GROUP_LABEL) then
            cpgGroups.RemovePanel_(pnl);
    end;
    cpgGroups.Invalidate;
    slGroups.Clear;


    TClipDatabase.StartBatch;
    TClipDatabase.LoadPermanentGroups(slGroups);

    for s in slGroups do begin
        showGroup(s);

    end;

    cpgGroups.Invalidate;

    cpgGroups.Visible := true;

    TClipDatabase.EndBatch;
end;
procedure TFramePermanentClips.ShowPermGroup(group : string; clipIndex : integer=-1);
var
    i : integer;
    cp : TCategoryPanel;
    lb : TListUsed;
begin
    resetView;
    for i := 0 to cpgGroups.Panels.Count-1 do begin
        cp := cpgGroups.Panels[i];
        if (cp.hint = group) then begin
            lastGroup := group;
            cp.Collapsed := false;

            if (clipIndex <> -1) then begin
                lb := TListUsed( TWinControl(cp.Controls[0]).Controls[0]);
                lb.SetFocus;

                self.showPermClip(clipIndex);
                lastClip := clipIndex;
                lb.ItemIndex := clipIndex;
                lb.Selected[clipIndex] := True;
            end;
            EXIT;
        end;
    end;
end;
procedure TFramePermanentClips.showPermClip(index : integer);
var
    ci : TClipItem;
    lastHotkey : string;
begin
    ci := TClipItem.Create;
    TClipDatabase.LoadPermanent(ci, index, lastGroup);
    lastHotkey := TClipDatabase.LoadPermanentHotkey(index, lastGroup);
    lblHotkey.Caption := unitmisc.hotkeyName(lastHotkey);

    FramePermClip.ShowClip(ci);
    myfree(ci);
end;

procedure TFramePermanentClips.resetView;
begin
    lblHotkey.Caption := '';
    lastClip := -1;
    FramePermClip.ShowClip('');
    FramePermClip.PicStretched := true;


    lblMacroHelp.Caption := DEFAULT_HELP_TEXT;
end;

// current clip controls
procedure TFramePermanentClips.btnSetHotkeyClick(Sender: TObject);
var
    hkd : THotkeyData;
    s, g : string;
    i : integer;
    id : int64;
begin
    if lastClip = -1 then EXIT;

    if FrmHotkey.GetHotkey(hkd) then begin
        s := FrmHotkey.ToHKString(hkd);
        i := lastClip;
        g := lastGroup;
        TClipDatabase.SavePermanentHotkey(s,lastClip,lastGroup );


        lblHotkey.Caption := unitmisc.hotkeyName(s);
        FrmPermanent.ReportRemovedHotkey(g,i);
        FrmPermanent.ReportNewHotkey(lastGroup, lastclip);
        self.loadPermanent;
        self.ShowPermGroup(g,i);
    end;
end;
procedure TFramePermanentClips.btnClearHotkeyClick(Sender: TObject);
var
    g : string;
    i : integer;
begin
    i := lastClip;
    g := lastGroup;
    TClipDatabase.SavePermanentHotkey('',lastClip,lastGroup);
    lblHotkey.Caption := '';
    FrmPermanent.ReportRemovedHotkey(lastGroup, lastClip);
    self.loadPermanent;
    self.ShowPermGroup(g,i);
end;

// list box events
procedure TFramePermanentClips.permanentMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
    lb : TListUsed;
    cp : TCategoryPanel;
    cpg : TCategoryPanelGroup;
    i : integer;
    pt : TPoint;
    ci : TClipITem;
    li : TListItem;
    procedure setButtons;
    begin

    end;
    procedure handleLeftClick;
    begin
        if lastModeSingle then begin
            lastClip := lb.ItemIndex;
            setButtons;
            if lastClip = -1 then EXIT;

            self.showPermClip(lastClip);
        end;
    end;
    procedure handleRightClick;
    var i : integer;
    begin
        pt := lb.ScreenToClient(mouse.CursorPos);
        if lastModeSingle then begin

            lastClip := lb.ItemAtPos(pt, true);

            for i := 0 to lb.SelCount-1 do begin
                lb.Selected[i] := false;
            end;
            lb.ItemIndex := lastClip;

            lb.Refresh;
            setButtons;
            if lastClip=-1 then EXIT;

            self.showPermClip(lastClip);
            pmPermMenu.Popup(mouse.CursorPos.X + 10, mouse.CursorPos.y + 5);
        end else begin
            pmPermMenu.Popup(mouse.CursorPos.X + 10, mouse.CursorPos.y + 5);
        end;
    end;
begin
    if (sender is TListUsed) then begin

        lb := TListUsed(Sender);
        resetView;
        FramePermClip.PicStretched := true;

        lastList := TListBox(sender);
        if lb.SelCount > 1 then begin
            self.ContextMenuMultiItem
        end else begin
            self.ContextMenuSingleItem;
        end;

        case Button of
        mbLeft: handleLeftClick;
        mbRight: handleRightClick;
        end;
    end;
end;
procedure TFramePermanentClips.permanentDoubleClick(Sender : TObject);
var
    lb : TListUsed;
begin
    if (sender is TListUsed) then begin
        self.permanentMouseUp(Sender, mbRight,[],-1,-1);
    end;
end;
procedure TFramePermanentClips.permanentDragDrop(Sender : TObject; Source:TObject; x : integer; y : integer);
var
    i, j, k, totalMoved  : integer;
    lb : TListUsed;
    s : string;
    moveup : Boolean;
begin
    lb := TlistUsed(Sender);
    i := lb.ItemAtPos(point(x,y),true);
    j := lb.ItemIndex;

    if self.lastModeSingle then begin
        FrmPermanent.PermFolderPush;
        FrmPermanent.SetPermanentPath(lastGroup);
        FrmPermanent.MoveClip(j, i);
        FrmPermanent.PermFolderPop;
    end else begin
        totalMoved := 0;
        for k := 0 to lb.Count-1 do begin
            if (lb.Selected[k]) then begin
                moveup := k > i;
                Break;
            end;
        end;


        if (moveup) then begin
            for k := lb.Count-1 downto 0 do begin
                if (lb.Selected[k]) then begin
                    FrmPermanent.PermFolderPush;
                    FrmPermanent.SetPermanentPath(lastGroup);
                    FrmPermanent.MoveClip(k + totalmoved, i);
                    FrmPermanent.PermFolderPop;

                    Inc(totalmoved);
                end;
            end;
        end else begin
            for k := 0 to lb.Count-1 do begin
                if (lb.Selected[k]) then begin
                    FrmPermanent.PermFolderPush;
                    FrmPermanent.SetPermanentPath(lastGroup);
                    FrmPermanent.MoveClip(k - totalmoved, i);
                    FrmPermanent.PermFolderPop;

                    Inc(totalmoved);
                end;
            end;
        end;
    end;


    s := lastGroup;
    self.loadPermanent;
    if self.lastModeSingle then begin
        self.ShowPermGroup(s, i);
    end else begin
        self.ShowPermGroup(s);
    end;

    //FrmPermanent.RefreshHotkeys;
end;
procedure TFramePermanentClips.permanentDragOver(Sender : TObject; Source:TObject; x : integer; y : integer; state : TDragState; var accept : boolean);
var
    i, j, firstx, lastx : integer;
    lb : TListUsed;
begin
    lb := TlistUsed(Sender);
    i := lb.ItemAtPos(point(x,y),true);


    if Self.lastModeSingle then begin
        accept := i <> -1;
        accept := accept and (i <> lb.ItemIndex);
    end else begin
        firstx := -1;
        lastx := -1;
        for j := lb.Count-1 downto 0 do begin
            if lb.Selected[j] then begin
                if firstx = -1 then begin
                    firstx := j;
                end else begin
                    lastx := j;
                end;
            end;
        end;

        accept := (i < firstx) or (i>lastx);
    end;
end;
procedure TFramePermanentClips.permanentKey(Sender : TObject; var Key : Word; Shift : TShiftState);
begin
    if key in [VK_UP, VK_DOWN] then begin
        self.showPermClip( lastList.ItemIndex );
    end;
end;

// Popup Menu Events and helper Routines
procedure TFramePermanentClips.pmEditGroupPopup(Sender: TObject);
var idx : Integer;
begin
    EGDelete1.Enabled := lastList.Count = 0;
    EGMoveUp1.Enabled := true;
    EGMoveDown1.Enabled := true;
    idx := slGroups.IndexOf(lastgroup);

    // Create Group will always be Zero
    if (idx = 0) then begin
        EGMoveUp1.Enabled := false;
    end else if (idx = slGroups.Count-1) then begin
        EGMoveDown1.Enabled := false;
    end;
end;

procedure TFramePermanentClips.pmPermMenuPopup(Sender: TObject);
var
    s : string;
    mi : TMenuItem;
begin
    MIMoveTo1.Clear;
    for s in slGroups do begin
        if (s <> lastGroup) then begin
            mi := TMenuItem.Create(MIMoveTo1);
            mi.Caption := s;
            mi.hint := s;
            mi.OnClick := self.permMenuItemClick;
            MIMoveTo1.Add(mi);
        end;
    end;
end;
procedure TFramePermanentClips.ContextMenuSingleItem;
begin
    MIEdit1.Enabled := true;
    lastModeSingle := true;
end;
procedure TFramePermanentClips.ContextMenuMultiItem;
begin
    MIEdit1.Enabled := false;
    lastModeSingle := false;
end;
procedure TFramePermanentClips.MIEdit1Click(Sender: TObject);
begin
    btnPermEdit(Sender);
end;
procedure TFramePermanentClips.MINewClip1Click(Sender: TObject);
begin
    btnPermNew(Sender);
end;
procedure TFramePermanentClips.btnPermEdit(Sender : TObject);
var s : string;
begin
    s := lastGroup;
    self.positionPermanentEdit;
    if FrmPermanentEdit.ShowForm(lastGroup, lastClip) = mrOK then begin
        self.loadPermanent;
        self.ShowPermGroup(s);
    end else if FrmPermanentEdit.ClipWasSaved then begin
        self.loadPermanent;
        self.ShowPermGroup(s);
    end;
end;
procedure TFramePermanentClips.btnPermDelete(Sender : TObject);
var s : string;
    i, cnt : integer;
begin
    if MessageDlg('Delete the selected item(s)?', mtConfirmation,[mbYes, mbNo],0,mbNo) <> mrYes  then
        EXIT;
    s := lastGroup;

    if lastModeSingle then begin
        FrmPermanent.ReportRemovedHotkey(lastgroup, lastclip);
        TClipDatabase.DeletePermanentClip(lastClip, lastGroup);
    end else begin
        cnt := lastList.Count;
        for i := cnt-1 downto 0 do begin
            if lastList.Selected[i] then begin
                FrmPermanent.ReportRemovedHotkey(lastgroup, i);
                TClipDatabase.DeletePermanentClip(i, lastGroup);
            end;
        end;
    end;

    self.loadPermanent;
    self.ShowPermGroup(s);
end;
procedure TFramePermanentClips.permMenuItemClick(Sender : TObject);
var
    group : string;
    cnt,i,totalMoved : Integer;
begin
    group := TMenuItem(Sender).hint;
    if lastModeSingle then begin
        TClipDatabase.MovePermanentClip(lastClip, lastGroup, group);
    end else begin

        // NOTE: The Move routine automatically re-index clips when moving
        // Keep count of removed clips to calculate the new offset of the
        // next clip
        TClipDatabase.StartBatch;
        cnt := lastList.Count;
        totalMoved := 0;
        for i := 0 to cnt-1 do begin
            if lastList.Selected[i] then begin
                TClipDatabase.MovePermanentClip(i-totalMoved, lastGroup, group);
                Inc(totalMoved);
            end;
        end;

        TClipDatabase.EndBatch;
    end;
    self.loadPermanent;
    self.ShowPermGroup(group);
end;




procedure TFramePermanentClips.btnPermNew(Sender : TObject);
var s : string;
begin

    if lastList <> nil then begin
        ScrollPush;
        lastList.SetFocus;
        ScrollPop;
    end;

    s := lastGroup;
    self.positionPermanentEdit;
    if FrmPermanentEdit.ShowFormNew(lastGroup) = mrOK then begin
        self.loadPermanent;
        self.ShowPermGroup(s);
    end;

end;
procedure TFramePermanentClips.groupExpand(Sender : TObject);
var i,j : integer;
    cp : TCategoryPanel;
    ci : TClipItem;
    lb : TListUsed;
    isNewGroup : boolean;
begin
    resetView;
    scrollPos := -1;

    isNewGroup := false;
    for i := 0 to cpgGroups.Panels.Count-1 do begin
        cp := cpgGroups.Panels[i];
        if (sender <> cp) then begin
            if (not cp.Collapsed) then begin
                cp.Collapse;
            end;
        end else begin
            if (cp.Caption = NEW_GROUP_LABEL) then begin
                txtPermGroup.Text := '';
                txtPermGroup.SetFocus;
                isNewGroup := true;

                CONTINUE;
            end;

            lb := TListUsed(TWinControl(cp.Controls[0]).Controls[0]);
            lb.ItemIndex := -1;
            lastGroup := cp.hint;
            lastClip := -1;
            lastList := lb;
            lb.SetFocus;
            CONTINUE;

//            ci := TClipItem.Create;
//            TClipDatabase.LoadPermanent(ci, lastClip, lastGroup);
//            FramePermClip.ShowClip(ci);
//            myfree(ci);
        end;
    end;

    if (isNewGroup) then begin
        lblMacroHelp.Caption := 'Create a new group for storing macros.' +
        ' Groups are used to categorize similar type macros.';
    end else if (lastGroup = SYSTEM_FOLDER) then begin
        lblMacroHelp.Caption := 'Unlike other groups, _System is not shown on the popup.'
        +' The macros in this group are designed to be used by hotkeys.';
    end else if (lastGroup = FORM_MODE_FOLDER) then begin
        lblMacroHelp.Caption := 'Unlike other groups, _Form Mode is not shown on the popup.'
        +' These macros appear in the Pasting Tools menu on the Popup.';
    end else if (lastGroup = DEFAULT_FOLDER) then begin
        lblMacroHelp.Caption := 'The "Default" group is shown on the popup when used in a new program.'
        +' The popup will remember the last group used for each program.';
    end else begin

    end;
end;


// Special Create Group Events
procedure TFramePermanentClips.txtPermGroupChange(Sender: TObject);
begin
    btnPermCreate.Enabled := txtPermGroup.Text <> '';
end;
procedure TFramePermanentClips.btnPermCreateClick(Sender: TObject);
var
    group : string;
begin
    group := txtPermGroup.text;
    if (slGroups.IndexOf(group) = -1) and (group <> '') then begin
        TClipDatabase.SavePermanentGroup(group, slGroups.count);
        self.loadPermanent;
        self.ShowPermGroup(group);

        FrmPermanent.RefreshGroups;
    end;
end;

procedure TFramePermanentClips.lbEnter(Sender: TObject);
begin
    //self.ScrollPop;
end;

procedure TFramePermanentClips.lbExit(Sender: TObject);
begin
    //self.ScrollPush;
end;

procedure TFramePermanentClips.cpgGroupsMouseWheel(Sender: TObject;
  Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint;
  var Handled: Boolean);
var
    direction : integer;
begin
    Handled := true;
    direction := -3;
    if wheelDelta < 0 then direction := 3;
    cpgGroups.VertScrollBar.Position :=
        cpgGroups.VertScrollBar.ScrollPos + cpgGroups.VertScrollBar.Increment * direction;
end;



// Group Popup Events
procedure TFramePermanentClips.btnEditGroup(Sendder: TObject);
begin
    if lastList <> nil then begin
        self.ScrollPush;
        lastList.SetFocus;
        self.ScrollPop;
    end;
    pmEditGroup.Popup(mouse.CursorPos.X + 10, mouse.CursorPos.y + 5);
end;

procedure TFramePermanentClips.EGDelete1Click(Sender: TObject);
begin
   Self.btnPermGroupDelete(sender);
end;

procedure TFramePermanentClips.EGEditName1Click(Sender: TObject);
var s : string;
begin
    s := InputBox('Edit Name', 'Name', lastGroup);
    if (s <> lastGroup) and (s <> '') then begin
        if (slGroups.IndexOf(s)=-1) then begin
            TClipDatabase.EditPermanentGroupName(lastGroup,s);
            FrmPermanent.RefreshGroups;

            self.loadPermanent;
            self.ShowPermGroup(s);
        end else begin
            ShowMessage('Group Name already exists');
        end;
    end;
end;

procedure TFramePermanentClips.EGMoveDown1Click(Sender: TObject);
var i : Integer;
    s : string;
begin
    i := slGroups.IndexOf(lastGroup);

    slGroups.Move(i,i+1);

    TClipDatabase.StartBatch;
    for i := 0 to slGroups.Count-1 do begin
        TClipDatabase.EditPermanentGroupIndex(slGroups[i], i);
    end;
    TClipDatabase.EndBatch;

    s := lastGroup;
    self.loadPermanent;
    self.ShowPermGroup(s);

    FrmPermanent.RefreshGroups;
end;
procedure TFramePermanentClips.EGMoveUp1Click(Sender: TObject);
var i : Integer;
    s : string;
begin
    i := slGroups.IndexOf(lastGroup);

    slGroups.Move(i,i-1);

    TClipDatabase.StartBatch;
    for i := 0 to slGroups.Count-1 do begin
        TClipDatabase.EditPermanentGroupIndex(slGroups[i], i);
    end;
    TClipDatabase.EndBatch;

    s := lastGroup;
    self.loadPermanent;
    self.ShowPermGroup(s);

    FrmPermanent.RefreshGroups;
end;
procedure TFramePermanentClips.btnPermGroupDelete(Sender : TObject);
var i : integer;
begin
    if MessageDlg('Delete this entire ['+lastGroup+'] group?', mtConfirmation,[mbYes, mbNo],0,mbNo) <> mrYes  then
        EXIT;


    slGroups.Delete( slGroups.IndexOf(lastGroup));

    // reindex group
    TClipDatabase.StartBatch;
    for i := 0 to slgroups.Count-1 do begin
        TClipDatabase.EditPermanentGroupIndex(slGroups[i], i);
    end;



    TClipDatabase.ClearPermanentGroup(lastGroup, true);
    TClipDatabase.EndBatch;
    self.loadPermanent;

    FrmPermanent.RefreshGroups;
end;

end.
