unit UnitFramePopup;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, UnitClipQueue,
  UnitMenuItemTagdata, unitMisc, Contnrs, UnitTWideChar,
  UnitFrmTooltipNew, UnitACPopupConfig, UnitACPopupPrototype,
  Generics.Collections, UnitClipMenu2;

const USE_POPUP_KEYBOARD_HOOK = FALSE;

const TUsesClipMenu = [IT_POPUPCLIP, IT_CLIPBOARD, IT_PERMANENT, IT_PINNED, IT_TEMP];
const TContainsAClip = [IT_POPUPCLIP, IT_CLIPBOARD, IT_PINNED];
const TPastesOnClickj = TUsesClipMenu;
const TClickableLeftIcons = TUsesClipMenu;
const TDoubleSized = [IT_POPUPCLIP, IT_CLIPBOARD, IT_PINNED];


type
TPopupEraseFlag = (
    peCLipboard, pePopupClips, peRemovedClips, peEverything
);

TACOpenWindowFlag = (
    owConfiguration, owEditHistory, owRemovedClips, owPermanentClips,
    owPasteSelected, owSearch, owAbout, owEditClipboard,
    owTextInspector
);

TACPopup = class(TACPopupPrototype)
    private
        fim : TClipMenu2;
        filter : TEdit;
        fFilterTimer : TTimer;
        fFilterItem : TACPopupItem;

        fExplorerClickTimer : TTimer;
        fExplorerMode : boolean;
        fMouseReset : TTimer;

        searchRemoved : boolean;
        fGroupSwitchUsed : boolean;

        fGroup : TList<TACPopupITem>;
        fUseGrouping : boolean;
        fGroupingSize : integer;
        fCurrentGroup : Integer;
        fUseGroupingOnce : boolean;
        fUseGroupingOnceFailed : boolean;
        fIsClickWhilePinned : boolean;
        fHasFiles : boolean;
        fPasteFiles : TACPopupItem;
        toolsAccelChars : string;
        ClipsPerSet : Integer;
        fAutoExpandOnce : TItemType;
        fClipboardOnlyWarning : boolean;
        fClipboardOnlyMessage : string;
        procedure AssignSubmenuShortcuts(p : TACPopupItem); override;
        procedure FormMouseWheel(Sender: TObject; Shift: TShiftState;
                WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);

        procedure popupClipsChange;

        function GetPermanentFrom(p : TACPopupItem) : TClipItem;
    protected
        function GetClipHeader(ci : TClipItem) : string;
        function CalcWidth(fpi : TACPopupItem; ClipIt : boolean=true; MinWidth : boolean=true) : integer; override;
        procedure KeyUp(var Key: Word; Shift: TShiftState); override;
        function HandleMouseClick(p : TACPopupItem; DownShift : TShiftState) : boolean; override;
        procedure PreHandleCaptionViaKeystroke(p : TACPopupITem; key : char); override;
        procedure HandleCaptionClick(p : TACPopupItem); override;
        procedure DetectKeystroke(p : TACPopupItem; useUppercase : Boolean = true); override;
        procedure SetHover(value : TACPopupItem; tooltip:boolean=true; redraw:Boolean=true);  override;

        procedure HandleFormModeClick(Sender : TObject);
        procedure HandlePinnedModeClick(Sender : TOBject);

        procedure SetPrefix(p : TACPopupItem);
        procedure MakeSubmenu(p : TACPopupItem);

        procedure AddPopupClips;
        procedure AddCancel;
        procedure AddFullConfigured;
        procedure AddCurrentClipboard;
        procedure AddLast;
        procedure AddCurrentPermanentItems;
        procedure AddSearch;
        procedure AddPastingTools;
        procedure AddProgramOptions;
        procedure AddSwitchToItems;
        procedure AddSwitchToSubmenu;
        procedure AddAllItemsSubmenu;
        procedure AddSystem;

        procedure AddTools;

        procedure ClipMenuShow(rightclick : boolean = false);  override;
        function ClipMenuVisible : boolean; override;
        procedure ClipMenuReportKey(key : Char); overload; override;
        procedure ClipMenuReportKey(key : word); overload; override;
        procedure ClipMenuHide; override;

        procedure SearchRemovedClicked(Sender : TObject);


        procedure HideFilter(clear : boolean=true);
        procedure FilterKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
        procedure FilterKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
        procedure FIlterKeyPress(Sender: TObject; var Key: Char);
        procedure FilterTimer(Sender : TObject);
        procedure HandleFilter;

        function ClipSetCanExpand(Sender : TACPopupItem) : boolean;
        function ClipSetCanCollapse(Sender : TACPopupItem) : boolean;

        function HoverClipSetNext : boolean;
        function HoverClipSetPrevious : boolean;

        function PermGroupNext : boolean;
        function PermGroupPrev : boolean;

        procedure DeleteClip(i:integer);
        procedure MoveClip(oldindex,newindex:integer);

        procedure MouseReset(Sender: TObject);
        procedure ExplorerClickTimer(Sender: TObject);

        function FindByType(it : TItemType) : TACPopupItem;

        procedure SetPinnedMode(enabled : boolean);
        function UseKeyboard : boolean; override;
        function UsePrefix : boolean; override;
        procedure DragHandleDrop(source, target : TACPopupItem); override;
        function IsLegalDrop(p, source : TACPopupItem) : boolean; override;
        function IsLegalDrag(p : TACPopupItem) : boolean; override;

        procedure ShowTooltip(p : TACPopupItem); override;

        procedure ActiveEvent(clicked : Boolean); override;
        procedure InactiveEvent; override;
        procedure HandleOnClick(p : TACPopupItem); override;

        procedure CheckForAutoExpand(p : TACPopupItem);
        function IsDoubleHeightType(p : TACPopupItem) : boolean; override;

       function getLeftSpaceWidth(p : TACPopupItem) : integer;  override;
       function GetAcceleratorReserved(i: integer) : Char; override;
       procedure PostSizeCalculationEvent; override;
       function getDrawLeftIcon(p : TACPopupItem) : Boolean; override;
       procedure PostDrawIconEvent(p : TACPopupItem; r : TRect); override;
    public
        procedure AutoPopulate;  override;
        procedure Reset; override;
        procedure ShowFilter(P : TACPopupItem);
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        procedure ShowPopup(x,y : integer; NoSizeCalc : boolean = false); override;
        procedure Hide; override;
        procedure KeyPress(var Key: Char); override;
        procedure SearchRemovedOn;

        procedure RefreshMenuItems;
        procedure DoForceHide;

        property ExplorerMode : boolean read fExplorerMode write fExplorerMode;
        property ClipboardOnlyWarning : Boolean read fClipboardOnlyWarning write fClipboardOnlyWarning;
        property ClipboardOnlyMessage : string read fClipboardOnlyMessage write fClipboardOnlyMessage;
        procedure HandleHotkeyWhileVisible;

        property PopupMode : TACPopupMode read fPopupMode;
end;



implementation

uses Math, GraphUtil,  UnitFrmConfig, UnitPopupGenerate,
  UnitFrmClipboardManager, StrUtils, UnitToken, UnitFrmPermanentNew,
  UnitFrmMainPopup, UnitPaste, UnitFrmSysTrayMenu, UnitACPopupClicks,
  UnitKeyboardQuery, Clipbrd, UnitFrmEditTextExternal,
  UnitFrmDummyClipboardBar, ShellAPi, UnitMyCursor,
  UnitFrmDebug, UnitFrmEditHistory, UnitClipDatabase, UnitFocusManager;

{ $R *.dfm}





function SetLeftIcon(p : TACPopupItem; ci : TClipItem; forceType : boolean = false) : HICON;
var
    cdf : TClipFormatType;
begin
    if ci = nil then EXIT;

    if (frmconfig.GetIconType = CBXICONTYPE_CLIPTYPE) or forcetype then begin
        cdf := ci.GetFormatType;
        case cdf of
            FT_PICTURE:		p.lefticon.Bitmap := FrmClipboardManager.iPic.Picture.Bitmap;
            FT_HTML: 		p.lefticon.Bitmap  := FrmClipboardManager.iFormat.Picture.Bitmap;
            FT_RICHTEXT:	p.lefticon.Bitmap := FrmClipboardManager.iFormat.Picture.Bitmap;
            FT_FILE: 		p.lefticon.Bitmap := FrmClipboardManager.iFiles.Picture.Bitmap;
            else
            	p.lefticon.Bitmap := FrmClipboardManager.iText.Picture.Bitmap;
        end;
    end else begin
        p.lefticon.setfrom(ci.CData.GetHICON);
    end;
end;



{TACPopup}
constructor TACPopup.Create(AOwner: TComponent);
begin
    inherited Create(AOwner);

    setConfig(TACPopupConfig.Create());
    self.fGroup := TList<TACPopupItem>.Create;
    fShowShadow := true;


    Filter := TEdit.Create(self);
    filter.ParentWindow := self.handle;
    filter.SetBounds(1,1,80,20);
    filter.visible := false;
    //filter.TabStop := false;
    filter.OnKeyUp := self.FilterKeyUp;
    filter.OnKeyDown := self.FilterKeyDown;
    filter.OnKeyPress := self.FIlterKeyPress;



    ffilterTimer := TTimer.Create(self);
    ffilterTimer.Enabled := false;
    ffiltertimer.OnTimer := self.filtertimer;
    fFilterTimer.Interval := 300;

    fMouseReset := TTimer.Create(self);
    fMouseReset.Enabled := false;
    fMouseReset.OnTimer := self.MouseReset;
    fMouseReset.Interval := 300;

    fExplorerClickTimer := TTimer.Create(self);
    fExplorerClickTimer.Enabled := false;
    fExplorerClickTimer.OnTimer := self.ExplorerClickTimer;
    fExplorerClickTimer.Interval := 40;

    if (fim = nil) then begin
        //TODO: Why was Application used?
        //fim := TClipMenu2.Create(Application);
        fim := TClipMenu2.Create(self);

        self.ClipMenuHide;
        fim.setOnRemoveClip(self.DeleteClipCallback);
        fim.setOnDestroyClip(self.DeleteClipCallback);
        fim.setOnFormMode(self.FormModeCallback);
        fim.setOnHide(self.HideCallback);
        fim.setOnPasteClip(self.PasteCallback);
        fim.setOnEditClip(Self.EditCallback);
        fim.setOnMakePermanentClip(self.MakePermanentCallback);
    end;

    self.OnMouseWheel := self.FormMouseWheel;
end;
destructor TACPopup.Destroy;
var ac : TACPopupItem;
begin
    FreeANdNil(FFilterTImer);
    FreeAndNil(fMouseReset);
    FreeAndNil(fExplorerClickTimer);
    FreeAndNil(Filter);

    if assigned(fim) then fim.Free;
//    for ac in fGroup do begin
//        ac.Free;
//    end;

    FreeAndNil(fGroup);


    inherited;

end;
procedure TACPopup.HandleHotkeyWhileVisible;
begin
    if fpopupMode.equals(pdmPinned) then begin
        TFocusManager.ForceForeground(self.Handle);
    end;
    self.HoverDown;
end;
procedure TACPopup.RefreshMenuItems;
begin
    self.RebuildPopup;
end;
procedure TACPopup.DoForceHide;
begin
    self.ForceHide := true;
    self.Hide;
end;
//
// Filter Related Routines
//
procedure TACPopup.MouseReset(Sender: TObject);
begin
    fMouseReset.Enabled := false;
    screen.Cursor := crMyCursor;
end;

procedure TACPopup.SearchRemovedOn;
begin
    searchRemoved := true;
end;

procedure TACPopup.popupClipsChange;
var
    acp : TACPopupPrototype;
begin
    acp := self.fim as TACPopupPrototype;
    if acp.Visible then begin
        self.fPopupMode.PushValue;
        self.fPopupMode.setMode(pdmStayOpen);
    end;
    self.RebuildPopup;
    if acp.Visible then begin
        self.fPopupMode.PopValue;
    end;
end;

procedure TACPopup.ShowPopup(x,y : integer; NoSizeCalc : boolean = false);
begin
    FrmDebug.StartTimer;
    self.HideFilter;



    inherited ShowPopup(x,y);
    if frmconfig.cbFilterAlways.Checked then begin
        if assigned(fFilterItem) then self.ShowFilter(fFilterItem);
    end;

    if not self.UseKeyboard then begin
        fExplorerClickTimer.Enabled := true;
    end;

    ClipQueue.addListener(popupClipsChange);

    ACPopupClicks.SetPopup(self);

    self.HoverDown;
    FrmDebug.EndTimerLog('ShowPopup');
end;
procedure TACPopup.ShowFilter(P : TACPopupItem);
var
    saccept : string;
    scancel : string;
    r : TRect;
begin
    if filter.Visible then begin
        self.HideFilter;
        self.HandleFilter;
    end else begin
        filter.Font := GetCanvas.Font;

        filter.Top := p.Top;
        filter.Left := p.Left;
        filter.Height := GetCanvas.TextHeight('HELO') + 4;
        filter.Width := 80;
        //r := CalcIconRect(p, filter.BoundsRect);
        r := CalcIconBackgroundRect(p, filter.boundsrect);
        filter.Left := r.Right;
        //filter.Top := r.Top;


        filter.Visible := true;
        filter.Text := '';

        Windows.SetFocus(filter.Handle);
        self.fCurrentGroup := 0;

        (*
        fToolTipNew.SingleLineOnce := true;
        if frmconfig.cbxFilterEnter.ItemIndex = 1 then begin
            saccept := saccept + 'Enter ';
        end else begin
            scancel := scancel + 'Enter ';
        end;
        if frmconfig.cbxFilterESC.ItemIndex = 1 then begin
            saccept := saccept + 'Esc ';
        end else begin
            scancel := scancel + 'Esc ';
        end;
        if frmconfig.cbxFilterTab.ItemIndex = 1 then begin
            saccept := saccept + 'Tab ';
        end else begin
            scancel := scancel + 'Tab ';
        end;


        fToolTipNew.ShowTooltip('accept [ '+saccept+']'#13#10'cancel [ '+scancel+']',point(
            filter.left+filter.Width+self.left+4,
            filter.top+self.top)
        );
        *)
    end;
end;
procedure TACPopup.HideFilter;
begin
    if filter.Visible then begin
        filter.Visible := false;
        if clear then begin
            filter.Text := '';
        end;
        fFilterTimer.Enabled := false;

        Windows.SetFocus(self.Handle);
    end;
end;
procedure TACPopup.FilterKeyPress(Sender: TObject; var Key: Char);
begin
  case key of
    #9,#13,#27:// Tab,Enter,ESC
        begin
            key := #0;
            EXIT;
        end;
  end;
end;
procedure TACPopup.FilterKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
    case key of
    VK_DOWN:
        begin
            HideFilter(false);
            self.HandleFilter;

            self.SetHover(nil);
            self.HoverDown;

            EXIT;
        end;
    end;

    fFilterTimer.Enabled := false;
    fFilterTimer.Enabled := true;
    MouseCursorReset;
end;
procedure TACPopup.FilterKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    function AcceptFilter(c : TComboBox) : boolean;
    begin
        result := c.ItemIndex = 1;

        self.HideFilter(not result);
        if not result then begin
            self.HandleFilter;
        end;
    end;
begin
    if shift = [] then begin
        case key of
        VK_RETURN:
            begin
                AcceptFilter(frmconfig.cbxFilterEnter);
                key := 0;
            end;
        VK_ESCAPE:
            begin
                AcceptFilter(frmconfig.cbxFilterESC);
                key := 0;
            end;
        VK_TAB:
            begin
                AcceptFilter(frmconfig.cbxFilterTab);
                key := 0;
            end;
        end;
    end;
end;
procedure TACPopup.FilterTimer(Sender : TObject);
begin
    fFilterTimer.Enabled := false;
    self.HandleFilter;
end;
procedure TACPopup.HandleFilter;
begin
    fFilterTimer.Enabled := false;
    self.RebuildPopup;

    MouseCursorReset;
end;
procedure TACPopup.SetHover(value : TACPopupItem; tooltip:boolean=true; redraw:Boolean=true);
var
    prevHover : TACPopupItem;
begin
    prevHover := self.Hover;
    inherited SetHover(value, tooltip, redraw);

    if filter.Visible then begin
        if value <> prevHover then begin
            self.HideFilter(false);
            self.HandleFilter;
        end;
    end;


    fMouseReset.Enabled := false;
    if (value<>nil) and
        (value.ItemType in TContainsAClip) and (LastPosition = pipCaption) and
        PtInRect(
            rect(value.left,value.top,value.Right+1,value.bottom+1),
            self.ScreenToClient(mouse.CursorPos)) then begin
        screen.Cursor := crMyCursor;
    end else begin
        screen.Cursor := crDefault;
    end;
end;

procedure TACPopup.SearchRemovedClicked(Sender : TObject);
begin
    searchRemoved := not searchRemoved;
    self.RebuildPopup;
end;

//
function TACPopup.ClipSetCanExpand(Sender : TACPopupItem) : boolean;
var
    i : integer;
    groupid : integer;
begin
    if sender.expanded then begin

    end else begin
        // find the collapsed group and trigger a refresh

        self.fCurrentGroup :=  sender.IntegerData;
        groupid := sender.IntegerData;

        sender.Expanded := true;

        for i := 0 to self.fGroup.Count-1 do begin
            if i <> groupid then begin
                TACPopupItem(self.fGroup.Items[i]).Expanded := false;
            end
        end;
        self.RebuildPopup(False);
    end;

    self.SetHover(sender);
    // expanding is done manually, cancel the automatic handling
    result := false;
end;
function TACPopup.ClipSetCanCollapse(Sender : TACPopupItem) : boolean;
var
    groupid : integer;
    i : Integer;
begin
    result := false;
    self.SetHover(sender);
end;

// ClipSet/PermClips Navigation Routines
//
procedure TACPopup.FormMouseWheel(Sender: TObject; Shift: TShiftState;
    WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
var b : boolean;
    ac : TACPopupItem;
    pt : TPoint;
begin
    case FrmConfig.GetMouseWheelAction of
    WA_CLIPSET:
        begin
            pt := ScreenToClient(mouse.CursorPos);
            ac := GetItemAt(pt.x,pt.Y);
            if wheeldelta > 0 then begin
                if (ac<>nil) and
                    (
                        (ac.ItemType in [IT_POPUPCLIP, IT_CLIPSET_HEADER]) or
                        (filter.Text<>'')
                    ) then begin
                    b := self.HoverClipSetPrevious;
                end else if (ac=nil) or (ac.ItemType in [IT_PERMANENT, IT_SWITCH]) then begin
                    self.PermGroupPrev;
                end;
            end else begin
                if (ac<>nil) and
                    (
                        (ac.ItemType in [IT_POPUPCLIP, IT_CLIPSET_HEADER]) or
                        (filter.Text<>'')
                    ) then begin
                    b := self.HoverClipSetNext;
                end else if (ac=nil) or (ac.ItemType in [IT_PERMANENT, IT_SWITCH]) then begin
                    self.PermGroupNext;
                end;
            end;
            CancelHoverTimer;
        end;
    WA_HIGHLIGHT:
        begin
            if wheeldelta > 0 then begin
                self.HoverUp;
            end else begin
                self.HoverDown;
            end;
        end;
    end;
end;
procedure TACPopup.KeyUp(var Key: Word; Shift: TShiftState);
    function IsMovePopupClips : boolean;
    begin
        result := false;
        if ([ssShift]=shift) and (key in [VK_UP,VK_DOWN]) then begin
            if (hover<>nil) and (hover.ItemType=IT_POPUPCLIP) then begin
                case key of
                VK_UP:
                    begin
                        self.MoveClip(hover.IntegerData, hover.IntegerData-1);
                    end;
                VK_DOWN:
                    begin
                        self.MoveClip(hover.IntegerData, hover.IntegerData+1);
                    end;
                end;
            end;
            result := true;
        end;
    end;
    function IsShowClipMenu : boolean;
    begin
        result := false;
        if ((key=VK_LEFT) and ([ssCtrl]=shift))
            or (key=VK_APPS) then begin
            HideTooltip;
            self.ClipMenuShow(false);
            result := true;
        end;
    end;
    function IsReportToClipMenu : boolean;
    begin
        result := false;
        if self.ClipMenuVisible then begin
            if key in [VK_UP, VK_DOWN, VK_LEFT,VK_RIGHT, VK_RETURN, VK_ESCAPE] then begin
                ClipMenuReportKey(key);
            end;
            result := true;
        end;

    end;
    function IsPreviousNext : boolean;
    begin
        result := false;
        case key of
        VK_PRIOR:
            begin
                result := HoverClipSetPrevious;
            end;
        VK_NEXT:
            begin
                result := HoverClipSetNext;
            end;
        VK_HOME:
            begin
                result := PermGroupPrev;
            end;
        VK_END:
            begin
                result := PermGroupNext;
            end;
        end;
    end;
    function IsShowCaptionShortcuts : boolean;
    begin
        result := false;
        if (key=VK_TAB) and (FrmConfig.GetTabClickAction = CA_Show_Titlebar_Shortcut_Keys) then begin
            ShowCaptionShortcuts := not ShowCaptionShortcuts;
            self.RebuildPopup(false);
            result := true;
        end else if (key = vk_menu) then begin
            self.ShowCaptionShortcuts := not self.ShowCaptionShortcuts;
            self.RebuildPopup(False);
            result := true;
        end;
    end;
begin
    if LastKeyDown in [VK_MENU, VK_CONTROL, VK_SHIFT] then begin
        HideTooltip;
        CancelModifierTimer;
    end;

    if IsReportToClipMenu then EXIT;
    if IsShowClipMenu then EXIT;
    if IsMovePopupClips then EXIT;

    inherited KeyUp(key, shift);

    if IsPreviousNext then EXIT;
    if IsShowCaptionShortcuts then EXIT;

    if hover = nil then EXIT;

    case key of
    VK_DELETE:
        begin
            case hover.ItemType  of
                IT_POPUPCLIP:
                    begin
                        self.DeleteClip(ClipQueue.IndexOf(hover.clip));
                    end;
                IT_CLIPBOARD: begin
                    frmClipboardManager.ClearClipboard;
                    self.DeleteClipCallback(nil);
                end;
            end;
        end;
    VK_APPS:
        begin
//            self.ClipMenuShow(false);
        end;
    VK_TAB:
        begin
            if (hover.ItemType in TContainsAClip) then begin
                self.Hover.TabPressed := true;
                if (Hover.ItemType in TContainsAClip) then begin
                    self.HoverClick; // Tab is now a configurable modifier
                end;
            end;
        end;
    end;
end;
function TACPopup.HoverClipSetNext : boolean;
var p : TACPopupItem;
    i : integer;
begin
    if fCurrentGroup < fgroup.count-1 then begin
        inc(fCurrentGroup);
        p := fGroup.Items[fCurrentGroup];
        SetHover(p, false, false);
        HoverClick;
    end;
end;
function TACPopup.HoverClipSetPrevious : boolean;
var P : TACPopupItem;
    i : integer;
begin
    if fCurrentGroup > 0 then begin
        Dec(fCurrentGroup);
        p := fGroup.Items[fCurrentGroup];
        SetHover(p, false, false);
        HoverClick;
    end;
end;
function TACPopup.PermGroupNext : boolean;
var i : integer;
begin
    Result := FrmPermanent.SetNextGroup;
    if Result then begin
        self.RebuildPopup;
        FrmPermanent.AssignPIG(FrmMainPopup.TargetData.ExeName);
    end;
end;
function TACPopup.PermGroupPrev : boolean;
var i : integer;
begin
    result := FrmPermanent.SetPreviousGroup;
    if Result then begin
        self.RebuildPopup;
        FrmPermanent.AssignPIG(FrmMainPopup.TargetData.ExeName);
    end;
end;
function TACPopup.CalcWidth(fpi : TACPopupItem; ClipIt : boolean=true;MinWidth : boolean=true) : integer;
begin
    result := inherited CalcWidth(fpi, ClipIt, MinWidth);

    if not ClipIt and (fpi.ItemType = IT_POPUPCLIP) then begin
        result := max(self.MaxItemWidth, result);
    end;
end;
procedure  TACPopup.PreHandleCaptionViaKeystroke(p : TACPopupItem; key : char);
var
    i, j : integer;
    p2 : TACPopupItem;
    ci : TClipItem;
    dt : string;
    it : TItemType;
begin
    if p.ItemType = IT_PERMANENT then begin
        ci := self.GetPermanentFrom(p);
        dt := ci.getDisplayText;
        if AnsiStartsText(KEYS_STR, dt) or
            AnsiStartsText(KEYS_IGNORENL_STR, dt) then begin
            KeyboardQuery.WaitUntilRelease( VkKeyScan(key) );
        end;
        myfree(ci);

        EXIT;
    end;
end;
procedure TACPopup.KeyPress(var Key: Char);
var
    i, j : integer;
    p, p2 : TACPopupItem;
    ci : TClipItem;
    dt : string;
    it : TItemType;
begin
    inherited KeyPress(Key);
    if (key = #0) then EXIT;


end;


//
// Popup Clips edited while the popup is open
//
procedure TACPopup.DeleteClip(i:integer);
var x, j : integer;
    it : TItemType;
begin
    x := i;
    ClipQueue.DeleteItem(i);
    self.RebuildPopup;

    for j := 0 to items.SubMenu.Count-1 do begin
        if (items[j].ItemType = IT_POPUPCLIP) and (items[j].integerdata=x) then begin
            sethover(items[j],false);
        end;
    end;
end;
procedure TACPopup.MoveClip(oldindex,newindex:integer);
var x, j : integer;
begin
    x := newindex;
    if not ClipQueue.Move(oldindex,newindex) then EXIT;

    self.RebuildPopup;

    for j := 0 to items.SubMenu.Count-1 do begin
        if (items[j].ItemType = IT_POPUPCLIP) and (items[j].integerdata=x) then begin
            sethover(items[j],false);
        end;
    end;
end;


// Detect When user tries to "off-click" to hide the popup
procedure TACPopup.ExplorerClickTimer(Sender: TObject);
begin
    if KeyboardQuery.IsClicked(leftButton) then begin
        if not self.MouseInPopup then begin
            FrmDebug.AppendLog('Off-Click close');
            self.Hide;
            fExplorerClickTimer.Enabled := false;
        end;
    end;
end;
procedure TACPopup.Hide;
    function FocusLostFromClipMenuClick : boolean;
    begin
        result := TClipmenu2(fim).showing and self.fim.MouseInMenu
    end;
begin
    FrmDebug.AppendLog('Hide Request');
    if not self.ForceHide then begin
        if not Application.Terminated then begin
            if (fPopupMode.equals(pdmPinned)) and (not fIsClickWhilePinned) then begin
                if (UseKeyboard <> self.lastRebuildUsedKeyboard) then
                    self.RebuildPopup;
            end;

            if fPopupMode.getMode in [pdmFormMode, pdmPinned, pdmStayOpen] then EXIT;
            if FocusLostFromClipMenuClick then EXIT;
        end;
    end else begin
        ForceHide := false;
    end;

    if ClipMenuVisible then begin
        ClipMenuHide;
    end;

    inherited Hide;

    ClipQueue.removeListener(popupClipsChange);
    if self.fshowing = false then EXIT;
    fExplorerClickTimer.Enabled := false;
    SetPinnedMode(false);
end;

procedure TACPopup.SetPinnedMode(enabled : boolean);
begin
    if enabled then  begin
        fpopupMode.setMode(pdmPinned);


    end else begin
        fpopupMode.setMode(pdmAutoHide);


        TFocusManager.ForceForeground(self.Handle);
    end;
    self.RebuildPopup;
end;
function TACPopup.UseKeyboard : boolean;
begin
    result := (not fExplorerMode) and  inherited;
end;
function TACPopup.UsePrefix : boolean;
begin
    result := inherited and not fExplorerMode;
end;

function TACPopup.IsLegalDrop(p, source: TACPopupItem): boolean;
begin
    result := false;
    if inherited IsLegalDrop(p, source) then begin
        case source.itemtype of
            IT_POPUPCLIP, IT_PERMANENT, IT_TEMP, IT_PINNED: begin
                if source.ItemType = p.ItemType then begin
                    result := true;
                end;
            end;
            else begin
                if source.IsExpandable or
                    (source.ItemType in [IT_CLIPBOARD, IT_SEARCH, IT_FULL,IT_POPUPCLIP,IT_PERMANENT]) then begin
                    if p.IsExpandable or
                    (p.ItemType in [IT_CLIPBOARD, IT_SEARCH, IT_FULL,IT_POPUPCLIP, IT_PERMANENT]) then begin
                        result := true;
                    end;
                end;
            end;
        end;
    end;
end;
function TACPopup.HandleMouseClick(p : TACPopupItem; DownShift : TShiftState):boolean;
    procedure DoIt;
    begin
        FrmMainPopup.SkipFocusReturnOnce;
        self.hide;
    end;
begin
    result := false;
	{handle Icon clicks, pass of Caption cliks}
    {handle right clicks}
    fIsClickWhilePinned := fPopupMode.equals(pdmPinned);
    if ([ssLeft, ssMiddle] * DownShift) <> [] then begin
        if hover=nil then begin
            SetHover(p,false);
        end;
        if (p.ItemType = IT_CANCEL) then PopupMode.setMode(pdmAutoHide);
        case LastPosition of
            pipLeftIcon: begin
                case hover.itemtype of
                    IT_PERMANENT:
                        begin
                            DoIt;
                            FrmEditHistory.ShowPermanent(hover.PermanentGroupID, hover.PermanentID);
                        end;
                    IT_LINE, IT_NONE:
                        begin
                            // do nothing, Lines have not icons
                        end;
                    IT_POPUPCLIP, IT_CLIPBOARD:
                        begin
                            if p.SmallCaption then EXIT;
                            fim.SetPopupClipMode;
                            fim.SetACPopupItem(hover);
                            fim.PerformDefaultAction;
                        end;
                end;
            end;
            pipCaption: begin
                inherited HandleMouseClick(p, DownShift);
            end;
            pipNone: ;
        end;
    end else if (ssRight in DownShift) then begin
        if hover=nil then begin
            SetHover(p,false);
        end;

        self.CancelShowSubmenu;
        CancelHoverTimer;
        CancelLeftIconTimer;
        if (p.Style = psNormal) and (p.ItemType in TUsesClipMenu) then begin
            self.ClipMenuShow(true);
        end;
    end;
end;
procedure TACPopup.HandleFormModeClick(Sender : TObject);
var
    p : TACPopupItem;
begin
    p := TACPopupItem(Sender);
    self.UseFormMode := p.Checked;
    p.Expanded := false;
    self.RebuildPopup(true);
end;
procedure TACPopup.HandlePinnedModeClick(Sender : TOBject);
var
    p : TACPopupItem;
begin
    p := TACPopupItem(Sender);

    self.SetPinnedMode( not fpopupMode.equals(pdmPinned) );
    if (p.ItemType = IT_PINNED) then begin
        p.checked := not fpopupMode.equals(pdmPinned);
        p.Expanded := false;
    end;


//    self.RebuildPopup(true);
end;

procedure TACPopup.DetectKeystroke(p: TACPopupItem;useUppercase : Boolean = true);
var
	c : char;
    i : integer;
begin
    inherited DetectKeystroke(p);

    i := keystrokes.IndexOfObject(p);
    if i <> -1 then begin
        c := Keystrokes.Strings[i][1];

        if p.ItemType = IT_PERMANENT then begin
            p.Prefix := '&' + c;
            if Pos('&'+c+' ', p.Caption) = 1 then begin
                p.Caption := UnitToken.clipManyChars(p.Caption, 3);
            end;
        end;
    end;
end;
procedure TACPopup.AssignSubmenuShortcuts(p : TACPopupItem);
begin
    if p.ItemType = IT_CLIPSET_HEADER then EXIT;

    inherited AssignSubmenuShortcuts(p);
end;


procedure TACPopup.AddCancel;
var p : TACPopupItem;
begin
    p := self.Add;
    p.ItemType := IT_CANCEL;
    if self.UseKeyboard then begin
        p.Caption := 'Cancel   (ESC)';
    end else begin
        p.Caption := 'Cancel';
    end;
    p.IntegerData := Integer(MOT_CANCEL);
end;
procedure TACPopup.AddPastingTools;
var
    p, sub : TACPopupItem;
    s : string;
    sl : TStringList;
    i : integer;

    procedure AddFormMode;
    begin
        sub := p.add;
        sub.SeparatorLine := true;
        //frmmainpopup.UseFormMode;
        sub.Caption := 'Form Mode';

        //sub.LeftIcon := GetIconFromBitmap(frmmainpopup.imgEdit.Picture.Bitmap);
        sub.Checked := self.UseFormMode;
        sub.hint := 'Enabled pasting of multiple clips';
        sub.ItemType := IT_FORMMODE;
        sub.OnClick := Self.HandleFormModeClick;
    end;
    procedure AddPinnedMode;
    begin
        sub := p.add;
        sub.Caption := 'Pin to Desktop';

        sub.Checked := fPopupMode.equals(pdmPinned);
        sub.hint := 'Enabled pasting of multiple clips';
        sub.ItemType := IT_PINNEDMODE;
        sub.OnClick := Self.HandlePinnedModeClick;
    end;
begin
    p := self.Add;
    p.IsExpandable := true;

    p.Caption := 'Pasting Tools';
    p.LeftIcon.SetFrom( ImgToBitmap(frmmainpopup.ImgMisc) );
    SetPrefix(p);
    p.IntegerData := Integer(MOT_PASTEUTILS);
    p.ItemType := IT_PASTING_TOOLS;


   if (not self.UseFormMode) then begin
        sub := p.add;
        sub.caption := 'Paste All';
        sub.LeftIcon.SetFrom(ImgToBitmap(frmmainpopup.imgPasteAll));
        sub.Hint := 'Pastes all Popup Clips as a single text clip';
        sub.leftIcon.IconOnlyOnHover := true;
        sub.OnClick  := ACPopupClicks.PasteAllClick;

        sub := p.add;
        sub.caption := 'Paste All Files';
        sub.LeftIcon.SetFrom( ImgToBitmap(frmmainpopup.imgPasteAll) );;
        sub.Hint := 'Pastes all File Clips as a single clip';
        sub.lefticon.IconOnlyOnHover := true;
        sub.OnClick  := ACPopupClicks.PasteAllFilesClick;
        sub.Disabled := not self.fHasFiles;
        self.fPasteFiles := sub;


        sub := p.add;
        sub.caption := 'Paste Selected Text...';
        sub.LeftIcon.SetFrom( ImgToBitmap(frmmainpopup.imgPaste) );
        sub.IntegerData := Integer(owPasteSelected);
        sub.OnClick := ACPopupClicks.OpenWindowCommand;
        sub.Hint := 'Shows the ''Paste Selected'' Window';
        sub.lefticon.IconOnlyOnHover := true;
        sub.CaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgNewWindow);


        sub := p.Add;
        sub.Caption := 'Search and Paste ...';
        sub.CaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgSearch);
        sub.ItemType := IT_SEARCH;
        sub.IntegerData := Integer(owSearch);
        sub.OnClick := ACPopupClicks.OpenWindowCommand;
        sub.hint := 'Shows the ''Search'' Window';


        sub := p.Add;
        sub.Caption := 'Text Inspector ...';
        sub.CaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgNewWindow);
        sub.IntegerData := Integer(owTextInspector);
        sub.OnClick := ACPopupClicks.OpenWindowCommand;
        sub.hint := 'Shows the ''Text Inspector'' Window';


        AddFormMode;
//        AddPinnedMode;
    end else begin
        sl := TStringList.Create;
        TClipDatabase.LoadPermanentNames(sl, FORM_MODE_FOLDER);
        i := 0;
        for s in sl do begin
            sub := p.add;
            sub.caption := s;
            sub.Hint := 'Simulates a keystrokes using a macro';
            sub.ItemType := IT_NEXTFIELD;
            sub.IntegerData := i;
            inc(i);
        end;
        myfree(sl);


        AddFormMode;

        sub := p.Add;
        sub.Caption := 'Form Mode Keystrokes...';
        sub.CaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgNewWindow);
        sub.OnClick := ACPopupClicks.OpenWindowCommand;
        sub.IntegerData := Integer(owPermanentClips);
        sub.PermanentGroupID := FrmPermanent.PermFolderToIndex(FORM_MODE_FOLDER);
    end;



    if fPopupMode.getMode in [pdmFormMode] then begin
        p.expanded := true;
    end;

    self.CheckForAutoExpand(p);
end;
procedure TACPopup.AddAllItemsSubmenu;
var i, j : integer;
    m, main, sub, subm2 : TACPopupItem;

    s : string;
    wc : TWideChar;
    ci : TClipItem;
    cl : TClipList;
begin
    main := nil;
    FrmDebug.StartTimer;
    if (not FrmConfig.cbShowAllAsSubmenus.checked) then begin
        main := self.Add;
        main.Caption := 'All Permanent';
        main.lefticon.SetFrom( ImgToBitmap(frmmainpopup.imgPermCasc) );
        main.IsExpandable := true;
        main.IntegerData := Integer(MOT_ALLPERMANENT);
        main.ItemType := IT_ALLPERM_MENU;
        SetPrefix(main);
    end;
    s := lowercase(frmPermanent.GetPermanentPath);

    TClipDatabase.StartBatch;
    FrmDebug.AppendLog('PermFolders count='+IntToStr(frmPermanent.PermFoldersGetCount));
    for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin
        if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

        if (FrmConfig.cbShowAllAsSubmenus.checked) then begin
            m := self.add;
            m.LeftIcon.SetFrom(ImgToBitmap(frmmainpopup.imgPermCasc));
            SetPrefix(m);
        end else begin
            m := main.Add;
        end;
        m.Caption := frmPermanent.PermFoldersGetItem(i);
        m.itemtype := IT_POPUP;
        MakeSubmenu(m);


        cl := TClipList.Create(true);
        TClipDatabase.LoadPermanentClips(cl, m.Caption);
        FrmDebug.AppendLog('PermCount='+IntToSTr(cl.Count));
        for j := 0 to cl.count - 1 do begin

            ci := cl[j];
            subm2 := m.add;
            subm2.Caption := ci.getDisplayText;
            subm2.itemtype := IT_PERMANENT;
            subm2.PermanentGroupID := i;
            subm2.PermanentID  := j;
            subm2.PermanentType := ci.GetFormatType;

            subm2.LeftIcon.SetFrom( ImgToBitmap(FrmMainPopup.ImgEdit) );
            subm2.ClickableLeftIcon := true;
            subm2.IconHoverCaption := 'Edit ...';
            subm2.lefticon.IconOnlyOnHover := true;

            case ci.GetFormatType of
            FT_FILE: 		subm2.lefticon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgFile);
            FT_PICTURE: 	subm2.lefticon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgPic);
            FT_HTML:		subm2.lefticon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgHTML);
            FT_RICHTEXT:	subm2.lefticon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgRichText);
            FT_UNICODE: 	subm2.lefticon.CliptypeIcon := nil;
            end;


            subm2.OnClick := ACPopupClicks.PermanentClipClick;
        end;
        cl.Clear;
        myfree(cl);
    end;


    if (not FrmConfig.cbShowAllAsSubmenus.checked) then begin
        if FrmConfig.cbPermanentItemsSubmenu.Checked then begin
            subm2 := main.Add;
            self.MakeSubmenu(subm2);
            subm2.Caption := '[Switch Group]';
        end;
        for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin

            if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

            if FrmConfig.cbPermanentItemsSubmenu.Checked then begin
                sub := subm2.add;
            end else begin
                sub := main.add;
                if (i=0) then
                    sub.SeparatorLine := true;
            end;

            //sub.Caption := FrmPermanent.PermFoldersGetItem(i);
            sub.PermanentGroupID := i;
            sub.itemtype := IT_SWITCH;
            sub.CollapseParentOnClick := true;
            sub.OnClick := ACPopupClicks.PermanentGroupClick;
            wc := TWideChar.create;
            wc.Append(WideChar($2192)); {right arrow}
            if (lowercase(FrmPermanent.PermFoldersGetItem(i)) <> s) then begin
                sub.Checked := false;
                sub.CheckGrouped;
            end else begin
                sub.checked := true;
                sub.CheckGrouped;
            end;
            wc.AppendUnicode('[' +FrmPermanent.PermFoldersGetItem(i) + ']');
            sub.caption := wc.GetString;
            myfree(wc);
            sub.hint := 'Changes the current Permanent Clips group';
        end;

	end;
    TClipDatabase.EndBatch;

    if (not FrmConfig.cbShowAllAsSubmenus.checked) then begin
        if (main.SubMenu.Count>0) then begin

            if (FrmConfig.cbShowAllAsSubmenus.checked) then begin
                self.AddLine;
            end else begin
                m := main.Add;
            end;
            m.Caption := 'Edit ...';
            m.SeparatorLine := true;
            m.CaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
            m.IntegerData := Integer(owPermanentClips);
            m.PermanentGroupID := -1;
            m.OnClick := ACPopupClicks.OpenWindowCommand;

            self.CheckForAutoExpand(main);
        end;
    end;

    FrmDebug.EndTimerLog('All Items');
end;

procedure TACPopup.AddSwitchToSubmenu;
var i : integer;
    p, sub : TACPopupItem;
    s : string;
    wc : TWideChar;
begin
    p := self.add;
    p.Caption := 'Permanent Groups';
    p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgPermCasc);
    p.IsExpandable := true;
    p.IntegerData := Integer(MOT_SWITCH);
    p.ItemType := IT_SWITCH_MENU;
    SetPrefix(p);
    s := lowercase(frmPermanent.GetPermanentPath);


    for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin
        if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

        sub := p.add;
        //sub.Caption := FrmPermanent.PermFoldersGetItem(i);
        sub.PermanentGroupID := i;
        sub.itemtype := IT_SWITCH;
        sub.CollapseParentOnClick := true;
        sub.OnClick := ACPopupClicks.PermanentGroupClick;
        wc := TWideChar.create;
        wc.Append(WideChar($2192)); {right arrow}
        if (lowercase(FrmPermanent.PermFoldersGetItem(i)) <> s) then begin

            sub.Checked := false;
            sub.CheckGrouped;
        end else begin
            sub.checked := true;
            sub.CheckGrouped;
        end;
        wc.Append('[' +FrmPermanent.PermFoldersGetItem(i) + ']');
        sub.caption := wc.GetString;
        myfree(wc);
        sub.hint := 'Changes the current Permanent Clips group';
    end;

//    p.addline;
    sub := p.add;
    sub.Caption := 'Edit ...';
    sub.SeparatorLine := true;
    sub.IntegerData := Integer(owPermanentClips);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.PermanentGroupID := -1;
    sub.CaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);

    self.CheckForAutoExpand(p);
end;
procedure TACPopup.AddCurrentClipboard;
var
    p : TACPopupItem;
    c : cardinal;
begin
    c := CurrentClipboard.GetClipboardItem(0);

    if (c<>0) and (CurrentClipboard.GetDataSize <> 0) then begin
        p := self.Add;
        p.ItemType := IT_CLIPBOARD;

        p.Clip := CurrentClipboard;
        self.SetPrefix(p);
        p.IntegerData := Integer(MOT_CURRENT);

        p.CaptionFromClip := p.clip;


        p.OnClick := ACPopupClicks.PopupClipClick;
        p.OnRightClick := ACPopupClicks.PopupClipRightClip;

        SetLeftIcon(p, p.clip, true);
        p.ClickableLeftIcon := true;
    end else begin
        p := self.Add;
        p.ItemType := IT_CLIPBOARD;
        self.SetPrefix(p);
        p.IntegerData := Integer(MOT_CURRENT);
        p.caption := '[empty]';
        p.LeftIcon.Bitmap := FrmClipboardManager.iText.Picture.Bitmap;
        p.Disabled := true;
    end;

    p.HoverOnlyCpation := 'Current Clipboard';
end;
procedure TACPopup.AddCurrentPermanentItems;
var i : integer;

    p, sub : TACPopupItem;
    ci : TPermanentClipItem;
    sl : TCaptionFormatList;
    cl : TClipList;
    s : TCaptionFormat;
    c : Cardinal;
    procedure AddSmallSwitchSubmenu;
    var i : integer;
        wc : TWideChar;
        s : string;
    begin
        // Default/_System
        if FrmPermanent.PermFoldersGetCount <= 2 then EXIT;

        p := self.add;
        p.IsSubmenu := true;
        p.ItemType := IT_SWITCH;
        p.SmallCaption := true;
        p.BottomLine := true;
        s := FrmPermanent.GetPermanentPath;
        p.Caption := s;
        s := lowercase(s);
        for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin
            if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

            sub := p.add;
            //sub.Caption := FrmPermanent.PermFoldersGetItem(i);
            sub.PermanentGroupID := i;
            sub.itemtype := IT_SWITCH;
            sub.CollapseParentOnClick := true;
            sub.OnClick := ACPopupClicks.PermanentGroupClick;
            wc := TWideChar.create;
            wc.Append(WideChar($2192)); {right arrow}
            if not SameText(FrmPermanent.PermFoldersGetItem(i),s) then begin

                sub.Checked := false;
                sub.CheckGrouped;
            end else begin
                sub.checked := true;
                sub.CheckGrouped;
            end;
            wc.Append('[' +FrmPermanent.PermFoldersGetItem(i) + ']');
            sub.caption := wc.GetString;
            MyFree(wc);
            sub.hint := 'Changes the current Permanent Clips group';
        end;
    end;
    procedure ClipToMenuItem(ci : TPermanentClipItem);
    var p : TACPopupItem;
    begin
        p := self.add;
        p.CaptionRaw := ci.getDisplayText;
        p.itemtype := IT_PERMANENT;
        p.PermanentGroupID := -1;
        p.PermanentID  := i;
        p.PermanentType := ci.GetFormatType;

        p.LeftIcon.SetFrom( ImgToBitmap(FrmMainPopup.ImgEdit) );
        p.ClickableLeftIcon := true;
        p.IconHoverCaption := 'Edit ...';
        p.lefticon.IconOnlyOnHover := true;

        case ci.GetFormatType of
        FT_FILE: 		p.lefticon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgFile);
        FT_PICTURE: 	p.lefticon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgPic);
        FT_HTML:		p.lefticon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgHTML);
        FT_RICHTEXT:	p.lefticon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgRichText);
        FT_UNICODE: 	p.lefticon.CliptypeIcon := nil;
        end;

        p.OnClick := ACPopupClicks.PermanentClipClick;

        SetPrefix(p);
    end;
begin
    FrmDebug.StartTimer;


    if not fGroupSwitchUsed then begin
        AddSmallSwitchSubmenu;
    end;
    if frmPermanent.GetCount = 0 then begin
        p := self.Add;
        p.Disabled := True;
        p.Caption := 'Permanent Group Empty';
        p.SmallCaption := true;
        EXIT;
    end;

    TClipDatabase.StartBatch;
    case 0 of
    0:
        begin
            for i := 0 to FrmPermanent.GetCount-1 do begin
                ClipToMenuItem(TPermanentClipItem(FrmPermanent.GetItemClip(i)));
            end;
        end;
    1:
        begin
        cl := TClipList.Create(true);
        FrmDebug.StartTimer;
        TClipDatabase.LoadPermanentClips(cl, FrmPermanent.GetPermanentPath);
        FrmDebug.EndTimerLog('PermCount='+IntToSTr(cl.Count));
        for i := 0 to cl.count - 1 do begin
            ci := TPermanentClipItem(cl[i]);
            ClipToMenuItem(ci);
        end;
        cl.Clear;
        myfree(cl);
        end;
    2:
        begin
        sl := TCaptionFormatList.Create();
        TClipDatabase.LoadPermanentCaptionsAndTypes(sl, FrmPermanent.GetPermanentPath);

        //ci := TPermanentClipItem.Create;
        i := 0;
        for s in sl do begin
            p := self.add;

            p.CaptionRaw := s.Key; {bypass the clip cleaning routings}

            p.LeftIcon.Bitmap  := ImgToBitmap(FrmMainPopup.ImgEdit);
            p.IconHoverCaption := 'Edit ...';
            p.ClickableLeftIcon := true;

            p.LeftIcon.IconOnlyOnHover := true;
            p.itemtype := IT_PERMANENT;
            p.PermanentGroupID := -1;
            p.PermanentID := i;
            p.PermanentType := TClipFormatType(s.Value);
            p.OnClick := ACPopupClicks.PermanentClipClick;
            p.OnRightClick := ACPopupClicks.PopupClipRightClip;

            case TClipFOrmatType(s.value ) of
            FT_FILE: 		p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgFile);
            FT_PICTURE: 	p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgPic);
            FT_HTML:		p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgHTML);
            FT_RICHTEXT:	p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgRichText);
            FT_UNICODE: 	p.LeftIcon.CliptypeIcon := nil;
            end;

            SetPrefix(p);
            inc(i);
        end;
        myfree(sl);
        end;
    end;
    TClipDatabase.EndBatch;
    FrmDebug.EndTimerLog('Current Perm');
end;
procedure TACPopup.AddFullConfigured;
var p : TACPopupItem;
begin
    p := self.Add;
    p.ItemType := IT_FULL;
    if self.UseKeyboard then begin
    	p.Prefix := '&' +FrmConfig.GetAccelSymbols[length(frmconfig.GetAccelSymbols)]+  ' ';
    end;
    if FullMode then begin
        p.Caption := 'Show Less';
        p.Hint := 'Show only configured items';
        p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgConfMode);
    end else begin
        p.Caption := 'Show More';
        p.Hint := 'Show all possible items';
        p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgConfMode);
    end;
    SetPrefix(p);
    p.IconHoverCaption := 'Edit Menu Order ...';
end;
procedure TACPopup.AddLast;

begin
{
    if PData.LastClickedText <> '' then begin
        p := self.add;
        p.Caption := 'Last: ' + PData.LastClickedText;
        self.AddPrefix(p);
    end else begin
        if fFullMode = false then
            inc(fReservedCount);
    end;
}
end;
procedure TACPopup.SetPrefix(p: TACPopupItem);
var accel : char;
	i, j  : integer;
    s : string;
begin
	if self.UsePrefix = false then EXIT;

    if keystrokes.count >= self.TotalShortcutKeysAvailable then EXIT;

    s := stringreplace(p.Caption,'&&','',[rfReplaceAll]);
    if (Pos('&', s)=0) and (pos('&', p.Prefix)=0)  then begin

        j := 0;
        repeat
//        	if j <> 0 then appendlog('Accel key take: ' + accel);

        	accel := GetAccelerator(j);
            if accel = ' ' then begin
                FrmDebug.AppendLog('out of accelerator keys');
                EXIT;
            end;

            i := Keystrokes.IndexOf(accel);
            if (i=-1) then begin
                i := Pos(accel, AccelCharsUsed);
                if i=0 then i:=-1;
            end;
            inc(j);
        until i = -1;
		AcceleratorCount := AcceleratorCount + 1;

        p.Prefix := '&' + accel  + ' ';
        Keystrokes.AddObject(accel, p);
    end else begin
		if (p.ItemType in [IT_POPUPCLIP, IT_PERMANENT, IT_FULL])  then begin
            DetectKeystroke(p);
        end;
    end;
end;
procedure TACPopup.AddProgramOptions;
var p, sub, sub2 : TACPopupItem;
    i : integer;
    s : string;
begin
    p := self.Add;
    s := lowercase(FrmMainPopup.TargetData.ExeName);
    p.caption := '['+TokenString(s,'.exe') + '] Options';
    s := p.Caption;
    s[2] := Uppercase(p.Caption[2])[1];;
    p.Caption := s;
    p.IsExpandable := true;
    p.LeftIcon.Icon := FrmMainPopup.TargetData.icon;
    if p.LeftIcon.Icon = 0 then p.LeftIcon.Icon := UnitClipQueue.ClipDataDefaultIcon;
    p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgAICon);

    p.ItemType := IT_PROGRAM_MENU;
    p.IntegerData := Integer(MOT_PROGRAM);
    SetPrefix(p);
    p.Hint := 'Per-program options for Pasting and Monitoring';
    i := Integer(Paste.GetPasteMethod(FrmMainPopup.TargetData.ExeName));


    sub2 := p.Add;
    sub2.Caption := 'Paste Method';
    MakeSubmenu(sub2);

        sub := sub2.add;
        sub.Caption := '( Use Default )';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 4);
        sub.IntegerData := 4;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;

        sub := sub2.add;
        sub.Caption := 'Mimic Typing';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 2);
        sub.IntegerData := 2;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;

        sub := sub2.add;
        sub.Caption := 'Clipboard Only';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 3);
        sub.IntegerData := 3;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;

        sub := sub2.add;
        sub.Caption := 'keypress [CTRL+V]';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 0);
        sub.IntegerData :=0;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;


        sub := sub2.add;
        sub.Caption := 'keypress [SHIFT+Insert]';
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 1);
        sub.IntegerData := 1;
        sub.CheckGrouped;
        sub.OnClick := ACPopupClicks.PasteMethodClick;

        sub := sub2.add;
        sub.Caption := 'Custom Macro';
        sub.SeparatorLine := true;
        sub.ItemType := IT_PASTE_METHOD;
        sub.Checked := (i = 6);
        sub.IntegerData := 6;
        sub.CheckGrouped;
        sub.Disabled := frmSysTrayMenu.GetProgramMacro(FrmMainPopup.TargetData.ExeName) = '';
        sub.OnClick := ACPopupClicks.PasteMethodClick;


    sub := p.add;
    sub.caption := 'Disable Monitoring';
    sub.SeparatorLine := true;
    sub.ItemType := IT_PASTE_METHOD;
    sub.Checked := FrmSysTrayMenu.IsDisabledEXE(FrmMainPopup.TargetData.ExeName);
    sub.OnClick := ACPopupClicks.ProgramOptionDisableMonitoring;

    sub := p.add;
    sub.caption := 'Disable ''Mouse Button Trigger''';
    sub.ItemType := IT_PASTE_METHOD;
    sub.Checked := FrmSysTrayMenu.IsNoRightClickEXE(FrmMainPopup.TargetData.ExeName);
    sub.OnClick := ACPopupClicks.ProgramOptionDisableRightClickPopup;

    sub := p.add;
    sub.caption := 'Explorer Compatibility';
    sub.ItemType := IT_PASTE_METHOD;
    sub.Checked := FrmSysTrayMenu.IsExplorerCompatEXE(FrmMainPopup.TargetData.ExeName);
    sub.OnClick := ACPopupClicks.ProgramOptionExplorerCompat;

    sub := p.add;
    sub.caption := 'More ...';
    sub.SeparatorLine := true;
    sub.ItemType := IT_PASTE_METHOD;
    sub.IntegerData := Integer(owConfiguration);
    sub.OnClick := ACPopupClicks.ConfigurationPerProgram;
    sub.CaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);

    self.CheckForAutoExpand(p);
end;
procedure TACPopup.AddSearch;
var p : TACPopupItem;
begin
    p := self.Add;
    p.Caption := 'Search and Paste ...';
    p.CaptionTrailingBitmap := ImgToBitmap(FrmMainPopup.imgSearch);
    p.ItemType := IT_SEARCH;
    p.IntegerData := Integer(owSearch);
    p.OnClick := ACPopupClicks.OpenWindowCommand;
    p.hint := 'Shows the ''Search'' Window';
    SetPrefix(p);
end;
procedure TACPopup.MakeSubmenu(p: TACPopupItem);
begin
    p.IsSubMenu := true;
    p.Disabled := true;
    p.ItemType := IT_POPUP;
    p.LeftIcon.IconOnlyOnHover := true;
end;
procedure TACPopup.AddSwitchToItems;
var i : integer;
    sub : TACPopupItem;
    s : string;
    wc : TWideChar;
begin
    s := lowercase(frmPermanent.GetPermanentPath);
    for i := 0 to frmPermanent.PermFoldersGetCount - 1 do begin
    	if SameText(frmPermanent.PermFoldersGetItem(i),s) then CONTINUE;
        if FrmPermanent.PermFolderIsSystem(i) then CONTINUE;

        sub := self.add;
        sub.PermanentGroupID := i;
        sub.itemtype := IT_SWITCH;
        sub.OnClick := ACPopupClicks.PermanentGroupClick;
        wc := TWideChar.create;
        if not SameText(FrmPermanent.PermFoldersGetItem(i), s) then begin
            wc.Append(WideChar($2192)); {right arrow}
        end;
        wc.AppendUnicode('[' +FrmPermanent.PermFoldersGetItem(i) + ']');
        sub.caption := wc.GetString;
        MyFree(wc);
        sub.hint := 'Changes the current Permanent Clips group';
        sub.LeftIcon.Bitmap := ImgToBitmap(frmmainpopup.imgPermCasc);
        SetPrefix(sub);
    end;
end;
procedure TACPopup.AddSystem;
var p, sub, sub2 : TACPopupItem;
begin
    p := self.add;
    p.Caption := 'System';
    p.LeftIcon.Bitmap := ImgToBitmap(frmmainpopup.imgAICon);
    p.IsExpandable := true;
    SetPrefix(p);
    p.IntegerData := Integer(MOT_SYSTEM);
    p.ItemType := IT_SYSTEM_MENU;


    sub := p.Add;
    sub.Caption := 'Configuration ...';
    sub.CaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
    sub.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgA);
    sub.LeftIcon.IconOnlyOnHover := true;
    sub.ItemType := IT_SYSTEM;
    sub.IntegerData := Integer(owConfiguration);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.hint := 'Shows the ''Configuration'' Window';
    sub.CaptionIconOnlyOnHover := true;

//    p.addline;

//    sub := p.Add;
//    sub.Caption := 'Permanent Clips/Macros ...';
//    sub.SeparatorLine := true;
//    sub.fCaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
//    sub.fLeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgPermCasc);
//    sub.fLeftIconOnlyOnHover := true;
//    sub.ItemType := IT_SYSTEM;
//    sub.fIntegerData := Integer(owPermanentClips);
//    sub.OnClick := ACPopupClicks.OpenWindowCommand;
//    sub.hint := 'Shows the ''Permanent Clips'' Window';
//    sub.fCaptionIconOnlyOnHover := true;

    sub := p.Add;
    sub.Caption := 'Edit Clips/Macros ...';
    sub.CaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
    sub.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgEdit);
    sub.LeftIcon.IconOnlyOnHover := true;
    sub.ItemType := IT_SYSTEM;
    sub.IntegerData := Integer(owEditHistory);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.hint := 'Shows the ''Edit Clips'' Window';
    sub.CaptionIconOnlyOnHover := true;

    sub := p.Add;
    sub.Caption := 'Edit Clipboard ...';
    sub.CaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
    sub.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgPaste);
    sub.LeftIcon.IconOnlyOnHover := true;
    sub.ItemType := IT_SYSTEM;
    sub.IntegerData := Integer(owEditClipboard);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.Clip := CurrentClipboard;
    sub.hint := 'Edits the clipboard using an external program';
    sub.CaptionIconOnlyOnHover := true;

//    p.AddLine;

    sub := p.Add;
    sub.caption := 'Flush History';
    sub.SeparatorLine := true;
    sub.ItemType := IT_POPUP;
    MakeSubmenu(sub);
//    sub.Hint := 'Erase Clipboad History';

    sub2 := sub.add;
    sub2.Caption := 'Erase Clipboard';
    sub2.IntegerData := Integer(peClipboard);
    sub2.OnClick := ACPopupClicks.EraseHistory;
    sub2 := sub.add;
    sub2.Caption := 'Erase Popup Clips';
    sub2.IntegerData := Integer(pePopupClips);
    sub2.OnClick := ACPopupClicks.EraseHistory;
    sub2 := sub.add;
    sub2.Caption := 'Erase Removed Clips';
    sub2.IntegerData := Integer(peRemovedClips);
    sub2.OnClick := ACPopupClicks.EraseHistory;
//    sub.AddLine;
    sub2 := sub.add;
    sub2.Caption := 'Erase Everything';
    sub2.SeparatorLine := true;
    sub2.IntegerData := Integer(peEverything);
    sub2.OnClick := ACPopupClicks.EraseHistory;


    sub := p.Add;
    sub.Caption := 'Toggle Clipboard Bar';
    sub.LeftIcon.Bitmap := ImgToBitmap(frmmainpopup.imgPaste);
    sub.ItemType := IT_SYSTEM;
    sub.Checked := frmClipboardBar.IsVisible;
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.hint := 'Shows or hides the Clipboard Bar';
    sub.LeftIcon.IconOnlyOnHover := true;
    sub.onclick := ACPopupClicks.ToggleClipboardBar;

//    p.addline;

    sub := p.Add;
    sub.Caption := 'About / Backup ...';
    sub.SeparatorLine := true;
    sub.CaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
    sub.ItemType := IT_SYSTEM;
    sub.IntegerData := Integer(owAbout);
    sub.OnClick := ACPopupClicks.OpenWindowCommand;
    sub.hint := 'Shows the ''About'' Window';

    sub := p.Add;
    sub.Caption := 'Exit';
    sub.ItemType := IT_SYSTEM;
    sub.OnClick := frmSysTrayMenu.ExitMenuItemClickEvent;
    sub.hint := 'Closes the program';

    self.CheckForAutoExpand(p);
end;

procedure TACPopup.AddTools;
var
    p : TACPopupItem;
    s : string;

    prefix : string;
    procedure AddFilter;
    begin
        p := tools.Add;
        p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgSearchTool);
        p.ItemType := IT_TOOL;
        leftToolsList.Add(p);
        p.OnClick := ACPopupClicks.ToolFilterClick;
        p.Prefix := '&'+toolsAccelChars[1];
        Keystrokes.AddObject(toolsAccelChars[1],p);
        p.Hint := 'Filter';
        if (p.prefix <> '') and (not p.Disabled) then begin
            p.Hint := p.Hint +'  [Key '+p.Prefix[2]+']';;
        end;
        if (Filter.Text <>'') then begin
            p.Caption := '('+Filter.Text+')';
        end;
        if not UseKeyboard then begin
            HideFilter;
            p.Disabled := true;
            p.LeftIcon.IconOpacity := 100;
        end;
        if (fExplorerMode) then begin
            p.Disabled := true;
            p.LeftIcon.IconOpacity := 100;
        end;
    end;
    procedure AddLessMore;
    begin
        p := Tools.Add;
        if self.UsePrefix then begin
            p.Prefix := '&' +prefix+  ' ';
        end;
        if not FullMode then begin
            p.Hint := 'Show More  [Key '+prefix+' ]';
            p.caption := 'More';
            p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgMore);
        end else begin
            p.Hint := 'Show Less  [Key '+prefix+' ]';
            p.caption := 'Less';
            p.LeftIcon.Bitmap :=  ImgToBitmap(FrmMainPopup.imgLess);
        end;
        Keystrokes.AddObject(prefix, p);
        leftToolsList.Add(p);
        p.ItemType := IT_TOOL;
        p.OnClick := ACPopupClicks.ToolMoreLessClick;
        p.StayOpenOnClick := true;
       // p.fScaleLeftBitmapToHeight := true;
    end;
    procedure HandleCaption;
    begin
        if (fExplorerMode) then begin
            p := tools.Add;
            p.ItemType := IT_TOOL;
            p.isGap := true;
            p.SmallCaption := true;
            p.NoSmallHeight := true;
            p.CaptionRaw := '[Explorer Mode]';

            leftToolsList.Add(p);
        end else if fClipboardOnlyWarning then begin
            p := tools.Add;
            p.ItemType := IT_TOOL;
            p.isGap := true;
            p.SmallCaption := true;
            p.Caption := '[Clipboard Only]';
            p.NoSmallHeight := true;

            leftToolsList.Add(p);

            p := tools.Add;
            p.ItemType := IT_TOOL;
            p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgUnkown);
            p.Hint :=
            'This mode is enabled because:' + #13#10#13#10+
            fClipboardOnlyMessage;
            leftToolsLIst.add(p);
        end;
    end;
    procedure AddSystem;
    begin
        p := Tools.Add;
        p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgSystem);
        p.Hint := 'System Menu';
        p.Caption := '';
        p.OnClick := ACPopupClicks.ToolSystemMenuClick;
        p.ItemType := IT_TOOL;

        p.StayOpenOnClick := true;
        //p.fScaleLeftBitmapToHeight := true;
    end;
    procedure AddPin;
    begin
        p := Tools.Add;
        if (fpopupMode.equals(pdmPinned)) then begin
            p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgPin2);
        end else begin
            p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgPin);
        end;
        //p.fScaleLeftBitmapToHeight := true;
        p.Hint := 'Pin to Desktop';
        p.ItemType := IT_TOOL;
        p.OnClick := HandlePinnedModeClick;
    end;
var
    i : integer;
    wd : integer;
begin
    Tools.SubMenu.Clear;
    prefix := FrmConfig.GetAccelSymbols[length(frmconfig.GetAccelSymbols)];

    leftToolsList.Clear;

    // left to right
    AddFilter;
    AddLessMore;
    HandleCaption;

    // right to left
    AddSystem;
    AddPin;
end;
type
    cliphelper = class helper for TClipItem
public
    procedure setFormat(format : word);
end;
procedure cliphelper.setFormat(format : word);
begin
    self.cformat := self.FileFormatToFormat(format);
end;
procedure TACPopup.AddPopupClips;
var i, clipcnt, lastClipcnt : integer;
    lastIcon : HICON;
    lastBM : TBitmap;
    p : TACPopupItem;
    group : TACPopupItem;
    clp : TClipItem;
    clipFormat : word;
    str, text : string;
    sl : TStringList;
    removedCnt: integer;
CONST LEFT_OPACITY = 200;
    procedure SetClipTypeIcon(p : TACPopupItem);
    begin
        case p.clip.GetFormatType of
        FT_FILE:
            begin
                self.fHasFiles := true;
                p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgFile);
            end;
        FT_PICTURE:
            begin

                p.LeftIcon.CliptypeIcon := nil;
                if p.ItemType = IT_PERMANENT then begin
                    p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgPic);
                end;
            end;
        FT_HTML:		p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgHTML);
        FT_RICHTEXT:	p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgRichText);
        FT_UNICODE: 	p.LeftIcon.CliptypeIcon := nil;
        end;

        if p.LeftIcon.CliptypeIcon <> nil then
        	p.LeftIcon.CliptypeIcon.TransparentColor := $AAAAAA;
    end;
    procedure SetPopupPrexif(p : TACPopupItem);
    begin
        if FrmConfig.cbPinnedShortcuts.Checked then begin
            p.prefix :=  '&' + GetAcceleratorReserved(clipcnt+PinnedClipQueue.GetQueueCount) +' ';
        end else begin
            p.prefix :=  '&' + GetAcceleratorReserved(clipcnt) +' ';
        end;
    end;
    procedure AddPinnedClips;
    var i : integer;
    begin
        if PinnedClipQueue.GetQueueCount > 0 then begin
            for i := (PinnedClipQueue.GetQueueCount - 1) downto 0 do begin
                p := self.add;
                p.Clip := PinnedClipQueue.GetClipItem(i);
                p.CaptionFromClip := p.clip;
                //p.Prefix := '  ';
                if self.UsePrefix and frmconfig.cbPinnedShortcuts.checked then begin
                    p.prefix := '&' + GetAcceleratorReserved((PinnedClipQueue.GetQueueCount-1)-i) +' ';
                end;
                p.ItemType := IT_PINNED;
                SetLeftIcon(p, p.Clip);
                p.LeftIcon.IconOpacity := LEFT_OPACITY;
                p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgUnkown);
                p.ClickableLeftIcon := true;
                p.OnClick := ACPopupClicks.PopupClipClick;
                p.OnRightClick := ACPopupClicks.PopupClipRightClip;
                p.IntegerData := i;

                //SetClipTypeIcon(p);

                p.LeftIcon.CliptypeIcon := ImgToBitmap(frmClipboardManager.iPin);
                DetectKeystroke(p);
            end;
            //Self.AddLine;
        end;
    end;
    procedure HandleGroupingSetup;
    begin
         //
        // use group when enabled and history > set size
        // use group ONCE when popup too tall and a large enough history
        // use group when a filter is present

        if frmconfig.rbClipSetsAlways.Checked then begin
            self.fUseGrouping := true;
        end else begin
            self.fUseGrouping := (ClipQueue.GetQueueCount > FrmConfig.udClipsPerSet.Position)
                and FrmConfig.cbEnableClipSets.Checked;
            if self.fUseGroupingOnce then begin
                Self.fUseGroupingOnce := false;
                self.fUseGrouping := (ClipQueue.GetQueueCount > FrmConfig.udClipsPerSet.Position);
                self.fUseGroupingOnceFailed := not self.fUseGrouping;
            end;
        end;
        self.ClipsPerSet := FrmConfig.udClipsPerSet.Position;

        if Filter.Text <> '' then self.fUseGrouping := true;
        fFilterItem := nil;
    end;
    function GetCurrentGroup(forceNew : boolean = false; Title : string = '  Clip Set  ') : TACPopupItem;
    var
        rem : integer;
    begin
        result := group;
        if (clipcnt<>0) and (lastclipcnt = clipcnt) then EXIT;

        rem := clipcnt mod self.ClipsPerSet;
        if ( (rem = 0) and
            not ((clipcnt=0) and (fgroup.count<>0))
            ) or forceNew then begin
            lastIcon := 0;
            lastBM := nil;
            lastClipcnt := clipcnt;
            group := self.Add;
            group.IsExpandable := true;
            group.ItemType := IT_CLIPSET_HEADER;
            if (clipcnt < 10) then begin
                group.Caption := Title+' ('+IntToStr(clipcnt+1)+'-'+
                    IntToStr(clipcnt + (ClipsPerSet -  rem))+')';
            end else begin
                group.Caption := Title+' ('+IntToStr(clipcnt+1)+'-'+
                    IntToStr(clipcnt + (ClipsPerSet -  rem))+')';
            end;
            group.Expanded := false;
            group.ShowCollapseIcon := false;
            group.CanExpand := self.ClipSetCanExpand;
            group.CanCollapse := self.ClipSetCanCollapse;
            group.IntegerData := fgroup.count;


            SetPrefix(group);
            Self.AcceleratorCount := self.AcceleratorCount-1;   // kludge to keep the shortcut key for the first submenu right
            fGroup.Add(group);
        end;
        result := group;
    end;
    procedure HandleIconVisual;
    begin
        p.LeftIcon.IconOpacity := LEFT_OPACITY;
        case frmconfig.GetIconType of
        CBXICONTYPE_PROGRAM:
            begin
                SetLeftIcon(p, p.Clip);
                case FrmConfig.GetRepeatIcons of
                CBXREPEATICONS_DIMMED:
                    begin
                        if (p.LeftIcon.Icon = lasticon) and (lasticon<>0) then begin
                            p.LeftIcon.IconOpacity := 25;

                        end;
                        lasticon := p.LeftIcon.Icon;
                    end;
                CBXREPEATICONS_NORMAL:
                    begin
                    end;
                CBXREPEATICONS_HIDDEN:
                    begin
                        if (p.LeftIcon.Icon = lasticon) and (lasticon<>0) then begin
                            p.LeftIcon.IconOpacity := 0;
                        end;
                        lasticon := p.LeftIcon.Icon;
                    end;
                end;
            end;
        CBXICONTYPE_CLIPTYPE:
            begin
                SetLeftIcon(p, p.Clip);
                case FrmConfig.GetRepeatIcons of
                CBXREPEATICONS_DIMMED:
                    begin
                        if (p.LeftIcon.Bitmap = lastBM) and (lastBM<>nil) then begin
                            p.LeftIcon.IconOpacity := 25;
                        end;
                        lastBM := p.LeftIcon.Bitmap;
                    end;
                CBXREPEATICONS_NORMAL:
                    begin

                    end;
                CBXREPEATICONS_HIDDEN:
                    begin
                        if (p.LeftIcon.Bitmap = lastBM) and (lastBM<>nil) then begin
                            p.LeftIcon.Bitmap := nil;
                        end else begin
                            lastBM := p.LeftIcon.Bitmap;
                        end;
                    end;
                end;

            end;
        CBXICONTYPE_NONE:
            begin

            end;
        end;

    end;
begin
    CurrentClipboard.GetClipboardItem(0);

    self.fHasFiles := false;

    AddPinnedClips;
    HandleGroupingSetup;

    self.fGroup.Clear;

    clipcnt := 0;
    lastClipcnt := 0;
    {$region 'Generate Popup Clips'}
    // extract Clip, Caption, Prefix, and 2 possible icons
    for i := 0 to ClipQueue.GetQueueCount - 1 do begin
        clp := ClipQueue.GetClipItem(i);
        if self.fUseGrouping then begin
            p := GetCurrentGroup;
            if filter.Text <> '' then begin
                if not ContainsText(clp.GetAsPlaintext, filter.Text)then begin
                    CONTINUE;
                end;
            end;
            p := p.Add;
        end else begin
            p := self.add;
        end;

        p.Clip := clp;
        p.CaptionFromClip := p.clip;
        if self.UsePrefix then begin
            if (not FrmConfig.cbPopupCharLimit.Checked) or
                (clipcnt < frmconfig.udPopupKeysLimit.Position) then begin
                SetPopupPrexif(p);
            end;
        end;
        inc(clipcnt);
        p.ItemType := IT_POPUPCLIP;
        HandleIconVisual;
        p.ClickableLeftIcon := true;
        p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgUnkown);
        p.OnClick := ACPopupClicks.PopupClipClick;
        p.IntegerData := i; // ClipQueue Index - not a mistake

        SetClipTypeIcon(p);
        DetectKeystroke(p);
    end;
    {$endregion}
    {$region 'Handle No Clips with Grouping on'}
    if self.fUseGrouping and (clipcnt=0) then begin
        if fgroup.count = 0 then GetCurrentGroup;
        p := self.Add;
        p.Caption := '[No Clips]';
        p.ItemType := IT_NONE;
        p.Disabled := true;
    end;
    {$endregion}

    {$region 'Search Removed checkbox'}
    if (filter.Text <> '')  then begin
        p := self.Add;
        p.Caption := 'Search Removed';
        p.ItemType := IT_SYSTEM;
        p.OnClick := self.SearchRemovedClicked;
        p.StayOpenOnClick := true;
        p.Checked := self.searchRemoved;
        p.SeparatorLine := true;
        SetPrefix(p);

    end;
    {$endregion}

    {$region 'Removed Clips open window'}
    if ((self.fUseGrouping and (fgroup.count > 1)) or
        (clipqueue.GetQueueSize=ClipQueue.GetQueueCount)) and
        (filter.Text = '') then begin
        if fgroup.count>=1 then begin
            p := TACPopupItem(fgroup.items[fgroup.count-1]).Add;
            p.Caption := 'Removed Clips ...';
            p.SeparatorLine := true;
            p.CaptionTrailingBitmap := ImgToBitmap(frmmainpopup.imgNewWindow);
            p.LeftIcon.Bitmap := ImgToBitmap(FrmMainPopup.imgRemoved);
            p.LeftIcon.IconOnlyOnHover := true;
            p.ItemType := IT_SYSTEM;
            p.OnClick := ACPopupClicks.OpenWindowCommand;
            p.IntegerData := integer(owRemovedClips);
        end;
    end;
    {$endregion}


    if (searchRemoved and (filter.text <> '')) then begin
        clipcnt := 0;
        lastClipcnt := 0;
        clp := TClipItem.Create;
        TClipDatabase.StartTextOnlyData;
        i := 0;
        str := filter.Text;
        str := StringReplace(str, chr($20), chr($a0),[rfReplaceAll]);
        removedCnt := 0;
        while (TClipDatabase.LoadNextText(text,clipFormat)) do begin
            if ContainsText(text, str) then begin
                clp.setFormat(clipFormat);
                p := GetCurrentGroup(removedCnt=0,'  Removed Clips  ');
                p := p.Add;
                p.Clip := clp;
                p.Caption := text;
                if self.UsePrefix then begin
                    if (not FrmConfig.cbPopupCharLimit.Checked) or
                        (clipcnt < frmconfig.udPopupKeysLimit.Position) then begin
                        SetPopupPrexif(p);
                    end;
                end;
                inc(removedCnt);
                p.ItemType := IT_TEMP;
                HandleIconVisual;
                p.LeftIcon.CliptypeIcon := ImgToBitmap(FrmMainPopup.imgUnkown);
                p.OnClick := ACPopupClicks.RemovedClicked;
                p.IntegerData := i;

                SetClipTypeIcon(p);
                DetectKeystroke(p);
                inc(clipcnt);

                p.clip := nil;
            end;
            inc(i);
        end;
        TClipDatabase.EndTextOnlyData;
        myfree(clp);
    end;
    if self.fUseGrouping and searchRemoved and (removedCnt = 0) and (filter.text <> '') then begin
        //if fgroup.count = 0 then  getCurrentGroup;
        p := self.Add;
        p.Caption := '[No Removed Clips]';
        p.ItemType := IT_NONE;
        p.Disabled := true;
    end;


    if self.fUseGrouping and (fgroup.Count <>0) then begin
        if not (self.fCurrentGroup < fgroup.Count) then begin
            self.fCurrentGroup := 0;
        end;
        TACPopupItem(fGroup.Items[self.fCurrentGroup]).Expanded := true;
    end;
end;

procedure TACPopup.Reset;
begin
    inherited;
end;

procedure TACPopup.AutoPopulate;
var i, x, cnt : integer;
	c : char;
    linebefore : boolean;
    mot : TMenuOrderType;
    s : string;
    b : boolean;
    procedure InitCaption;
    var c : TCanvas;
    begin
        ShowCaption := true;

        GetCanvas.Font := Config.GetFont;
        GetCanvas.Font.Size := Config.GetFont.Size;
        GetCanvas.font.Style := Config.getfont.style;
        CaptionHeight :=  CalcCaptionHeight;
    end;
    procedure EmptyMenuOrderWorkaround;
    begin
        if (FrmConfig.lvOrder.items.Count=0) then begin
            FrmConfig.lvOrder.HandleNeeded;
            if (FrmConfig.lvOrder.items.Count=0) then begin
                raise Exception.Create('Error: [Configuration>Popup>Menu Order] is empty.');
                EXIT;
            end;
        end;
    end;
    procedure SetupColor;
    begin
        // default colors
        fBackgroundColor := ColorToRGB(clBtnFace);
        fHighlightColor := ColorToRGB(clHighlight);
        fFontColor := ColorToRGB(clBtnText);


        fClickedColor := $00790079;

        // config colors
        if FrmConfig.cbFontColor.Checked then begin
            fFontColor := ColorToRGB(FrmConfig.pnlFontColor.color);
        end;
        if FrmConfig.cbHighlightColor.Checked then begin
            fHighlightColor := ColorToRGB(FrmConfig.pnlHighlightColor.color);
        end;
        if FrmConfig.cbBackgroundColor.Checked then begin
            fBackgroundColor := ColorToRGB(FrmConfig.pnlBackgroundColor.color);
        end;
        if frmconfig.cbClickedColor.Checked then begin
            fClickedColor := ColorToRGB(FrmConfig.pnlClickedColor.color);
        end;



        // derived colors
        fExpandedBackgroundColor := BlendOrReverse(fBackgroundColor, clWhite, clBlack, 90);

        //fExpandedBackgroundColor := DimColorOrReverse(fBackgroundColor, 1.02);
        fColumnColor := BlendOrReverse(fBackgroundColor, $000000, clWhite, 93);
        fColumnEdgeColor := DimColorOrReverse(fBackgroundColor,0.86);
        //fDisabledColor := BlendOrReverse(fFontColor, clWhite, clBlack, 70);
        fDisabledColor := Blend(fFontColor, clGrayText, 30);
        fCaptionColor := fColumnColor;

//        fCaptionColor := Blend(fColumnColor, clBlue, 99);
        if (frmConfig.cbTitleColor.Checked) then begin
            fCaptionColor := ColorToRGB(FrmConfig.pnlTitleColor.Color);
        end;
        if not UseKEyboard then begin
            fCaptionColor := DimColorOrReverse(fCaptionColor, 0.93);
        end;
    end;
    procedure ReserveUserSetPermanentKeys;
    var i,j : integer;
    begin
        fGroupSwitchUsed := false;
        // reserve user set permanent keys
        for i := 0 to FrmConfig.lvOrder.items.Count - 1 do begin
            mot := TMenuOrderType(frmConfig.lvOrder.Items[i].data);
            if frmConfig.lvOrder.Items[i].Checked or
                FullMode or
                ((mot = MOT_PASTEUTILS) and self.UseFormMode)  then begin
                case mot of
                    MOT_PERMANENT: begin
                        for j := 0 to FrmPermanent.GetCount - 1 do begin
                            s := FrmPermanent.GetItemName(j);
                            s := StringReplace(s,'&&','',[rfReplaceAll]);
                            x := pos('&', s);
                            if (x<>0) then begin
                                if x<length(s) then begin
                                    c := upcase(s[x+1]);
                                    AccelCharsUsed := AccelCharsUsed + c;
                                end;
                            end;
                        end;
                    end;
                    MOT_SWITCH:
                        begin
                            fGroupSwitchUsed := true;
                        end;
                end;
            end;
        end;
        FrmDebug.AppendLog('PermKeys= '+AccelCharsUsed);
        FrmDebug.AppendLog('FrmConfig.lvOrder.items.Count='+IntToStr(FrmConfig.lvOrder.items.Count));
    end;

var t : Cardinal;
begin
    t := Windows.GetTickCount;
    FrmDebug.AppendLog('Clear Popup');
    FrmDebug.StartTimer;
    EmptyMenuOrderWorkaround;
    self.Reset;
    self.fPasteFiles := nil;
    items.SubShowing := nil;

    InitCaption;


    self.TotalShortcutKeysAvailable := length(frmConfig.GetAccelAlphaNumeric) + length(frmConfig.GetAccelSymbols);

    if (frmconfig.getalwaysClearFilter) and not self.Showing then begin
        filter.text := '';
    end;

    SetupColor;

    CancelHoverTimer;
    Keystrokes.Clear;
    //fExpandedKeystrokes.Clear;

    ClearHover;



    if FrmConfig.cbPopupCharLimit.Checked then begin
        if frmConfig.cbPinnedShortcuts.Checked then begin
            AcceleratorCount := Min(ClipQueue.GetQueueSize, FrmConfig.udPopupKeysLimit.position) +
                 PinnedClipQueue.GetQueueCount;
        end else begin
            AcceleratorCount := Min(ClipQueue.GetQueueSize, FrmConfig.udPopupKeysLimit.position);
        end;
    end else begin
        if frmConfig.cbPinnedShortcuts.Checked then begin
            AcceleratorCount := ClipQueue.GetQueueSize + PinnedClipQueue.GetQueueCount;
        end else begin
            AcceleratorCount := ClipQueue.GetQueueSize;
        end;
    end;
    if (ShowCaption) then begin
        toolsAccelChars := toolsAccelChars + GetAcceleratorReserved(AcceleratorCount);
        AcceleratorCount := AcceleratorCount + 1; // Filter

    end;
    AccelCharsUsed := '';
    if (ShowCaption) then begin
        self.AddTools;
    end;



    if frmConfig.cbFilterSimplified.Checked and
        (filter.Text <> '')  then begin
        self.AddPopupClips;
        if not self.UseKeyboard then begin
            self.AddLine;
            self.AddCancel;
        end;
    end else begin
        ReserveUserSetPermanentKeys;
        FrmDebug.EndTimerLog('Pre Add Menu Items');
        FrmDebug.StartTimer;


        for i := 0 to FrmConfig.lvOrder.items.Count - 1 do begin

            linebefore := (FrmConfig.lvOrder.items[i].SubItems[0] = 'Yes');

            mot := TMenuOrderType(frmConfig.lvOrder.Items[i].data);
            b := FullMode;
            if MOT = MOT_CANCEL then begin
                // always show CANCEL when forced keyboard off detected
                if (not FrmMainPopup.GetNeedsFocus) then begin
                    FullMode := true;
                end;
            end;

            if frmConfig.lvOrder.Items[i].Checked or
                FullMode or
                ((mot = MOT_PASTEUTILS) and self.UseFormMode)  then begin
                if linebefore and (items.SubMenu.Count > 0) then begin
                   self.AddLine;
                end;
                cnt := Items.SubMenu.Count;
                case mot of
                    MOT_MENU : begin
                        self.AddPopupClips;
                    end;
                    MOT_CANCEL : self.AddCancel;
                    MOT_CURRENT : self.AddCurrentClipboard;
                    MOT_PROGRAM :
                    begin
                        self.AddProgramOptions;
                    end;
                    MOT_SYSTEM : self.AddSystem;
                    MOT_PASTEUTILS : self.AddPastingTools;
                    MOT_PERMANENT : begin
                        // don't show in full mode, unless configured to show normally
                        if not (FullMode and (not frmConfig.lvOrder.Items[i].Checked)) then begin
                            self.AddCurrentPermanentItems;
                        end;
                    end;
                    MOT_SWITCH :
                        begin
                            if frmconfig.cbPermanentItemsSubmenu.checked then
                                self.AddSwitchToSubmenu
                            else
                                self.AddSwitchToItems;
                        end;
                    MOT_FULL : self.AddFullConfigured;
                    MOT_ALLPERMANENT :
                        begin
                            self.AddAllItemsSubmenu;
                        end;
                    MOT_SEARCH: self.AddSearch;
                    MOT_BREAK:  if not (fullMode and (not frmConfig.lvOrder.Items[i].Checked)) then begin
                         self.AddBreak; // don't add breaks in Full Mode
                    end;

                end;
                // remove lines for items that generate no new menuitems
                if linebefore and (cnt = Items.SubMenu.count) then begin
                    if cnt <> 0 then begin
                        AddLineToNext := false;
                    end;
                end;
            end;
            FullMode := b;
        end;

    end;

    if fPasteFiles <> nil then begin
        fPasteFiles.Disabled := not self.fHasFiles;
    end;

    FrmDebug.AppendLog('End of AutoPopulate = '+ IntToStr(items.submenu.count));
    FrmDebug.EndTimerLog('AutoPopulate');
end;



{Clip Menu Routines}
function TACPopup.ClipMenuVisible : Boolean;
begin
    result := TClipMenu2(fim).Showing;
end;
procedure TACPopup.ClipMenuReportKey(key : Char);
begin
    fim.ReportKeypress(key);
end;
procedure TACPopup.ClipMenuReportKey(key : word);
begin
    fim.ReportKeypress(key);
end;
procedure TACPopup.ClipMenuHide;
begin
    if TClipMenu2(fim).showing then begin
        fim.Hide;
    end;
end;
procedure TACPopup.ClipMenuShow(rightclick : boolean = false);
var cm : TClipMenu2;
    procedure ShowIt;
    var fm : TPopupDisplayMode;
    begin
        self.fPopupMode.PushValue;
        self.fPopupMode.setMode(pdmStayOpen);
        cm.ShowEX(self.top, self.left,rightclick);
        self.fPopupMode.PopValue;
    end;
begin
	if hover = nil then EXIT;
    cm := TClipMenu2(fim);
    if (hover = fim.GetACPopupItem) and TClipMenu2(fim).showing then exit;


    self.MouseCursorReset;
    self.ClipMenuHide;
    case hover.ItemType of
        IT_PERMANENT:
            begin
                cm.SetPermanentClipMode;
                cm.SetPermanentClip(hover.PermanentGroupID, hover.PermanentID, hover.PermanentType);
                cm.SetACPopupItem(hover);
                ShowIt;
            end;
        IT_POPUPCLIP,
        IT_TEMP,
        IT_CLIPBOARD,
        IT_PINNED:
            begin
                if hover.Clip <> nil then begin
                    cm.SetPopupClipMode;
                    cm.SetACPopupItem(hover);
                    ShowIt;
                end;
            end;
    else
        begin
        end;
    end;

end;

{utility}
function TACPopup.GetPermanentFrom(p : TACPopupItem) : TClipItem;
var
    s : string;
begin
    result := nil;
    if p.ItemType = IT_PERMANENT then begin
        result := TClipITem.Create;
        if (p.PermanentGroupID = -1) then begin
            s := FrmPermanent.GetPermanentPath;
        end else begin
            s := FrmPermanent.PermFoldersGetItem(p.PermanentGroupID)
        end;
        TClipDatabase.LoadPermanent(
            result,
            p.PermanentID,
            s
        );
    end;
end;
function TACPopup.FindByType(it : TItemType) : TACPopupItem;
var i : integer;
begin
    result := nil;
    for i := 0 to items.SubMenu.Count-1 do begin
        if items.SubMenu[i].ItemType = it then begin
            result := items.SubMenu[i];
            EXIT;
        end;
    end;
end;



procedure TACPopup.CheckForAutoExpand(p : TACPopupItem);
begin
    if p.ItemType = fAutoExpandOnce then begin
        p.Expanded := true;
    end;
end;


procedure TACPopup.HandleOnClick(p: TACPopupItem);
    function SafeClick(p : TACPopupItem) : boolean;
    begin
        result := false;
        if assigned(p.OnClick) then begin
            result := true;
            p.OnClick(p);
        end;
    end;
var
    h : THandle;
    special : Boolean;
    ci : TClipITem;
    savedMode : TPopupDisplayMode;
begin
    HideTooltip;

    special := true;
    case p.ItemType  of
    IT_NEXTFIELD:begin
        ci := TClipItem.Create;
        TClipDatabase.LoadPermanent(ci, p.IntegerData, FORM_MODE_FOLDER);
        TFocusManager.ForceForeground(FrmMainPopup.TargetData.ForegroundWindow);
        Paste.SendMacro(ci.GetAsPlaintext);
        myfree(ci);
    end;
    IT_CANCEL: begin
        self.Hide;
    end;
    else begin
        special := False;
    end;
    end;
    if special then Exit;

    if p.ItemType = IT_POPUPCLIP then begin
        if p.Clip <> nil then  begin
            p.Clip.CData.Clicked := true;
        end;
    end;


    case ACPopupClicks.OverrideClickType(p) of
    OC_NONE:
        begin
        end;
    OC_STAY_OPEN:
        begin
            fPopupMode.PushValue;
            fPopupMode.setMode(pdmStayOpen);

            ACPopupClicks.StayOpenClick(p);
            fPopupMode.PopValue;

            if FrmMainPopup.GetNeedsFocus then begin
                TFocusManager.ForceForeground(self.Handle);
            end;
            self.RebuildPopup;
            EXIT;
        end;
    OC_RIGHT_CLICK:
        begin
            self.ClipMenuShow;
            EXIT;
        end;
    OC_PIN_TO_LIST:
        begin
            if SafeClick(p) then begin
                self.RebuildPopup;
            end;
            EXIT;
        end;
    OC_TITLEBAR_SHORTCUTS:
        begin
            ShowCaptionShortcuts := true;
            self.RebuildPopup(False);
            EXIT;
        end;
    end;

    case p.ItemType  of
    IT_POPUPCLIP,IT_PINNED,IT_PERMANENT, IT_CLIPBOARD,IT_TEMP,IT_SYSTEM,IT_SEARCH,
    IT_PASTE_METHOD,IT_TOOL  : begin
        case LastPosition  of
        pipLeftIcon: ;
        pipCaption: begin
            if assigned(p.OnClick) then begin

                if (not p.StayOpenOnClick) and fPopupMode.equals(pdmAutoHide) and (p.ItemType <> IT_TOOL) then
                    self.Hide;
                ACPopupClicks.SetMenuPoint(self.CaptionPoint);

                if (p.itemType = IT_TOOL) and p.StayOpenOnClick and fpopupMode.equals(pdmAutoHide) then begin
                    fPopupMode.SetOverride(pdmStayOpen);
                end;
                SafeClick(p);
                if (p.ItemType = IT_TOOL) and fPopupMode.equals(pdmStayOpen) and p.StayOpenOnClick then begin
                    fPopupMode.ClearOverride;
                end;
                if (fPopupMode.equals(pdmPinned)) then begin
                    if (Config.getReturnFocusWhenPinned) then begin
                        if (fExplorerMode = false) then begin
                            TFocusManager.ForceForeground(self.handle);
                        end;
                    end;
                    fIsClickWhilePinned := false;
                    self.RebuildPopup;
                end;
                if (fPopupMode.equals(pdmFormMode)) then begin
                    self.RebuildPopup;

                    if (KeyActivated) then begin
                        TFocusManager.ForceForeground(self.Handle);
                    end;
                end;
            end;
        end;
        pipNone: ;
        end;
    end;
    IT_NONE: begin {TODO think about this}
        if assigned(p.OnClick) then begin
            self.Hide;
            SafeClick(p);
        end;
    end;
    IT_SWITCH: begin
        if SafeClick(p) then begin
            if p.IsInExpandedMenu then
            	p.Parent.Expanded := false;

            self.RebuildPopup;
        end;
    end;
    end;
end;
procedure TACPopup.HandleCaptionClick(p : TACPopupItem);
var
    waschecked : boolean;
begin
    waschecked := (p.Style = psCheckable) and p.Checked;
    inherited HandleCaptionClick(p);
    
    if p.ItemType = IT_SWITCH then begin
        if not (waschecked and p.checked) then begin
            self.RebuildPopup;
        end;
    end;
end;



procedure TACPopup.DragHandleDrop(source, target : TACPopupItem);
var m1, m2 : TMenuOrderType;
begin
    if source.IsExpandable then begin
        m1 := TMenuOrderType(source.integerdata);
    end else begin
        case source.ItemType  of
        IT_POPUPCLIP:	m1 := MOT_MENU;
        IT_PERMANENT: m1 := MOT_PERMANENT;
        IT_CLIPBOARD:	m1 := MOT_CURRENT;
        IT_SEARCH: 	m1 := MOT_SEARCH;
        IT_FULL: 	m1 := MOT_FULL;
        end;
    end;
    if target.IsExpandable then begin
        m2 := TMenuOrderType(target.integerdata);
    end else begin
        case target.ItemType  of
        IT_POPUPCLIP:	m2 := MOT_MENU;
        IT_PERMANENT: m2 := MOT_PERMANENT;
        IT_CLIPBOARD: m2 := MOT_CURRENT;
        IT_SEARCH: 	m2 := MOT_SEARCH;
        IT_FULL: 	m2 := MOT_FULL;
        end;
    end;
    if (m1 = MOT_MENU) then begin
        ClipQueue.Move(source.IntegerData,target.IntegerData)
    end else if (m1 = MOT_PERMANENT) then begin
        if source.PermanentGroupID = -1 then begin
            FrmPermanent.MoveClip(source.PermanentID, target.PermanentID);
        end;
    end else if (target.ItemType = IT_PINNED) then begin
        PinnedClipQueue.Move(source.IntegerData,target.IntegerData)
    end else begin
        FrmConfig.MoveItem(m1, m2);
    end;
    self.RebuildPopup;
end;
function TACPopup.IsLegalDrag(p : TACPopupItem) : boolean;
begin
    result := not (p.ItemType in [IT_NONE, IT_LINE]) ;
end;

function TACPopup.IsDoubleHeightType(p : TACPopupItem) : boolean;
begin
    result := p.itemtype in TDoubleSized;
end;
function TACPopup.GetAcceleratorReserved(i: integer) : Char;
begin
    result := self.GetAccelerator(i, true);
    EXIT;



    if FrmConfig.cbPopupCharLimit.Checked then begin
        Result := self.GetAccelerator(
            i - (AcceleratorCount+ReservedCount)
        );
    end else begin
        if FrmConfig.cbPinnedShortcuts.checked then begin
            Result := self.GetAccelerator(
                i - (ClipQueue.GetQueueSize+PinnedClipQueue.GetQueueCount+ReservedCount)
            );
        end else begin
            Result := inherited GetAcceleratorReserved(i);
        end;
    end;
end;
function TACPopup.getLeftSpaceWidth(p : TACPopupItem) : integer;
begin
    if (p=nil) then begin
        result := inherited;
        EXIT;
    end;

    if (p.ItemType = IT_POPUPCLIP) and (FrmConfig.GetIconType = CBXICONTYPE_NONE) then begin
        result := LEFTEDGE;
    end else if (p.ItemType = IT_TOOL) and (p.LeftIcon.Bitmap=nil) then begin
        result := 0;
    end else begin
        result := inherited;
    end;
end;
procedure TACPopup.PostSizeCalculationEvent;
var x,y : integer;
	m : TMonitor;
    expandedset : set of TItemType;
begin
    {Fudge it up or left to keep it on the screen}
    expandedset := [];
    if not self.fUseGrouping and (self.Height > screen.DesktopRect.Bottom) then begin
        if FrmConfig.cbEnableClipsSetsWhenTall.Checked then begin
            if (ClipQueue.GetQueueCount > FrmConfig.udClipsPerSet.Position) then begin
                Self.fUseGroupingOnce := True;
                self.AutoPopulate;
                self.CalcTotalSize;
                Self.Invalidate;
            end;
        end;
    end;
end;

function TACPopup.getDrawLeftIcon(p : TACPopupItem) : Boolean;
begin
    result := not ((p.ItemType = IT_POPUPCLIP) and (FrmConfig.GetIconType = CBXICONTYPE_NONE));
end;
procedure TACPopup.PostDrawIconEvent(p : TACPopupItem; r : TRect);
begin
//    if p.ItemType = IT_PINNED then begin
//        r.right := r.right - frmClipboardManager.iPin.Width-1; //8x8 icon
//        UseCanvas.Draw(r.right, r.Top, FrmClipboardManager.iPin.Picture.Graphic);
//    end;
end;
procedure TACPopup.ShowTooltip(p : TACPopupItem);
var
    s : string;
    pt : TPoint;
    procedure SingleMode;
    begin
        ToolTipNew.HideHeader;
        ToolTipNew.SingleLineOnce := true;
        ToolTipNew.SmallFontOnce := true;
    end;

    procedure showClipTooltip(clip : TClipItem; useTimestamp : boolean);
    begin
        s := '';
        if (Clip <> nil) and (clip.GetFormatType = FT_PICTURE) then begin
            s := Clip.GetFormatName;
        end;

        ToolTipNew.ShowTooltip(clip, pt, GetClipHeader(clip),'',
            useTimestamp);
    end;
var
    r : TRect;
    cix : TClipItem;
    hotkeyname : string;

begin
    r := p.BoundRect;
    pt := point(r.Right - trunc((r.Right-r.Left) / 3.5), r.bottom + 2);

   case p.ItemType  of
        IT_PERMANENT: begin
            case LastPosition  of
            pipCaption: begin
                cix := TClipItem.Create;
                s := FrmPermanent.GetPermanentPath;
                if p.PermanentGroupID <> -1 then begin
                    s := FrmPermanent.PermFoldersGetItem(p.PermanentGroupID);
                end;
                hotkeyname := TClipDatabase.LoadPermanentHotkey(p.PermanentID, s);
                TClipDatabase.LoadPermanent(cix, p.PermanentID, s );
                ToolTipNew.ShowTooltip(cix, pt, GetClipHeader(cix), hotkeyname);
                myfree(cix);
            end;
            end;
        end;
        IT_POPUPCLIP,IT_PINNED,
        IT_PERMANENT_GROUP,
        IT_TEMP,
        IT_CLIPBOARD,
        IT_SELECTED,
        IT_FULL: begin
            case LastPosition of
            pipCaption: begin
                if p.Hint <> '' then begin
                    SingleMode;
                    TooltipNew.ShowTooltip(p.hint,pt);
                end else if p.Clip <> nil then begin
                    showClipTooltip(p.clip, (p.ItemType in [IT_POPUPCLIP]) and (p.clip.CData.CreationDateUsed));
                end else begin
                    if (p.ItemType = IT_TEMP) then begin
                        cix := RemovedQueue.GetItemClip(p.IntegerData);
                        showClipTooltip(cix, false);
                        myfree(cix);
                    end;

                end;
            end;
            pipLeftIcon: begin
                if p.ItemType = IT_FULL then begin
                	SingleMode;
                    ToolTipNew.ShowTooltip('Edit Menu Order', pt);
                end;
            end;
            end;
        end else begin
            if p.Hint <> '' then begin
                SingleMode;
                if (p.ItemType = IT_TOOL) then begin
                    TooltipNew.SmallFontOnce := false;
                end;

                TooltipNew.ShowTooltip(p.hint,pt);
            end;
        end;
    end;
end;

function TACPopup.GetClipHeader(ci : TClipItem) : string;
begin
	result := 'right-click for Clip Menu';
	if ci <> nil then begin
    	result := result + '    ('+IntToStr(ci.GetDataSize div 2)+' chars)';
    end;
end;



procedure TACPopup.ActiveEvent(clicked: Boolean);
var
    h : THandle;
    pt : TPoint;
    p : TACPopupItem;
begin
    //FrmDebug.AppendLog('WA_ACTIVE');
    if fPopupMode.equals(pdmPinned) then begin
        h := FrmMainPopup.GetNextWindow(self.Handle);
        if SameText(WindowHandleToEXEName(h),'explorer.exe') then begin
            h := FrmMainPopup.GetNextWindow(h);
        end;
        FrmMainPopup.GatherTargetWindowData(h);
    end;
    if fPopupMode.equals(pdmPinned) and (clicked) then begin
        // set focus when a non-menu item is clicked
        pt := ScreenToClient(mouse.CursorPos);
        p := GetItemAt(pt.X,pt.y);
        if (p = nil) or (p.ItemType = IT_CLIPSET_HEADER) then begin
            FrmDebug.AppendLog('WA_ACTIVE: NIL Item');
            TFocusManager.ForceForeground(self.Handle);
            if (not lastRebuildUsedKeyboard) then begin
                self.RebuildPopup;
            end;
        end else if (p.ItemType = IT_TOOL) then begin
            TFocusManager.ForceForeground(self.Handle);
        end else begin
            SetHover(p);
        end;
    end;
    //FrmDebug.AppendLog('WA_ACTIVE End');
end;
procedure TACPopup.InactiveEvent;
begin
    FrmDebug.AppendLog('WA_INACTIVE');
    if self.FirstPaint then begin
        self.hide;
        if self.showing and not self.ClipMenuVisible then begin
            self.RebuildPopup;
        end;
    end;
    FrmDebug.AppendLog('WA_INACTIVE End');
end;



end.
