unit UnitFrameRichEdit;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.Buttons, Vcl.StdCtrls,
  Vcl.ComCtrls, Vcl.ExtCtrls, UnitClipQueue, UnitRichTextUpdate;

type
  TFrameRichEdit = class(TFrame)
    pnlTop: TPanel;
    reText: TRichEdit;
    cbxFont: TComboBox;
    cbxSize: TComboBox;
    btnBold: TSpeedButton;
    btnItalic: TSpeedButton;
    btnUnderline: TSpeedButton;
    btnStrike: TSpeedButton;
    cbxAlign: TComboBox;
    btnNumbers: TSpeedButton;
    btnBullets: TSpeedButton;
    btnIndentMore: TSpeedButton;
    btnIndentLess: TSpeedButton;
    btnRemoveFormatting: TSpeedButton;
    procedure btnBoldClick(Sender: TObject);
    procedure btnItalicClick(Sender: TObject);
    procedure btnUnderlineClick(Sender: TObject);
    procedure btnStrikeClick(Sender: TObject);
    procedure btnRemoveFormattingClick(Sender: TObject);
    procedure cbxFontChange(Sender: TObject);
    procedure cbxAlignChange(Sender: TObject);
    procedure btnNumbersClick(Sender: TObject);
    procedure btnBulletsClick(Sender: TObject);
    procedure btnIndentMoreClick(Sender: TObject);
    procedure btnIndentLessClick(Sender: TObject);
    procedure reTextSelectionChange(Sender: TObject);
    procedure cbxSizeChange(Sender: TObject);
  private
    { Private declarations }
    function getAttributes : TTextAttributes;
    procedure setDefaultAttributes;
    procedure getSettingstFromContext;
    procedure returnFocus;
    procedure setNumbering(enabled : Boolean);
  public
    { Public declarations }
    function getRichText : string;
    procedure setRichText(ci : TClipItem);
  end;

implementation

{$R *.dfm}

uses RichEdit, Math;

const
    CBX_ALIGN_LEFT = 0;
    CBX_ALIGN_RIGHT = 1;
    CBX_ALIGN_CENTER = 2;
    CBX_SIZE_SMALL = 0;
    CBX_SIZE_NORMAL = 1;
    CBX_SIZE_LARGE = 2;
    CBX_SIZE_HUGE = 3;
    FNT_SMALL = 7;
    FNT_NORMAL = 12;
    FNT_LARGE = 14;
    FNT_HUGE = 20;

procedure TFrameRichEdit.setRichText(ci : TClipItem);
begin
    self.setDefaultAttributes;

    reText.Lines.BeginUpdate;
    reText.Lines.Clear;
    ci.GetStream.Position := 0;
    retext.Lines.LoadFromStream( ci.GetStream );
    reText.Lines.EndUpdate;
end;
function TFrameRichEdit.getRichText : string;
var ss : TStringStream;
begin
    ss := TStringStream.Create('');

    try
        reText.Lines.SaveToStream(ss);
        result := ss.DataString;
    finally
        ss.Free;
    end;
end;

procedure TFrameRichEdit.setDefaultAttributes;
begin
    reText.Color := clWindow;
    reText.Font.Color := clWindowText;
    reText.Font.Name := 'Tahoma';
    reText.Font.Style := [];
    reText.Font.Size := FNT_NORMAL;

end;
function TFrameRichEdit.getAttributes : TTextAttributes;
begin
    result := reText.SelAttributes;
    EXIT;

    if reText.SelLength = 0 then begin
        result := reText.defAttributes;
    end else begin
        result := reText.SelAttributes;
    end;


end;
procedure TFrameRichEdit.returnFocus;
begin
    if Self.Visible then begin
        reText.SetFocus;
    end;
end;

procedure TFrameRichEdit.btnRemoveFormattingClick(Sender: TObject);
begin
    getAttributes.Style := [];
    getAttributes.Color := retext.Font.Color;
    getAttributes.size := FNT_NORMAL;
    reText.Paragraph.Alignment := taLeftJustify;
    reText.Paragraph.FirstIndent := 0;
    setNumbering(false);
end;

procedure TFrameRichEdit.btnBoldClick(Sender: TObject);
begin
    if btnBold.Down then begin
        getAttributes.Style := getAttributes.Style + [fsBold];
    end else begin
        getAttributes.style := getAttributes.Style - [fsBold];
    end;

    returnFocus;
end;
procedure TFrameRichEdit.btnStrikeClick(Sender: TObject);
begin
    if btnStrike.Down then begin
        getAttributes.Style := getAttributes.Style + [fsStrikeOut];
    end else begin
        getAttributes.style := getAttributes.Style - [fsStrikeOut];
    end;

    returnFocus;
end;
procedure TFrameRichEdit.btnUnderlineClick(Sender: TObject);
begin
    if btnUnderline.Down then begin
        getAttributes.Style := getAttributes.Style + [fsUnderline];
    end else begin
        getAttributes.style := getAttributes.Style - [fsUnderline];
    end;

    returnFocus;
end;
procedure TFrameRichEdit.btnItalicClick(Sender: TObject);
begin
    if btnItalic.Down then begin
        getAttributes.Style := getAttributes.Style + [fsItalic];
    end else begin
        getAttributes.style := getAttributes.Style - [fsItalic];
    end;

    returnFocus;
end;


procedure TFrameRichEdit.btnIndentLessClick(Sender: TObject);
begin
    reText.Paragraph.FirstIndent :=
    Max(0, reText.Paragraph.FirstIndent - 40);

    returnFocus;
end;
procedure TFrameRichEdit.btnIndentMoreClick(Sender: TObject);
begin
    reText.Paragraph.FirstIndent :=
    reText.Paragraph.FirstIndent + 40;

    returnFocus;
end;



procedure TFrameRichEdit.cbxFontChange(Sender: TObject);
begin
    case cbxFont.ItemIndex of
    0: getAttributes.Name := 'Sans Serif';
    1: getAttributes.Name := 'Serif';
    2: getAttributes.Name := 'Lucida Console';
    3: getAttributes.Name := 'Arial Bold';
    4: getAttributes.Name := 'Times New Roman';
    5: getAttributes.Name := 'Georgia';
    6: getAttributes.Name := 'Tahoma';
    7: getAttributes.Name := 'Verdana';
    8: getAttributes.Name := cbxFont.Items[cbxFont.ItemIndex];
    end;

    returnFocus;
end;
procedure TFrameRichEdit.cbxSizeChange(Sender: TObject);
begin
    case cbxSize.ItemIndex of
    CBX_SIZE_SMALL: getAttributes.Size := FNT_SMALL;
    CBX_SIZE_NORMAL: getAttributes.Size := FNT_NORMAL;
    CBX_SIZE_LARGE: getAttributes.Size := FNT_LARGE;
    CBX_SIZE_HUGE: getAttributes.Size := FNT_HUGE;
    end;

    returnFocus;
end;

procedure TFrameRichEdit.cbxAlignChange(Sender: TObject);
begin
    case cbxAlign.ItemIndex of
    CBX_ALIGN_LEFT: reText.Paragraph.Alignment := taLeftJustify;
    CBX_ALIGN_RIGHT: reText.Paragraph.Alignment := taRightJustify;
    CBX_ALIGN_CENTER: reText.Paragraph.Alignment := taCenter;
    end;

    returnFocus;
end;


procedure TFrameRichEdit.setNumbering(enabled : Boolean);
var
    fmt: TParaFormat2;

const
    NUMBERING_FLAGS = PFM_NUMBERING or PFM_NUMBERINGSTART or
                PFM_NUMBERINGSTYLE or PFM_NUMBERINGTAB;
begin

    // NOTES Paragraph.Numbering only supports bullets
    // manually send the format

    FillChar(fmt, SizeOf(fmt), 0);
    fmt.cbSize := SizeOf(fmt);

    reText.Perform(EM_GETPARAFORMAT,0, lParam( @fmt) );
    if not enabled then begin
        fmt.dwMask := NUMBERING_FLAGS;
        fmt.wNumbering := 0; // no numbers
    end else begin
        fmt.dwMask :=  NUMBERING_FLAGS;
        fmt.wNumbering := 2; // regular numbers
    end;

    fmt.wNumberingStart := 1;
    fmt.wNumberingStyle := $200; // #. style
    fmt.wNumberingTab := 1 * (1440 div 4); // TWIPPS but should use (1440 div GetDeviceCaps(DC, LOGPIXELSX))

    retext.Perform( EM_SETPARAFORMAT, 0, lParam( @fmt ) );
end;
procedure TFrameRichEdit.btnNumbersClick(Sender: TObject);
var
    fmt: TParaFormat2;
begin
    FillChar(fmt, SizeOf(fmt), 0);
    fmt.cbSize := SizeOf(fmt);

    reText.Perform(EM_GETPARAFORMAT,0, lParam( @fmt) );
    if fmt.wNumbering <> 0 then begin
        setNumbering(false);
    end else begin
        setNumbering(True);
    end;
    returnFocus;
end;
procedure TFrameRichEdit.btnBulletsClick(Sender: TObject);
begin

    if retext.Paragraph.Numbering = nsBullet then begin
        retext.Paragraph.Numbering := nsNone;
    end else begin
        retext.Paragraph.Numbering := nsBullet;
    end;

    returnFocus;
end;


// setting from caret change
//
procedure TFrameRichEdit.getSettingstFromContext;
var
    ca : TConsistentAttributes;
begin

    btnBold.Down := (fsBold in getAttributes.Style);
    btnUnderline.Down := (fsUnderline in getAttributes.Style);
    btnStrike.Down := (fsStrikeOut in getAttributes.Style);
    btnItalic.Down := (fsItalic in getAttributes.Style);

    case reText.Paragraph.Alignment of
    taLeftJustify: cbxAlign.ItemIndex := CBX_ALIGN_LEFT;
    taRightJustify: cbxAlign.ItemIndex := CBX_ALIGN_RIGHT;
    taCenter: cbxAlign.ItemIndex := CBX_ALIGN_CENTER;
    end;

    if getAttributes.Name = 'Sans Serif' then begin
        cbxFont.ItemIndex := 0;
    end else if getAttributes.Name = 'Serif' then begin
        cbxFont.ItemIndex := 1;
    end else if getAttributes.Name = 'Lucida Console' then begin
        cbxFont.ItemIndex := 2;
    end else if getAttributes.Name = 'Arial Bold' then begin
        cbxFont.ItemIndex := 3;
    end else if getAttributes.Name = 'Times New Roman' then begin
        cbxFont.ItemIndex := 4;
    end else if getAttributes.Name = 'Georgia' then begin
        cbxFont.ItemIndex := 5;
    end else if getAttributes.Name = 'Tahoma' then begin
        cbxFont.ItemIndex := 6;
    end else if getAttributes.Name = 'Verdana' then begin
        cbxFont.ItemIndex := 7;
    end else begin
        try
            cbxFont.Items.Delete(8);
        except
        end;
        cbxFont.Items.Add(getAttributes.name);
        cbxFont.ItemIndex := 8;
    end;

    if getAttributes.Size < 10 then begin
        cbxSize.ItemIndex := CBX_SIZE_SMALL;
    end else if getAttributes.Size < 13  then begin
        cbxSize.ItemIndex := CBX_SIZE_NORMAL;
    end else if getAttributes.Size < 17  then begin
        cbxSize.ItemIndex := CBX_SIZE_LARGE;
    end else begin
        cbxSize.ItemIndex := CBX_SIZE_HUGE;
    end;


    if reText.SelLength > 0 then begin
        ca := reText.SelAttributes.ConsistentAttributes;
        if not (caFace in ca) then cbxFont.ItemIndex := -1;
        if not (caSize in ca) then cbxSize.ItemIndex := -1;

        if not (caBold in ca) then btnBold.Down := False;
        if not (caItalic in ca) then btnItalic.Down := False;
        if not (caStrikeOut in ca) then btnStrike.Down := False;
        if not (caUnderline in ca) then btnUnderline.Down := False;
    end;
end;
procedure TFrameRichEdit.reTextSelectionChange(Sender: TObject);
begin
    getSettingstFromContext;
end;

end.
