unit UnitFrmAbout;
{
    What else is an about page for?
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ShellAPI, Vcl.Imaging.pngimage {for shellexecute};

type
  TFrmAbout = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    lblVersion: TLabel;
    Button1: TButton;
    lblURL: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    lblBuild: TLabel;
    Button2: TButton;
    Button3: TButton;
    sdBackup: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure lblURLMouseEnter(Sender: TObject);
    procedure lblURLMouseLeave(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmAbout: TFrmAbout;

implementation

uses UnitMisc, UnitFrmCheckForUpdate, UnitFrmDebug, UnitAutoBackup,
    IOUtils, Generics.Collections, UnitPopupGenerate;

{$R *.dfm}

procedure TFrmAbout.Button2Click(Sender: TObject);
begin
    FrmCheckForUpdate.DoCheck(pn_ArsClip);
    self.Hide;
end;

procedure TFrmAbout.Button3Click(Sender: TObject);
var s, s2 : string;
    backupFullName : string;
    sl : TList<string>;
begin
    sl := TList<string>.create;

    s := UnitMisc.GetAppPath;
    s2 := IncludeTrailingPathDelimiter(ExtractFilePath(Application.ExeName));

    sl.add(s);
    if (s <> s2) then begin
        sl.Add(s2);
    end;
    self.Close;
    TAutoBackup.DialogBackup(Self .Handle, 'ac', s, sl);

    FreeAndNil(sl);
end;

procedure TFrmAbout.FormCreate(Sender: TObject);
var L, i : DWORD;
    p, buf : Pointer;
    ver : array [0 .. 3] of word;
begin
    FrmDebug.AppendLog('FrmAbout - creating');

    //
    // So much damn work just to get the program's version info....
    //
    lblVersion.Caption := '';
    L := Windows.GetFileVersionInfoSize(PChar(Application.EXEName), i);
    if (L = 0) then begin
        EXIT;
    end;


    GetMem(buf, L);
        Windows.GetFileVersionInfo(PChar(Application.EXEName), 0, L, Buf);
        Windows.VerQueryValue(Buf, '\', p, i);

        Ver[0] := HiWord(TVSFixedFileInfo(p^).dwFileVersionMS);
        Ver[1] := LoWord(TVSFixedFileInfo(p^).dwFileVersionMS);
        Ver[2] := HiWord(TVSFixedFileInfo(p^).dwFileVersionLS);
        Ver[3] := LoWord(TVSFixedFileInfo(p^).dwFileVersionLS);

    FreeMem(Buf);

    lblVersion.Caption := IntToStr(ver[0]) + '.' + IntToStr(ver[1]);
    lblBuild.Caption := 'build ' + IntToStr(ver[2]) +'-' + IntToStr(ver[3]);

    FrmDebug.AppendLog('FrmAbout - ' + lblVersion.Caption + ' ' + lblBuild.Caption);
end;

procedure TFrmAbout.FormDestroy(Sender: TObject);
begin
    FrmDebug.AppendLog('UnitFrmAbout Destroy', false);
end;

procedure TFrmAbout.Button1Click(Sender: TObject);
begin
    self.Hide;
end;



//-------
// URL -
//-------
procedure TFrmAbout.lblURLClick(Sender: TObject);
begin
    ShellAPI.ShellExecute(self.Handle, nil, PChar(lblURL.caption), nil, nil, SW_HIDE);
end;


procedure TFrmAbout.lblURLMouseEnter(Sender: TObject);
begin
    lblURL.Cursor := crUpArrow;
end;
procedure TFrmAbout.lblURLMouseLeave(Sender: TObject);
begin
    lblURL.Cursor := crDefault;
end;

procedure TFrmAbout.FormKeyPress(Sender: TObject; var Key: Char);
begin
    //if key = chr(VK_ESCAPE) then self.Close;
    
end;

procedure TFrmAbout.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if (KEY = VK_ESCAPE) then begin
        self.Button1.Click;
    end;
end;


initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmAbout', false);
end;

end.
