unit UnitFrmCheckForUpdate;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;


type TProgramName = (pn_ArsClip, pn_RenameMaster, pn_MouseWrangler, pn_NewFileGo, pn_WinColor);

type
  TFrmCheckForUpdate = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure DoCheck(pn : TProgramName);
  end;

var
  FrmCheckForUpdate: TFrmCheckForUpdate;

implementation

uses VCL.ExtActns, UnitFrmAbout, StrUtils, System.Types;

{$R *.dfm}

var AppPath : string;
function GetAppPath : string;
var par : string;

    found : boolean;
begin
    if AppPath = '' then begin
        par := '';
        found := false;
        if not found then begin
            AppPath := IncludeTrailingPathDelimiter(
                ExtractFilePath(Application.ExeName)
            );
        end;
    end;
    result := AppPath;
end;


procedure TFrmCheckForUpdate.Button1Click(Sender: TObject);
var bu : TBrowseURL;
begin
    bu := TBrowseURL.Create(self);
    bu.URL := 'http://joejoesoft.com/';

    try
        bu.ExecuteTarget(nil);
    except
        ShowMessage('Unable to contact website');
    end;
    self.ModalResult := mrCancel;
end;

procedure TFrmCheckForUpdate.Button2Click(Sender: TObject);
begin
    self.ModalResult := mrCancel;
end;

procedure TFrmCheckForUpdate.DoCheck(pn : TProgramName);
    function FindPrefix(prefix : string; sl : TStringList) : integer;
    var x : string;
        i : integer;
    begin
        result := -1;
        i := 0;
        for x in sl do begin
            if StartsText(prefix, x) then begin
                result := i;
                EXIT;
            end;
            Inc(i);
        end;
    end;


var prefix : string;
    du : TDownLoadURL;
    sl : TStringList;
    s, current : string;
    i : integer;
    a : TStringDynArray;

    c : TCursor;
begin
    case pn of
    pn_ArsClip: prefix := 'acv';
    pn_RenameMaster: prefix := 'rmv';
    pn_MouseWrangler: prefix := 'mwv';
    pn_NewFileGo: prefix := 'nfgv';
    pn_WinColor: prefix := 'wcv';
    end;

    c := Screen.Cursor;
    Screen.Cursor := crHourGlass;

    du := TDownLoadURL.Create(self);
    du.URL := 'http://joejoesoft.com/cms/update.php';
    du.Filename := GetAppPath + 'update.txt';
    try
        du.ExecuteTarget(nil);
        Screen.Cursor := c;
        sl := TStringList.Create;

        sl.LoadFromFile(du.Filename);
        i := FindPrefix(prefix, sl);
        if i <> -1 then begin
            s := sl[i];

            current := FrmAbout.lblVersion.Caption;
            s := StringReplace(s,'.','',[rfReplaceAll]);
            a := SplitString(s,'=');
            s := a[1];

            current := StringReplace(current,'.','',[rfReplaceAll]);
            if Length(current)= 2 then begin
                Insert('0',current,2);
            end;

            if StrToInt(current) < StrToInt(a[1]) then begin
                self.ShowModal;
            end else begin
                ShowMessage('Your program is the newest official version.');
            end;
        end else begin
            ShowMessage('Unable to find an official version');
        end;
    except
        ShowMessage('Unable to contact website');
    end;
    Screen.Cursor := c;
    du.Free;
    sl.Clear;
    sl.Free;
end;

procedure TFrmCheckForUpdate.FormCreate(Sender: TObject);
begin
    AppPath := '';
end;

end.
