unit UnitFrmClipMenuNew;

interface

uses
  Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.Buttons, Vcl.ExtCtrls;

type
  TFrmClipMenuNew = class(TForm)
    pnl1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    pnlPaste: TPanel;
    pnlPermanent: TPanel;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    SpeedButton13: TSpeedButton;

     procedure CreateParams(var Params: TCreateParams);  override;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure ShowForm;
    procedure HideForm;
  end;

var
  FrmClipMenuNew: TFrmClipMenuNew;

implementation

{$R *.dfm}


uses UnitMisc, Windows, UnitFocusManager;


constructor TFrmClipMenuNew.Create(AOwner: TComponent);
begin
    inherited create(nil);
    self.ParentWindow := GetDesktopWindow;
end;

procedure TFrmClipMenuNew.CreateParams(var Params: TCreateParams);
begin
    inherited;

    Params.Style := WS_CHILDWINDOW; // WS_CHILDWINDOW doesn't close a WS_POPUP window

    params.ExStyle := {WS_EX_NOACTIVATE or} WS_EX_TOOLWINDOW or WS_EX_TOPMOST or WS_EX_COMPOSITED ;
    {WS_EX_COMPOSITED - bottom to top repainting order, children first}

    if CheckWin32Version(6, 0) then
       params.WindowClass.Style := params.WindowClass.style or CS_DROPSHADOW;

end;


procedure TFrmClipMenuNew.FormKeyPress(Sender: TObject; var Key: Char);
begin
    ShowMessage('hello');
end;

procedure  TFrmClipMenuNew.ShowForm;
begin
    self.Visible := true;
    SetWindowPos(self.handle,HWND_TOPMOST,self.left,self.top,self.Width,self.Height,
    	{SWP_NOACTIVATE or SWP_NOMOVE or} SWP_SHOWWINDOW or SWP_NOACTIVATE);
    self.Visible := True;
	//SetFocus;
    TFocusManager.ForceForeground(self.Handle);
    self.Invalidate;
end;
procedure  TFrmClipMenuNew.HideForm;
begin
    //windows.ShowWindow(self.Handle,SW_HIDE);
//    self.Visible := false;
    self.Hide;
end;

procedure TFrmClipMenuNew.SpeedButton1Click(Sender: TObject);
begin
    ShowMessage('hello');
end;

procedure TFrmClipMenuNew.SpeedButton5Click(Sender: TObject);
begin
    pnlPermanent.Visible := not pnlPermanent.Visible;
end;

procedure TFrmClipMenuNew.SpeedButton6Click(Sender: TObject);
begin
    pnlPaste.Visible := not pnlPaste.Visible;
end;

end.
