unit UnitFrmDebug;

interface

uses
  Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, System.Generics.Collections;

type
  TFrmDebug = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Memo1: TListBox;
    Label1: TLabel;
    cbAutoSave: TCheckBox;
    btnKill: TButton;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cbAutoSaveClick(Sender: TObject);
    procedure btnKillClick(Sender: TObject);

  private
    { Private declarations }
        cl : TList<Cardinal>;
        fLevel : integer;
        procedure DumpLog(filename : string);
        function LogToString : string;
  protected
        procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public declarations }
        procedure AppendLog( s : string; IncludeLastError : boolean = false);
        procedure ApplicationException(Sender: TObject; E: Exception);
        procedure EmergencyDump(filename : string = '');
        procedure StartTimer;
        procedure EndTimerLog(s : string);

        procedure IncLevel;
        procedure DecLevel;

        procedure SetSaveOnExit;

        class procedure MeOnlyAppend(s : string;IncludeLastError : boolean = false);
  end;



var
  FrmDebug: TFrmDebug;

implementation

{$R *.dfm}

uses Windows, UnitMisc, clipbrd, math, UnitFocusManager, UnitPopupGenerate,
    UnitFrmClipboardManager;

var
    AppendCount : integer;
    AppendStr : string;
    sl : TList<string>;
    AutoSave : boolean;

class procedure TFrmDebug.MeOnlyAppend(s : string; IncludeLastError : boolean = false);
var isDebug : boolean;
begin
    {$WARN UNIT_PLATFORM off}
    isDebug := (DebugHook <> 0);
    {$WARN UNIT_PLATFORM on}
    if isDebug or AutoSave then begin
        FrmDebug.AppendLog(s, IncludeLastError);
    end;
end;
procedure TFrmDebug.IncLevel;
begin
    inc(flevel);
end;
procedure TFrmDebug.DecLevel;
begin
    if flevel > 0 then dec(flevel);
end;

procedure TFrmDebug.CreateParams(var Params: TCreateParams);
begin
    inherited CreateParams(Params);
    // allow context taskbar context menu and
    // show me on the taskbar - independant of main form
    with Params do begin
        ExStyle := ExStyle or WS_EX_APPWINDOW;
        WndParent := GetDesktopwindow;
    end;
end;

procedure TFrmDebug.FormCreate(Sender: TObject);
begin
    cl := TList<Cardinal>.create;
end;
procedure TFrmDebug.FormDestroy(Sender: TObject);
begin
    AppendLog('UnitFrmDebug Destroy', false);

    Memo1.items.Clear;
    FreeAndNil(cl);

    if autosave then begin
        FrmDebug.AppendLog('UnitFrmDebug Autosave', false);
        FrmDebug.EmergencyDump;
    end;
    // we don't want to clear the log, since debug info
    // may be needed during an exception when exiting the program

//    if assigned(sl) then begin
//        sl.clear;
//        FreeANdNil(sl);
//    end;
end;
procedure TFrmDebug.FormShow(Sender: TObject);
var i : integer;
begin
    TFocusManager.ForceForeground(self.Handle);
    memo1.Clear;
    for i := 0 to min(200,sl.Count-1) do begin
        memo1.Items.Add(sl[i])
    end;
end;


// NOTE:
// This routine is safe to call even before the form is created
procedure TFrmDebug.AppendLog( s : string; IncludeLastError : boolean = false);
    function Prefix : string;
    var i : integer;
    begin
        if assigned(FrmDebug) then begin
            result := TimeToStr(Now) + ': ';
            if flevel > 0 then begin
                for i := 1 to flevel do begin
                    result := result + '>';
                end;
                result := result + ' ';
            end;

        end else begin
            result := TimeToStr(Now) + ':(x) ';
        end;

    end;
var i : integer;
begin
    if not Assigned(sl) then sl := TList<string>.create;
    if (IncludeLastError) then begin
        i := getLastError;
        s := s + ' :('+IntToStr(i)+') ' + SysErrorMessage(i);
    end;
    AppendStr := Prefix + s;

    sl.Insert(0, AppendStr); // first is newest, last is oldest

    if sl.Count > 20000 then begin
        sl.Delete(sl.Count-1);
    end;

    if assigned(FrmDebug) and (frmdebug.Visible) then begin
        if FrmDebug.memo1.items.Count > 1000 then begin
            FrmDebug.memo1.items.Delete(FrmDebug.memo1.items.Count-1);
        end;
        frmdebug.Memo1.items.Insert(0, AppendStr)
    end;
end;



procedure TFrmDebug.ApplicationException(Sender: TObject; E: Exception);
begin
    AppendLog(e.Message, false);
    DumpLog('Debug.txt');

    Windows.SetLastError(ERROR_SUCCESS);
    ShowMessage(
        e.Message + #13#10 +
        '[Debug.txt] log created.'
    );
end;

procedure TFrmDebug.btnKillClick(Sender: TObject);
var m : TWMEndSession;
begin
    m.EndSession := true;
    FrmMainPopup.WMEndSession(m);
end;

procedure TFrmDebug.EmergencyDump;
begin
    if filename = '' then filename := 'Debug.txt';
    DumpLog(filename);
end;

function TFrmDebug.LogToString : string;
var i : integer;
begin
    for i := 0 to sl.Count-1 do begin
        result := result + sl.Items[i] + #13#10;
    end;
end;

procedure TFrmDebug.Button1Click(Sender: TObject);
var s : string;
    i : integer;
begin
    clipboard.SetTextBuf(pwidechar(self.LogToString));
end;

procedure TFrmDebug.Button2Click(Sender: TObject);
begin
    DumpLog('Debug.txt');
    ShowMessage('Debug.txt Created');
end;



procedure TFrmDebug.cbAutoSaveClick(Sender: TObject);
begin
    autosave := cbAutoSave.Checked;
end;

procedure TFrmDebug.DumpLog(filename : string);
var i : integer;
    backup : string;
    s : string;
    sw : TStringWriter;
begin
    filename := UnitMisc.GetAppPath + filename;

    if FileExists(filename) then begin
        i := 1;

        repeat
            backup := filename + '.bak' + IntToStr(i);
            inc(i);
        until not FileExists(backup);
        RenameFile(filename, backup);
    end;


    with TStreamWriter.Create(filename, false, TEncoding.Unicode) do begin
        Write(LogToString);
        Free();
    end;
end;


procedure TFrmDebug.StartTimer;
begin
    cl.Add(Windows.GetTickCount);
end;
procedure TFrmDebug.EndTimerLog(s : string);
var c : cardinal;
begin
    c := cl[cl.count-1];
    cl.Remove(cl.Count-1);
    AppendLog('ms('+IntToStr(Windows.GetTickCount-c)+'): '+s);
end;

procedure TFrmDebug.SetSaveOnExit;
begin
    autosave := true;
end;


initialization
begin
    AppendCount := 0;
    AppendStr := '';
end;

finalization
begin

    //if assigned(sl) then FreeAndNil(sl);
end;
end.
