unit UnitFrmFind;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Vcl.Buttons, Vcl.StdCtrls, Vcl.ExtCtrls, Vcl.ComCtrls;

type
  TfrmFind = class(TForm)
    pnl1: TPanel;
    Label1: TLabel;
    txtFind: TEdit;
    btnFind: TSpeedButton;
    lvResults: TListView;
    lblCount: TLabel;
    procedure FormPaint(Sender: TObject);
    procedure btnFindClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lvResultsDeletion(Sender: TObject; Item: TListItem);
    procedure lvResultsClick(Sender: TObject);
    procedure txtFindKeyPress(Sender: TObject; var Key: Char);
    procedure FormResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    	procedure UpdatePreview;
        procedure DrawIt;
  end;

var
  frmFind: TfrmFind;

implementation

uses UnitFrmConfig, StrUtils, Math, UnitFrmDebug;

{$R *.dfm}

{ TfrmPreviewPopup }


type TConfigLocation = record
    PageIndex : integer;
    PanelIndex : integer;
    Control : TControl;
end;
type PConfigurationLocation = ^TConfigLocation;

procedure TfrmFind.btnFindClick(Sender: TObject);
var i : integer;
    PageName : string;
    PageIndex : integer;
    PanelName : string;
    PanelIndex : integer;

    procedure findText(c : TControl);
    var s : string;
        excerpt, upper : string;
        li : TListItem;
        cl : PConfigurationLocation;
        index : integer;
    begin
        if c is tlabel then begin
            s := tlabel(c).Caption;
        end else if (c is tEdit) then begin
            s := tedit(c).Text;
        end else if (c is TCheckBox) then begin
            s := TCheckBox(c).Caption;
        end else if (c is TRadioButton) then begin
            s := TRadioButton(c).Caption;
        end else if (c is TRichEdit) then begin
            s := TRichEdit(c).Text;
        end else if (c is TMemo) then begin
            s := TMemo(c).Text;
        end else if (c is TGroupBox) then begin
            s := TGroupBox(c).Caption;
        end;

        if containsText(s, txtFind.Text) then begin
            li := lvResults.Items.Add;
            li.Caption := pagename + '>' + PanelName;

            excerpt := s;
            if Length(s) > 80 then begin
                excerpt := StrUtils.LeftStr(s, 20) + '...';
                upper := UpperCase(s);

                index := Pos(UpperCase(txtFind.text), upper);
                index := Max(1, index - 18);
                excerpt := excerpt +  StrUtils.MidStr(s,index, index + 80);
            end;

            li.SubItems.Add(excerpt);
            cl := new(PConfigurationLocation);

            cl^.PageIndex := PageIndex;
            cl^.PanelIndex := PanelIndex;
            cl^.Control := c;

            li.Data := cl;
        end;
    end;

    procedure searchContainer(c : TWinControl);
    var i : integer;
        wc : TControl;
    begin
        for i := 0 to c.ControlCount -1 do begin
            wc := c.Controls[i];
            if  wc is TWinControl then begin
                if (wc is TRichEdit) or (wc is TCheckBox) or
                (wc is TRadiobutton) then begin
                    findText(wc);
                    CONTINUE;
                end;

                if wc is TGroupBox then begin
                    // groupboxes have captions
                    findText(wc);
                end;

                if wc is TCategoryPanel then begin
                    PanelName := TCategoryPanel(wc).Caption;
                    PanelIndex := i;
                end;
                searchCOntainer(TWinControl(wc));
            end else begin
                findText(wc);
            end;
        end;
    end;

var ts : TTabSheet;
begin
    lvresults.Clear;
    for i :=0 to frmconfig.pcPanels.PageCount -1 do begin
        ts := frmconfig.pcPanels.Pages[i];
        pagename := ts.Caption;

        pagename := frmconfig.tvOptions.Items[i].Text;

        PageIndex := i;
        searchCOntainer(ts);
    end;

    lblCount.Caption := '('+IntToStr(lvResults.items.Count)+') results';
end;

procedure TfrmFind.DrawIt;
begin

end;

procedure TfrmFind.FormCreate(Sender: TObject);
begin
    lvresults.Columns[0].Width := -1;
    lvresults.Columns[1].Width := -1;

    lvresults.Columns[0].MinWidth := 40;
    lvresults.Columns[1].MinWidth := 80;
end;

procedure TfrmFind.FormDestroy(Sender: TObject);
begin
    FrmDebug.AppendLog('UnitFrmFind Destroy', false);
end;

procedure TfrmFind.FormPaint(Sender: TObject);
begin
    self.UpdatePreview;
end;

procedure TfrmFind.FormResize(Sender: TObject);
begin
    lvresults.Columns[0].Width := -1;
    lvResults.Columns[1].Width := lvResults.Width - lvResults.columns[0].width;
end;

procedure TfrmFind.FormShow(Sender: TObject);
    procedure handleTooFarRight(m : TMonitor);
    var monRight : integer;
    begin
        // place our window at the right edge of the screen
        // when the window is only paritially visible horizontally
        if screen.MonitorCount = 1 then begin
            monRight := (m.Left + m.width);
            if (self.Left+self.Width) > monRight  then begin
                self.Left := monRight - self.Width;
            end;
        end;
    end;
var m : TMonitor;

begin
    m := Screen.MonitorFromWindow(frmconfig.Handle);
    if (m <> nil) then begin
        handleTooFarRight(m);
    end;
end;

procedure TfrmFind.lvResultsClick(Sender: TObject);
var cl : PConfigurationLocation;
begin
    if lvResults.Selected = nil then EXIT;

    cl := lvResults.Selected.Data;

    frmConfig.ShowPanel(cl^.PageIndex, cl^.PanelIndex);

end;

procedure TfrmFind.lvResultsDeletion(Sender: TObject; Item: TListItem);
var cl : PConfigurationLocation;
begin
    cl := item.Data;
    dispose(PConfigurationLocation(cl));
end;

procedure TfrmFind.txtFindKeyPress(Sender: TObject; var Key: Char);
begin
    if Key = #13 then begin
        btnFind.click;
        key := #0;
    end;
end;

procedure TfrmFind.UpdatePreview;

begin

end;


initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmFind', false);
end;

end.
