unit UnitFrmImport;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;

type
  TFrmImport = class(TForm)
    rbBlank: TRadioButton;
    rbImport: TRadioButton;
    cbxNames: TComboBox;
    btnCreate: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure btnCreateClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure showFrom(dbNames : TStringList);
    function getResult : string;
  end;

var
  FrmImport: TFrmImport;

implementation

uses
    UnitClipDatabase, UnitFrmDebug;

{$R *.dfm}


procedure TFrmImport.showFrom(dbNames : TStringList);
var s : string;
    b : boolean;
begin
    cbxNames.Clear;
    for s in dbNames do begin
        cbxNames.Items.Add(s);
    end;
    rbBlank.Checked := true;

    b := cbxNames.items.count > 0;
    if (b) then begin
        cbxNames.ItemIndex := 0;
        rbImport.Checked := true;
    end;
    rbImport.Enabled := b;
    cbxNames.Enabled := b;

    // don't show if nothing to import
    if (b) then
        ShowModal;
end;


procedure TFrmImport.btnCreateClick(Sender: TObject);
begin
    ModalResult := mrOk;
end;

procedure TFrmImport.FormDestroy(Sender: TObject);
begin
    FrmDebug.AppendLog('UnitFrmShared Destroy', false);
end;

function TFrmImport.getResult : string;
begin
    result := '';

    if (rbImport.Checked) then begin
        result := cbxNames.Items[cbxNames.ItemIndex];
    end;
end;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmImport', false);
end;

end.
