unit UnitFrmPermanentEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, Buttons, UnitClipQueue, Menus,
  UnitFrmHotKey, UnitFrmPermanentNew, ImgList, UnitJScript, UnitOnlineScript,
  Vcl.CategoryButtons, UnitFrameRichEdit, UnitFrameHTMLEdit;



type
  TFrmPermanentEdit = class(TForm)

    {$REGION 'default'}
    pmGetAs: TPopupMenu;
    PlaintText1: TMenuItem;
    DIBPicture1: TMenuItem;
    CopiedFiles1: TMenuItem;
    RichTExt1: TMenuItem;
    pmSaveGroup: TPopupMenu;
    pnlBottom: TPanel;
    btnCancel: TButton;
    btnSave: TButton;
    ilPics: TImageList;
    pmRightClick: TPopupMenu;
    MICut1: TMenuItem;
    MICopy1: TMenuItem;
    MIPaste1: TMenuItem;
    MIDelete2: TMenuItem;
    N3: TMenuItem;
    MISelectAll1: TMenuItem;
    MIPasteAs1: TMenuItem;
    MainMenu1: TMainMenu;
    MIKeystrokes1: TMenuItem;
    MILeft2: TMenuItem;
    MIRight2: TMenuItem;
    MIUp2: TMenuItem;
    MIDown2: TMenuItem;
    MiBackspace2: TMenuItem;
    MIHome2: TMenuItem;
    MIEnd2: TMenuItem;
    MITab2: TMenuItem;
    N6: TMenuItem;
    MIDelete3: TMenuItem;
    MIInsert2: TMenuItem;
    MISpacebar2: TMenuItem;
    MIEnter2: TMenuItem;
    N7: TMenuItem;
    MICustomCombination1: TMenuItem;
    MIMouseClick2: TMenuItem;
    MICommands1: TMenuItem;
    MIInsert3: TMenuItem;
    MISelect2: TMenuItem;
    MICopyandWaitforClip2: TMenuItem;
    MICopy2: TMenuItem;
    MICut2: TMenuItem;
    MIPasteasconfigured1: TMenuItem;
    MITemporaryClipList1: TMenuItem;
    N10: TMenuItem;
    MIEditClipboard2: TMenuItem;
    MIPopupClips2: TMenuItem;
    MIOptionalModes1: TMenuItem;
    N11: TMenuItem;
    MIWait2: TMenuItem;
    MIWaitforNewClip2: TMenuItem;
    MIRun2: TMenuItem;
    MISaveClipboardtoTextfile1: TMenuItem;
    MIShowArsClipWindow1: TMenuItem;
    Date1: TMenuItem;
    CurrentClipboard1: TMenuItem;
    StartingClipboardClip1: TMenuItem;
    PopupClipasPlaintext1: TMenuItem;
    PromptforInput1: TMenuItem;
    SplitClipboard2: TMenuItem;
    SplitClipboardLoop1: TMenuItem;
    All1: TMenuItem;
    WordLeft1: TMenuItem;
    WordRight1: TMenuItem;
    Normal1: TMenuItem;
    PrependClipboard1: TMenuItem;
    AppendClipboard2: TMenuItem;
    asPlaintext1: TMenuItem;
    asFormatted1: TMenuItem;
    SaveClipboard1: TMenuItem;
    RestoreFirstClip1: TMenuItem;
    RestoreLastClip1: TMenuItem;
    Delete2: TMenuItem;
    N12: TMenuItem;
    rim1: TMenuItem;
    FindandReplace1: TMenuItem;
    ReplaceDoubleSpaces2: TMenuItem;
    ReplaceDoubleLinefeeds2: TMenuItem;
    ReplaceTabswithSpaces2: TMenuItem;
    RemoveLinefeeds1: TMenuItem;
    UpperCase2: TMenuItem;
    N13: TMenuItem;
    Lowercase2: TMenuItem;
    CapitalizeWords2: TMenuItem;
    InverseCase2: TMenuItem;
    FinedandReplacexamples1: TMenuItem;
    DeleteClip1: TMenuItem;
    DeteleAllClips1: TMenuItem;
    CopytoClipboard1: TMenuItem;
    MoveClip2: TMenuItem;
    NewClip1: TMenuItem;
    ClipboardOly1: TMenuItem;
    MimicTypeg1: TMenuItem;
    DisableClipboardMonitoring2: TMenuItem;
    ClipType1: TMenuItem;
    CTPlaintText2: TMenuItem;
    CTMacro1: TMenuItem;
    CTJavaScript1: TMenuItem;
    N14: TMenuItem;
    CTIgnorenewline: TMenuItem;
    MIShow1: TMenuItem;
    MIShowResults1: TMenuItem;
    OnlineExamples1: TMenuItem;
    pnlTopMost: TPanel;
    pnlTop: TPanel;
    pnlCaption: TPanel;
    lblCaptionHelp: TLabel;
    Label2: TLabel;
    txtItemName: TEdit;
    pnlClip: TPanel;
    lblDesc: TLabel;
    pnlPreview: TPanel;
    pPreview: TImage;
    reItemText: TRichEdit;
    mItemTextX: TMemo;
    pnlInfo: TPanel;
    Splitter1: TSplitter;
    lbScripts: TListBox;
    pnl1: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    txtCode: TMemo;
    txtDesc: TMemo;
    MIConfiguration2: TMenuItem;
    MIEditHistory2: TMenuItem;
    MIRemovedClips2: TMenuItem;
    MIEditClipboard3: TMenuItem;
    MIPermanetnClips2: TMenuItem;
    MISearchandPaste2: TMenuItem;
    MIPasteSelected2: TMenuItem;
    CommandReference1: TMenuItem;
    spInfo: TSplitter;
    pcPages: TPageControl;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    pnlTitleBar: TPanel;
    lblInfoTitle: TLabel;
    btnHide: TButton;
    N15: TMenuItem;
    DATEFormattingHelp1: TMenuItem;
    txtDateHelp: TMemo;
    PageControl2: TPageControl;
    TabSheet8: TTabSheet;
    TabSheet9: TTabSheet;
    txtJSMain: TMemo;
    txtJSComm: TMemo;
    RUNHelp1: TMenuItem;
    TabSheet10: TTabSheet;
    txtRunHelp: TMemo;
    JavaScriptReference1: TMenuItem;
    MIInsertJavaScript1: TMenuItem;
    createMainfunction1: TMenuItem;
    saveToPopupClipsstring1: TMenuItem;
    getPopupClipint1: TMenuItem;
    manuallyExecuteMacrostring1: TMenuItem;
    getCurrentClipboard1: TMenuItem;
    setClipboardstring1: TMenuItem;
    N1: TMenuItem;
    pnl2: TPanel;
    Label1: TLabel;
    lblClipboard: TLabel;
    btnRerun: TButton;
    Splitter2: TSplitter;
    PinnedClipasPlaintext1: TMenuItem;
    N2: TMenuItem;
    LoadfromFile1: TMenuItem;
    cbCommands: TCategoryButtons;
    pcCommands: TPageControl;
    TabSheet11: TTabSheet;
    TabSheet12: TTabSheet;
    TabSheet13: TTabSheet;
    TabSheet14: TTabSheet;
    TabSheet15: TTabSheet;
    TabSheet16: TTabSheet;
    TabSheet17: TTabSheet;
    TabSheet18: TTabSheet;
    TabSheet19: TTabSheet;
    TabSheet20: TTabSheet;
    TabSheet21: TTabSheet;
    TabSheet22: TTabSheet;
    TabSheet23: TTabSheet;
    TabSheet24: TTabSheet;
    TabSheet25: TTabSheet;
    TabSheet26: TTabSheet;
    TabSheet27: TTabSheet;
    TabSheet28: TTabSheet;
    TabSheet29: TTabSheet;
    TabSheet30: TTabSheet;
    TabSheet31: TTabSheet;
    TabSheet32: TTabSheet;
    TabSheet33: TTabSheet;
    TabSheet34: TTabSheet;
    TabSheet35: TTabSheet;
    TabSheet36: TTabSheet;
    TabSheet37: TTabSheet;
    TabSheet38: TTabSheet;
    TabSheet39: TTabSheet;
    TabSheet40: TTabSheet;
    TabSheet41: TTabSheet;
    TabSheet42: TTabSheet;
    TabSheet43: TTabSheet;
    TabSheet44: TTabSheet;
    TabSheet45: TTabSheet;
    TabSheet46: TTabSheet;
    TabSheet47: TTabSheet;
    TabSheet48: TTabSheet;
    TabSheet49: TTabSheet;
    TabSheet50: TTabSheet;
    TabSheet51: TTabSheet;
    TabSheet52: TTabSheet;
    TabSheet53: TTabSheet;
    TabSheet54: TTabSheet;
    TabSheet55: TTabSheet;
    Label3: TLabel;
    Memo3: TLabel;
    Memo4: TLabel;
    Memo5: TLabel;
    Memo6: TLabel;
    Memo7: TLabel;
    Memo8: TLabel;
    Memo10: TLabel;
    Memo11: TLabel;
    Memo12: TLabel;
    Memo13: TLabel;
    Memo14: TLabel;
    Memo15: TLabel;
    Memo16: TLabel;
    Memo17: TLabel;
    Memo18: TLabel;
    Memo19: TLabel;
    Memo20: TLabel;
    Memo21: TLabel;
    Memo22: TLabel;
    Memo23: TLabel;
    Memo24: TLabel;
    Memo25: TLabel;
    Memo26: TLabel;
    Memo27: TLabel;
    Memo28: TLabel;
    Memo29: TLabel;
    Memo30: TLabel;
    Memo31: TLabel;
    Memo32: TLabel;
    Memo33: TLabel;
    Memo34: TLabel;
    Memo35: TLabel;
    Memo36: TLabel;
    Memo37: TLabel;
    Memo38: TLabel;
    Memo39: TLabel;
    Memo40: TLabel;
    Memo41: TLabel;
    Memo42: TLabel;
    Memo43: TLabel;
    Memo44: TLabel;
    Memo45: TLabel;
    Memo46: TLabel;
    Splitter3: TSplitter;
    Label4: TLabel;
    getPopupClipCount1: TMenuItem;
    getPinnedClipCount1: TMenuItem;
    getPinnedClip1: TMenuItem;
    getInstallPath1: TMenuItem;
    PromptListforInput1: TMenuItem;
    TabSheet56: TTabSheet;
    Label5: TLabel;
    TabSheet57: TTabSheet;
    Label6: TLabel;
    PopupPinnedClip1: TMenuItem;
    Clipboard1: TMenuItem;
    Windows1: TMenuItem;
    getCurrentWindow1: TMenuItem;
    MIsetCurrentWindowint1: TMenuItem;
    getMouseX1: TMenuItem;
    getMouseY1: TMenuItem;
    setMousePosXY1: TMenuItem;
    MIUndo1: TMenuItem;
    RepeatPromptResponse1: TMenuItem;
    pcClips: TPageControl;
    tsClipMacro: TTabSheet;
    tsPicture: TTabSheet;
    tsRichText: TTabSheet;
    tsRichEditor: TTabSheet;
    FrameRichEdit1: TFrameRichEdit;
    MIClipOnlyFormat1: TMenuItem;
    PlainText1: TMenuItem;
    RichText2: TMenuItem;
    HTMLClipReadOnly1: TMenuItem;
    N4: TMenuItem;
    tsHTMLEdit: TTabSheet;
    FrameHTMLEdit1: TFrameHTMLEdit;
    pnlHTMLHelper: TPanel;
    lblNoHTML: TLabel;
    btnGetClipboard: TButton;
    intfindWindowByPartialTitlestring1: TMenuItem;
    GetClipboardas1: TMenuItem;
    MiGetRichText3: TMenuItem;
    MIGetHTML1: TMenuItem;
    MIGetPicture1: TMenuItem;
    MIGetFiles1: TMenuItem;
    MIGetText1: TMenuItem;
    boolclipboardHasFormat1: TMenuItem;
    MIFormatRich: TMenuItem;
    MIFormatHTML: TMenuItem;
    MIFormatText: TMenuItem;
    MIFormatPicture: TMenuItem;
    MIFormatFiles: TMenuItem;
    N5: TMenuItem;
    MIgetWindowTitle1: TMenuItem;
    MIsetWindowMaximizedint1: TMenuItem;
    MIsetWindowMinimized: TMenuItem;
    pnl3: TPanel;
    pnl4: TPanel;
    txtMacroPreview: TMemo;
    cbClear: TCheckBox;
    Label7: TLabel;
    File1: TMenuItem;
    MISave1: TMenuItem;
    MISaveandClose1: TMenuItem;
    MIExit1: TMenuItem;
    N8: TMenuItem;
    MISaveCopyto1: TMenuItem;
    N9: TMenuItem;
    Misc1: TMenuItem;
    MIshowDebugTextstring1: TMenuItem;
    MIwriteDebugTextstring1: TMenuItem;
    extInspector1: TMenuItem;
    mItemText: TRichEdit;
    extInspector2: TMenuItem;
    clickInWindowstringintint1: TMenuItem;
    focusControlByPathstring1: TMenuItem;

    procedure btnCancelClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SaveToGroupMenuClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure txtItemNameChange(Sender: TObject);
    procedure MIAllClick(Sender: TObject);
    procedure txtItemNameEnter(Sender: TObject);
    procedure txtItemNameExit(Sender: TObject);
    procedure MICut1Click(Sender: TObject);
    procedure MICopy1Click(Sender: TObject);
    procedure MIPaste1Click(Sender: TObject);
    procedure MIDelete2Click(Sender: TObject);
    procedure MISelectAll1Click(Sender: TObject);
    procedure pmRightClickPopup(Sender: TObject);
    procedure MIKeyCombination1Click(Sender: TObject);

    procedure btnPreviewClick(Sender: TObject);
    procedure lblGroupContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure mItemTextXKeyPress(Sender: TObject; var Key: Char);
    procedure MIExtractLinksClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure MIMouseClick1Click(Sender: TObject);
    procedure btnDismissClick(Sender: TObject);
    procedure btnOnlineClick(Sender: TObject);
    procedure txtCodeKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure CTPlaintText2Click(Sender: TObject);
    procedure CTMacro1Click(Sender: TObject);
    procedure CTJavaScript1Click(Sender: TObject);
    procedure DATEFormattingHelp1Click(Sender: TObject);
    procedure MIShowResults1Click(Sender: TObject);
    procedure OnlineExamples1Click(Sender: TObject);
    procedure CommandReference1Click(Sender: TObject);
    procedure RUNHelp1Click(Sender: TObject);
    procedure JavaScriptReference1Click(Sender: TObject);
    procedure createMainfunction1Click(Sender: TObject);
    procedure saveToPopupClipsstring1Click(Sender: TObject);
    procedure getPopupClipint1Click(Sender: TObject);
    procedure manuallyExecuteMacrostring1Click(Sender: TObject);
    procedure getCurrentClipboard1Click(Sender: TObject);
    procedure setClipboardstring1Click(Sender: TObject);
    procedure MIConvertCliptoPlaintext1Click(Sender: TObject);
    procedure cbCommandsCategories1Items0Click(Sender: TObject);
    procedure cbCommandsCategories1Items1Click(Sender: TObject);
    procedure cbCommandsCategories1Items2Click(Sender: TObject);
    procedure cbCommandsCategories1Items3Click(Sender: TObject);
    procedure cbCommandsCategories0Items0Click(Sender: TObject);
    procedure cbCommandsCategories0Items1Click(Sender: TObject);
    procedure cbCommandsCategories0Items2Click(Sender: TObject);
    procedure cbCommandsCategories0Items3Click(Sender: TObject);
    procedure cbCommandsCategories0Items4Click(Sender: TObject);
    procedure cbCommandsCategories0Items5Click(Sender: TObject);
    procedure cbCommandsCategories0Items6Click(Sender: TObject);
    procedure cbCommandsCategories2Items0Click(Sender: TObject);
    procedure cbCommandsCategories2Items1Click(Sender: TObject);
    procedure cbCommandsCategories2Items2Click(Sender: TObject);
    procedure cbCommandsCategories2Items3Click(Sender: TObject);
    procedure cbCommandsCategories3Items0Click(Sender: TObject);
    procedure cbCommandsCategories3Items1Click(Sender: TObject);
    procedure cbCommandsCategories3Items2Click(Sender: TObject);
    procedure cbCommandsCategories3Items3Click(Sender: TObject);
    procedure cbCommandsCategories4Items0Click(Sender: TObject);
    procedure cbCommandsCategories4Items1Click(Sender: TObject);
    procedure cbCommandsCategories4Items2Click(Sender: TObject);
    procedure cbCommandsCategories4Items3Click(Sender: TObject);
    procedure cbCommandsCategories4Items4Click(Sender: TObject);
    procedure cbCommandsCategories4Items5Click(Sender: TObject);
    procedure cbCommandsCategories4Items6Click(Sender: TObject);
    procedure cbCommandsCategories4Items7Click(Sender: TObject);
    procedure cbCommandsCategories4Items8Click(Sender: TObject);
    procedure cbCommandsCategories4Items9Click(Sender: TObject);
    procedure cbCommandsCategories5Items0Click(Sender: TObject);
    procedure cbCommandsCategories5Items1Click(Sender: TObject);
    procedure cbCommandsCategories5Items2Click(Sender: TObject);
    procedure cbCommandsCategories5Items3Click(Sender: TObject);
    procedure cbCommandsCategories5Items4Click(Sender: TObject);
    procedure cbCommandsCategories5Items5Click(Sender: TObject);
    procedure cbCommandsCategories5Items6Click(Sender: TObject);
    procedure cbCommandsCategories6Items0Click(Sender: TObject);
    procedure cbCommandsCategories6Items1Click(Sender: TObject);
    procedure cbCommandsCategories6Items2Click(Sender: TObject);
    procedure cbCommandsCategories6Items3Click(Sender: TObject);
    procedure cbCommandsCategories7Items0Click(Sender: TObject);
    procedure cbCommandsCategories8Items0Click(Sender: TObject);
    procedure cbCommandsCategories8Items1Click(Sender: TObject);
    procedure cbCommandsCategories8Items2Click(Sender: TObject);
    procedure cbCommandsCategories8Items3Click(Sender: TObject);
    procedure getPopupClipCount1Click(Sender: TObject);
    procedure getPinnedClip1Click(Sender: TObject);
    procedure getPinnedClipCount1Click(Sender: TObject);
    procedure getInstallPath1Click(Sender: TObject);
    procedure cbCommandsCategories0Items7Click(Sender: TObject);
    procedure cbCommandsCategories0Items8Click(Sender: TObject);
    procedure getCurrentWindow1Click(Sender: TObject);
    procedure MIsetCurrentWindowint1Click(Sender: TObject);
    procedure getMouseX1Click(Sender: TObject);
    procedure getMouseY1Click(Sender: TObject);
    procedure setMousePosXY1Click(Sender: TObject);
    procedure MIUndo1Click(Sender: TObject);
    procedure PlainText1Click(Sender: TObject);
    procedure RichText2Click(Sender: TObject);
    procedure HTMLClipReadOnly1Click(Sender: TObject);
    procedure btnGetClipboardClick(Sender: TObject);
    procedure tsHTMLEditShow(Sender: TObject);
    procedure intfindWindowByPartialTitlestring1Click(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure MIFormatRichClick(Sender: TObject);
    procedure MIFormatHTMLClick(Sender: TObject);
    procedure MIFormatTextClick(Sender: TObject);
    procedure MIFormatPictureClick(Sender: TObject);
    procedure MIFormatFilesClick(Sender: TObject);
    procedure MIgetWindowTitle1Click(Sender: TObject);
    procedure MIsetWindowMaximizedint1Click(Sender: TObject);
    procedure MIsetWindowMinimizedClick(Sender: TObject);
    procedure MIExit1Click(Sender: TObject);
    procedure MISave1Click(Sender: TObject);
    procedure MISaveandClose1Click(Sender: TObject);
    procedure MIshowDebugTextstring1Click(Sender: TObject);
    procedure MIwriteDebugTextstring1Click(Sender: TObject);
    procedure pcClipsChange(Sender: TObject);
    procedure lbScriptsClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure mItemTextKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure clickInWindowstringintint1Click(Sender: TObject);
    procedure focusControlByPathstring1Click(Sender: TObject);


    {$ENDREGION}
  private
    { Private declarations }
    clip : TClipItem;
    IsNew : boolean;
    index : integer;
    group : string;
    overridegroup : string;
    format : TClipFormatType;
    HasNewData : boolean;
    HasNewCaption: boolean;
    NewDatIsClip : boolean;
    DialogMode : boolean;
    js : TJScript;
    osl : TOnlineScriptList;
    ts : TSplitter;
    plainText : string;

    clipSaved : boolean;

    procedure ShowItem(ci : TClipItem); overload;
    procedure UpdateCaret;
    procedure setOverride(group : string);
    procedure NewClipEvent(Sender : TObject);
    procedure setCaption(group : string);
    procedure SaveClipNow;
    procedure createGroupMenus;
    procedure setSaveEnabled(enabled : Boolean);
    procedure getNewClip(var inClip : TClipItem);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure HidePreviews;
    procedure ShowEditMode;
    procedure HideAllInfoPanels;
    procedure AddSplitter;

    procedure DetectClipType;

    procedure ClipTypeClipOnlyMode;
    procedure ClipTypeMacro;
    procedure ClipTypeJavaScript;

    procedure ShowInfoPanel(index : Integer);

    procedure SendText(text : string);
    procedure ReplaceAll(text : string);
    function getCurrentPageText : string;
    procedure setClipPage(index : Integer);
  public
    procedure MouseClickCallback(x,y:Integer);
    { Public declarations }
    function ShowFormNew(group : string) : integer;
    function ShowForm(
        group : string;
        itemindex : integer) : integer; overload;
    function ShowAsDialog(var caption : string; var clip : string) : boolean;

    function SetNewItem(ci : TClipItem) : boolean;  overload;
    function SetNewItem( clip : string; caption :string='' ) : boolean; overload;

    procedure PopupItemClick(sender : Tobject);

    procedure SetCliptypeClipOnly;
    procedure SetCliptypeKeystrokes;
    procedure SetCliptypeJavaScript;
    function isKeystrokeCommand : boolean;
    function isPlainText : boolean;
    function isJavaScript : boolean;
    procedure setKeystrokeCommand(value : boolean);
    function ClipWasSaved : boolean;
  end;

var
  FrmPermanentEdit: TFrmPermanentEdit;

implementation

uses  Clipbrd, UnitMisc, StrUtils, UnitFrmPermanentPreview,
  UnitPaste, ShLwApi, UnitKeyboardQuery, UnitToken, UnitClipDatabase,
  UnitACPopupClicks, UnitClipboardGrabber, UnitFrmRatTrap,
  UnitFrmClipboardManager, UnitFrmDebug, Math,
  mshtml, ActiveX, ComObj, RichEdit;



type TPageIndex = (
    PI_SCRIPT_RESULTS = 0,
    PI_ONLINE_EXAMPLES = 1,
    PI_COMMAND_REF = 2,
    PI_DATE_HELP = 3,
    PI_RUN_HELP = 5,
    PI_JAVASCRIPT_REF = 4
);
{$R *.dfm}

const
    PC_PAGE_TEXT = 0;
    PC_PAGE_PIC = 1;
    PC_PAGE_RICH_READONLY = 2;
    PC_PAGE_RICHEDIT = 3;
    PC_PAGE_HTML = 4;
//
// Clip Type Routines
//
procedure TFrmPermanentEdit.SetCliptypeClipOnly;
begin
    CTPlaintText2.Checked := true;
    ClipTypeClipOnlyMode;
    ShowEditMode;
    MIClipOnlyFormat1.Enabled := true;
end;
procedure TFrmPermanentEdit.SetCliptypeKeystrokes;
begin
    CTMacro1.Checked := true;
    ClipTypeMacro;
    MIClipOnlyFormat1.Enabled := false;

    setClipPage( PC_PAGE_TEXT );
end;
procedure TFrmPermanentEdit.SetCliptypeJavaScript;
begin
    CTJavaScript1.Checked := true;
    ClipTypeJavaScript;
    MIClipOnlyFormat1.Enabled := false;

    setClipPage( PC_PAGE_TEXT );
end;

procedure TFrmPermanentEdit.ClipTypeClipOnlyMode;
begin
    CTIgnorenewline.Checked := False;
    CTIgnorenewline.Enabled := false;

    MIKeystrokes1.Enabled := false;
    MICommands1.Enabled := false;
    MIShow1.Enabled := false;
    MIInsertJavaScript1.Enabled := false;

    lblDesc.Caption := 'Clip to Paste';
end;
procedure TFrmPermanentEdit.ClipTypeMacro;
begin
    CTIgnorenewline.Checked := False;
    CTIgnorenewline.Enabled := True;

    MIKeystrokes1.Enabled := True;
    MICommands1.Enabled := True;
    MIShow1.Enabled := true;
    MIInsertJavaScript1.Enabled := false;

    lblDesc.Caption := 'ArsClip Macro';
end;
procedure TFrmPermanentEdit.ClipTypeJavaScript;
begin
    CTIgnorenewline.Checked := False;
    CTIgnorenewline.Enabled := false;

    MIKeystrokes1.Enabled := True;
    MICommands1.Enabled := True;
    MIShow1.Enabled := true;
    MIInsertJavaScript1.Enabled := True;

    lblDesc.Caption := 'JavaScript';
end;

function TFrmPermanentEdit.ClipWasSaved : boolean;
begin
    Result := clipSaved;
end;

procedure TFrmPermanentEdit.setKeystrokeCommand;
begin
    if value then begin
        SetCliptypeKeystrokes
    end else begin
        SetCliptypeClipOnly
    end;
end;
function TFrmPermanentEdit.isKeystrokeCommand : boolean;
begin
    result := CTMacro1.Checked;
end;
function TFrmPermanentEdit.isJavaScript : boolean;
begin
    result := CTJavaScript1.Checked;
end;
function TFrmPermanentEdit.isPlainText : boolean;
begin
    result := CTPlaintText2.Checked;
end;


//
// Edit Mode and Info Panel Mode stuff
//
procedure TFrmPermanentEdit.ShowEditMode;
begin
    HideAllInfoPanels;

    pnlTop.Visible := true;
    pnlTop.Align := alNone;
    pnlInfo.Visible := False;
    pnlTop.Align := alClient;
end;
procedure TFrmPermanentEdit.ShowInfoPanel(index : Integer);
begin
    if pnlInfo.Visible = False then begin
        HideAllInfoPanels;
    end;


    pcPages.ActivePageIndex := index;
    lblInfoTitle.Caption := pcPages.ActivePage.Caption;

    pnlInfo.Visible := True;
    AddSplitter;
end;
procedure TFrmPermanentEdit.HideAllInfoPanels;
begin
    pnlInfo.Visible := false;
    spInfo.Visible := false;
end;
procedure TFrmPermanentEdit.AddSplitter;
begin
    spInfo.Visible := true;
    exit;
    if ts = nil then begin
        ts := TSplitter.Create(pnlTopMost);
        ts.ResizeStyle := rsLine;
    end;

    ts.Align := alNone;
    ts.Align := alRight;
end;

procedure TFrmPermanentEdit.btnDismissClick(Sender: TObject);
begin
    ShowEditMode;
    self.SetFocusedControl(mItemText);
end;

// Form Events
procedure TFrmPermanentEdit.CreateParams(var Params: TCreateParams);
begin
    inherited CreateParams(Params);
    // allow context taskbar context menu and
    // show me on the taskbar - independant of main form
    with Params do begin
        ExStyle := ExStyle or WS_EX_APPWINDOW;
        WndParent := FrmPermanent.Handle;
    end;
end;
procedure TFrmPermanentEdit.FormCreate(Sender: TObject);
var
    i : integer;
    Mask: DWORD;
begin
//    self.clientheight := pnlTop.Height + pnlBottom.height;
//    pnlTop.Align := alClient;

    SHAutoComplete(txtItemName.Handle,
        SHACF_AUTOAPPEND_FORCE_OFF or SHACF_AUTOSUGGEST_FORCE_OFF);

//    Memo1.WordWrap := true;
    txtDateHelp.WordWrap := true;
    txtJSMain.WordWrap := True;
    txtJSComm.WordWrap := true;
    txtRunHelp.WordWrap := true;
    for i := 0 to pcPages.PageCount - 1 do begin
        pcPages.Pages[i].TabVisible := false;
    end;

    for i := 0 to pcCommands.PageCount - 1 do begin
        pcCommands.Pages[i].TabVisible := false;
    end;

    for i := 0 to pcClips.PageCount - 1 do begin
        pcClips.Pages[i].TabVisible := false;
    end;

    //
    // the IDE doesn't allow these type of shortcuts
    // to be made directly
    //
    MIExit1.ShortCut := Menus.ShortCut(VK_ESCAPE,[]);
    MISaveandClose1.ShortCut := Menus.ShortCut(Word('S'), [ssAlt]);



    frmClipboardManager.addNewClipListener(NewClipEvent);

    clip := nil;

    Mask := SendMessage(FrameRichEdit1.reText.Handle, EM_GETEVENTMASK, 0, 0);
    SendMessage(FrameRichEdit1.reText.handle, EM_SETEVENTMASK, 0, Mask or ENM_LINK);
    SendMessage(FrameRichEdit1.reText.Handle, EM_AUTOURLDETECT, 0, 0);
end;
procedure TFrmPermanentEdit.FormDestroy(Sender: TObject);
var i : integer;
begin
    FrmDebug.AppendLog('UnitFrmPernanentEdit Destroy', false);
    EXIT;
    // TODO - don't forget about me

    try
        if osl <> nil then begin
            for i := osl.Count-1 downto 0 do begin
                osl.Items[i].Free;
            end;
            osl.Free;
        end;

        if (self.clip<>nil) then MyFree(self.clip);
    except
        FrmDebug.AppendLog('UnitFrmPernanentEdit Destroy Fail', false);
    end;



    //inherited;
end;

procedure TFrmPermanentEdit.FormHide(Sender: TObject);
begin
    if not self.DialogMode then begin
        FrameHTMLEdit1.setHTMLFromClip('');
        FrameRichEdit1.reText.Text := '';
        mItemText.Text := '';
        reItemText.Text := '';
    end;
end;

procedure TFrmPermanentEdit.FormActivate(Sender: TObject);
begin
    if self.Visible then
        if self.ActiveControl = nil then begin
            self.SetFocusedControl(self.txtItemName);
        end;
end;
procedure TFrmPermanentEdit.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    self.HasNewData := false;
    self.NewDatIsClip := false;
    self.HasNewCaption := false;
    FrmPermanentPreview.Hide;
end;
procedure TFrmPermanentEdit.FormShow(Sender: TObject);
begin
    self.ShowEditMode;
    self.createGroupMenus;

    self.clipSaved := false;

    self.txtItemName.SetFocus;

    self.mItemTextX.ClearUndo;

    setOverride(overridegroup);
end;

procedure TFrmPermanentEdit.DetectClipType;
begin
    if pcClips.ActivePageIndex = PC_PAGE_TEXT then begin
        if TJScript.isJavaScript(mItemText.text) then begin
            SetCliptypeJavaScript;
        end;
        if StartsText(KEYS_STR, mItemText.text) then begin
            setKeystrokeCommand(true);
            CTIgnorenewline.Enabled := true;
        end;
    end;
end;

procedure TFrmPermanentEdit.setOverride(group : string);
begin
    self.overridegroup := group;

end;

function TFrmPermanentEdit.SetNewItem(clip : string; caption :string='' ) : boolean;
begin
    self.getNewClip(self.clip);

    self.clip.SetFromPlainText(clip);
    self.clip.SetDisplayText(caption);

    setOverride(FrmPermanent.GetPermanentPath);
    self.ShowItem(self.clip);

    self.txtItemName.Text := caption;



    self.IsNew := true;

    Result := False;
    if not self.DialogMode then
        result := IsPositiveResult(self.ShowModal);
end;
function TFrmPermanentEdit.SetNewItem(ci : TClipItem) : boolean;
begin
    if (self.clip<>nil) then myfree(self.clip);

    self.clip := ci.CloneClip;


    setOverride(FrmPermanent.GetPermanentPath);
    self.ShowItem(self.clip);

    self.txtItemName.text := '';


    self.IsNew := true;
    self.index := -1;

    result := IsPositiveResult(self.ShowModal);
end;


//
// public functions to show the form
// - as dialog for Clip Menu > Custom Items
// - empty for a given permanent group
// - populated with a permanent clip for a given group
procedure TFrmPermanentEdit.getNewClip(var inClip : TClipItem);
begin
    if assigned(inClip) then myfree(self.clip);
    inClip := TClipITem.Create;
    inClip.SetFromPlainText('');
    inClip.SetDisplayText('');
end;
procedure TFrmPermanentEdit.setCaption(group : string);
begin
    self.Caption := 'Edit Permanent Clip  -  [Group: ' + group+']';
end;

function TFrmPermanentEdit.ShowFormNew(group : string) : integer;
begin
    self.IsNew := true;
    self.overridegroup := group;
    self.index := -1;
    txtItemName.text := '';
    mItemText.Lines.clear;

    SetCliptypeClipOnly;

    self.getNewClip(self.clip);
    self.clip.SetFromPlainText('');
    self.clip.SetDisplayText('');
    self.ShowItem(self.clip);

    setCaption(group);

    result := self.ShowModal;
end;
function TFrmPermanentEdit.ShowForm(
        group : string; itemindex : integer) : integer;
var s : string;
    prefix : string;


begin
    self.getNewClip(self.clip);
    TClipDatabase.LoadPermanent(clip, itemindex, group);

    self.IsNew := false;
    self.index := itemindex;
    setOverride(group);

    HidePreviews;

    self.index := ItemIndex;
    self.group := group;

//    cbKeystrokes.Checked := false;
    setKeystrokeCommand(false);
    CTIgnorenewline.Checked := false;;




    self.ShowItem(self.clip);

    txtItemName.text := self.clip.getDisplayText;
    setSaveEnabled(txtItemName.Text <> '');

    prefix := uppercase(leftstr(mItemText.Text,6));

    CTIgnorenewline.Enabled := false;
    CTIgnorenewline.checked := false;

    DetectClipType;

    if StartsText(KEYS_IGNORENL_STR, mItemText.text) then begin
        CTIgnorenewline.Enabled := true;
        setKeystrokeCommand(true);
        CTIgnorenewline.Checked := true;
    end;

    if (CTIgnorenewline.Checked) then begin
        s := mItemText.Text;
        delete(s, 1, length(KEYS_IGNORENL_STR));
        mItemText.Text := s;
    end else if isKeystrokeCommand then begin
        s := mItemText.Text;
        delete(s,1,length(KEYS_STR));
        mItemText.Text := s;
    end;

    setCaption(group);

    result := self.ShowModal;
end;
function TFrmPermanentEdit.ShowAsDialog(var caption : string; var clip : string) : boolean;
var windowCaption : string;
begin
    DialogMode := true;
    self.SetNewItem(clip, caption);


    setSaveEnabled(false);

    windowCaption := self.Caption;
    self.Caption := 'Edit Macro';
    result := false;

    DetectClipType;

    if IsPositiveResult(self.ShowModal) then begin
        result := true;
        caption := txtItemName.Text;
        clip := mItemText.Text;
    end;
    self.Caption := windowCaption;
    DialogMode := false;
end;
procedure TFrmPermanentEdit.ShowItem(ci: TClipItem);
var
    s : string;
    ms : TMemoryStream;
    ansi : AnsiString;
begin
    HidePreviews;

    if group = '' then begin
        if overridegroup <> '' then begin
            group := overridegroup;
        end else begin
            group := FrmPermanent.GetPermanentPath;
        end;
    end;

    setCaption(group);

    SetCliptypeClipOnly;

    format := ci.GetFormatType;
    self.plainText := '';
    lblDesc.Caption := 'Clip to Paste';
    case format of
    FT_PICTURE:
        begin
            setClipPage( PC_PAGE_PIC );

            ci.GetDIB(pPreview.Picture);

            lblDesc.Caption := 'Clip to Paste  -  [Picture (DIB)]';
        end;
    FT_RICHTEXT:
        begin
            setClipPage( PC_PAGE_RICHEDIT );
            FrameRichEdit1.setRichText( ci );
            lblDesc.Caption := 'Clip to Paste  -  [RichText]';
        end;
    FT_HTML:
        begin
            setClipPage(PC_PAGE_HTML);
            ci.GetUTF8Text(s);
            FrameHTMLEdit1.setHTMLFromClip(s);

            lblDesc.Caption := 'Clip to Paste  -  [HTML Clips are Read Only]';
        end;
    FT_FILE:
        begin
            setClipPage(PC_PAGE_RICH_READONLY);

            if format = FT_FILE then begin
                reItemText.PlainText := true;
                reItemText.Lines.Clear;
                reItemText.Text := ci.GetAsPlaintext;

                lblDesc.Caption := 'Clip to Paste  -  [File clips are Read Only]';
            end else begin
                FrameRichEdit1.reText.Lines.Clear;
                ci.GetUTF8Text(s);
                self.plainText := ci.GetAsPlaintext;

                reItemText.PlainText := true;
                reItemText.Lines.Clear;
                reItemText.Text := s;

                lblDesc.Caption := 'Clip to Paste  -  [HTML Clips are Read Only]';
            end;
        end;
    else
        begin
            setClipPage(PC_PAGE_TEXT);
            mItemText.Visible := true;
            mItemText.ClearUndo;
            mItemText.Text := ci.GetAsPlaintext;
            // NOTE: Purposely replacing manually to clear
            // all levels of the undo buffer
//            ReplaceAll( ci.GetAsPlaintext );
        end;
    end;
end;

// Caption events to enable save and show/hide help text
procedure TFrmPermanentEdit.txtItemNameChange(Sender: TObject);
begin
    if not DialogMode then begin
        btnsave.Enabled := txtItemName.Text <> '';
        setSaveEnabled(btnSave.Enabled);
    end else begin
        btnsave.Enabled := (txtItemName.Text <> '') and (mItemText.Text<>'');
        setSaveEnabled(false);
    end;
end;
procedure TFrmPermanentEdit.txtItemNameEnter(Sender: TObject);
begin
    if not DialogMode then
        lblCaptionHelp.Visible := true;
end;
procedure TFrmPermanentEdit.txtItemNameExit(Sender: TObject);
begin
    lblCaptionHelp.Visible := false;
end;
procedure TFrmPermanentEdit.mItemTextKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    // Trick the control into creating an Undo buffer
    // when the Enter key is pressed.
    // - Treat RETURN like arrow keys: moving the selection
    if (Key = VK_RETURN) and (shift = []) then begin
        mItemText.SelStart := mItemText.SelStart;
        mItemText.SelLength := 0;
    end;
end;

procedure TFrmPermanentEdit.mItemTextXKeyPress(Sender: TObject; var Key: Char);
begin

end;

// callbacks
procedure TFrmPermanentEdit.MouseClickCallback;
begin
    SendText(
        '[MOUSECLICK X="'+IntToStr(x)+'" Y="'+IntToStr(y)+'"]'
    );
end;

procedure TFrmPermanentEdit.UpdateCaret;
begin
    if (mItemText.SelStart = 0) and (mItemText.SelLength = 0) then
        mItemTExt.SelStart := length(mItemText.Text);
end;
procedure TFrmPermanentEdit.MIExtractLinksClick(Sender: TObject);
var
    s : AnsiString;
    ResStream: TResourceStream;
const NL = #13#10;
begin

    ResStream := TResourceStream.Create(hInstance, 'EXTRACT_JS', RT_RCDATA);
    setlength(s, ResStream.Size);
    ResStream.Read(s[1],length(s));
    myfree(ResStream);

    SetCliptypeJavaScript;

    mItemText.text := TJScript.getStartNoMacro +
    '   var urls = extractURLs(clipboardStr);'+ NL +
    '   if (urls==null) return;'+ NL +
    '   var result = "";'+NL+
    '   for (var i=0;i<urls.length;i++) {'+NL+
    '       result += urls[i]+"\r\n";'+NL+
    '   }'+NL+
    '   manuallyExecuteMacro("[CLIPBOARDONLY]"+result);'+NL+
    TJScript.getEndNoMacro + NL +
    string(s);
end;

// right click menu

procedure TFrmPermanentEdit.MISelectAll1Click(Sender: TObject);
begin
    if pcClips.ActivePageIndex = PC_PAGE_TEXT then begin
        mItemText.SelectAll;
    end else if pcClips.ActivePageIndex = PC_PAGE_RICHEDIT then begin
        FrameRichEdit1.reText.SelectAll;
    end;
end;
procedure TFrmPermanentEdit.MIConvertCliptoPlaintext1Click(Sender: TObject);
begin
    HidePreviews;
    format := FT_TEXT;

    setClipPage(PC_PAGE_TEXT) ;

    mitemtext.Text := self.plainText;
    lblDesc.Caption := 'Clip to Paste';
end;
procedure TFrmPermanentEdit.MICopy1Click(Sender: TObject);
begin

    if pcClips.ActivePageIndex = PC_PAGE_TEXT then begin
        mItemText.CopyToClipboard;
    end else if pcClips.ActivePageIndex = PC_PAGE_RICHEDIT then begin
        FrameRichEdit1.reText.CopyToClipboard;
    end;
end;
procedure TFrmPermanentEdit.MICut1Click(Sender: TObject);
begin

    if pcClips.ActivePageIndex = PC_PAGE_TEXT then begin
        mItemText.CutToClipboard;
    end else if pcClips.ActivePageIndex = PC_PAGE_RICHEDIT then begin
        FrameRichEdit1.reText.CutToClipboard;
    end;
end;
procedure TFrmPermanentEdit.MIDelete2Click(Sender: TObject);
begin
    if pcClips.ActivePageIndex = PC_PAGE_TEXT then begin
        SendText('');
    end else if pcClips.ActivePageIndex = PC_PAGE_RICHEDIT then begin
        // TODO test for UNDO trigger
        FrameRichEdit1.reText.SelText := '';
    end;
end;
procedure TFrmPermanentEdit.MIPaste1Click(Sender: TObject);
begin

    if pcClips.ActivePageIndex = PC_PAGE_TEXT then begin
        mItemText.PasteFromClipboard;
    end else if pcClips.ActivePageIndex = PC_PAGE_RICHEDIT then begin
        FrameRichEdit1.reText.PasteFromClipboard;
    end;
end;

procedure TFrmPermanentEdit.pmRightClickPopup(Sender: TObject);
    procedure AddFormat(format : integer; description : string);
    var mi : TMenuItem;
    begin
        if TClipboardGrabber.HasFormat(format) then begin
            mi := TMenuItem.Create(MIPasteAs1);
            mi.Caption := description;
            mi.Hint := IntToStr(format);
            mi.OnClick := self.PopupItemClick;
            MIPasteAs1.Add(mi);
        end;

    end;

begin
    if pcClips.ActivePageIndex = PC_PAGE_TEXT then begin
        MISelectAll1.Enabled := mItemText.text <> '';
        MIDelete2.Enabled := mItemText.SelText <> '';
        MICut1.Enabled := MIDelete2.Enabled;
        MICopy1.Enabled := MIDelete2.Enabled;

        MIUndo1.Enabled := mItemText.CanUndo;

    end else if pcClips.ActivePageIndex = PC_PAGE_RICHEDIT then begin
        MISelectAll1.Enabled := FrameRichEdit1.reText.text <> '';
        MIDelete2.Enabled := FrameRichEdit1.reText.SelText <> '';
        MICut1.Enabled := MIDelete2.Enabled;
        MICopy1.Enabled := MIDelete2.Enabled;

        MIUndo1.Enabled := FrameRichEdit1.reText.CanUndo;

    end else begin
        MISelectAll1.Enabled := false;
        MIDelete2.Enabled := false;
        MICut1.Enabled := false;
        MICopy1.Enabled := false;
        MIUndo1.Enabled := false;
    end;



    MIPasteAs1.Clear;
    AddFormat(CF_TEXT, 'Plain Text');
    AddFormat(CF_WAVE, 'Wave Audio');
    AddFormat(CF_DIB, 'DIB (Picture)');
    AddFormat(CF_HDROP, 'File(s)');
    AddFormat(UnitMisc.GetCF_RICHTEXT, 'RichText');
    AddFormat(UnitMisc.GetCF_HTML, 'HTML');
    AddFormat(CF_UNICODETEXT, 'Unicode');

//    MIConvertCliptoPlaintext1.Visible := (self.plainText <> '')
//        and CTPlaintText2.Checked
//        and (pcClips.ActivePageIndex <> PC_PAGE_TEXT);

end;
procedure TFrmPermanentEdit.PopupItemClick(sender: Tobject);
begin
    if assigned(clip) then myfree(clip);
    clip := TClipItem.Create;
    clip.GetClipboardItem(0, SysUtils.StrToInt(TMenuItem(sender).Hint));
    self.ShowItem(clip);
end;

procedure TFrmPermanentEdit.MIUndo1Click(Sender: TObject);
begin
    if pcClips.ActivePageIndex = PC_PAGE_TEXT then begin
        mItemText.Undo;
    end else if pcClips.ActivePageIndex = PC_PAGE_RICHEDIT then begin
        FrameRichEdit1.reText.Undo;
    end;
end;


// Panel stuff
procedure TFrmPermanentEdit.txtCodeKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if (ssCtrl in Shift) and (Key = Ord('A')) then begin
        txtCode.SelectAll;
    end;
end;
procedure TFrmPermanentEdit.HidePreviews;
begin
    setClipPage( PC_PAGE_TEXT );
end;
procedure TFrmPermanentEdit.tsHTMLEditShow(Sender: TObject);
begin
    pnlHTMLHelper.Visible := FrameHTMLEdit1.getHTMLClip = '';
    if pnlHTMLHelper.Visible then begin
        btnGetClipboard.Enabled := TClipboardGrabber.hasFormat(UnitMisc.GetCF_HTML);
        lblNoHTML.Visible := not btnGetClipboard.Enabled;
    end;
end;
procedure TFrmPermanentEdit.NewClipEvent(Sender: TObject);
begin
    if pcClips.ActivePageIndex = PC_PAGE_HTML then begin
        tsHTMLEdit.OnShow(tsRichText);
    end;
end;

procedure TFrmPermanentEdit.btnGetClipboardClick(Sender: TObject);
begin
    if assigned(self.clip) then MyFree(clip);
    clip := TClipItem.Create;
    clip.GetClipboardItem(0, UnitMisc.GetCF_HTML);
    self.ShowItem(clip);
    pnlHTMLHelper.Visible := False;
end;
procedure TFrmPermanentEdit.btnPreviewClick(Sender: TObject);
var
    s,s2,token : string;
    b : boolean;
    prefix : string;

    procedure showClipboard;
    var s : string;
    begin
        lblClipboard.Caption := '';
        s := TClipboardGrabber.asText;
        if (s='') then begin
            lblClipboard.Caption := '(empty)';
        end else begin
            lblClipboard.Caption := s;
        end;
    end;
    procedure HandleJavaScriptError(js : TJScript);
    var err : string;
    begin
        err := js.LastErr;
        txtMacroPreview.Text := 'JavaScript Error line('+IntToStr(js.LastLine)+'): '+ err ;

        mItemText.SelStart := mitemText.Perform(EM_LINEINDEX, js.LastLine, 0);
        mItemText.SelLength := length(mItemText.Lines[js.LastLine]);
        FrmDebug.appendlog('JavaScript: '+err);
    end;
var
    err : string;
begin
    btnRerun.enabled := False;

    if cbClear.Checked then begin
        txtMacroPreview.Lines.Clear;
    end;
    showClipboard;

    self.FocusControl(txtMacroPreview);

    s := uppercase(mItemText.text);
    s2 := TokenString(s,'[INDEX=',false);
    if (s<>'') then begin
        //[INDEX=$i]
        token := TokenString(s,']',false);
        s := mItemText.text;
        s := StringReplace(s,'[index='+token+']', '',[rfReplaceAll,rfIgnoreCase]);
        s := StringReplace(s,token, IntToStr(0),[rfReplaceAll,rfIgnoreCase]);
    end else begin
        s := mItemText.text;
    end;
    if ContainsText(s,'[STAYOPEN]') then begin
        s := StringReplace(s,'[STAYOPEN]', '',[rfReplaceAll,rfIgnoreCase]);
    end;

    if CTPlaintText2.Checked then
        begin
            Paste.SendPlainText(s);
        end
    else if CTMacro1.Checked then
        begin
            if CTIgnorenewline.Checked then begin
                s := KEYS_IGNORENL_STR + s;
            end else begin
                s := KEYS_STR + s;
            end;
            Paste.SendMacro(s);
        end
    else if CTJavaScript1.Checked then
        begin
            js := TJScript.Create;
            js.executeJS(Paste, s);
            err := js.LastErr;
            if (err <> '') then begin
                HandleJavaScriptError(js);
            end;
            myfree(js);
        end;

    showClipboard;

    btnRerun.enabled := True;
end;
procedure TFrmPermanentEdit.pcClipsChange(Sender: TObject);
begin
    PlainText1.Enabled := True;
    HTMLClipReadOnly1.Enabled := true;
    RichTExt2.Enabled := True;

    case pcClips.ActivePageIndex of
    PC_PAGE_TEXT: PlainText1.Enabled := false;
    PC_PAGE_RICHEDIT: RichText2.Enabled := False;
    PC_PAGE_HTML: HTMLClipReadOnly1.Enabled := false;
    end;
end;
procedure TFrmPermanentEdit.setClipPage(index : Integer);
begin
    pcClips.ActivePageIndex := index; // the ONLY place this must be set
    pcClipsChange(pcClips);
end;

procedure TFrmPermanentEdit.lbScriptsClick(Sender: TObject);
begin
    if lbScripts.ItemIndex = -1 then Exit;

    txtDesc.text := osl.Items[lbScripts.ItemIndex].description;
    txtCode.Text := osl.Items[lbScripts.ItemIndex].code;

    //txtCode.SetFocus;
end;


// File Menu
procedure TFrmPermanentEdit.MISave1Click(Sender: TObject);
begin
     self.SaveClipNow;
     if group <> overridegroup then begin
         setcaption(group);
         group := overridegroup;
     end;
end;
procedure TFrmPermanentEdit.MISaveandClose1Click(Sender: TObject);
begin
    btnSaveClick(btnSave);
end;
procedure TFrmPermanentEdit.MIExit1Click(Sender: TObject);
begin
    btnCancel.Click;
end;
procedure TFrmPermanentEdit.SaveToGroupMenuClick(Sender: TObject);
var b : boolean;
begin
    Self.overridegroup := TMenuItem(Sender).Caption;
    self.SaveClipNow;
    self.group := overridegroup;
    setCaption(group);
end;

procedure TFrmPermanentEdit.createGroupMenus;
var i : integer;
    cur, s : string;
    mi : TMenuItem;
    var p : TPoint;
begin
    MISaveCopyto1.Clear;

    if self.overridegroup = '' then self.overridegroup := self.group;
    cur := self.overridegroup;

    for i  := 0 to FrmPermanent.PermFoldersGetCount - 1 do begin
        s := FrmPermanent.PermFoldersGetItem(i);
        if (s = cur) then CONTINUE;

        mi := MainMenu1.CreateMenuItem;
        mi.Caption := s;
        mi.OnClick := self.SaveToGroupMenuClick;

        MISaveCopyto1.add(mi);
    end;
end;
procedure TFrmPermanentEdit.setSaveEnabled(enabled : Boolean);
begin
    if DialogMode then begin
        MISave1.Enabled := false;
        MISaveCopyto1.Enabled := false;
        MISaveandClose1.Enabled := True;
    end else begin
        MISave1.Enabled := enabled;
        MISaveCopyto1.Enabled := enabled;
        MISaveandClose1.Enabled := enabled;
    end;
end;



//
// main dialog buttons
//

type
    cliphelper = class helper for TClipItem
public
    procedure setFormat(format : word);
end;
procedure cliphelper.setFormat(format : word);
begin
    self.cformat := self.FileFormatToFormat(format);
end;

procedure TFrmPermanentEdit.SaveClipNow;
var s : string;
    sz : cardinal;
    ms : TMemoryStream;
    astr : AnsiString;
begin
    try
        TClipDatabase.StartBatch;
        // if the group changed, just save to the end of the list
        if (self.group <> self.overridegroup) then begin
            self.index := -1;
            self.group := self.overridegroup;
        end;

        if (self.IsNew) or (self.index = -1) then begin
            self.index := TClipDatabase.getCountPermanent(self.group);
        end;

        if (pcClips.ActivePageIndex = PC_PAGE_TEXT) then begin
            if (CTIgnorenewline.Checked) then begin
                self.clip.SetFromPlainText(KEYS_IGNORENL_STR+mItemText.text);
            end else if (isKeystrokeCommand) then begin
                self.clip.SetFromPlainText(KEYS_STR+mItemText.text);
            end else begin
                self.clip.SetFromPlainText(mItemText.text);
            end;
        end else if (pcClips.ActivePageIndex = PC_PAGE_RICHEDIT) then begin
            // this is just a workaround for getting the ANSI
            // strings of RichText into a TClipItem
            FrameRichEdit1.reText.SelLength := 0;

            ms := TMemoryStream(self.clip.GetStream);
            ms.Clear;
            self.clip.setFormat(UnitMisc.GetCF_RICHTEXT);

            FrameRichEdit1.reText.Lines.SaveToStream(ms);
            ms.Position := 0;
        end;
        self.clip.SetDisplayText(txtItemName.text);
        TClipDatabase.SavePermanent(self.clip, self.index, self.group);

        TClipDatabase.EndBatch;
    finally
        // Caller is reponsible for freeing clip on close
        self.IsNew := false;
    end;
    self.clipSaved := true;
end;

procedure TFrmPermanentEdit.btnSaveClick(Sender: TObject);
begin
    if not DialogMode then begin
        FrmPermanentPreview.Hide;
        self.SaveClipNow;
        MyFree(self.clip);
    end;
    self.ModalResult := mrOK;
end;
procedure TFrmPermanentEdit.btnCancelClick(Sender: TObject);
begin
    self.ModalResult := mrCancel;
    self.Hide;
    myfree(self.clip);
end;
procedure TFrmPermanentEdit.lblGroupContextPopup(Sender: TObject; MousePos: TPoint; var Handled: Boolean);
begin

end;




// Clip menu
procedure TFrmPermanentEdit.CTPlaintText2Click(Sender: TObject);
begin
    SetCliptypeClipOnly;
end;
procedure TFrmPermanentEdit.CTMacro1Click(Sender: TObject);
begin
   SetCliptypeKeystrokes;
end;
procedure TFrmPermanentEdit.CTJavaScript1Click(Sender: TObject);
begin
    SetCliptypeJavaScript;

    if not TJScript.isJavaScript(mItemText.text) then begin
        mItemText.Text := TJScript.getStartMacro + TJScript.getEndMacro;
    end;
end;
procedure TFrmPermanentEdit.PlainText1Click(Sender: TObject);
var s : string;
begin
    s := getCurrentPageText;

    setClipPage(PC_PAGE_TEXT);
    lblDesc.Caption := 'Clip to Paste';

    ReplaceAll(s);
end;
procedure TFrmPermanentEdit.RichText2Click(Sender: TObject);
var s : string;
begin
    s := getCurrentPageText;
    setClipPage(PC_PAGE_RICHEDIT);
    lblDesc.Caption := 'Clip to Paste  -  [RichText]';

    FrameRichEdit1.reText.Lines.Clear;
    FrameRichEdit1.reText.Lines.Add(s)

end;
procedure TFrmPermanentEdit.HTMLClipReadOnly1Click(Sender: TObject);
var s : string;
begin
    s := getCurrentPageText;
    setClipPage(PC_PAGE_HTML);
    lblDesc.Caption := 'Clip to Paste   -  [HTML Clips are Read Only]';

    FrameHTMLEdit1.setAsPlaintext(s);
end;

function TFrmPermanentEdit.getCurrentPageText : string;
var ms : TMemoryStream;
begin
    result := '';

    case pcClips.ActivePageIndex of
    PC_PAGE_TEXT:
        begin
            result := mItemText.Text;
        end;
    PC_PAGE_RICHEDIT:
        begin
            result := FrameRichEdit1.reText.Text;
        end;
    PC_PAGE_RICH_READONLY:
        begin
            result := reItemText.Text;
        end;
    PC_PAGE_HTML:
        begin
            result := FrameHTMLEdit1.getPlainTextClip;
        end;
    end;
end;

// View menu
procedure TFrmPermanentEdit.MIShowResults1Click(Sender: TObject);
begin
    ShowInfoPanel(Integer(PI_SCRIPT_RESULTS));
    btnRerun.Click;
end;
procedure TFrmPermanentEdit.OnlineExamples1Click(Sender: TObject);
begin
    ShowInfoPanel(Integer(PI_ONLINE_EXAMPLES));

    txtDesc.text := '';
    txtCode.Text := '';

    btnOnlineClick(nil);
end;


procedure TFrmPermanentEdit.btnOnlineClick(Sender: TObject);
var
    i : integer;
    c : TCursor;
    os : TOnlineScript;
begin
    if osl <> nil then begin
        for i := osl.Count-1 downto 0 do begin
            osl.Items[i].Free;
        end;
        osl.Clear;
        osl.Free;
    end;

    if DialogMode then begin
        osl := TOnlineScriptReader.getScripts(OST_CLIPMENU)
    end else begin
        osl := TOnlineScriptReader.getScripts(OST_MACRO)
    end;

    lbScripts.Clear;
    if osl.Count <> 0 then begin
        for os in osl do begin
            lbScripts.AddItem(os.name, os);
        end;
    end;

end;
procedure TFrmPermanentEdit.CommandReference1Click(Sender: TObject);
begin
    ShowInfoPanel(Integer(PI_COMMAND_REF));
end;
procedure TFrmPermanentEdit.DATEFormattingHelp1Click(Sender: TObject);
begin
   ShowInfoPanel(Integer(PI_DATE_HELP));
end;
procedure TFrmPermanentEdit.RUNHelp1Click(Sender: TObject);
begin
    ShowInfoPanel(integer(PI_RUN_HELP));
end;
procedure TFrmPermanentEdit.JavaScriptReference1Click(Sender: TObject);
begin
    ShowInfoPanel(integer(PI_JAVASCRIPT_REF));
end;

// insert command
procedure TFrmPermanentEdit.MIKeyCombination1Click(Sender: TObject);
var hkd : THotkeyData;
begin
    if FrmHotkey.GetHotkey(
        hkd.alt, hkd.shft, hkd.ctrl, hkd.win,
        hkd.key,
        hkd.name
    ) then begin

       self.Update;


        SendText(
            '[KEY="'+ frmHotkey.toHKstring(hkd)  +'"]'
        );
    end;
end;
procedure TFrmPermanentEdit.MIMouseClick1Click(Sender: TObject);
begin
    FrmRatTrap.SetPositionCallback(Self.MouseClickCallback);
    FrmRatTrap.Show;
end;
procedure TFrmPermanentEdit.MIAllClick(Sender: TObject);


    function isKeystroke(str : string) : boolean;
{
    pv_left, pv_right, pv_up, pv_down,
    , pv_home, pv_end,
    pv_tab, pv_delete, pv_space, pv_enter}
    const
        TEMP_DELIM = '&';
        KEYS_STR = ' LEFT RIGHT UP DOWN HOME END TAB SPACE ENTER ';

    begin
        result := TokenInString(
            str,
            TEMP_DELIM,
            ReplaceText(KEYS_STR,' ',TEMP_DELIM)
        );
    end;

var mi : TMenuItem;
    s : string;
begin
    mi := TMenuItem(sender);
    s := uppercase(mi.Caption);

    self.Update;


    if (s = 'DATE') then begin
        SendText('[DATE="mm/dd/yyyy"]');
    end else if (s = 'WAIT') then begin
        SendText('[WAIT=100]');
    end else if (AnsiStartsText('PROMPT FOR INPUT',s)) then begin
        SendText('[PROMPT="Enter Data"]');
    end else if AnsiStartsText('PROMPT LIST FOR INPUT',s) then begin
        SendText('[PROMPTOPTIONS="Enter Data" OPTIONS="first|second"]');
    end else if AnsiStartsText('PROMPT RESPONSE', s) then begin
        SendText('[PROMPTRESPONSE=0]');
    end else if (s = 'POPUPITEM') then begin
        SendText('[POPUPITEM="0"]');
    end else if (AnsiStartsText('POPUP CLIP AS', s)) then begin
        SendText('[POPUPITEM=0]');
    end else if (AnsiStartsText('PINNED CLIP AS', s)) then begin
        SendText('[PINNEDITEM=0]');


    end else if (s= 'BACKSPACE') then begin
        SendText('[BACK REPEAT=1]');
    end else if (s= 'DELETE') then begin
        SendText('[DEL REPEAT=1]');
    end else if (s='SPACEBAR') then begin
        SendText('[SPACE REPEAT=1]');
    end else if (s= 'DATE') then begin
        SendText('[DATE="mm/dd/yyyy"]');
    end else if (AnsiStartsText('STARTING CLIPBOARD', s)) then begin
        SendText('[CLIPBRD]');
    end else if (AnsiStartsText('CURRENT CLIPBOARD', s)) then begin
        SendText('[CLIPBRDCURRENT]');
    end else if (s= 'DELETE CLIPBOARD') then begin
        SendText('[CLEAR]');
        end else if (s= 'CONFIGURATION') then begin
            SendText('[WINDOWCONFIG]');
        end else if (s= 'EDIT HISTORY') then begin
            SendText('[WINDOWHISTORY]');
        end else if (s= 'REMOVED CLIPS') then begin
            SendText('[WINDOWREMOVED]');
        end else if (s= 'EDIT CLIPBOARD') then begin
            SendText('[WINDOWCLIPBOARD]');
        end else if (s= 'PERMANENT CLIPS') then begin
            SendText('[WINDOWPERMANENT]');
        end else if (s= 'SEARCH AND PASTE') then begin
            SendText('[WINDOWSEARCH=""]');
        end else if (s= 'TEXT INSPECTOR') then begin
            SendText('[WINDOWINSPECT]');
    end else if (s= 'ALL') then begin
        SendText('[SELECTALL]');
    end else if (s= 'WORD LEFT') then begin
        SendText('[SELECTLEFT REPEAT=1]');
    end else if (s= 'WORD RIGHT') then begin
        SendText('[SELECTRIGHT REPEAT=1]');
     end else if (s= 'PASTE SELECTED') then begin
        SendText('[WINDOWPASTESEL]');
    end else if (AnsiStartsText('CLIPBOARD ONLY', s)) then begin
    	SendText('[CLIPBOARDONLY]');
    end else if (s = 'FIND AND REPLACE') then begin
        SendText('[CLIPBOARDFIND="" REPLACE=""]');
    end else if (s = 'REPLACE DOUBLE SPACES') then begin
        SendText('[CLIPBOARDFIND="  " REPLACE=" "]');
    end else if (s = 'REPLACE DOUBLE LINEFEEDS') then begin
        SendText('[CLIPBOARDFIND="\n\n" REPLACE="\n"]');
    end else if (s = 'REPLACE TABS WITH SPACES') then begin
        SendText('[CLIPBOARDFIND="\t" REPLACE="    "]');
    end else if (s = 'REMOVE LINEFEEDS') then begin
        SendText('[CLIPBOARDFIND="\n" REPLACE=""]');
        end else if (s = 'UPPER CASE') then begin
        SendText('[CLIPBOARDUPPER]');
        end else if (s = 'LOWER CASE') then begin
        SendText('[CLIPBOARDLOWER]');
        end else if (s = 'CAPITALIZE WORDS') then begin
        SendText('[CLIPBOARDCAPWORDS]');
        end else if (s = 'INVERSE CASE') then begin
        SendText('[CLIPBOARDINVERSE]');
    end else if (AnsiStartsText('DISABLE CLIP', s)) then begin
        SendText('[DISABLEMONITORING]');
    end else if (AnsiStartsText('MIMIC TYPING', s)) then begin
        SendText('[MIMIC]');
    end else if (AnsiStartsText('TRIM', s)) then begin
        SendText('[TRIMCLIPBOARD]');
    end else if (AnsiStartsText('COPY AND', s)) then begin
        SendText('[COPYWAIT=2000]');
    end else if (s = 'SAVE CLIPBOARD') then begin
        SendText('[PUSHCLIPBOARD]');
    end else if (AnsiStartsText('RESTORE FIRST', s)) then begin
        SendText('[POPFIRST]');
    end else if (AnsiStartsText('RESTORE LAST', s)) then begin
        SendText('[POPLAST]');
    end else if (AnsiStartsText('PASTE', s)) then begin
        SendText('[PASTEDEFAULT]');

    {Popup Clips}
    end else if (s= 'DELETE CLIP') then begin
        SendText('[DELETECLIP=0]');
    end else if (s= 'DELETE ALL CLIPS') then begin
        SendText('[CLEARPOPUP]');
    end else if (AnsiStartsText('COPY TO CLIPBOARD', s)) then begin
        SendText('[TOCLIPBOARD=0]');
    end else if (s= 'MOVE CLIP') then begin
        SendText('[MOVECLIP="0" TO="1"]');
    // get clipboard as ...
        end else if (s= 'TEXT') then begin
            SendText('[SAVECLIPBOARD AS="TEXT"]');
        end else if (s='RICHTEXT') then begin
            SendText('[SAVECLIPBOARD AS="RICH"]');
        end else if (s='HTML') then begin
            SendText('[SAVECLIPBOARD AS="HTML"]');
        end else if (s='PICTURE') then begin
            SendText('[SAVECLIPBOARD AS="PIC"]');
        end else if (s='FILES') then begin
            SendText('[SAVECLIPBOARD AS="FILES"]');
    end else if (s= 'NEW CLIP') then begin
        SendText('[NEWCLIP=""]');

    end else if (s='RUN') then begin
        SendText('[RUN][ENDRUN]');

    end else if s = 'WAIT FOR NEW CLIP' then begin
        SendText('[WAITFORCLIP]');
    end else if s = 'SAVE CLIPBOARD TO TEXTFILE' then begin
        SendText('[TOTEXTFILE=""]');

    end else if (s='NORMAL') then begin
        SendText('[COPY="NORMAL"]');
        end else if (s='PREPEND CLIPBOARD') then begin
            SendText('[COPY="PREPEND"]');
        end else if (s='APPEND CLIPBOARD') then begin
            SendText('[COPY="APPEND"]');
        end else if (s='AS PLAINTEXT') then begin
            SendText('[COPY="PLAIN"]');
        end else if (s='AS FORMATTED') then begin
            SendText('[COPY="FORMAT"])');
    end else if (s='SPLIT CLIPBOARD') then begin
        SendText('[CLIPBOARDSPLIT SEPARATOR=""][SPLITPIECE=0][SPLITPIECE=1]');
    end else if (s='SPLIT CLIPBOARD LOOP') then begin
        SendText('[CLIPBOARDSPLIT SEPARATOR=""][SPLITLOOP="$i"][SPLITPIECE=$i][ENDSPLITLOOP]');

    end else if (s='LOAD FROM FILE') then begin
        SendText('[CLIPBOARDFROMFILE=""]');


    end else if isKeystroke(s)  then begin
        SendText('[' + s + ' REPEAT=1]');
    end else begin
        SendText('[' + s + ']');
    end;
end;

// insert JavaScript
procedure TFrmPermanentEdit.getCurrentClipboard1Click(Sender: TObject);
begin
    SendText('getCurrentClipboard();');
end;
procedure TFrmPermanentEdit.getCurrentWindow1Click(Sender: TObject);
begin
    SendText('getCurrentWindow();');
end;
procedure TFrmPermanentEdit.getInstallPath1Click(Sender: TObject);
begin
    SendText('getInstallPath();');
end;
procedure TFrmPermanentEdit.getMouseX1Click(Sender: TObject);
begin
    SendText('getMouseX();');
end;
procedure TFrmPermanentEdit.getMouseY1Click(Sender: TObject);
begin
    SendText('getMouseY();');
end;
procedure TFrmPermanentEdit.getPinnedClip1Click(Sender: TObject);
begin
    SendText('getPinnedClip(0);');
end;
procedure TFrmPermanentEdit.getPinnedClipCount1Click(Sender: TObject);
begin
    SendText('getPinnedClipCount();');
end;
procedure TFrmPermanentEdit.getPopupClipCount1Click(Sender: TObject);
begin
    SendText('getPopupClipCount();');
end;
procedure TFrmPermanentEdit.getPopupClipint1Click(Sender: TObject);
begin
    SendText('getPopupClip(0);');
end;
procedure TFrmPermanentEdit.createMainfunction1Click(Sender: TObject);
begin
    if not TJScript.isJavaScript(mItemText.text) then begin
        ReplaceAll(
         TJScript.getStartMacro + TJScript.getEndMacro
        )
    end;
end;
procedure TFrmPermanentEdit.saveToPopupClipsstring1Click(Sender: TObject);
begin
    SendText('saveToPopupClips("");');
end;
procedure TFrmPermanentEdit.setClipboardstring1Click(Sender: TObject);
begin
    SendText('setClipboard("");');
end;
procedure TFrmPermanentEdit.manuallyExecuteMacrostring1Click(Sender: TObject);
begin
    SendText('manuallyExecuteMacro("");');
end;
procedure TFrmPermanentEdit.intfindWindowByPartialTitlestring1Click(
  Sender: TObject);
begin
    SendText('findWindowByPartialTitle("");');
end;
procedure TFrmPermanentEdit.MIgetWindowTitle1Click(Sender: TObject);
begin
    SendText('getWindowTitle(int);');
end;
procedure TFrmPermanentEdit.MIsetWindowMaximizedint1Click(Sender: TObject);
begin
    SendText('setWindowMaximized(int);');
end;
procedure TFrmPermanentEdit.MIsetWindowMinimizedClick(Sender: TObject);
begin
    SendText('setWindowMinimized(int);');
end;
procedure TFrmPermanentEdit.MIshowDebugTextstring1Click(Sender: TObject);
begin
    SendText('showDebugText("");');
end;
procedure TFrmPermanentEdit.MIwriteDebugTextstring1Click(Sender: TObject);
begin
    SendText('writeDebugText("");');
end;
procedure TFrmPermanentEdit.MIFormatFilesClick(Sender: TObject);
begin
SendText('clipboardHasFormat("FILES");');
end;
procedure TFrmPermanentEdit.MIFormatHTMLClick(Sender: TObject);
begin
    SendText('clipboardHasFormat("HTML");');
end;
procedure TFrmPermanentEdit.MIFormatPictureClick(Sender: TObject);
begin
    SendText('clipboardHasFormat("PIC");');
end;
procedure TFrmPermanentEdit.MIFormatRichClick(Sender: TObject);
begin
    SendText('clipboardHasFormat("RICH");');
end;
procedure TFrmPermanentEdit.MIFormatTextClick(Sender: TObject);
begin
SendText('clipboardHasFormat("TEXT");');
end;
procedure TFrmPermanentEdit.MIsetCurrentWindowint1Click(Sender: TObject);
begin
    SendText('setForegroundWindow(int);');
end;
procedure TFrmPermanentEdit.setMousePosXY1Click(Sender: TObject);
begin
    SendText('setMousePos(int, int);');
end;
procedure TFrmPermanentEdit.clickInWindowstringintint1Click(Sender: TObject);
begin
    SendText(
        'clickInWindow("",int,int);'+#13#10+
        '// this function is designed to be generated by the Text Inspector'
    );
end;
procedure TFrmPermanentEdit.focusControlByPathstring1Click(Sender: TObject);
begin
    SendText(
        'focusControlByPath("");'+#13#10+
        '// this function is designed to be generated by the Text Inspector'
    );
end;



procedure TFrmPermanentEdit.SendText(text : string);
begin
    // NOTE: Using CustomEdit.SelText does not use the Undo option set to 1
    mItemText.Perform(EM_REPLACESEL, 1, LongInt(PChar(text)));
end;
procedure TFrmPermanentEdit.ReplaceAll(text: string);
begin
    mItemText.SelectAll;
    SendText(text);
end;


// View > Command Reference buttons
procedure TFrmPermanentEdit.cbCommandsCategories0Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 0;
end;
procedure TFrmPermanentEdit.cbCommandsCategories0Items1Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 1;
end;
procedure TFrmPermanentEdit.cbCommandsCategories0Items2Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 2;
end;
procedure TFrmPermanentEdit.cbCommandsCategories0Items3Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 3;
end;
procedure TFrmPermanentEdit.cbCommandsCategories0Items4Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 4;
end;
procedure TFrmPermanentEdit.cbCommandsCategories0Items5Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 5;
end;
procedure TFrmPermanentEdit.cbCommandsCategories0Items6Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 6;
end;
procedure TFrmPermanentEdit.cbCommandsCategories0Items7Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 7;
end;
procedure TFrmPermanentEdit.cbCommandsCategories0Items8Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 8;
end;

procedure TFrmPermanentEdit.cbCommandsCategories1Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 9;
end;
procedure TFrmPermanentEdit.cbCommandsCategories1Items1Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 10;
end;
procedure TFrmPermanentEdit.cbCommandsCategories1Items2Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 11;
end;
procedure TFrmPermanentEdit.cbCommandsCategories1Items3Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 12;
end;

procedure TFrmPermanentEdit.cbCommandsCategories2Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 13;
end;
procedure TFrmPermanentEdit.cbCommandsCategories2Items1Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 14;
end;
procedure TFrmPermanentEdit.cbCommandsCategories2Items2Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 15;
end;
procedure TFrmPermanentEdit.cbCommandsCategories2Items3Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 16;
end;

procedure TFrmPermanentEdit.cbCommandsCategories3Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 17;
end;
procedure TFrmPermanentEdit.cbCommandsCategories3Items1Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 18;
end;
procedure TFrmPermanentEdit.cbCommandsCategories3Items2Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 19;
end;
procedure TFrmPermanentEdit.cbCommandsCategories3Items3Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 20;
end;

procedure TFrmPermanentEdit.cbCommandsCategories4Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 21;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items1Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 22;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items2Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 23;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items3Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 24;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items4Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 25;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items5Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 26;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items6Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 27;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items7Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 28;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items8Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 29;
end;
procedure TFrmPermanentEdit.cbCommandsCategories4Items9Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 30;
end;

procedure TFrmPermanentEdit.cbCommandsCategories5Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 31;
end;
procedure TFrmPermanentEdit.cbCommandsCategories5Items1Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 32;
end;
procedure TFrmPermanentEdit.cbCommandsCategories5Items2Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 33;
end;
procedure TFrmPermanentEdit.cbCommandsCategories5Items3Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 34;
end;
procedure TFrmPermanentEdit.cbCommandsCategories5Items4Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 35;
end;
procedure TFrmPermanentEdit.cbCommandsCategories5Items5Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 36;
end;
procedure TFrmPermanentEdit.cbCommandsCategories5Items6Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 37;
end;

procedure TFrmPermanentEdit.cbCommandsCategories6Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 38;
end;
procedure TFrmPermanentEdit.cbCommandsCategories6Items1Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 39;
end;
procedure TFrmPermanentEdit.cbCommandsCategories6Items2Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 40;
end;
procedure TFrmPermanentEdit.cbCommandsCategories6Items3Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 41;
end;

procedure TFrmPermanentEdit.cbCommandsCategories7Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 42;
end;
procedure TFrmPermanentEdit.cbCommandsCategories8Items0Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 43;
end;
procedure TFrmPermanentEdit.cbCommandsCategories8Items1Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 44;
end;
procedure TFrmPermanentEdit.cbCommandsCategories8Items2Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 45;
end;
procedure TFrmPermanentEdit.cbCommandsCategories8Items3Click(Sender: TObject);
begin
    pcCommands.ActivePageIndex := 46;
end;


initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitPermanentEdit', false);
end;

end.
