unit UnitFrmPreviewPopup;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TfrmPreviewPopup = class(TForm)
    procedure FormPaint(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    	procedure UpdatePreview;
        procedure DrawIt;
  end;

var
  frmPreviewPopup: TfrmPreviewPopup;

implementation

uses UnitFramePopup, UnitFrmConfig, UnitFrmDebug;

{$R *.dfm}

{ TfrmPreviewPopup }

procedure TfrmPreviewPopup.DrawIt;
begin

end;

procedure TfrmPreviewPopup.FormDestroy(Sender: TObject);
begin
    FrmDebug.AppendLog('UnitFrmPreviewPopup Destroy', false);
end;

procedure TfrmPreviewPopup.FormPaint(Sender: TObject);
begin
    self.UpdatePreview;
end;

procedure TfrmPreviewPopup.UpdatePreview;
var ac : TACPopup;
begin
	ac := TACPopup.Create(self);
    ac.Name := '';
    //ac.ParentWindow := self.handle;

    ac.SetCanvas(Canvas);
    ac.IncludeEmpty := true;
    ac.FullMode :=FrmConfig.cbfullmode.checked;
    ac.AutoPopulate;
    ac.DrawOnCanvas();
    self.ClientWidth  := ac.Width;
    self.ClientHeight := ac.Height;

    ac.Free;
end;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmPreviewPopup', false);
end;

end.
