unit UnitFrmRatTrap;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ExtCtrls, Vcl.StdCtrls;
type TRatTrapPosition = procedure(x,y:Integer) of object;
type
  TFrmRatTrap = class(TForm)
    btnClose: TButton;
    Label1: TLabel;
    Label2: TLabel;
    lblMousePos: TLabel;
    procedure FormShow(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure Label2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    callback : TRatTrapPosition;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure ShowMousePosition;

      public
    { Public declarations }
    procedure SetPositionCallback(proc : TRatTrapPosition);
      procedure ReportMouse(pt : TPoint);
    procedure ReportDirectionChange;
  end;


var
  FrmRatTrap: TFrmRatTrap;

implementation

{$R *.dfm}

uses UnitFrmDebug;

procedure TFrmRatTrap.SetPositionCallback(proc : TRatTrapPosition);
begin
    callback := proc;
end;

procedure TFrmRatTrap.btnCloseClick(Sender: TObject);
begin
    Self.Hide;
end;

procedure TFrmRatTrap.CreateParams(var Params: TCreateParams);
begin
    //ControlStyle := ControlStyle - [csOpaque];
    //Brush.Style := bsClear;
   	inherited;

    Params.Style := WS_POPUP and not WS_CAPTION {and WS_BORDER};
    Params.ExStyle := WS_EX_TOOLWINDOW or WS_EX_TOPMOST {or
    WS_EX_NOACTIVATE};
end;

procedure TFrmRatTrap.FormDestroy(Sender: TObject);
begin
    FrmDebug.AppendLog('UnitFrmRatTrap Destroy', false);
end;

procedure TFrmRatTrap.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
    ShowMousePosition;
end;
procedure TFrmRatTrap.ShowMousePosition;
begin
    lblMousePos.Caption := 'Current ('+IntToStr(Mouse.CursorPos.x)+','
    +IntToStr(Mouse.CursorPos.y)+')';
end;
procedure TFrmRatTrap.FormShow(Sender: TObject);
var pt : TPoint;
    m : TMonitor;
begin
    self.WindowState := wsNormal;
    Self.Top := Screen.DesktopTop;
    Self.Height := Screen.DesktopHeight;
    self.Left := Screen.DesktopLeft;
    Self.Width := screen.DesktopWidth;

    //self.WindowState := wsMaximized;

    ShowMousePosition;

    Canvas.Brush.Color := clBtnFace;
    canvas.Rectangle(self.ClientRect);
end;

procedure TFrmRatTrap.Label2Click(Sender: TObject);
begin
    self.Hide;
    callback(Mouse.CursorPos.X, Mouse.CursorPos.Y);
end;


procedure TFrmRatTrap.Label2MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
    ShowMousePosition;
end;

procedure TFrmRatTrap.ReportMouse(pt : TPoint);
begin
    pt := ScreenToClient(pt);

    if pt <> canvas.PenPos then begin
        Canvas.MoveTo(Canvas.PenPos.X, Canvas.PenPos.y);
        Canvas.LineTo(pt.X, pt.y);
    end;

    Canvas.Pixels[pt.X, pt.Y] := clBlack;
end;


procedure TFrmRatTrap.ReportDirectionChange;
begin
end;



initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmRatTrap', false);
end;

end.
