unit UnitFrmShared;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls;

type
  TfrmShared = class(TForm)
    Label1: TLabel;
    lbGroups: TListBox;
    btnConvert: TButton;
    lblDone: TLabel;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lbGroupsClick(Sender: TObject);
    procedure btnConvertClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    sl : TStringList;
    procedure updateForm;
  public
    { Public declarations }
  end;

var
  frmShared: TfrmShared;

implementation

{$R *.dfm}

uses UnitClipDatabase, UnitFrmDebug;

procedure TfrmShared.btnConvertClick(Sender: TObject);
begin
    TSharedMetadata.reportUpdated( sl[lbGroups.ItemIndex] );
    updateForm;
    lblDone.Visible := true;
end;

procedure TfrmShared.FormCreate(Sender: TObject);
begin
    sl := TStringList.Create;

end;

procedure TfrmShared.FormDestroy(Sender: TObject);
begin
    FrmDebug.AppendLog('UnitFrmShared Destroy', false);
    FreeAndNil(sl);
end;

procedure TfrmShared.FormShow(Sender: TObject);
begin
    TSharedMetadata.update; // prevent a recently shared group from being shared again
    updateForm;
end;


procedure TfrmShared.updateForm;
var
    i : integer;
begin
    sl.Clear;
    lbGroups.Clear;

    TClipDatabase.LoadPermanentGroups(sl);
    for i := 0 to sl.Count-1 do begin
        if TSharedMetadata.isShared(sl[i]) then begin
            lbGroups.Items.Add( sl[i] + ' (shared)');
        end else begin
            lbGroups.Items.Add( sl[i] );
        end;
    end;

    btnConvert.enabled := false;

    lblDone.Visible := false;
end;

procedure TfrmShared.lbGroupsClick(Sender: TObject);
begin
    btnConvert.Enabled := false;
    if lbGroups.ItemIndex = -1 then begin
        EXIT;
    end;

    if not TSharedMetadata.isShared(sl[lbGroups.ItemIndex]) then begin
        btnConvert.Enabled := true;
    end;
end;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmShared', false);
end;

end.
