unit UnitFrmTextContent;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.Buttons, Vcl.StdCtrls, Vcl.ExtCtrls,
    UnitTextInspectorData, Vcl.Menus;

type
  TfrmTextContent = class(TForm)
    pnlContent: TPanel;
    txtContent: TMemo;
    pnlButtons: TPanel;
    btnClose: TSpeedButton;
    btnCopy: TSpeedButton;
    btnCopyExit: TSpeedButton;
    btnExtract: TSpeedButton;
    pmTree: TPopupMenu;
    pmHeader: TPopupMenu;
    pmListbox: TPopupMenu;
    ExtractAllColumnText1: TMenuItem;
    ExtractFullBranch1: TMenuItem;
    AllListRows1: TMenuItem;
    AllColumnHeaders1: TMenuItem;
    pmCombo: TPopupMenu;
    AllListItems1: TMenuItem;
    pmListItem: TPopupMenu;
    EntireRow1: TMenuItem;
    SelecterRows1: TMenuItem;
    SelectedColumnItems1: TMenuItem;
    SelectedRows1: TMenuItem;
    procedure btnCloseClick(Sender: TObject);
    procedure btnCopyClick(Sender: TObject);
    procedure pnlButtonsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pnlButtonsMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pnlButtonsMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btnCopyExitClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure btnExtractClick(Sender: TObject);
    procedure ExtractAllColumnText1Click(Sender: TObject);
    procedure AllColumnHeaders1Click(Sender: TObject);
    procedure ExtractFullBranch1Click(Sender: TObject);
    procedure AllListRows1Click(Sender: TObject);
    procedure AllListItems1Click(Sender: TObject);
    procedure EntireRow1Click(Sender: TObject);
    procedure SelecterRows1Click(Sender: TObject);
    procedure SelectedColumnItems1Click(Sender: TObject);
    procedure SelectedRows1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    fMouseDown : boolean;
    fdx, fdy : integer;
    CType : TTIControlType;
    fLastControl : TTICInfo;
     procedure CreateParams(var Params: TCreateParams); override;

        function ExtractColumn : string;
        function ExtractColumnHeaders : string;
        function ExtractTreePath : string;
        function ExtractAllListBox : string;
        function ExtractAllComboBoxList : string;
        function ExtractListViewRow : string;
        function ExtractListViewSelectedRows : string;
        function ExtractColumnSelectedRow : string;
        function ExtractListboxSelected : string;
  public
    { Public declarations }
    procedure ShowContent(r : TRect; s : string);
    procedure SetContext(CType : TTIControlType; MultiSelect : boolean = false);
  end;

var
  frmTextContent: TfrmTextContent;

implementation

{$R *.dfm}

uses UnitFrmTextInspector, UnitFrmTextInspectorControls,
UnitFocusManager, UnitMisc, UnitViewExtract, Winapi.CommCtrl,
UnitUIAutomation, Generics.Collections, UIAutomationClient_TLB, UnitFrmDebug;


procedure TfrmTextContent.CreateParams(var Params: TCreateParams);
begin
    inherited;

    Params.Style := (WS_POPUP and not WS_CAPTION) or WS_EX_APPWINDOW ;
    Params.ExStyle := {WS_EX_TOOLWINDOW or} WS_EX_TOPMOST;
    Params.WndParent := FrmTextInspector.Handle;
end;
procedure TfrmTextContent.FormDestroy(Sender: TObject);
begin
    FrmDebug.AppendLog('UnitFrmTextContent Destroy');
end;

procedure TfrmTextContent.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if key = vk_escape then begin
        self.btnClose.Click;
        key := 0;
    end;
end;

procedure TfrmTextContent.ShowContent(r : TRect; s : string);
begin
    if s = '' then begin
        ShowWindow(self.Handle, SW_HIDE);
        self.Visible := false;
        EXIT;
    end;


    self.Top := r.Top + 18;
    self.Left := r.Left + 5;
    self.txtContent.Text := s;
    self.txtContent.SelectAll;

    if self.Top + self.Height > (screen.DesktopLeft+ screen.DesktopHeight) then begin
        self.Top := (screen.DesktopTop + screen.DesktopHeight) - self.Height;
    end;
    if self.Top < screen.DesktopTop then begin
        self.Top := screen.DesktopTop;
    end;
    if (self.Left + self.Width) > (screen.DesktopLeft+screen.DesktopWidth) then begin
        self.Left := (screen.DesktopLeft+screen.DesktopWidth) - self.Width;
    end;
    if self.Left < screen.DesktopLeft then begin
        self.Left := screen.DesktopLeft;
    end;

    ShowWindow(self.Handle, SW_SHOWNORMAL);
    Winapi.Windows.SetWindowPos(
        frmTextContent.Handle,  HWND_TOP , self.left, self.top,0,0,
        SWP_NOSIZE
    );

    self.Visible := true;
end;
procedure TfrmTextContent.SetContext(CType : TTIControlType; MultiSelect : boolean = false);
begin
    self.fLastControl := FrmTextInspector.LastControl;
    self.ctype := ctype;

    btnExtract.PopupMenu := nil;
    case ctype of
    tctUnknown,
    tctEdit:
        begin
        end;
    tctHeader:
        begin
            btnExtract.PopupMenu := pmHeader;
            SelectedColumnItems1.Enabled := MultiSelect;
        end;
    tctListView:
        begin
            btnExtract.PopupMenu := pmListItem;
            self.SelecterRows1.enabled := MultiSelect;
        end;
    tctListBox:
        begin
            btnExtract.PopupMenu := pmListbox;
        end;
    tctTreeView:
        begin
            btnExtract.PopupMenu := pmTree;
        end;
    tctComboBox:
        begin
           // btnExtract.PopupMenu := pmCombo;
           // Doesn't work yet. ComboBox has a list that doesn't
           // exist until displayed.
        end;
    end;
    btnExtract.enabled := assigned(btnExtract.PopupMenu);
end;


procedure TfrmTextContent.SelectedColumnItems1Click(Sender: TObject);
begin
    txtContent.Text := self.ExtractColumnSelectedRow;
    txtContent.SelectAll;
end;
procedure TfrmTextContent.SelectedRows1Click(Sender: TObject);
begin
   txtContent.Text := self.ExtractListboxSelected;
   txtContent.SelectAll;
end;
procedure TfrmTextContent.SelecterRows1Click(Sender: TObject);
begin
    txtContent.Text := self.ExtractListViewSelectedRows;
    txtContent.SelectAll;
end;
procedure TfrmTextContent.EntireRow1Click(Sender: TObject);
begin
    txtContent.Text := self.ExtractListViewRow;
    txtContent.SelectAll;
end;
procedure TfrmTextContent.ExtractAllColumnText1Click(Sender: TObject);
begin
    txtContent.Text := self.ExtractColumn;
    txtContent.SelectAll;
end;
procedure TfrmTextContent.ExtractFullBranch1Click(Sender: TObject);
begin
   txtContent.Text := self.ExtractTreePath;
   txtContent.SelectAll;
end;
procedure TfrmTextContent.AllColumnHeaders1Click(Sender: TObject);
begin
    //
    txtContent.Text := self.ExtractColumnHeaders;
    txtContent.SelectAll;
end;
procedure TfrmTextContent.AllListItems1Click(Sender: TObject);
begin
    txtContent.Text := self.ExtractAllComboBoxList;
    txtContent.SelectAll;
end;
procedure TfrmTextContent.AllListRows1Click(Sender: TObject);
begin
    txtContent.Text := self.ExtractAllListBox;
    txtContent.SelectAll;
end;

procedure TfrmTextContent.btnCloseClick(Sender: TObject);
begin
    self.Visible := false;
    ShowWindow(self.Handle, SW_HIDE);
end;
procedure TfrmTextContent.btnCopyClick(Sender: TObject);
begin
    txtContent.CopyToClipboard;
    btnClose.Click;
end;


procedure TfrmTextContent.btnCopyExitClick(Sender: TObject);
begin
    txtContent.CopyToClipboard;
    frmTextInspectorControls.btnClose.Click;
end;

procedure TfrmTextContent.btnExtractClick(Sender: TObject);
begin
    if assigned(btnExtract.PopupMenu) then begin
        UnitMisc.ShowPopupBottom(btnExtract, btnExtract.PopupMenu);
    end;
end;

// make window easy to drag
procedure TfrmTextContent.pnlButtonsMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    fMouseDown := true;
    fdx := x;
    fdy := y;
end;
procedure TfrmTextContent.pnlButtonsMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
    if fMouseDown then begin
        SetBounds(
            self.Left + (X - fdX),
            self.Top + (Y - fdy),
            self.Width, self.Height
        );
    end;
end;
procedure TfrmTextContent.pnlButtonsMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    fMouseDown := false;
end;



function TfrmTextContent.ExtractColumn : string;
var
    i, j, k : integer;
    parentH : integer;
    str : string;
    c  : TTICInfo;
begin
    result := '';

    if (fLastControl.ControlType = tctHeader) then begin
        k := THeaderExtract.GetColumnIdx(fLastControl.Handle, fLastControl.MousePoint);
        parentH := Winapi.Windows.GetParent(fLastControl.Handle);
        j := Winapi.Windows.SendMessage(parentH, LVM_GETITEMCOUNT, 0, 0);
        for i := 0 to j-1 do begin
            if TListViewExtract.GetText(parentH, i,k, str) then begin
                if str <> '' then begin
                    if result <> '' then result := result + #13#10;
                    result := result + str;
                end;
            end;
        end;
    end else begin
        if TUIAutomation.GetColumnIndex(flastControl, j) then begin
            if TUIAutomation.GetAssociatedListView(flastControl, c) then begin
                if TUIAutomation.GetListViewRowCount(c, k) then begin
                    for i := 0 to k-1 do begin
                        if TUIAutomation.GetListViewTextAsGrid(c, i, j, str) then begin
                            if str <> '' then begin
                                if result <> '' then result := result + #13#10;
                                result := result + str;
                            end;
                        end;
                    end;
                end;
            end;
        end;

    end;

end;
function TfrmTextContent.ExtractColumnHeaders : string;
var


    i,j : integer;
    str : string;
begin
    if (fLastControl.ControlType = tctHeader) then begin
        j := THeaderExtract.GetColumnCount(fLastControl.Handle);
        for i := 0 to j-1 do begin
            str := THeaderExtract.GetText(fLastControl.Handle, i);
            if str <> '' then begin
                if result <> '' then result := result + ' ';
                result := result + str;
            end;
        end;
    end else if TUIAutomation.isActuallyHeaderItem(fLastControl) then begin
        if TUIAutomation.GetColumnHeaders(fLastControl, str) then begin
            result := str;
        end;
    end;
end;
function TfrmTextContent.ExtractColumnSelectedRow : string;
var rows : TObjectList<TList<String>>;
    parentH : THandle;
    listView : TTICInfo;
    idx, i,cnt : integer;
    str : string;
    found : boolean;
begin
    rows := TObjectList<TList<String>>.create;
    if (fLastControl.ControlType = tctHeader) then begin
        parentH := Winapi.Windows.GetParent(flastControl.handle);
        idx := THeaderExtract.GetColumnIdx(flastControl.Handle, fLastControl.MousePoint);
        found := TListViewExtract.GetSelectedRows(parenth, idx, rows);
    end else begin
        if TUIAutomation.GetColumnIndex(fLastControl, idx) then begin
            TUIAutomation.GetAssociatedListView(flastControl, listview);
            if TUIAutomation.GetListViewSelectedRows(
                listView, idx, rows
            ) then begin
                found := true;
            end;
            myfree(listView);
        end;
    end;
    if found then begin
        for i := 0 to rows.Count-1 do begin
            str := rows[i][0];
            result := result + str + #13#10;
        end;
    end;

    rows.Clear;
    myfree(rows);

end;
function TfrmTextContent.ExtractTreePath : string;
var s : string;
begin
    if TUIAutomation.GetTreeViewPathText(fLastControl, s) then begin
        result := s;
    end else begin
        if fLastControl.ControlType = tctTreeView then begin
            if TTreeViewExtract.GetPathText(
                fLastControl.Handle, fLastControl.MousePoint, s
            ) then begin
                result := s;
            end;
        end;
    end;
end;
function TfrmTextContent.ExtractAllListBox : string;
var i,j : integer;
    s : string;
begin
    TListBoxExtract.GetCount(flastControl.Handle, j);
    for i := 0 to j-1 do begin
        if TListBoxExtract.GetText(flastControl.Handle, i, s) then begin
            if s <> '' then begin
                if result <> '' then result := result + #13#10;
                result := result + s;
            end;
        end;
    end;
end;
function TfrmTextContent.ExtractAllComboBoxList : string;
var s : string;
begin
    if TUIAutomation.GetComboBoxList(fLastControl, s) then begin
        result := s;
    end;
end;
function TfrmTextContent.ExtractListViewRow : string;
var i,j,k : integer;
    s, str : string;
    good : boolean;
    r : TRect;
    c : TTICInfo;
    needsFree : boolean;
    element, tempElement : IUIAutomationElement;
    sl : TList<String>;
begin
    good := false;
    k := -1;

    if fLastControl.UIA.ParentCType = UIA_ListItemControlTypeId then begin
        sl := TList<string>.create;
        c := TUIAutomation.GetParent(flastControl, true);
        if TUIAutomation.GetChildrenTextFromContainer(c,sl) then begin
            good := true;
            for i := 0 to sl.Count -1 do begin
                Appendx(result, sl[i], '  ');
            end;
        end;
        myfree(sl);
        myfree(c);
        if good then EXIT;
    end;

    c := fLastControl;
    if fLastControl.UIA.ParentCType = UIA_ListControlTypeId then begin
        c := TUIAutomation.GetParent(flastControl, true);
        c.MousePoint := flastControl.MousePoint;
        needsFree := false;
    end;

    if TUIAutomation.GetListViewRow(c, k) then begin
        i := 0;
        repeat
            if TUIAutomation.GetListViewTextAsGrid(c, k, i, str) then begin
                good := true;
                appendx(s, str, '  ');
                inc(i);
            end else begin
                BREAK;
            end;
        until false;
        result := s;
    end;

    if not good then begin
        if (k <> -1) then begin
            sl := TList<String>.create;
            TListViewExtract.GetText(
                fLastControl.Handle, k, sl
            );
            for i := 0 to sl.Count-1 do begin
                Appendx(s, sl[i], '  ');
            end;
            myfree(sl);
        end else begin
            sl := TList<string>.create;
            TListViewExtract.GetText(
                flastControl.Handle,fLastControl.MousePoint, r,sl
            );
            myfree(sl);
        end;
        result := s;
    end;

    if (needsFree) then begin
        MyFree(c);
    end;
end;
function TfrmTextContent.ExtractListViewSelectedRows : string;
var
    i,j,cnt : integer;
    str : string;
    rows : TList<Tlist<String>>;
    found : boolean;
    sl : TList<string>;
begin
    found := false;
    rows := TList<Tlist<String>>.create;
    if TListViewExtract.GetSelectedRows(fLastControl.Handle, rows) then begin
        found := true;
    end else if TUIAutomation.GetListViewSelectedRows(fLastControl, rows) then begin
        found := true;
    end;
    if found then begin
        for i := 0 to rows.Count-1 do begin
            str := '';
            for j := 0 to rows[i].Count-1 do begin
                Appendx(str, rows[i][j], '  ');
            end;
            appendx(result, str, #13#10);
        end;
        for i := 0 to rows.Count-1 do begin
            sl := rows[i];
            myfree(sl);
        end;
        myfree(rows);
    end;

end;
function TfrmTextContent.ExtractListboxSelected : string;
var sl : TList<string>;
    i : integer;
begin
    sl := TList<string>.create;
    TListBoxExtract.GetSelected(flastControl.Handle, sl);
    for i := 0 to sl.Count-1 do begin
        Appendx(result, sl[i], #13#10);
    end;
    myfree(sl);
end;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmTextContent', false);
end;

end.
