unit UnitFrmTextInspector;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ExtCtrls, Vcl.StdCtrls,
  Winapi.CommCtrl, Vcl.Buttons, UIAutomationClient_TLB,
  UnitTextInspectorData;
type TTextInspectorPosition = procedure(x,y:Integer) of object;
type
  TFrmTextInspector = class(TForm)
    lblWindowCanvas: TLabel;
    pnlBox: TPanel;
    pnlSubRect: TPanel;
    procedure FormShow(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure lblWindowCanvasMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormActivate(Sender: TObject);

    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblWindowCanvasMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pnlSubRectMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure pnlBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
    private
        { Private declarations }
        fMousePoint : TPoint;
        callback : TTextInspectorPosition;
        fLastControl : TTICInfo;
        procedure CreateParams(var Params: TCreateParams); override;
        procedure ShowMousePosition;
        procedure InspectUnderMouse;
//        function GetListViewText(h : THandle; column : integer) : string;
//        function GetListViewColumnCount(h : THandle) : integer;
        function IsButton(h : THandle) : boolean;
        function IsListView(h : THandle) : boolean;
        function IsListBox(h : THandle) : boolean;
        function IsEdit(h : THandle) : boolean;
        function IsComboBox(h : Thandle) : boolean;
        function IsTreeView(h : THandle) : boolean;
        function IsHeader(h : THandle) : boolean;
        procedure HandleMouseClick;
        function IsDebug : boolean;
    public
        { Public declarations }
        procedure SetPositionCallback(proc : TTextInspectorPosition);
        procedure ReportMouse(pt : TPoint);



        property LastControl : TTICInfo read fLastControl;
  end;


var
  FrmTextInspector: TFrmTextInspector;

implementation

{$R *.dfm}

uses UnitMisc, UnitThreadAttach, RichEdit, UnitUIAutomation,
generics.collections, UnitFrmTextInspectorControls, ComObj, UnitFocusManager,
  UnitFrmTextContent, UnitListViewExtract, UnitViewExtract, UnitFrmDebug;




procedure TFrmTextInspector.CreateParams(var Params: TCreateParams);
begin
   	inherited;

    Params.Style := (WS_POPUP and not WS_CAPTION) ;
    Params.ExStyle := {WS_EX_TOOLWINDOW or} WS_EX_TOPMOST;
    Params.WndParent := GetDesktopWindow;
end;
procedure TFrmTextInspector.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    // alt+f4 close event
    self.hide;
    frmTextInspectorControls.btnClose.Click;
end;

procedure TFrmTextInspector.FormDestroy(Sender: TObject);
begin
    FrmDebug.appendlog('UnitFrmTextInspector Destroy', false);
end;

procedure TFrmTextInspector.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if key = VK_ESCAPE then begin
        self.Hide;
        frmTextInspectorControls.btnClose.Click;
    end;
end;

procedure TFrmTextInspector.FormShow(Sender: TObject);
var pt : TPoint;
    m : TMonitor;
begin
    self.WindowState := wsNormal;
    // Virtual Desktop Bounds
    Self.Top := Screen.DesktopTop;
    Self.Height := Screen.DesktopHeight;
    self.Left := Screen.DesktopLeft;
    Self.Width := screen.DesktopWidth;


    if not frmTextInspectorControls.Visible then begin
        frmTextInspectorControls.Top := self.Top;
        frmTextInspectorControls.Left := self.Left + self.Width - frmTextInspectorControls.Width;

        FrmTextInspectorControls.show;
        Winapi.Windows.SetWindowPos(
            self.Handle,  frmTextInspectorControls.Handle, self.left, self.top,0,0,
            SWP_NOSIZE
        );

    end;

    ShowMousePosition;

    Canvas.Brush.Color := clBtnFace;
    canvas.Rectangle(self.ClientRect);

    pnlBox.Visible := false;
    pnlSubRect.Visible := false;

end;
procedure TFrmTextInspector.FormActivate(Sender: TObject);
begin
    pnlBox.Visible := false;
    pnlSubRect.Visible := false;
    if frmTextInspectorControls.WindowState = wsMinimized then begin
        frmTextInspectorControls.WindowState := wsNormal;
    end;
end;


function TFrmTextInspector.IsDebug;
begin
    {$WARN UNIT_PLATFORM off}
    result := (debughook <> 0);
    {$WARN UNIT_PLATFORM on}
end;
//
// mouse movement
//
procedure TFrmTextInspector.ShowMousePosition;
begin
    frmTextInspectorControls.ReportMousePos(Mouse.CursorPos);
end;
procedure TFrmTextInspector.lblWindowCanvasMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
    frmTextInspectorControls.ReportMousePos(point(x,y));
end;
procedure TFrmTextInspector.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
    frmTextInspectorControls.ReportMousePos(point(x,y));
end;

//
// mouse click event
//
procedure TFrmTextInspector.HandleMouseClick;
begin
    if Assigned(callback) then begin
        callback(Mouse.CursorPos.X, Mouse.CursorPos.Y);
    end;
    self.InspectUnderMouse;
end;
procedure TFrmTextInspector.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
    HandleMouseClick;
end;
procedure TFrmTextInspector.lblWindowCanvasMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    HandleMouseClick;
end;
procedure TFrmTextInspector.pnlBoxMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
    HandleMouseClick;
end;

procedure TFrmTextInspector.pnlSubRectMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    HandleMouseClick;
end;

procedure TFrmTextInspector.InspectUnderMouse;
    function getControlHandleAt(pt : TPoint) : Thandle;
    var subpt : TPoint;
        subH : THandle;
    begin
        // WindowFromPoint only drills down so far and stops at certain
        // container classes.
        //
        // RealChildFromPoint takes transparency into account and returns
        // the control behind a transparent point
        //
        result := Winapi.Windows.WindowFromPoint(pt);
        subpt := pt;
        Winapi.Windows.ScreenToClient(result, subpt);
        subH := Winapi.Windows.RealChildWindowFromPoint(result, subpt);
        while (subH <> 0) and (subH <> result) do begin
            result := subH;
            subH := Winapi.Windows.RealChildWindowFromPoint(result, subpt);
        end;
    end;

var pt  : TPoint;
    controlH, parenth  : THandle;
    c : TTICInfo;
    controlClass : string;
    realControlClass : string;
    tempClass1, tempClass2 : string;
    r : TRect;
    sz : long;
    winTitle : string;
    winText : string;
    hasCaret : boolean;
    ownerList : string;
    ta : TThreadAttach;
    alpha : byte;
    multiSelect : boolean;
    function Depth(child, parent : THandle) : integer;
    var h : THandle;
    begin
        h := child;
        result := 0;
        while (Winapi.Windows.GetParent(h) <> parent) and (h <> 0) do begin
            inc(result);
            h := Winapi.Windows.GetParent(h);
        end;
    end;

    procedure ShowContentBox(r : TRect);
    begin
    end;
    procedure ShowBox(r : TRect);
    begin

        pnlBox.Visible := true;
        pnlBox.Top := r.Top;
        pnlBox.Left := r.Left;
        pnlBox.Width := r.Width;
        pnlBox.Height := r.Height;
        pnlBox.Color := clBtnShadow;

        ShowContentBox(r);
    end;
    procedure ShowSubBox;
    begin
        pnlSubRect.Visible := false;
        if c.subrect.Width = 0 then EXIT;


        pnlSubRect.Visible := true;
        pnlSubRect.Top := c.SubRect.Top;
        pnlSubRect.left := c.SubRect.left;
        pnlSubRect.width  := c.SubRect.width;
        pnlSubRect.height := c.SubRect.height;
        pnlSubRect.Color := clWindowText;

        pnlSubRect.BringToFront;


        ShowContentBox(c.SubRect);
    end;

    function getDeepestChild(parent : THandle; el : TList<Thandle>) : THandle;
    var i, lowest : integer;
        h : THandle;
    begin
        result := 0;

        lowest := 0;
        for h in el do begin
            if lowest = 0 then begin
                lowest := Depth(h, parent);
                result := h;
            end else begin
                i := Depth(h, parent);
                if (i < lowest) then begin
                    lowest := i;
                    result := h;
                end;
            end;
        end;
    end;
    procedure DetectControlType(c : TTICInfo; h : THandle);
    begin
        if IsButton(h) then begin
            c.ControlType := tctButton;
        end else if IsListView(h) then begin
            c.ControlType := tctListView;
        end else if IsComboBox(h) then begin
            c.ControlType := tctComboBox;
        end else if IsEdit(h) then begin
            c.ControlType := tctEdit;
        end else if IsListBox(h) then begin
            c.ControlType := tctListBox;
        end else if IsHeader(h) then begin
            c.ControlType := tctHeader;
        end else if IsTreeView(h) then begin
            c.ControlType := tctTreeView;
        end else begin
            c.ControlType := tctUnknown;
        end;
    end;
    procedure ShowContent(r : TRect; s : string);
    var i : integer;
        header : TTICInfo;
    begin
        frmTextContent.ShowContent(r, s);

        case c.ControlType of
        tctUnknown:
            begin
                case c.UIA.CType of
                UIA_UNKNOWN:
                    begin
                        frmTextContent.SetContext(c.ControlType, multiSelect);
                    end;
                UIA_TreeItemControlTypeId:
                    begin
                        frmTextContent.SetContext(tctTreeView);
                    end;
                UIA_HeaderControlTypeId,
                UIA_HeaderItemControlTypeId:
                    begin
                        frmTextContent.SetContext(tctHeader);
                    end;
                UIA_ListControlTypeId,
                UIA_ListItemControlTypeId:
                    begin
                        frmTextContent.SetContext(tctListBox);
                    end;
                else
                    begin
                        case c.UIA.ParentCType of
                        UIA_HeaderControlTypeId:
                            begin
                                i := -1;
                                TUIAutomation.GetAssociatedListView(c, header);
                                TUIAutomation.GetListViewSelectedCount(header, i);
                                multiSelect := i > 1;
                                myfree(header);

                                frmTextContent.SetContext(tctHeader, multiSelect);
                            end;
                        UIA_ListItemControlTypeId:
                            frmTextContent.SetContext(tctListView, multiSelect);
                        else
                            begin
                                if TUIAutomation.isActuallyHeaderItem(c) then begin
                                    frmTextContent.SetContext(tctHeader);
                                end else begin
                                    frmTextContent.SetContext(c.ControlType, multiSelect);
                                end;
                            end;
                        end;
                    end;
                end;
            end;
        else
            begin
                frmTextContent.SetContext(c.ControlType, MultiSelect);
            end;
        end;

    end;
    procedure ExtractAutomationInfo;
    var
        b : boolean;
        i : integer;
    begin
        // Automation ElementFromPoint doesn't ignore transparent windows
        self.Visible := false;
        b := TUIAutomation.FindControl(c);
        self.Visible := true;

        if b then TUIAutomation.InspectControl(c);
        case c.uia.ParentCType of
        UIA_ListControlTypeId,
        UIA_ListItemControlTypeId:
            begin
                TUIAutomation.GetListViewSelectedCount(c, i);
                multiSelect := i > 1;
            end;
        end;
    end;
    procedure ExtractFromListView;
    var tl : TList<string>;
        s, controlText : string;
        i : integer;
    begin

        tl := TList<string>.create;
        if not TListViewExtract.GetText(
            c.Handle,
            c.MousePoint,
            c.SubRect,
            tl
        ) then begin
            TUIAutomation.InspectControl(c);
            TUIAutomation.GetListViewSelectedCount(c, i);
            multiSelect := i > 1;
        end else begin
            multiSelect := TListViewExtract.GetSelectedCount(c.handle) > 0;
            for s in tl do begin
                if s <> '' then begin
                    if controltext <> '' then begin
                        controltext := controltext + '  ';
                    end;
                    controltext := controltext + s;
                end;
            end;
            c.WindowText := controltext;
        end;

        FreeAndNil(tl);
    end;
    procedure ExtractFromListBox;
    var rowText : string;
        row : integer;
        cnt : integer;
    begin
        TListBoxExtract.GetRow(c.Handle, c.MousePoint, row);
        TListBoxExtract.GetText(c.Handle, row, c.WindowText, c.subrect);

        TListBoxExtract.GetSelectedCount(c.Handle, cnt);
        multiSelect := cnt > 1;
        //self.GetListBoxText(c.handle, c.SubRect);
        frmTextInspectorControls.AddInfo('ListBox: ' + rowText );
    end;
    procedure ExtractFromHeader;
    var idx : integer;
        parentH : THandle;
    begin
        c.WindowText := THeaderExtract.GetText(
            c.Handle, c.MousePoint, c.subrect
        );

        parentH := Winapi.Windows.GetParent(c.Handle);
        multiSelect := TListViewExtract.GetListViewRowCount(parentH) > 0;
    end;
    procedure ExtractFromTreeView;
    begin
        if not TTreeViewExtract.GetText(c.Handle, c.MousePoint, c.WindowText) then begin

        end;
    end;

begin
    alpha := self.AlphaBlendValue;
    pnlSubRect.Visible := false;

    pt.X := Mouse.CursorPos.X;
    pt.Y := Mouse.CursorPos.Y;
    fMousePoint := Mouse.CursorPos;

    self.AlphaBlendValue := 0;
    controlH := getControlHandleAt(pt);

    if not IsDebug then begin
        self.AlphaBlendValue := alpha;
    end;

    controlClass := HandleToClassname(controlH);

    c := TTICInfo.Create;
    if assigned(fLastControl) then MyFree(fLastControl);
    fLastControl := c;
    c.SubRect.Width := 0;
    c.SubRect.Height := 0;
    c.Handle := controlH;
    c.MousePoint := pt;

    Winapi.Windows.GetWindowRect(controlH, r);
    c.WindowRect := r;



    parenth := controlH;
    while Winapi.Windows.GetParent(parenth) <> 0 do begin

        tempClass1 := HandleToClassname(parentH);
        tempClass2 := HandleToClassname(parentH, true);
        if (tempClass1 <> tempClass2) then begin
            tempClass1 := TempClass1 +'('+tempClass2+')';
        end;
        c.OwnerList.Add( TOwnerInfo.Create(parentH, tempClass1) );
        if ownerlist <> '' then begin
            OwnerList :=  ' > ' + Ownerlist;
        end;
        OwnerList := tempClass1 + OwnerList;
        parenth := Winapi.Windows.GetParent(parenth);
    end;
    if ownerlist <> '' then begin
        OwnerList :=  ' > ' + Ownerlist;
    end;
    OwnerList := HandleToClassname(parentH) + OwnerList;
    c.RootParent := parentH;

    c.ParentEXE := UnitMisc.WindowHandleToEXEName(parenth);


    realControlClass := HandleToClassname(controlH, true);
    c.ClassName := controlClass;
    c.RealClassName := realControlClass;

    sz := GetWindowTextLength(parentH);
    if (sz <> 0) then  begin
        inc(sz, 1); // don't ask

        SetLength(winTitle, sz);
        GetWindowText(parentH, PChar(winTitle), sz);
    end;


    sz := Winapi.Windows.SendMessage(controlH, WM_GETTEXTLENGTH, 0, 0);
    if (sz <> 0) then begin
        inc(sz);
        SetLength(winText, sz);
        Winapi.Windows.SendMessage(controlH, WM_GETTEXT, sz, LPARAM(pchar(winText)));

        c.WindowText := winText;

        ta := TThreadAttach.Create(controlH);
        if ta.IsAttached then begin
            hasCaret := GetCaretPos(pt);
            if hasCaret then begin
                winText := 'Caret: '+ winText;
            end;
            ta.Detach;
        end;
        FreeAndNil(ta);
    end;

    DetectControlType(c, controlH);
    if (c.ControlType = tctTreeView) or (c.ControlType = tctComboBox) then begin
        ExtractAutomationInfo;
    end;
    if (c.ControlType = tctUnknown) or (c.WindowText = '') then begin
        c.WindowRect := TRect.Empty;
        ExtractAutomationInfo;
        if (c.WindowText = '') and (c.UIA.Handle <> 0) then begin
            if c.UIA.Handle <> c.Handle then begin
                // TODO - find a case to trigger this method
                sz := GetWindowTextLength(c.UIA.Handle);
                if (sz <> 0) then  begin
                    inc(sz, 1);

                    SetLength(c.WindowText, sz);
                    GetWindowText(parentH, PChar(c.WindowText), sz);
                end;
            end;
        end;
    end;

    frmTextInspectorControls.ClearInfo;
    frmTextInspectorControls.AddInfo('Classes: '+ownerlist);
    frmTextInspectorControls.AddInfo('Program: '+c.ParentEXE );
    frmTextInspectorControls.AddInfo('Program Title: '+winTitle);
    frmTextInspectorControls.ReportControl(c);

    case fLastControl.ControlType of
    tctUnknown:
        begin

        end;
    tctEdit:
        begin
        end;
    tctListView:
        begin
            ExtractFromListView;
        end;
    tctListBox:
        begin
            ExtractFromListBox
        end;
    tctButton:
        begin
        end;
    tctComboBox:
        begin
        end;
    tctTreeView:
        begin
            ExtractFromTreeView;
        end;
    tctHeader:
        begin
            ExtractFromHeader;
        end;
    end;

    if c.subRect.Width <> 0 then begin
        ShowContent(c.SubRect, c.WindowText);
    end else begin
        ShowContent(c.WindowRect, c.WindowText);
    end;


    ShowBox(c.WindowRect);
    ShowSubBox;
    if IsDebug then begin
        //self.AlphaBlendValue := alpha;
    end;
end;


procedure TFrmTextInspector.SetPositionCallback(proc : TTextInspectorPosition);
begin
    callback := proc;
end;
procedure TFrmTextInspector.ReportMouse(pt : TPoint);
begin
    pt := ScreenToClient(pt);

    if pt <> canvas.PenPos then begin
        Canvas.MoveTo(Canvas.PenPos.X, Canvas.PenPos.y);
        Canvas.LineTo(pt.X, pt.y);
    end;

    Canvas.Pixels[pt.X, pt.Y] := clBlack;
end;

function TFrmTextInspector.IsButton(h : THandle) : boolean;
var i : integer;
begin
    i := Winapi.Windows.SendMessage(h, BM_GETSTATE, 0, 0);
    result := i > 0;
end;
function TFrmTextInspector.IsListView(h : THandle) : boolean;
var s : string;
    i : integer;
begin
    i := Winapi.Windows.SendMessage(h, LVM_GETITEMCOUNT, 0, 0);
    result := i > 0;

    s := SysErrorMessage(GetLastError());
    if result then EXIT;

    i := SendMessage(h, LVM_GETTEXTCOLOR , 0, 0);
    result := i <> 0;
    if result then EXIT;

    i := SendMessage(h, LVM_GETEXTENDEDLISTVIEWSTYLE , 0, 0);
    result := i <> 0;

end;
function TFrmTextInspector.IsListBox(h : THandle) : boolean;
begin
    result := Winapi.Windows.SendMessage(h, LB_GETCOUNT, 0,0)
        > 0;
end;
function TFrmTextInspector.IsEdit(h : THandle) : boolean;
begin
    result := Winapi.Windows.SendMessage(h, EM_GETLINECOUNT , 0,0)
        > 0;
end;
function TFrmTextInspector.IsComboBox(h : Thandle) : boolean;
var sz : integer;
    s : string;
begin
    result := false;
    if IsEdit(h) then begin
        h := GetParent(h);
        if h = 0 then EXIT;
        s := HandleToClassname(h);
        sz := Winapi.Windows.SendMessage(h, CB_GETCOUNT, 0,0);
        result := sz > 0;
    end else begin
        sz := Winapi.Windows.SendMessage(h, CB_GETCOUNT, 0,0);
        result := sz > 0;
    end;
end;
function TFrmTextInspector.IsTreeView(h : THandle) : boolean;
begin
    result := Winapi.Windows.SendMessage(h, TVM_GETCOUNT , 0,0)
        > 0;
end;
function TFrmTextInspector.IsHeader(h : THandle) : boolean;
begin
    result := Winapi.Windows.SendMessage(h, HDM_GETITEMCOUNT, 0, 0)
        > 0;
end;




initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmTextInspector', false);
end;

end.
