unit UnitFrmTextInspectorControls;

interface

uses
  Winapi.Windows, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ExtCtrls,
  Generics.Collections, UnitUIAutomation, UnitTextInspectorData, System.Math,
  Vcl.ComCtrls;




type
  TfrmTextInspectorControls = class(TForm)
    pnlInfo: TPanel;
    txtInfo: TMemo;
    pnl1: TPanel;
    btnClose: TButton;
    btnMinimize: TButton;
    lblMousePos: TLabel;
    Label1: TLabel;
    txtControl: TEdit;
    pcDetails: TPageControl;
    tsInfo: TTabSheet;
    tsJavaScript: TTabSheet;
    reScript: TRichEdit;
    cbxFunction: TComboBox;
    procedure btnCloseClick(Sender: TObject);
    procedure btnMinimizeClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cbxFunctionChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbxFunctionClick(Sender: TObject);
  private
    { Private declarations }
    fLastControl : TTICInfo;
    //fMousePoint : TPoint;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure RefreshScript;
  public
    { Public declarations }
    procedure ReportMousePos(pt : TPoint);
    procedure SetControlName(name : String);

    procedure ClearInfo;
    procedure AddInfo(s : string);

    procedure ReportControl( c : TTICInfo);
  end;

var
  frmTextInspectorControls: TfrmTextInspectorControls;

implementation

{$R *.dfm}

uses UnitFrmTextInspector, Winapi.CommCtrl, Winapi.Messages,
    UnitListViewExtract, UIAutomationClient_TLB,  Generics.Defaults,
  UnitMisc, UnitFrmTextContent, UnitFocusManager, Unit64BitDetect,
  UnitMouseScaler, UnitViewExtract,
  StrUtils, UnitFrmDebug;


const
    IDX_CLICK_IN_WINDOW = 0;
    IDX_FOCUS_CONTROL = 1;


procedure TfrmTextInspectorControls.ReportControl( c : TTICInfo);
var
    pair : TOwnerInfo;
begin
    fLastControl := c;

//    cbxFunction.ItemIndex := IDX_CLICK_IN_WINDOW;
    RefreshScript;

    if c.UIA.CType = UIA_UNKNOWN then begin
        txtControl.Text := 'Control: ' + fLastControl.ClassName +
        '('+ fLastControl.ToString(fLastControl.ControlType) +')';
    end else begin
        if trim(c.UIA.Classname) = '' then begin
            txtControl.Text := 'Control: ' + fLastControl.ClassName

        end else begin
            txtControl.Text := 'Control: ' + fLastControl.UIA.Classname
        end;
        txtControl.Text := txtControl.Text + '('+ fLastControl.ToString(fLastControl.UIA.CType) +')';
    end;

    pair := TOwnerInfo.Create(0,'#32770');
    if fLastControl.OwnerList.IndexOf(pair) <> -1 then begin
        // is dialog
    end;

    self.AddInfo('UIA Type: ' +  c.ToString(c.UIA.CType));
end;


procedure TfrmTextInspectorControls.ReportMousePos(pt : TPoint);
begin
    lblMousePos.Caption := 'Current ('+IntToStr(pt.x)+','
    +IntToStr(pt.y)+')';
end;
procedure TfrmTextInspectorControls.SetControlName(name : String);
begin
    txtControl.text := 'Control: ' + name;
end;
procedure TfrmTextInspectorControls.ClearInfo;
begin
    txtInfo.clear;
end;
procedure TfrmTextInspectorControls.AddInfo(s : string);
begin
    txtInfo.lines.add(s);
end;


procedure TfrmTextInspectorControls.CreateParams(var Params: TCreateParams);
begin
   	inherited;

    Params.Style := (WS_POPUP or WS_CAPTION) or WS_EX_APPWINDOW;
    Params.ExStyle := {WS_EX_TOOLWINDOW or} WS_EX_TOPMOST;
    Params.WndParent := FrmTextInspector.Handle;
end;
procedure TfrmTextInspectorControls.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    btnClose.Click;
end;

procedure TfrmTextInspectorControls.FormCreate(Sender: TObject);
begin
    pcDetails.ActivePageIndex := 0;
end;

procedure TfrmTextInspectorControls.FormDestroy(Sender: TObject);
begin
    FrmDebug.AppendLog('UnitFrmTextInspectorControls Destroy', false);
    if assigned(fLastControl) then FreeAndNil(fLastControl);
end;
procedure TfrmTextInspectorControls.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if key = VK_ESCAPE then begin
        btnClose.Click;
    end;
    {$WARN UNIT_PLATFORM off}
    if (DebugHook <> 0) then begin
    {$WARN UNIT_PLATFORM on}
        if key = ord('T') then begin
            FrmTextInspector.AlphaBlendValue := 150;
        end;
    end;
end;

procedure TfrmTextInspectorControls.btnCloseClick(Sender: TObject);
begin
    FrmTextInspector.Hide;
    FrmTextContent.Visible := false;
    Self.Hide;

    cbxFunction.ItemIndex := IDX_CLICK_IN_WINDOW;
    pcDetails.ActivePageIndex := 0;
end;
procedure TfrmTextInspectorControls.btnMinimizeClick(Sender: TObject);
begin
    //Winapi.Windows.SetParent(self.Handle, GetDesktopWindow);
    self.WindowState := wsMinimized;
    FrmTextInspector.WindowState := wsMinimized;
    ShowWindow(FrmTextContent.Handle, SW_HIDE);
end;



procedure TfrmTextInspectorControls.cbxFunctionChange(Sender: TObject);
begin
    RefreshScript;
end;

procedure TfrmTextInspectorControls.cbxFunctionClick(Sender: TObject);
begin
    reScript.SetFocus;
end;

procedure TfrmTextInspectorControls.RefreshScript;
var
    s, path : string;
    classname : string;
    clientPT : TPoint;
begin
    reScript.Clear;
    if not assigned(fLastControl) then EXIT;

    case cbxFunction.ItemIndex of
    IDX_CLICK_IN_WINDOW:
        begin
            s := 'clickInWindow("%W",%X,%Y);';
            classname := HandleToClassname(flastControl.RootParent);
            if classname = '' then begin
                reScript.Text := 'Error: Cannot get classname for parent window.';
                EXIT;
            end;
            clientPT := fLastControl.MousePoint;
            Winapi.Windows.ScreenToClient(flastControl.RootParent, clientPT);

            s := ReplaceStr(s,'%W', classname);
            s := ReplaceStr(s, '%X', IntToSTr(clientPT.X));
            s := ReplaceStr(s, '%Y', IntToSTr(clientPT.Y));

            reScript.Text := s;
            reScript.SelectAll;
        end;
    IDX_FOCUS_CONTROL:
        begin
            if not fLastControl.UIA.IsFocusable then begin
                reScript.Text := 'Error: Cannot focus this control.';
                EXIT;
            end;

            path := TUIAutomation.GetFullPathName( fLastControl.Handle);

            s := 'focusControlByPath("%P");';
            s := ReplaceStr(s, '%P', path);


            reScript.Text := s;
            reScript.SelectAll;
        end;
    end;
end;


initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitFrmTextInspectorControls', false);
end;

end.
