unit UnitLoadClip;

interface

type TLoadClip = class(TObject)
    class function fromFile(const filename : string) : boolean;
end;

implementation

uses Windows, Graphics, Classes, UnitMisc, SysUtils,
System.IOUtils, Vcl.Imaging.pngimage, Vcl.Imaging.jpeg, Forms,
UnitFrmDebug, UnitMyClipboard;

class function TLoadClip.fromFile(const filename : string) : boolean;
var ext : string;
    ms : TMemoryStream;
    fs : TFileStream;
    frmt : cardinal;

    s : string;
    h : THandle;



    APalette : HPALETTE;
    function GetFilestream : TFileStream;
    begin
        result := TFileStream.Create(filename, fmOpenRead);
    end;
    procedure HandleGraphic(g : TGraphic);
    var wd : word;
    begin
        g.LoadFromStream(fs);
        g.SaveToClipboardFormat(wd, h, APalette);
        frmt := wd;
        g.Free;
        myfree(fs);
    end;
begin
    ms := TMemoryStream.Create;
    fs := GetFilestream;
    try
        ext := ExtractFileExt(filename);
        h := 0;
        result := true;
        if (ext = '.txt') then begin
            frmt := CF_UNICODETEXT;
            MyFree(fs);
            s := TFile.readalltext(filename) + #0;
            h := UnitMisc.DupPointerToHandle(@s[1], length(s) * SizeOf(Char) );
        end else if (ext = '.rtf') then begin
            frmt := UnitMisc.GetCF_RICHTEXT;
            ms.CopyFrom(fs, 0);
            MyFree(fs);
        end else if (ext = '.bmp') then begin
            HandleGraphic(TBitmap.Create);
        end else if (ext = '.png') then begin
            HandleGraphic(TPngImage.Create);
        end else if (ext = '.jpg') or (ext = '.jpeg') then begin
            HandleGraphic(TJPEGImage.Create);
        end else begin
            result := false;
        end;
        ms.Position := 0;
        if (result = true) and TMyClipboard.OpenClipboard(Application.Handle, 'fromFile') then begin
            Windows.EmptyClipboard;
            FrmDebug.AppendLog('SetClipboardData',true);
            if h = 0 then begin
                h := unitMisc.DupStreamToHandle(ms);
            end;
            Windows.SetClipboardData(frmt, h);
            FrmDebug.AppendLog('SetClipboardData',true);
            TMyClipboard.CloseClipboard;
        end;
    finally
        if fs <> nil then fs.Free;
        ms.Free;
    end;

end;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitLoadClip', false);
end;

end.
