unit UnitMiscCom;

interface

uses Windows, ActiveX;

const
    CLSID_CustomDestinationList_string = '{6332debf-87b5-4670-90c0-5e57b408a49e}';
    CLSID_CustomDestinationList: TGUID = '{77f10cf0-3db5-4966-b520-b7c54fd35ed6}';
    // NOTE: The abstract and instance are supposed to be different

    IID_IObjectArray_string  = '{92CA9DCD-5622-4BBA-A805-5E9F541BD8C9}';
    IID_IObjectArray: TGUID  = IID_IObjectArray_string;
    SID_IPropertyStore = '{886d8eeb-8cf2-4446-8d02-cdba1dbdcf99}';

const
  KDC_FREQUENT = $01;
  KDC_RECENT = $02;

type
  IObjectArray = interface
     [IID_IObjectArray_string]
     function GetCount(): UInt; safecall;
     function GetAt(uiIndex: UInt; riid: PGUID): IUnknown; safecall;
  end;

type
  ICustomDestinationList = interface
    [CLSID_CustomDestinationList_string]
    procedure SetAppID(pszAppID: LPWSTR); safecall;
    function BeginList(out pcMaxSlots: UINT; riid: PGUID): IObjectArray; safecall;
    procedure AppendCategory(pszCategory: LPWSTR; poa: IObjectArray); safecall;
    procedure AppendKnownCategory(Category: Integer); safecall;
    procedure AddUserTasks(poa: IUnknown); safecall;
    procedure CommitList(); safecall;
    function GetRemovedDestinations(riid: PGUID): IUnknown; safecall;
    procedure DeleteList(pszAppID:LPWSTR); safecall;
    procedure AbortList(); safecall;
  end;

  _tagpropertykey = packed record
    fmtid: TGUID;
    pid: DWORD;
  end;
  TPropertyKey = _tagpropertykey;


  IPropertyStore = interface(IUnknown)
    [SID_IPropertyStore]
    function GetCount(out cProps: DWORD): HResult; stdcall;
    function GetAt(iProp: DWORD; out pkey: TPropertyKey): HResult; stdcall;
    function GetValue(const key: TPropertyKey; out pv: TPropVariant): HResult; stdcall;
    function SetValue(const key: TPropertyKey; const propvar: TPropVariant): HResult; stdcall;
    function Commit: HResult; stdcall;
  end;



implementation

uses
    UnitFrmDebug;

initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitMiscCom', false);
end;

end.
