unit UnitMouseScaler;
{

For some reason, controls in a 64 bit process aren't using the desktop
scaling routines for their Windows Messages.

}
interface

uses System.Types;

type TMouseScaler = class(TObject)
    public
        class function ScalePoint(pt : TPoint; toNative : boolean = true) : TPoint;
end;
implementation

uses Winapi.Windows, Forms, UnitFrmDebug;

class function TMouseScaler.ScalePoint(pt : TPoint; toNative : boolean = true) : TPoint;
var dc : THandle;
    wd, ht : integer;
    dx, dy : double;
begin
    // turn the point into a percent based on context
    // transform that percent into a new context

    dc := GetDC(0);
    wd := GetDeviceCaps(dc, DESKTOPHORZRES);
    ht := GetDeviceCaps(dc, DESKTOPVERTRES);

    result := pt;
    if (wd <> screen.DesktopWidth) or (ht <> screen.DesktopHeight) then begin
        if (toNative) then begin
            dx := pt.X / screen.DesktopWidth;
            dy := pt.Y / screen.DesktopHeight;
            result.X := round(wd * dx);
            result.Y := round(ht * dy);
        end else begin
            dx := pt.X / wd;
            dy := pt.Y / ht;
            result.X := round(screen.DesktopWidth * dx);
            result.Y := round(screen.DesktopHeight * dy);
        end;
    end;
end;


initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitMouseScaler', false);
end;

end.
