unit UnitMyClipboard;

interface

type TMyClipboard = class(TObject)
    private
    class var fOpenCount : Integer;
    class var fLastProc : string;
    public
      class function OpenClipboard( Handle : THandle; lastProc : string) : boolean; overload;
      class function OpenClipboard( Handle : THandle; lastProc : string; retryTimeMS : integer) : boolean; overload;
      class procedure CloseClipboard;
end;

implementation


uses UnitFrmDebug, Winapi.Windows, SysUtils;

class function TMyClipboard.OpenClipboard( Handle : THandle; lastProc : string; retryTimeMS : integer) : boolean;
var i  : integer;
const sleep_ms = 50;
begin
    i := 0;
    result := false;
    while (i*sleep_ms) < retryTImeMS do begin
        result := TMyClipboard.OpenClipboard(handle, lastProc);
        if result then BREAK;
        inc(i);
    end;
end;

class function TMyClipboard.OpenClipboard(Handle : THandle; lastProc : string) : boolean;
var err : boolean;
begin
    err := fOpenCOunt <> 0;
    result := false;

    if not err then begin
        result := Winapi.Windows.OpenClipboard(Handle);
        if result then begin
            inc(fOpenCount);
        end;
    end else begin
        raise  Exception.Create('Clipboard already open');
    end;

    if not Result then begin
        FrmDebug.AppendLog('OpenClipboard: Failed for '+fLastProc, true);
    end else begin
        fLastProc := lastproc;
    end;
end;
class procedure TMyClipboard.CloseClipboard;
begin
    if (fopencount = 0) then begin
        FrmDebug.AppendLog('CloseClipboard: clipboard not open');
        EXIT;
    end;

    Dec(fopencount);
    Winapi.Windows.CloseClipboard();
end;


initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitMyClipboard', false);
end;

end.
