unit UnitMyCursor;

interface
    const
        crMyCursor = 5; // system cursors are <= 0
    procedure CreateCustomCursor;

implementation

uses VCL.Forms, VCL.Controls, Windows, Graphics, UnitPopupGenerate, Classes,
UnitMisc, SysUtils, UnitFrmDebug;


var BM, BMMASK : TBitmap;

procedure CreateCustomCursor;
var
    Info : _ICONINFO;
    ico : TIcon;
    bm2, bmx : TBitmap;
    x,y : integer;
    bmshadow : TBitmap;
const
    DEBUGIT = FALSE;
    XOFFSET = 2;
    YOFFSET = 0;
    procedure SaveIt(bm : TBitmap; filename : string);
    begin
        if DEBUGIT then
            bm.SaveToFile(filename);
    end;
begin
    bm := TBitmap.create;
    bm.Canvas.Lock;
    bm.Width := 32;
    bm.Height := 32;
    bm.PixelFormat := pf32bit;
    bm.Canvas.Brush.color := clNone;
    bm.Canvas.FillRect(bm.Canvas.ClipRect);

    ico := TIcon.Create;
    ico.Handle := screen.Cursors[crArrow];
    bm.Canvas.Draw(0,0,ico);
    SaveIt(bm,'bmicon.bmp');


    bmmask := ToMask(bm);
    bmmask.Canvas.Lock;

    bm2 := TBitmap.Create;
    bm2.Monochrome := true;
    bm2.Width := bm.Width;
    bm2.Height := bm.Height;
    bm2.Canvas.CopyRect(bmmask.Canvas.ClipRect,bmmask.Canvas,bmmask.Canvas.ClipRect);

    bmmask.Canvas.CopyMode := cmSrcAnd; // boolean OR
    bmmask.Canvas.CopyRect(rect(0+XOFFSET,0+YOFFSET,32+XOFFSET,32+YOFFSET), bm2.Canvas,rect(0,0,32,32));
    bmmask.Canvas.CopyRect(rect(0,0+1,32,32+1), bm2.Canvas,rect(0,0,32,32));
    saveit(bmmask,'bmmask.bmp');

    bmshadow := TBitmap.Create;
    bmshadow.Monochrome := true;
    bmshadow.Assign(bm2);
    bmshadow.Canvas.CopyMode := cmSrcInvert;
    bmshadow.Canvas.CopyRect(bmmask.Canvas.ClipRect,bmmask.Canvas,bmmask.Canvas.ClipRect);
    SaveIt(bmshadow,'bmshadowmask.bmp');

    UnitMisc.addshadow(bm, bmmask, bmshadow);
    with frmMainPopup.imgClipPaste.Picture do begin
        myfree(bm2);
        bm2 := Convert32bit(bitmap);
        bm.Canvas.Draw(12,13, bm2);
    end;

    saveit(bm,'bmshadow.bmp');

    GetIconInfo(screen.Cursors[crArrow],info);
    info.fIcon := false;
    info.hbmMask := bmmask.Handle;
    info.hbmColor := bm.Handle;

    screen.Cursors[crMyCursor] := CreateIconIndirect(info);


    FreeAndNil(info);
    FreeAndNil(bm2);
    FreeAndNil(bmshadow);
    FreeAndNil(ico);

    // bmmask/bm no free?
    // TODO: reread about CreatIconIndirect and see it Windows
    // now owns the handles
end;


initialization
begin

end;

finalization
begin
    TFrmDebug.MeOnlyAppend('UnitMyCursor', false);

    if not assigned(bm) then EXIT;

    //CreateIconIndirect requires us to manage the bitmaps used
    // to create an icon

    bm.Canvas.Unlock;
    bmmask.Canvas.Unlock;

    myfree(bm);
    myfree(bmmask);

    DestroyIcon(screen.Cursors[crMyCursor]);
end;



end.
