unit UnitOnlineScript;

interface

uses System.Generics.Collections;

type TOnlineScript = class(TObject)
    public
        name, description, code : string
end;
type TOnlineScriptType =
    (OST_CLIPMENU=1, OST_MACRO=0);
type TOnlineScriptList = TList<TonlineScript>;
type TOnlineScriptReader = class(TObject)
    class function getScripts(ost : TOnlineScriptType) : TOnlineScriptList;
end;
implementation

uses Vcl.ExtActns, UnitMisc, System.Classes, Dialogs, System.SysUtils, UnitToken,
System.IOUtils, UnitFrmDebug;

class function TOnlineScriptReader.getScripts(ost : TOnlineScriptType): TOnlineScriptList;
var
    du : TDownloadURL;
    //sl : TStringList;
    i : integer;
    os : TOnlineScript;
    s : string;
    varname, vardata : string;

    function getTouple(var s : string; var varname : string; var vardata : string) : boolean;
    begin
        result := false;
        varname := TokenString(s,'="');
        if varname = '' then Exit;
        vardata := TokenString(s,'";');
        Result := true;
    end;
begin
    du := TDownLoadURL.Create(nil);
    du.URL := 'http://joejoesoft.com/cms/ac_scripts.php?page_id=' + IntToStr(Integer(ost));
    du.Filename := GetAppPath + 'scripts.txt';
    result := TOnlineScriptList.Create;
    try
        du.ExecuteTarget(nil);
        s := TFile.ReadAllText(du.Filename);


        i := 0;
        repeat
            if not getTouple(s, varname, vardata) then BREAK;
            os := TOnlineScript.Create;
            os.name := vardata;
            getTouple(s, varname, vardata);
            os.description := vardata;
            getTouple(s, varname, vardata);
            os.code := vardata;
            result.Add(os);
            Inc(i);
        until false;
    except
        ShowMessage('Unable to contact website');
    end;
    du.Free;
end;


initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitOnlineScript', false);
end;

end.
