unit UnitReportError;
{
    Purpose:
        Show and allow the user to report an error to my website

    Updates:
        Ability to send error report has been removed
        Include ArsClip version in data string
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFrmReportError = class(TForm)
    Button1: TButton;
    GroupBox2: TGroupBox;
    lblProgram: TLabel;
    lblDesc: TLabel;
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowForm( ProblemProgram : string);
  end;

var
  FrmReportError: TFrmReportError;

implementation
uses ShellAPI, StrUtils, UnitFrmDebug;
{$R *.dfm}

{ TFrmReportError }

procedure TFrmReportError.ShowForm(ProblemProgram : string);
begin
    lblProgram.caption := stringreplace(lblProgram.caption, '%s', ProblemProgram,[rfReplaceAll, rfIgnoreCase]);
    if not self.showing then begin
        self.ShowModal;
    end;
    Windows.SetForegroundWindow(self.Handle); 
end;

procedure TFrmReportError.FormDestroy(Sender: TObject);
begin
    FrmDebug.appendlog('UnitReportError Destroy', false);
end;

procedure TFrmReportError.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     if (KEY = VK_ESCAPE) then begin
        self.Button1.Click;
     end;
end;


initialization
finalization
begin
    FrmDebug.AppendLog('UnitReportError', false);
end;

end.
