unit UnitRichTextUpdate;

//
// https://docs.microsoft.com/en-us/windows/win32/controls/about-rich-edit-controls
//
// intercepter class - loads the WinXP SP1 version
//

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, RichEdit;

type
  TRichEdit = class(ComCtrls.TRichEdit)
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  end;

implementation

uses
    UnitFrmDebug;


var
  FRichEditModule: THandle;

{ TRichEdit }

procedure TRichEdit.CreateParams(var Params: TCreateParams);
const
  RichEditClassName = 'RICHEDIT50W';
  RichEditModuleName = 'MSFTEDIT.DLL';
//  HideScrollBarsStyle: array[Boolean] of DWORD = (ES_DISABLENOSCROLL, 0);
//  HideSelectionsStyle: array[Boolean] of DWORD = (ES_NOHIDESEL, 0);
begin
    if FRichEditModule = 0 then begin
        FRichEditModule := LoadLibrary(RichEditModuleName);
        if FRichEditModule <= HINSTANCE_ERROR then
          FRichEditModule := 0;
    end;

    inherited CreateParams(Params);

    CreateSubClass(Params, RichEditClassName);
//    Params.Style := Params.Style or HideScrollBarsStyle[HideScrollBars] or
//    HideSelectionsStyle[HideSelection];

//    Params.WindowClass.style := Params.WindowClass.style
//        and not (CS_HREDRAW or CS_VREDRAW);
end;

initialization

finalization
begin
    TFrmDebug.MeOnlyAppend('UnitRichTextUpdate', false);
  if FRichEditModule <> 0 then
    FreeLibrary(FRichEditModule);
end;

end.
