unit UnitSound;

///
/// Notes: Using the registry has been depricated. This unit will now automatically
/// delete any registry settings made by previous versions.
///

{///////////////}
{//}interface{//}
{///////////////}
procedure PlaySound_NewClipboardItem;
//procedure PlaySound_Init;
//procedure PlaySound_Remove;
//procedure PlaySound_SetWavefile(fullname : string);
procedure PlaySound_PlayFile(fullname : string);
{////////////////////}
{//}implementation{//}
{////////////////////}

uses Registry, Windows, MMSystem, UnitFrmConfig, UnitFrmDebug;

var r : TRegistry;

const AC_APPNAME = 'ArsClip';
const AC_NEWCLIPBOARDITEM = AC_APPNAME + '_NewClipboardItem';
const AC_NEWCLIPBOARDITEM_VALUE = 'New Clipboard Item';


procedure PlaySound_PlayFile(fullname : string);
begin

    //MMSystem.sndPlaySound(pchar(fullname), SND_FILENAME and SND_ASYNC);
    MMSystem.sndPlaySound(pchar(fullname), SND_ASYNC);
end;

procedure PlaySound_NewClipboardItem();
begin
    PlaySound_PlayFile(frmConfig.GetNewClipWav);

{    MMSystem.PlaySound(
        AC_NEWCLIPBOARDITEM,
        0,
        SND_APPLICATION or SND_ASYNC or SND_NODEFAULT
    );
}    
end;

///
/// Older unused functions for playing sounds using event names
///


procedure SetAppEventKey(key, name, value : string; cancreate : boolean = false; expanded : boolean = false);
var s : string;
begin
    r.RootKey := HKEY_CURRENT_USER;
    s := '\AppEvents\';

    s := s + key;

    if (r.OpenKey(s, cancreate)) then begin
        if (expanded) then begin
            r.WriteExpandString(name, value);
        end else begin
            r.WriteString(name, value);
        end;
        r.CloseKey;
    end;
end;

procedure PlaySound_Init;
begin
    if FrmConfig.cbEnableSound.Checked then begin

        SetAppEventKey('EventLabels\' + AC_NEWCLIPBOARDITEM, '', AC_NEWCLIPBOARDITEM_VALUE , true);
        SetAppEventKey('Schemes\Apps\' + AC_APPNAME, '', AC_APPNAME, true);
        SetAppEventKey('Schemes\Apps\' + AC_APPNAME +'\' + AC_NEWCLIPBOARDITEM, '', AC_NEWCLIPBOARDITEM_VALUE, true);

        // default to a sound, if none is already set
        r.RootKey := HKEY_CURRENT_USER;
        if not r.KeyExists('\AppEvents\Schemes\Apps\ArsClip\ArsClip_NewClipboardItem\.current') then begin
            SetAppEventKey('Schemes\Apps\' + AC_APPNAME +'\' + AC_NEWCLIPBOARDITEM+'\.current', '',
                'C:\Windows\Media\chimes.wav',true);
        end;
    end;
end;

procedure PlaySound_SetWavefile(fullname : string);
begin
    SetAppEventKey('Schemes\Apps\' + AC_APPNAME +'\' + AC_NEWCLIPBOARDITEM+'\.current', '',
            fullname, true);

end;

procedure PlaySound_Remove;
begin
    r.RootKey := HKEY_CURRENT_USER;
    if r.OpenKey('\AppEvents\EventLabels', false) then begin
        r.DeleteKey(AC_NEWCLIPBOARDITEM);
        r.CloseKey;
    end;

    r.RootKey := HKEY_CURRENT_USER;
    if r.OpenKey('\AppEvents\Schemes\Apps', false) then begin
        r.DeleteKey(AC_APPNAME);
        r.closekey
    end;
end;


initialization
begin
   r := TRegistry.Create();
   PlaySound_Remove;
end;

finalization
begin
    TFrmDebug.MeOnlyAppend('UnitSound', false);
    r.Free;
end;
end.
