unit UnitSpecialPaths;
{
    Purpose:
        Return the paths to special folders used throught the program

    Updates:
        Win9x compatibility added for GetCommonStartupPath
}

interface

type TSpecialPaths = class(TObject)
    private
        function GetPath(CLSIDL : word) : string;
    public
        function GetAppDataPath : string;
        function GetStartupPath : string;
        function GetCommonStartupPath : string;
        function GetAltStartupPath : string;
        function GetStartRightStartup : string;
        function GetProfiles : string;
        function GetMyDocs : string;
        function GetProgramFiles : string;
        function GetProgramFiles86 : string;
end;
var SpecialPaths : TSpecialPaths;

{////////////////////}
{//}implementation{//}
{////////////////////}

uses ShellAPI, ShlObj, Windows, Forms, SysUtils, UnitFrmDebug;

function TSpecialPaths.GetPath(CLSIDL : word) : string;
var p : PItemIDList;
    Path: array[0..MAX_PATH] of char;
begin
    SHGetSpecialFolderLocation(Application.Handle , CLSIDL, p);
    SHGetPathFromIDList(p, path);
    result := path;
end;


function TSpecialPaths.GetProfiles : string;
var s  : string;
    i : integer;
begin
    result := '';
    s :=  self.GetCommonStartupPath;
    i := Pos('All Users', s);
    if (i = 0) then EXIT;

    result := copy(s,1,i-1);
end;

function TSpecialPaths.GetStartupPath : string;
begin
    result := self.GetPath(CSIDL_STARTUP);
end;

function TSpecialPaths.GetAppDataPath: string;
begin
    result := self.GetPath(CSIDL_APPDATA);
end;

function TSpecialPaths.GetCommonStartupPath : string;
begin
    result := self.GetPath(CSIDL_COMMON_STARTUP);

    // win9x compatibility
    if (result = '') then begin
        result := self.GetPath(CSIDL_STARTUP);
    end;
end;

function TSpecialPaths.GetMyDocs: string;
begin
    result := self.GetPath(CSIDL_PERSONAL);
end;

function TSpecialPaths.GetAltStartupPath : string;
begin
    result := self.GetPath(CSIDL_ALTSTARTUP);
end;
function TSpecialPaths.GetStartRightStartup : string;
begin
    result := IncludeTrailingPathDelimiter(
         ExtractFilePath(Application.ExeName)) + 'Startup\';
end;


function TSpecialPaths.GetProgramFiles : string;
begin
    result := self.GetPath(CSIDL_PROGRAM_FILES);
end;
function TSpecialPaths.GetProgramFiles86 : string;
begin
    result := self.GetPath(CSIDL_PROGRAM_FILESX86);
end;


initialization
begin
    SpecialPaths := TSpecialPaths.Create;
end;

finalization
begin
    TFrmDebug.MeOnlyAppend('UnitSpecialPaths', false);
    FreeAndNil(specialPaths);
end;
end.
