unit UnitTextInspectorData;

interface

uses Generics.Collections, Winapi.Windows, Winapi.messages, UIAutomationClient_TLB;

type TControlPatternID = (
    UIA_TextPatternId = 10014,
    UIA_ValuePatternId = 10002,

    UIA_GridItemPatternId = 10007,
    UIA_GridPatternId = 10006,
    UIA_MultipleViewPatternId = 10008,
    UIA_SelectionPatternId = 10001,
    UIA_SelectionItemPatternId = 10010
);

type TPropertyID = (
    UIA_AutomationIdPropertyId = 30011, // only unique among sibling controls
    UIA_FullDescriptionPropertyId = 30159,
    UIA_ItemTypePropertyId = 300021,
    UIA_RuntimeIdPropertyId = 30000, // unique ID that changes on next run
    UIA_NativeWindowHandlePropertyId = 30020,
    UIA_ClassNamePropertyId = 30012,
    UIA_NamePropertyId = 30005,
    UIA_ControlTypePropertyId = 30003,
    UIA_IsMultipleViewPatternAvailablePropertyId = 30032,
    UIA_ValueValuePropertyId = 30045,
    UIA_BoundingRectanglePropertyId = 30001,
    UIA_ClickablePointPropertyId = 30014,

    UIA_IsContentElementPropertyId = 30017,
    UIA_IsControlElementPropertyId = 30016,
    UIA_IsKeyboardFocusablePropertyId = 30009,

    UIA_IsGridItemPatternAvailablePropertyId = 30029,
    UIA_IsGridPatternAvailablePropertyId = 30030,
    UIA_IsItemContainerPatternAvailablePropertyId = 30108,
    UIA_IsSelectionPatternAvailablePropertyId = 30037,
    UIA_IsSelectionItemPatternAvailablePropertyId = 30036
);

type UIA_ControlType = (
    UIA_UNKNOWN = 0,
    UIA_AppBarControlTypeId = 50040,
    UIA_ButtonControlTypeId = 50000,
    UIA_CalendarControlTypeId = 50001,
    UIA_CheckBoxControlTypeId = 50002,
    UIA_ComboBoxControlTypeId = 50003,
    UIA_CustomControlTypeId = 50025,
    UIA_DataGridControlTypeId = 50028,
    UIA_DataItemControlTypeId = 50029,
    UIA_DocumentControlTypeId = 50030,
    UIA_EditControlTypeId = 50004,
    UIA_GroupControlTypeId = 50026,
    UIA_HeaderControlTypeId = 50034,
    UIA_HeaderItemControlTypeId = 50035,
    UIA_HyperlinkControlTypeId = 50005,
    UIA_ImageControlTypeId = 50006,
    UIA_ListControlTypeId = 50008,
    UIA_ListItemControlTypeId = 50007,
    UIA_MenuBarControlTypeId = 50010,
    UIA_MenuControlTypeId = 50009,
    UIA_MenuItemControlTypeId = 50011,
    UIA_PaneControlTypeId = 50033,
    UIA_ProgressBarControlTypeId = 50012,
    UIA_RadioButtonControlTypeId = 50013,
    UIA_ScrollBarControlTypeId = 50014,
    UIA_SemanticZoomControlTypeId = 50039,
    UIA_SeparatorControlTypeId = 50038,
    UIA_SliderControlTypeId = 50015,
    UIA_SpinnerControlTypeId = 50016,
    UIA_SplitButtonControlTypeId = 50031,
    UIA_StatusBarControlTypeId = 50017,
    UIA_TabControlTypeId = 50018,
    UIA_TabItemControlTypeId = 50019,
    UIA_TableControlTypeId = 50036,
    UIA_TextControlTypeId = 50020,
    UIA_ThumbControlTypeId = 50027,
    UIA_TitleBarControlTypeId = 50037,
    UIA_ToolBarControlTypeId = 50021,
    UIA_ToolTipControlTypeId = 50022,
    UIA_TreeControlTypeId = 50023,
    UIA_TreeItemControlTypeId = 50024,
    UIA_WindowControlTypeId = 50032
);



type TTIControlType = (
    tctUnknown, tctEdit, tctListView, tctListBox, tctButton,
    tctComboBox, tctTreeView, tctHeader
);

Type TOwnerInfo = TPair<THandle, String>;
Type TOwnerList = TList<TOwnerInfo>;

type TUIAInfo = record
        Element : IUIAutomationElement;
        ElementUnderMouse : IUIAutomationElement;
        Path : string;
        Handle : THandle;
        Id : string;
        Rect : TRect;
        //UIA_RuntimeID : array of integer;
        Name : string;
        Classname : string;
        CType : UIA_ControlType;
        ParentCType : UIA_ControlType;
        IsFocusable : boolean;
end;
type
    TTICInfo = class(TObject)
    public
        Handle : THandle;
        MousePoint : TPoint;
        ControlType : TTIControlType;
        WindowRect : TRect;
        WindowText : string;
        SubRect : TRect;
        row, column : integer;

        ClassName : string;
        RealClassName : string;
        RootParent : THandle;
        ParentEXE : string;
        OwnerList : TOwnerList;

        UIA : TUIAinfo;
        constructor Create;
        destructor Destroy; override;

        class function ToString(ct : TTIControlType) : string; overload;
        class function ToString(ct : UIA_ControlType) : string; overload;
end;

implementation

uses Generics.Defaults, SysUtils, UnitFrmDebug;

constructor TTICInfo.Create;
begin
    OwnerList := TOwnerList.Create(TComparer<TOwnerInfo>.Construct(
    function (const L, R : TOwnerInfo) : Integer
    begin
        result := -1;
        if SameText(L.value, R.value) then begin
            result := 1;
        end;
    end)
   );
end;
destructor TTICInfo.Destroy;
var ownerinfo : TOwnerInfo;
begin
    // TPairs are records, no need to free
    FreeAndNil(OwnerList);
end;

class function TTICInfo.ToString(ct : TTIControlType) : string;
begin
    case ct of
    tctUnknown : result := 'Unknown';
    tctEdit: result := 'Edit';
    tctListView: result := 'ListView';
    tctListBox: result := 'ListBox';
    tctButton: result := 'Button';
    tctComboBox: result := 'ComboBox';
    tctTreeView: result := 'TreeView';
    tctHeader: result := 'Header';
    end;
end;
class function TTICInfo.ToString(ct : UIA_ControlType) : string;
begin
    result := 'Unknown';
    case ct of
    UIA_AppBarControlTypeId: result := 'UIA AppBar';
    UIA_ButtonControlTypeId: result := 'UIA Button';
    UIA_CalendarControlTypeId: result := 'UIA Calendar';
    UIA_CheckBoxControlTypeId: result := 'UIA Checkbox';
    UIA_ComboBoxControlTypeId: result := 'UIA ComboBox';
    UIA_CustomControlTypeId: result := 'UIA Custom';
    UIA_DataGridControlTypeId: result := 'UIA DataGrid';
    UIA_DataItemControlTypeId: result := 'UIA DataItem';
    UIA_DocumentControlTypeId: result := 'UIA Document';
    UIA_EditControlTypeId: result := 'UIA Edit';
    UIA_GroupControlTypeId: result := 'UIA Group';
    UIA_HeaderControlTypeId: result := 'UIA Header';
    UIA_HeaderItemControlTypeId: result := 'UIA HeaderItem';
    UIA_HyperlinkControlTypeId: result := 'UIA Hyperlink';
    UIA_ImageControlTypeId: result := 'UIA Image';
    UIA_ListControlTypeId: result := 'UIA List';
    UIA_ListItemControlTypeId: result := 'UIA ListItem';
    UIA_MenuBarControlTypeId: result := 'UIA MenuBar';
    UIA_MenuControlTypeId: result := 'UIA Menu';
    UIA_MenuItemControlTypeId: result := 'UIA MenuItem';
    UIA_PaneControlTypeId: result := 'UIA Pane';
    UIA_ProgressBarControlTypeId: result := 'UIA ProgressBar';
    UIA_RadioButtonControlTypeId: result := 'UIA RadioButton';
    UIA_ScrollBarControlTypeId: result := 'UIA ScrollBar';
    UIA_SemanticZoomControlTypeId: result := 'UIA Zoom';
    UIA_SeparatorControlTypeId: result := 'UIA Separator';
    UIA_SliderControlTypeId: result := 'UIA Slider';
    UIA_SpinnerControlTypeId: result := 'UIA Spinner';
    UIA_SplitButtonControlTypeId: result := 'UIA SplitButton';
    UIA_StatusBarControlTypeId: result := 'UIA StatusBar';
    UIA_TabItemControlTypeId: result := 'UIA TabItem';
    UIA_TabControlTypeId: result := 'UIA Tab';
    UIA_TableControlTypeId: result := 'UIA Table';
    UIA_TextControlTypeId: result := 'UIA Text';
    UIA_ThumbControlTypeId: result := 'UIA Thumb';
    UIA_TitleBarControlTypeId: result := 'UIA TitleBar';
    UIA_ToolBarControlTypeId: result := 'UIA ToolBar';
    UIA_ToolTipControlTypeId: result := 'UIA ToolTip';
    UIA_TreeControlTypeId: result := 'UIA Tree';
    UIA_TreeItemControlTypeId: result := 'UIA TreeItem';
    UIA_WindowControlTypeId: result := 'UIA Window';
end;
end;


initialization
finalization
begin
    TFrmDebug.MeOnlyAppend('UnitTextInspectorData', false);
end;

end.
