/*
nsWindows.Lite.nsh
by jiake
*/
!ifndef NSWINDOWS_INCLUDED
!define NSWINDOWS_INCLUDED
!verbose push
!verbose 3

!include Colors.nsh
!include nsDialogs.nsh
!include Util.nsh

!define HWND_TOP            0
!define HWND_BOTTOM         1
!define HWND_TOPMOST        -1
!define HWND_NOTOPMOST      -2

!define SWP_NOSIZE          0x0001
!define SWP_NOMOVE          0x0002
!define SWP_NOZORDER        0x0004
!define SWP_NOREDRAW        0x0008
!define SWP_NOACTIVATE      0x0010
!define SWP_FRAMECHANGED    0x0020
!define SWP_SHOWWINDOW      0x0040
!define SWP_HIDEWINDOW      0x0080
!define SWP_NOCOPYBITS      0x0100
!define SWP_NOOWNERZORDER   0x0200
!define SWP_NOSENDCHANGING  0x0400

!define SWP_DRAWFRAME       ${SWP_FRAMECHANGED}
!define SWP_NOREPOSITION    ${SWP_NOOWNERZORDER}

!define SWP_DEFERERASE      0x2000
!define SWP_ASYNCWINDOWPOS  0x4000

!define WS_OVERLAPPED       0x00000000
;!define WS_MAXIMIZEBOX      0x00010000
;!define WS_MINIMIZEBOX      0x00020000
!define WS_THICKFRAME       0x00040000
!define WS_SYSMENU          0x00080000
!define WS_DLGFRAME         0x00400000
;!define WS_BORDER           0x00800000
!define WS_CAPTION          0x00C00000
!define WS_MINIMIZE         0x20000000
!define WS_POPUP            0x80000000
!define WS_TILED            ${WS_OVERLAPPED}
!define WS_ICONIC           ${WS_MINIMIZE}
!define WS_SIZEBOX          ${WS_THICKFRAME}
!define WS_TILEDWINDOW      ${WS_OVERLAPPEDWINDOW}

!define WS_OVERLAPPEDWINDOW     ${WS_OVERLAPPED}|${WS_CAPTION}|${WS_SYSMENU}|${WS_THICKFRAME}|${WS_MINIMIZEBOX}|${WS_MAXIMIZEBOX}
!define WS_POPUPWINDOW          ${WS_POPUP}|${WS_BORDER}|${WS_SYSMENU}
!define WS_CHILDWINDOW          ${WS_CHILD}
!define WS_EX_PALETTEWINDOW     ${WS_EX_WINDOWEDGE}|${WS_EX_TOOLWINDOW}|${WS_EX_TOPMOST}
!define WS_EX_OVERLAPPEDWINDOW  ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}
!define WS_EX_LAYERED           0x00080000
!define WS_EX_NOINHERITLAYOUT   0x00100000
!define WS_EX_LAYOUTRTL         0x00400000
!define WS_EX_COMPOSITED        0x02000000
!define WS_EX_NOACTIVATE        0x08000000

!define __NSW_HLine_CLASS STATIC
!define __NSW_HLine_STYLE ${DEFAULT_STYLES}|${SS_ETCHEDHORZ}|${SS_SUNKEN}
!define __NSW_HLine_EXSTYLE ${WS_EX_TRANSPARENT}

!define __NSW_VLine_CLASS STATIC
!define __NSW_VLine_STYLE ${DEFAULT_STYLES}|${SS_ETCHEDVERT}|${SS_SUNKEN}
!define __NSW_VLine_EXSTYLE ${WS_EX_TRANSPARENT}

!define __NSW_Label_CLASS STATIC
!define __NSW_Label_STYLE ${DEFAULT_STYLES}|${SS_NOTIFY}
!define __NSW_Label_EXSTYLE ${WS_EX_TRANSPARENT}

!define __NSW_Icon_CLASS STATIC
!define __NSW_Icon_STYLE ${DEFAULT_STYLES}|${SS_ICON}|${SS_NOTIFY}
!define __NSW_Icon_EXSTYLE 0

!define __NSW_Bitmap_CLASS STATIC
!define __NSW_Bitmap_STYLE ${DEFAULT_STYLES}|${SS_BITMAP}|${SS_NOTIFY}
!define __NSW_Bitmap_EXSTYLE 0

!define __NSW_BrowseButton_CLASS BUTTON
!define __NSW_BrowseButton_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}
!define __NSW_BrowseButton_EXSTYLE 0

!define __NSW_Link_CLASS LINK
!define __NSW_Link_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${BS_OWNERDRAW}
!define __NSW_Link_EXSTYLE 0

!define __NSW_Button_CLASS BUTTON
!define __NSW_Button_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}
!define __NSW_Button_EXSTYLE 0

!define __NSW_GroupBox_CLASS BUTTON
!define __NSW_GroupBox_STYLE ${DEFAULT_STYLES}|${BS_GROUPBOX}
!define __NSW_GroupBox_EXSTYLE ${WS_EX_TRANSPARENT}

!define __NSW_CheckBox_CLASS BUTTON
!define __NSW_CheckBox_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${BS_TEXT}|${BS_VCENTER}|${BS_AUTOCHECKBOX}|${BS_MULTILINE}
!define __NSW_CheckBox_EXSTYLE 0

!define __NSW_RadioButton_CLASS BUTTON
!define __NSW_RadioButton_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${BS_TEXT}|${BS_VCENTER}|${BS_AUTORADIOBUTTON}|${BS_MULTILINE}
!define __NSW_RadioButton_EXSTYLE 0

!define __NSW_Text_CLASS EDIT
!define __NSW_Text_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${ES_AUTOHSCROLL}
!define __NSW_Text_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_ReadText_CLASS EDIT
!define __NSW_ReadText_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${ES_AUTOHSCROLL}|${ES_READONLY}
!define __NSW_ReadText_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_Memo_CLASS EDIT
!define __NSW_Memo_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${WS_VSCROLL}|${ES_AUTOHSCROLL}|${ES_MULTILINE}|${ES_WANTRETURN}
!define __NSW_Memo_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_Password_CLASS EDIT
!define __NSW_Password_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${ES_AUTOHSCROLL}|${ES_PASSWORD}
!define __NSW_Password_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_Number_CLASS EDIT
!define __NSW_Number_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${ES_AUTOHSCROLL}|${ES_NUMBER}
!define __NSW_Number_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_FileRequest_CLASS EDIT
!define __NSW_FileRequest_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${ES_AUTOHSCROLL}
!define __NSW_FileRequest_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_DirRequest_CLASS EDIT
!define __NSW_DirRequest_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${ES_AUTOHSCROLL}
!define __NSW_DirRequest_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_ComboBox_CLASS COMBOBOX
!define __NSW_ComboBox_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${WS_VSCROLL}|${WS_CLIPCHILDREN}|${CBS_AUTOHSCROLL}|${CBS_HASSTRINGS}|${CBS_DROPDOWN}
!define __NSW_ComboBox_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_DropList_CLASS COMBOBOX
!define __NSW_DropList_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${WS_VSCROLL}|${WS_CLIPCHILDREN}|${CBS_AUTOHSCROLL}|${CBS_HASSTRINGS}|${CBS_DROPDOWNLIST}
!define __NSW_DropList_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_ListBox_CLASS LISTBOX
!define __NSW_ListBox_STYLE ${DEFAULT_STYLES}|${WS_TABSTOP}|${WS_VSCROLL}|${LBS_DISABLENOSCROLL}|${LBS_HASSTRINGS}|${LBS_NOINTEGRALHEIGHT}|${LBS_NOTIFY}
!define __NSW_ListBox_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}

!define __NSW_ProgressBar_CLASS msctls_progress32
!define __NSW_ProgressBar_STYLE ${DEFAULT_STYLES}
!define __NSW_ProgressBar_EXSTYLE ${WS_EX_WINDOWEDGE}|${WS_EX_CLIENTEDGE}


!macro __NSW_DefineControl Name
  !define NSW_Create${Name} "nsWindows::CreateControl ${__NSW_${Name}_CLASS} ${__NSW_${Name}_STYLE} ${__NSW_${Name}_EXSTYLE}"
!macroend
!insertmacro __NSW_DefineControl HLine
!insertmacro __NSW_DefineControl VLine
!insertmacro __NSW_DefineControl Label
!insertmacro __NSW_DefineControl Icon
!insertmacro __NSW_DefineControl Bitmap
!insertmacro __NSW_DefineControl BrowseButton
!insertmacro __NSW_DefineControl Link
!insertmacro __NSW_DefineControl Button
!insertmacro __NSW_DefineControl GroupBox
!insertmacro __NSW_DefineControl CheckBox
!insertmacro __NSW_DefineControl RadioButton
!insertmacro __NSW_DefineControl Text
!insertmacro __NSW_DefineControl ReadText
!insertmacro __NSW_DefineControl Memo
!insertmacro __NSW_DefineControl Password
!insertmacro __NSW_DefineControl Number
!insertmacro __NSW_DefineControl FileRequest
!insertmacro __NSW_DefineControl DirRequest
!insertmacro __NSW_DefineControl ComboBox
!insertmacro __NSW_DefineControl DropList
!insertmacro __NSW_DefineControl ListBox
!insertmacro __NSW_DefineControl ProgressBar



!macro __NSW_OnControlEvent EVENT HWND FUNCTION
  Push ${HWND}
  Exch $0
  Push $1
  GetFunctionAddress $1 "${FUNCTION}"
  nsWindows::On${EVENT} $0 $1
  Pop $1
  Pop $0
!macroend

!macro __NSW_DefineControlCallback EVENT
  !define NSW_On${EVENT} `!insertmacro __NSW_OnControlEvent ${EVENT}`
!macroend

!macro __NSW_OnDialogEvent EVENT FUNCTION
  Push $0
  GetFunctionAddress $0 "${FUNCTION}"
  nsWindows::on${EVENT} $0
  Pop $0
!macroend

!macro __NSW_DefineDialogCallback EVENT
  !define NSW_On${EVENT} `!insertmacro __NSW_OnDialogEvent ${EVENT}`
!macroend

!insertmacro __NSW_DefineControlCallback Click
!insertmacro __NSW_DefineControlCallback Change
!insertmacro __NSW_DefineControlCallback Notify
!insertmacro __NSW_DefineControlCallback DropFiles
!insertmacro __NSW_DefineDialogCallback Back



!macro _NSW_CreateTimer FUNCTION INTERVAL
  Push $R0
  GetFunctionAddress $R0 "${FUNCTION}"
  nsWindows::CreateTimer $R0 "${INTERVAL}"
  Pop $R0
!macroend
!define NSW_CreateTimer `!insertmacro _NSW_CreateTimer`



!macro _NSW_KillTimer FUNCTION
  Push $R0
  GetFunctionAddress $R0 "${FUNCTION}"
  nsWindows::KillTimer $R0
  Pop $R0
!macroend
!define NSW_KillTimer `!insertmacro _NSW_KillTimer`



!macro __NSW_CenterWindow_Call HWPARENT HWND
  !verbose push
  !verbose 3
  Push ${HWPARENT}
  Push ${HWND}
  ${CallArtificialFunction} __NSW_CenterWindow
  !verbose pop
!macroend
!macro __NSW_CenterWindow
  System::Store SR2R1
  System::Call `*(i,i,i,i)i.R0`
  System::Call `user32::GetWindowRect(iR1,iR0)`
  System::Call `*$R0(i.R3,i.R4,i.R5,i.R6)`
  IntOp $R3 $R3 + $R5
  IntOp $R3 $R3 / 2
  IntOp $R4 $R4 + $R6
  IntOp $R4 $R4 / 2
  System::Call `user32::GetWindowRect(iR2,iR0)`
  System::Call `*$R0(i.R5,i.R6,i.R7,i.R8)`
  IntOp $R7 $R7 - $R5
  IntOp $R7 $R7 / 2
  IntOp $R8 $R8 - $R6
  IntOp $R8 $R8 / 2
  System::Free $R0
  System::Int64Op $R4 - $R8
  System::Int64Op $R3 - $R7
  System::Call `user32::SetWindowPos(iR2,i${HWND_TOP},is,is,i,i,i${SWP_NOSIZE})`
  System::Store L
!macroend
!define NSW_CenterWindow `!insertmacro __NSW_CenterWindow_Call`



!macro __NSW_GetWindowSize_Call CONTROL WIDTH HEIGHT
  Push ${CONTROL}
  ${CallArtificialFunction} __NSW_GetWindowSize
  Pop ${HEIGHT}
  Pop ${WIDTH}
!macroend
!macro __NSW_GetWindowSize
  System::Store S
  Exch $R0
  System::Alloc 16
  System::Call `user32::GetWindowRect(iR0,isR5)`
  System::Call `*$R5(i.R1,i.R2,i.R3,i.R4)`
  System::Free $R5
  Exch $R0
  System::Int64Op $R3 - $R1
  System::Int64Op $R4 - $R2
  System::Store L
!macroend
!define NSW_GetWindowSize `!insertmacro __NSW_GetWindowSize_Call`



!macro __NSW_SetWindowSize CONTROL WIDTH HEIGHT
  System::Call `user32::SetWindowPos(i${CONTROL},i0,i0,i0,i${WIDTH},i${HEIGHT},i${SWP_NOMOVE}|${SWP_NOZORDER})`
!macroend
!define NSW_SetWindowSize `!insertmacro __NSW_SetWindowSize`



!macro __NSW_SetWindowPos CONTROL LEFT TOP
  System::Call `user32::SetWindowPos(i${CONTROL},i0,i${LEFT},i${TOP},i0,i0,i${SWP_NOSIZE}|${SWP_NOZORDER})`
!macroend
!define NSW_SetWindowPos `!insertmacro __NSW_SetWindowPos`



!macro __NSW_SetWindowPosEx CONTROL hWndInsertAfter Left Top Width Height uFlags
  System::Call `user32::SetWindowPos(i${CONTROL},i${hWndInsertAfter},i${LEFT},i${TOP},i${WIDTH},i${HEIGHT},i${uFlags})`
!macroend
!define NSW_SetWindowPosEx `!insertmacro __NSW_SetWindowPosEx`



!macro __NSW_SetCtlText_Call HWND FILENAME
  Push ${HWND}
  Push `${FILENAME}`
  ${CallArtificialFunction} __NSW_SetCtlText
!macroend

!macro __NSW_SetCtlText
  Exch $R0
  Exch
  Exch $R1
  System::Store `P2P3P4P5`
  ClearErrors
  FileOpen $R2 $R1 r
  ${Unless} ${Errors}
    System::Call `kernel32::GetFileSize(iR2,*i)i.R3`
    IntOp $R3 $R3 + 1
    System::Alloc $R3
    Pop $R4
    ${If} $R4 U> 0
      System::Call `kernel32::ReadFile(iR2,iR4,iR3,*i.R5,i0)`
      IntCmp $R5 0 +2 +2
      System::Call `user32::SendMessage(iR0,i${WM_SETTEXT},i0,iR4)`
      System::Free $R4
    ${EndIf}
    FileClose $R2
  ${EndUnless}
  System::Store `R5R4R3R2R1R0`
!macroend
!define NSW_SetCtlText `!insertmacro __NSW_SetCtlText_Call`

!verbose pop
!endif
