(function(){
	function recv(str) {
		//console.log('[recv]' + str)
		var obj = JSON.parse(str);
		var id = obj.id;
		var cmd = obj.cmd;
		var p = obj.p;

		var tpl;
		if (cmd == 'init_widget') {
			if ($('#' + id).length == 0)
			{
				if (p.type == 'div') {
				tpl = _.template('<div id="<%= id %>" class="<%= className %>"></div>');
				} else if (p.type == 'iframe') {
					tpl = _.template('<iframe id="<%= id %>" class="<%= className %>"></iframe>');
				}
				var html = tpl({ id: id, className: QGWidgetClass});
				$QGContainer.append(html);
				$('#' + id).hide();
			}
		}

		var $el = $('#' + id);
		if ($el.length > 0) {
			//for some animation or logic
			$el.trigger(cmd, p);

			//finally sync show/hide/pos/size state with hall
			switch(obj.cmd) {
				case 'show_widget':
					$el.show();
					break;
				case 'hide_widget':
					$el.hide();
					break;
				case 'move_widget':
					$el.css({
						'left': p.x,
						'top': p.y
					});
					break;
				case 'resize_widget':
					$el.css({
						'width': p.width - ($el.outerWidth(true) - $el.width()),
						'height': p.height - ($el.outerHeight(true) - $el.height())
					});
					break;
				case 'load_widget':
					var type = $el.get(0).nodeName.toLowerCase();
					var onload = function() {
						send('widget_loaded', { id: id });
					};
					if (type == 'div') {
						// $('body').append($('<script/>', {
						// 	src: p.url,
						// 	onload: onload
						// }));
						var head = document.getElementsByTagName("body")[0];
					    var js = document.createElement("script");
					    js.type = "text/javascript";
					    js.src =  p.url;
					    js.onload = onload;
					    head.appendChild(js);
					} else if (type == 'iframe') {
						$el.on('load', function() {
							send('widget_loaded', { id: id });
						});
						$el.attr('src', p.url);
					}
					break;
				default:
					break;
			}
		}
	}

	function send(fn, p, ns, cb) {
		p = p || {};
		ns = ns || '';
		cb = cb || '';
		var str = JSON.stringify({ ns: ns, fn: fn, p: p, cb: cb});
		window.external.callHallApi(str);
		//console.log('[send]' + str);
	}

	function register(event, fn) {
		var param = {};
		param[event] = fn,
		send('register', param, 'common');
	}


	window.Communicator = {
		recv: recv,
		send: send,
		register: register
	}
})();


