/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLServerDDLBuilder
extends AbstractDDLBuilder {
    public SQLServerDDLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    protected String getAutoIncrementSQL(Property property) {
        return property.column + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")") + " identity(1,1) unique ";
    }

    @Override
    public String hasTableExists(Entity entity) {
        String hasTableExistsSQL = "select name from sysobjects where xtype='u' and name = '" + entity.tableName + "';";
        return hasTableExistsSQL;
    }

    @Override
    public String createTable(Entity entity) {
        StringBuilder builder = new StringBuilder("create table " + entity.escapeTableName + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                builder.append(this.getAutoIncrementSQL(property));
            } else {
                builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
                if (property.notNull) {
                    builder.append(" not null");
                }
                if (null != property.defaultValue) {
                    builder.append(" default '" + property.defaultValue + "'");
                }
                if (null != property.comment) {
                    builder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    builder.append(" check " + property.escapeCheck);
                }
            }
            builder.append(",");
        }
        if (this.quickDAOConfig.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            for (Property property : entity.foreignKeyProperties) {
                builder.append("foreign key(" + this.quickDAOConfig.databaseProvider.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                builder.append(this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.databaseProvider.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                builder.append(",");
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(");");
        if (null != entity.comment) {
            builder.append("EXEC sp_addextendedproperty 'MS_Description',N'" + entity.comment + "','SCHEMA','dbo','table',N'" + entity.tableName + "';");
        }
        for (Property property : entity.properties) {
            if (null == property.comment) continue;
            builder.append("EXEC sp_addextendedproperty 'MS_Description',N'" + property.comment + "','SCHEMA','dbo','table',N'" + entity.tableName + "','column',N'" + property.column + "';");
        }
        for (IndexField indexField : entity.indexFieldList) {
            builder.append(this.createIndex(indexField));
        }
        builder.append(";");
        return builder.toString();
    }

    @Override
    public String hasIndexExists(String tableName, String indexName) {
        String hasIndexExistsSQL = "select name from sys.indexes WHERE object_id=OBJECT_ID('" + tableName + "', N'U') and name = '" + indexName + "';";
        return hasIndexExistsSQL;
    }

    @Override
    public String dropIndex(String tableName, String indexName) {
        String dropIndexSQL = "drop index " + this.quickDAOConfig.databaseProvider.escape(tableName) + "." + this.quickDAOConfig.databaseProvider.escape(indexName) + ";";
        return dropIndexSQL;
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) throws SQLException {
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        HashMap<String, String> fieldTypeMapping = new HashMap<String, String>();
        fieldTypeMapping.put("byte", "TINYINT");
        fieldTypeMapping.put("java.lang.Byte", "TINYINT");
        fieldTypeMapping.put("[B", "BINARY");
        fieldTypeMapping.put("boolean", "TINYINT");
        fieldTypeMapping.put("java.lang.Boolean", "TINYINT");
        fieldTypeMapping.put("char", "TINYINT");
        fieldTypeMapping.put("java.lang.Character", "TINYINT");
        fieldTypeMapping.put("short", "SMALLINT");
        fieldTypeMapping.put("java.lang.Short", "SMALLINT");
        fieldTypeMapping.put("int", "INT");
        fieldTypeMapping.put("java.lang.Integer", "INTEGER(11)");
        fieldTypeMapping.put("float", "REAL");
        fieldTypeMapping.put("java.lang.Float", "REAL");
        fieldTypeMapping.put("long", "BIGINT");
        fieldTypeMapping.put("java.lang.Long", "BIGINT");
        fieldTypeMapping.put("double", "FLOAT");
        fieldTypeMapping.put("java.lang.Double", "FLOAT");
        fieldTypeMapping.put("java.lang.String", "VARCHAR(255)");
        fieldTypeMapping.put("java.util.Date", "DATETIME");
        fieldTypeMapping.put("java.sql.Date", "DATE");
        fieldTypeMapping.put("java.sql.Time", "TIME");
        fieldTypeMapping.put("java.sql.Timestamp", "TIMESTAMP");
        fieldTypeMapping.put("java.time.LocalDate", "DATE");
        fieldTypeMapping.put("java.time.LocalDateTime", "DATETIME");
        fieldTypeMapping.put("java.sql.Array", "");
        fieldTypeMapping.put("java.math.BigDecimal", "DECIMAL");
        fieldTypeMapping.put("java.sql.Blob", "BINARY");
        fieldTypeMapping.put("java.sql.Clob", "TEXT");
        fieldTypeMapping.put("java.sql.NClob", "TEXT");
        fieldTypeMapping.put("java.sql.Ref", "");
        fieldTypeMapping.put("java.net.URL", "");
        fieldTypeMapping.put("java.sql.RowId", "");
        fieldTypeMapping.put("java.sql.SQLXML", "");
        fieldTypeMapping.put("java.io.InputStream", "TEXT");
        fieldTypeMapping.put("java.io.Reader", "TEXT");
        return fieldTypeMapping;
    }

    @Override
    protected void getIndex(List<Entity> entityList) throws SQLException {
        for (Entity entity : entityList) {
            String getIndexSQL = "select i.is_unique,i.name,col.name col_name from sys.indexes i left join sys.index_columns ic on ic.object_id = i.object_id and ic.index_id = i.index_id left join (select * from sys.all_columns where object_id = object_id( '" + entity.tableName + "', N'U' )) col on ic.column_id = col.column_id where i.object_id = object_id('" + entity.tableName + "', N'U' ) and i.index_id > 0;";
            ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f", getIndexSQL);
            while (resultSet.next()) {
                IndexField indexField = new IndexField();
                indexField.indexType = resultSet.getBoolean("is_unique") ? IndexType.UNIQUE : IndexType.NORMAL;
                indexField.indexName = resultSet.getString("name");
                IndexField existIndexField = entity.indexFieldList.stream().filter(indexField1 -> indexField1.indexName.equals(indexField.indexName)).findFirst().orElse(null);
                if (null != existIndexField) {
                    existIndexField.columns.add(resultSet.getNString("col_name"));
                    continue;
                }
                indexField.columns.add(resultSet.getNString("col_name"));
                entity.indexFieldList.add(indexField);
            }
            resultSet.close();
        }
    }

    @Override
    protected void getEntityPropertyList(List<Entity> entityList) throws SQLException {
        String getEntityPropertyTypeListSQL = "select table_name, ordinal_position,column_name,data_type,is_nullable from information_schema.columns;";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f", getEntityPropertyTypeListSQL);
        block0: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                Property property = new Property();
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("data_type");
                property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                entity.properties.add(property);
                continue block0;
            }
        }
        resultSet.close();
        String getPropertyCommentList = "select b.name table_name, c.name, convert(varchar(255),a.value) value from sys.extended_properties a, sysobjects b, sys.columns c where a.major_id = b.id and c.object_id = b.id and c.column_id = a.minor_id;";
        resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u5b57\u6bb5\u6ce8\u91ca", getPropertyCommentList);
        block2: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                for (Property property : entity.properties) {
                    if (!property.column.equalsIgnoreCase(resultSet.getString("name"))) continue;
                    property.comment = resultSet.getString("value");
                    continue block2;
                }
                continue block2;
            }
        }
        resultSet.close();
    }

    @Override
    protected List<Entity> getEntityList() throws SQLException {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        String getEntityListSQL = "select name from sysobjects where xtype='u' order by name;";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5217\u8868", getEntityListSQL);
        while (resultSet.next()) {
            Entity entity = new Entity();
            entity.tableName = resultSet.getString("name");
            entityList.add(entity);
        }
        resultSet.close();
        String getEntityCommentSQL = "select so.name table_name, isnull(convert(varchar(255),value),'') comment from sys.extended_properties ex_p left join sys.sysobjects so on ex_p.major_id = so.id where ex_p.minor_id=0;";
        resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u6ce8\u91ca", getEntityCommentSQL);
        if (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                entity.comment = resultSet.getString("comment");
                break;
            }
        }
        resultSet.close();
        return entityList;
    }
}

