/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.DAOOperation;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.GenerateEntityFileOption;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.transaction.Transaction;
import cn.schoolwow.quickdao.transaction.TransactionInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDAOOperation
implements DAOOperation {
    Logger logger = LoggerFactory.getLogger(AbstractDAOOperation.class);
    private QuickDAOConfig quickDAOConfig;

    public AbstractDAOOperation(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public Transaction startTransaction() {
        try {
            Connection connection = this.quickDAOConfig.dataSource.getConnection();
            connection.setAutoCommit(false);
            TransactionInvocationHandler transactionInvocationHandler = new TransactionInvocationHandler(this.quickDAOConfig, connection);
            Transaction transactionProxy = (Transaction)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Transaction.class}, (InvocationHandler)transactionInvocationHandler);
            return transactionProxy;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void startTransaction(Consumer<Transaction> transactionConsumer) {
        Transaction transaction = this.startTransaction();
        try {
            transactionConsumer.accept(transaction);
            transaction.commit();
        }
        catch (SQLRuntimeException e) {
            transaction.rollback();
            throw e;
        }
        finally {
            transaction.endTransaction();
        }
    }

    @Override
    public boolean hasTable(Class entityClass) {
        Entity entity = this.quickDAOConfig.entityMap.get(entityClass.getName());
        return null != entity;
    }

    @Override
    public boolean hasTable(String tableName) {
        Collection<Entity> entityCollection = this.quickDAOConfig.entityMap.values();
        Entity entity = this.quickDAOConfig.dbEntityList.stream().filter(entity1 -> entity1.tableName.equalsIgnoreCase(tableName)).findFirst().orElse(null);
        return null != entity;
    }

    @Override
    public boolean hasColumn(String tableName, String column) {
        Entity entity = this.quickDAOConfig.dbEntityList.stream().filter(entity1 -> entity1.tableName.equalsIgnoreCase(tableName)).findFirst().orElse(null);
        if (null == entity) {
            return false;
        }
        return entity.properties.stream().anyMatch(property -> property.column.equalsIgnoreCase(column));
    }

    @Override
    public DataSource getDataSource() {
        return this.quickDAOConfig.dataSource;
    }

    @Override
    public Map<String, Entity> getEntityMap() {
        return this.quickDAOConfig.entityMap;
    }

    @Override
    public List<Entity> getDbEntityList() {
        return this.quickDAOConfig.dbEntityList;
    }

    @Override
    public Entity getEntity(Class clazz) {
        return this.quickDAOConfig.entityMap.values().stream().filter(entity -> entity.clazz.getName().equalsIgnoreCase(clazz.getName())).findFirst().orElse(null);
    }

    @Override
    public Entity getDbEntity(String tableName) {
        return this.quickDAOConfig.dbEntityList.stream().filter(entity -> entity.tableName.equalsIgnoreCase(tableName)).findFirst().orElse(null);
    }

    @Override
    public Property getProperty(Class clazz, String column) {
        Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728!\u5b9e\u4f53\u7c7b\u540d:" + clazz.getName());
        }
        Property property = entity.properties.stream().filter(property1 -> property1.column.equalsIgnoreCase(column)).findFirst().orElse(null);
        if (null == property) {
            throw new IllegalArgumentException("\u5217\u4e0d\u5b58\u5728!\u5b9e\u4f53\u7c7b\u540d:" + clazz.getName() + ",\u5b57\u6bb5\u540d:" + column);
        }
        return property;
    }

    @Override
    public Property getProperty(String tableName, String column) {
        Entity entity = this.quickDAOConfig.dbEntityList.stream().filter(entity1 -> entity1.tableName.equalsIgnoreCase(tableName)).findFirst().orElse(null);
        if (null == entity) {
            throw new IllegalArgumentException("\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        Property property = entity.properties.stream().filter(property1 -> property1.column.equalsIgnoreCase(column)).findFirst().orElse(null);
        if (null == property) {
            throw new IllegalArgumentException("\u5217\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName + ",\u5b57\u6bb5\u540d:" + column);
        }
        return property;
    }

    @Override
    public List<Property> getPropertyList(Class clazz) {
        Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728!\u5b9e\u4f53\u7c7b:" + clazz.getName());
        }
        return entity.properties;
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        Entity entity = this.quickDAOConfig.dbEntityList.stream().filter(entity1 -> entity1.tableName.equalsIgnoreCase(tableName)).findFirst().orElse(null);
        if (null == entity) {
            throw new IllegalArgumentException("\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        return entity.properties;
    }

    @Override
    public DatabaseProvider getDatabaseProvider() {
        return this.quickDAOConfig.databaseProvider;
    }

    @Override
    public QuickDAOConfig getQuickDAOConfig() {
        return this.quickDAOConfig;
    }

    @Override
    public void generateEntityFile(GenerateEntityFileOption generateEntityFileOption) {
        this.quickDAOConfig.entityHandler.generateEntityFile(generateEntityFileOption);
    }
}

