/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql.dcl;

import cn.schoolwow.quickdao.builder.dcl.AbstractDCLBuilder;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import cn.schoolwow.quickdao.dao.sql.dcl.DCLDAO;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.dcl.DataBaseUser;
import cn.schoolwow.quickdao.domain.dcl.GrantOption;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class AbstractDCLDAO
extends AbstractSQLDAO
implements DCLDAO {
    private AbstractDCLBuilder dclBuilder;

    public AbstractDCLDAO(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.dclBuilder = quickDAOConfig.databaseProvider.getDCLBuilderInstance(quickDAOConfig);
        this.sqlBuilder = this.dclBuilder;
    }

    @Override
    public List<String> getUserNameList() {
        String getUserNameListSQL = this.dclBuilder.getUserNameList();
        try {
            ResultSet resultSet = this.dclBuilder.connectionExecutor.executeQuery("\u83b7\u53d6\u7528\u6237\u5217\u8868", getUserNameListSQL);
            ArrayList<String> userNameList = new ArrayList<String>();
            while (resultSet.next()) {
                userNameList.add(resultSet.getString(1));
            }
            resultSet.close();
            return userNameList;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void createUser(DataBaseUser dataBaseUser) {
        String createUserSQL = this.dclBuilder.createUser(dataBaseUser);
        try {
            this.dclBuilder.connectionExecutor.executeUpdate("\u521b\u5efa\u7528\u6237", createUserSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void modifyPassword(String username, String newPassword) {
        String modifyPasswordSQL = this.dclBuilder.modifyPassword(username, newPassword);
        try {
            this.dclBuilder.connectionExecutor.executeUpdate("\u66f4\u6539\u5bc6\u7801", modifyPasswordSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void deleteUser(DataBaseUser dataBaseUser) {
        String deleteUserSQL = this.dclBuilder.deleteUser(dataBaseUser);
        try {
            this.dclBuilder.connectionExecutor.executeUpdate("\u5220\u9664\u7528\u6237", deleteUserSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void grant(GrantOption grantOption) {
        String grantSQL = this.dclBuilder.grant(grantOption);
        try {
            this.dclBuilder.connectionExecutor.executeUpdate("\u6570\u636e\u5e93\u6388\u6743", grantSQL);
            this.flushPrivileges();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void createUserAndGrant(GrantOption grantOption) {
        String createUserAndGrantSQL = this.dclBuilder.createUserAndGrant(grantOption);
        try {
            this.dclBuilder.connectionExecutor.executeUpdate("\u521b\u5efa\u7528\u6237\u5e76\u6388\u6743", createUserAndGrantSQL);
            this.flushPrivileges();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void revoke(GrantOption grantOption) {
        String revokeSQL = this.dclBuilder.revoke(grantOption);
        try {
            this.dclBuilder.connectionExecutor.executeUpdate("\u6536\u56de\u6743\u9650", revokeSQL);
            this.flushPrivileges();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void flushPrivileges() {
        String flushPrivilegesSQL = this.dclBuilder.flushPrivileges();
        try {
            this.dclBuilder.connectionExecutor.executeUpdate("\u5237\u65b0\u6743\u9650", flushPrivilegesSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

