/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql.ddl;

import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import cn.schoolwow.quickdao.dao.sql.ddl.DDLDAO;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractDDLDAO
extends AbstractSQLDAO
implements DDLDAO {
    private AbstractDDLBuilder ddlBuilder;

    public AbstractDDLDAO(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.ddlBuilder = quickDAOConfig.databaseProvider.getDDLBuilderInstance(quickDAOConfig);
        this.sqlBuilder = this.ddlBuilder;
    }

    @Override
    public boolean hasTableExists(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        boolean result = false;
        try {
            String hasTableExistsSQL = this.ddlBuilder.hasTableExists(entity);
            ResultSet resultSet = this.ddlBuilder.connectionExecutor.executeQuery("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728", hasTableExistsSQL);
            if (resultSet.next()) {
                result = true;
            }
            resultSet.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return result;
    }

    @Override
    public void create(Class clazz) {
        this.create(this.quickDAOConfig.getEntityByClassName(clazz.getName()));
    }

    @Override
    public void create(Entity entity) {
        try {
            String createTableSQL = this.ddlBuilder.createTable(entity);
            this.ddlBuilder.connectionExecutor.executeUpdate("\u751f\u6210\u65b0\u8868", createTableSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void dropTable(Class clazz) {
        this.dropTable(this.quickDAOConfig.getEntityByClassName((String)clazz.getName()).tableName);
    }

    @Override
    public void dropTable(String tableName) {
        try {
            String dropTableSQL = this.ddlBuilder.dropTable(tableName);
            this.ddlBuilder.connectionExecutor.executeUpdate("\u5220\u9664\u8868", dropTableSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void rebuild(Class clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        if (this.hasTableExists(clazz)) {
            this.dropTable(clazz);
        }
        this.create(clazz);
    }

    @Override
    public void rebuild(String tableName) {
        Entity entity = this.quickDAOConfig.dao.getDbEntity(tableName);
        if (null == entity) {
            throw new IllegalArgumentException("\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        this.dropTable(tableName);
        this.create(entity);
    }

    @Override
    public void createColumn(String tableName, Property property) {
        try {
            Entity entity = new Entity();
            entity.tableName = tableName;
            property.entity = entity;
            if (null != property.check) {
                if (!property.check.isEmpty() && !property.check.contains("(")) {
                    property.check = "(" + property.check + ")";
                }
                property.check = property.check.replace("#{" + property.name + "}", property.column);
                property.escapeCheck = property.check.replace(property.column, this.quickDAOConfig.databaseProvider.escape(property.column));
            }
            String createPropertySQL = this.ddlBuilder.createProperty(property);
            this.ddlBuilder.connectionExecutor.executeUpdate("\u65b0\u589e\u5217", createPropertySQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public String alterColumn(Property property) {
        try {
            String alterColumnSQL = this.ddlBuilder.alterColumn(property);
            this.ddlBuilder.connectionExecutor.executeUpdate("\u4fee\u6539\u5217", alterColumnSQL);
            return alterColumnSQL;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public Property dropColumn(String tableName, String column) {
        Entity dbEntity = this.quickDAOConfig.dbEntityList.stream().filter(entity -> entity.tableName.equals(tableName)).findFirst().orElse(null);
        if (null == dbEntity) {
            throw new IllegalArgumentException("\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        Property deleteProperty = dbEntity.properties.stream().filter(property -> property.column.equals(column)).findFirst().orElse(null);
        if (null == deleteProperty) {
            throw new IllegalArgumentException("\u5217\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName + ",\u5217\u540d:" + column);
        }
        try {
            String dropColumnSQL = this.ddlBuilder.dropColumn(deleteProperty);
            this.ddlBuilder.connectionExecutor.executeUpdate("\u5220\u9664\u5217", dropColumnSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return deleteProperty;
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        try {
            String hasIndexExistsSQL = this.ddlBuilder.hasIndexExists(tableName, indexName);
            ResultSet resultSet = this.ddlBuilder.connectionExecutor.executeQuery("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728", hasIndexExistsSQL);
            boolean result = false;
            if (resultSet.next()) {
                result = true;
            }
            resultSet.close();
            return result;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public boolean hasConstraintExists(String tableName, String indexName) {
        try {
            String hasConstraintExistsSQL = this.ddlBuilder.hasConstraintExists(tableName, indexName);
            ResultSet resultSet = this.ddlBuilder.connectionExecutor.executeQuery("\u5224\u65ad\u7ea6\u675f\u662f\u5426\u5b58\u5728", hasConstraintExistsSQL);
            boolean result = false;
            if (resultSet.next()) {
                result = true;
            }
            resultSet.close();
            return result;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void createIndex(IndexField indexField) {
        try {
            String createIndexSQL = this.ddlBuilder.createIndex(indexField);
            this.ddlBuilder.connectionExecutor.executeUpdate("\u521b\u5efa\u7d22\u5f15", createIndexSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        try {
            String dropIndexSQL = this.ddlBuilder.dropIndex(tableName, indexName);
            this.ddlBuilder.connectionExecutor.executeUpdate("\u5220\u9664\u7d22\u5f15", dropIndexSQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void createForeignKey(Property property) {
        try {
            String createForeignKeySQL = this.ddlBuilder.createForeignKey(property);
            String foreignKeyName = "FK_" + property.entity.tableName + "_" + property.foreignKey.field() + "_" + this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName + "_" + property.name;
            if (this.hasConstraintExists(property.entity.tableName, foreignKeyName)) {
                this.logger.warn("[\u5916\u952e\u7ea6\u675f\u5df2\u5b58\u5728]\u8868\u540d:{},\u5916\u952e\u7ea6\u675f\u540d:{}", (Object)property.entity.tableName, (Object)foreignKeyName);
                return;
            }
            this.ddlBuilder.connectionExecutor.executeUpdate("\u521b\u5efa\u5916\u952e", createForeignKeySQL);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) {
        try {
            this.ddlBuilder.enableForeignConstraintCheck(enable);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        return this.ddlBuilder.getTypeFieldMapping();
    }

    @Override
    public void synchonizedEntityAndDatabase() {
        this.refreshDbEntityList();
        Collection<Entity> entityList = this.quickDAOConfig.entityMap.values();
        ArrayList<Entity> newEntityList = new ArrayList<Entity>();
        HashMap<Entity, Entity> updateEntityMap = new HashMap<Entity, Entity>();
        for (Entity entity : entityList) {
            Entity dbEntity = this.quickDAOConfig.dbEntityList.stream().filter(entity1 -> entity1.tableName.equalsIgnoreCase(entity.tableName)).findFirst().orElse(null);
            if (null == dbEntity) {
                newEntityList.add(entity);
                continue;
            }
            updateEntityMap.put(entity, dbEntity);
        }
        if (this.quickDAOConfig.autoCreateTable) {
            for (Entity entity : newEntityList) {
                this.create(entity);
            }
        }
        if (this.quickDAOConfig.autoCreateProperty) {
            for (Map.Entry entry : updateEntityMap.entrySet()) {
                List<Property> propertyList = ((Entity)entry.getKey()).properties;
                for (Property property : propertyList) {
                    Property targetProperty = ((Entity)entry.getValue()).properties.stream().filter(property1 -> property1.column.equalsIgnoreCase(property.column)).findFirst().orElse(null);
                    if (null == targetProperty) {
                        if (((Entity)entry.getValue()).properties.stream().noneMatch(property1 -> property1.column.equalsIgnoreCase(property.column))) {
                            this.createColumn(property.entity.tableName, property);
                        }
                        if (null == property.foreignKey || !this.quickDAOConfig.openForeignKey) continue;
                        this.createForeignKey(property);
                        continue;
                    }
                    if (!this.quickDAOConfig.autoUpdateProperty || !this.compareProperty(property, targetProperty) || property.id) continue;
                    String alterColumnSQL = this.alterColumn(property);
                    this.logger.info("[\u66f4\u65b0\u6570\u636e\u5e93\u5217]\u8868\u540d:{},\u5b57\u6bb5:{},\u5b9e\u4f53\u7c7b\u578b:{},\u6570\u636e\u5e93\u5b57\u6bb5\u7c7b\u578b:{},\u6267\u884cSQL:{}", ((Entity)entry.getKey()).tableName, property.column, property.columnType + (null == property.length ? "" : "(" + property.length + ")"), targetProperty.columnType + (null == targetProperty.length ? "" : "(" + targetProperty.length + ")"), alterColumnSQL);
                }
                List<IndexField> indexFieldList = ((Entity)entry.getKey()).indexFieldList;
                for (IndexField indexField : indexFieldList) {
                    if (!((Entity)entry.getValue()).indexFieldList.stream().noneMatch(indexField1 -> indexField1.indexName.equalsIgnoreCase(indexField.indexName))) continue;
                    this.createIndex(indexField);
                }
            }
        }
        if (this.quickDAOConfig.autoDeleteTableAndProperty) {
            this.deleteDatabaseTableAndColumn();
        }
        if (null == this.quickDAOConfig.visualTableList || this.quickDAOConfig.visualTableList.isEmpty()) {
            this.quickDAOConfig.visualTableList = this.ddlBuilder.getVirtualEntity();
        }
    }

    @Override
    public void refreshDbEntityList() {
        try {
            this.ddlBuilder.getDatabaseName();
            List<Entity> dbEntityList = this.ddlBuilder.getDatabaseEntity();
            for (Entity dbEntity : dbEntityList) {
                dbEntity.escapeTableName = this.quickDAOConfig.databaseProvider.escape(dbEntity.tableName);
                dbEntity.clazz = JSONObject.class;
                for (Property property : dbEntity.properties) {
                    Class type;
                    if (null != this.quickDAOConfig.columnTypeMapping && null != (type = this.quickDAOConfig.columnTypeMapping.columnMappingType(property))) {
                        property.className = type.getName();
                    }
                    property.entity = dbEntity;
                }
            }
            this.quickDAOConfig.dbEntityList = dbEntityList;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    private void deleteDatabaseTableAndColumn() {
        Collection<Entity> entityList = this.quickDAOConfig.entityMap.values();
        if (entityList.isEmpty()) {
            this.logger.debug("[\u626b\u63cf\u5b9e\u4f53\u7c7b\u5217\u8868\u4e3a\u7a7a]");
            return;
        }
        ArrayList<String> dropTableNameList = new ArrayList<String>();
        ArrayList<Property> dropPropertyList = new ArrayList<Property>();
        for (Entity dbEntity : this.quickDAOConfig.dbEntityList) {
            Entity sourceEntity = null;
            for (Entity entityItem : entityList) {
                if (!dbEntity.tableName.equalsIgnoreCase(entityItem.tableName)) continue;
                sourceEntity = entityItem;
                break;
            }
            if (null == sourceEntity) {
                dropTableNameList.add(dbEntity.tableName);
                continue;
            }
            for (Property dbProperty : dbEntity.properties) {
                Property sourceEntityProperty = null;
                for (Property propertyItem : sourceEntity.properties) {
                    if (!dbProperty.column.equalsIgnoreCase(propertyItem.column)) continue;
                    sourceEntityProperty = propertyItem;
                    break;
                }
                if (null != sourceEntityProperty) continue;
                dropPropertyList.add(dbProperty);
            }
        }
        for (String dropTableName : dropTableNameList) {
            this.logger.info("[\u540c\u6b65\u5b9e\u4f53\u7c7b]\u5220\u9664\u8868:{}", (Object)dropTableName);
            this.dropTable(dropTableName);
        }
        for (Property dropProperty : dropPropertyList) {
            this.logger.info("[\u540c\u6b65\u5b9e\u4f53\u7c7b]\u5220\u9664\u8868\u5b57\u6bb5.\u8868\u540d:{},\u5b57\u6bb5\u540d:{}", (Object)dropProperty.entity.tableName, (Object)dropProperty.column);
            this.dropColumn(dropProperty.entity.tableName, dropProperty.column);
        }
    }

    private boolean compareProperty(Property source, Property target) {
        String targetColumnType;
        String sourceColumnType = this.cleanColumnType(source.columnType);
        if (!sourceColumnType.equals(targetColumnType = this.cleanColumnType(target.columnType))) {
            return true;
        }
        if (null != source.length) {
            return !source.length.equals(target.length);
        }
        if (null != target.length) {
            return !target.length.equals(source.length);
        }
        return false;
    }

    private String cleanColumnType(String columnType) {
        if (columnType.contains("(") && columnType.contains(")")) {
            columnType = columnType.substring(0, columnType.indexOf("("));
        }
        return columnType.toLowerCase();
    }
}

