/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain;

import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionExecutor {
    private Logger logger = LoggerFactory.getLogger(ConnectionExecutor.class);
    public int count = -1;
    public Connection connection;
    public QuickDAOConfig quickDAOConfig;

    public ConnectionExecutor(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    public ConnectionExecutorItem newConnectionExecutorItem(String name, String sql) throws SQLException {
        this.logger.trace("[\u65b0\u5efa\u67e5\u8be2SQL]SQL:{}", (Object)sql);
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
            ConnectionExecutorItem connectionExecutorItem = new ConnectionExecutorItem();
            connectionExecutorItem.name = name;
            connectionExecutorItem.sql = sql;
            connectionExecutorItem.preparedStatement = preparedStatement;
            return connectionExecutorItem;
        }
        catch (SQLException e) {
            this.logger.warn("[SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25]\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)name, (Object)sql);
            throw e;
        }
    }

    public ConnectionExecutorItem newConnectionExecutorItemWithReturnGeneratedKeys(String name, String sql) throws SQLException {
        this.logger.trace("[\u65b0\u5efa\u67e5\u8be2SQL]SQL:{}", (Object)sql);
        try {
            PreparedStatement preparedStatement = sql.startsWith("insert ") ? this.connection.prepareStatement(sql, 1) : this.connection.prepareStatement(sql);
            ConnectionExecutorItem connectionExecutorItem = new ConnectionExecutorItem();
            connectionExecutorItem.name = name;
            connectionExecutorItem.sql = sql;
            connectionExecutorItem.preparedStatement = preparedStatement;
            return connectionExecutorItem;
        }
        catch (SQLException e) {
            this.logger.warn("[SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25]\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)name, (Object)sql);
            throw e;
        }
    }

    public ResultSet executeQuery(String name, String sql) throws SQLException {
        return this.executeQuery(this.newConnectionExecutorItem(name, sql));
    }

    public ResultSet executeQuery(ConnectionExecutorItem connectionExecutorItem) throws SQLException {
        try {
            long startTime = System.currentTimeMillis();
            ResultSet resultSet = connectionExecutorItem.preparedStatement.executeQuery();
            long endTime = System.currentTimeMillis();
            if (!"\u83b7\u53d6\u884c\u6570".equals(connectionExecutorItem.name)) {
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                if (stackTraceElements[3].getClassName().startsWith("cn.schoolwow.quickdao.builder.ddl")) {
                    if (this.count >= 0) {
                        this.logger.trace("[{}]\u884c\u6570:{},\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", connectionExecutorItem.name, this.count, endTime - startTime, connectionExecutorItem.sql);
                        this.count = -1;
                    } else {
                        this.logger.trace("[{}]\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", connectionExecutorItem.name, endTime - startTime, connectionExecutorItem.sql);
                    }
                } else if (this.count >= 0) {
                    this.logger.debug("[{}]\u884c\u6570:{},\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", connectionExecutorItem.name, this.count, endTime - startTime, connectionExecutorItem.sql);
                    this.count = -1;
                } else {
                    this.logger.debug("[{}]\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", connectionExecutorItem.name, endTime - startTime, connectionExecutorItem.sql);
                }
            }
            return resultSet;
        }
        catch (SQLException e) {
            this.logger.warn("[SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25]\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)connectionExecutorItem.name, (Object)connectionExecutorItem.sql);
            throw e;
        }
    }

    public int executeUpdate(String name, final String sql) throws SQLException {
        this.logger.trace("[\u65b0\u5efa\u66f4\u65b0SQL]SQL:{}", (Object)sql);
        if (sql.contains(";")) {
            return this.executeUpdate(name, sql, new UpdateExecutor(){

                @Override
                public int executeUpdate() throws SQLException {
                    StringTokenizer st = new StringTokenizer(sql, ";");
                    int effect = 0;
                    while (st.hasMoreTokens()) {
                        effect += ConnectionExecutor.this.connection.createStatement().executeUpdate(st.nextToken());
                    }
                    return effect;
                }
            });
        }
        return this.executeUpdate(name, sql, new UpdateExecutor(){

            @Override
            public int executeUpdate() throws SQLException {
                PreparedStatement preparedStatement = ConnectionExecutor.this.connection.prepareStatement(sql);
                int effect = preparedStatement.executeUpdate();
                preparedStatement.close();
                return effect;
            }
        });
    }

    public int executeUpdate(final ConnectionExecutorItem connectionExecutorItem) throws SQLException {
        return this.executeUpdate(connectionExecutorItem.name, connectionExecutorItem.sql, new UpdateExecutor(){

            @Override
            public int executeUpdate() throws SQLException {
                int effect = connectionExecutorItem.preparedStatement.executeUpdate();
                return effect;
            }
        });
    }

    public int executeBatchUpdate(final ConnectionExecutorItem connectionExecutorItem) throws SQLException {
        return this.executeUpdate(connectionExecutorItem.name, connectionExecutorItem.sql, new UpdateExecutor(){

            @Override
            public int executeUpdate() throws SQLException {
                int[] batches = connectionExecutorItem.preparedStatement.executeBatch();
                int effect = 0;
                block4: for (int batch : batches) {
                    switch (batch) {
                        case -2: {
                            ++effect;
                            continue block4;
                        }
                        case -3: {
                            continue block4;
                        }
                        default: {
                            effect += batch;
                        }
                    }
                }
                ConnectionExecutor.this.connection.commit();
                connectionExecutorItem.preparedStatement.clearBatch();
                connectionExecutorItem.preparedStatement.close();
                return effect;
            }
        });
    }

    private int executeUpdate(String name, String sql, UpdateExecutor updateExecutor) throws SQLException {
        try {
            long startTime = System.currentTimeMillis();
            int effect = updateExecutor.executeUpdate();
            long endTime = System.currentTimeMillis();
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements[3].getClassName().startsWith("cn.schoolwow.quickdao.builder.ddl")) {
                this.logger.trace("[{}]\u8017\u65f6:{}ms,\u5f71\u54cd\u884c\u6570:{},\u6267\u884cSQL:{}", name, endTime - startTime, effect, sql);
            } else {
                this.logger.debug("[{}]\u8017\u65f6:{}ms,\u5f71\u54cd\u884c\u6570:{},\u6267\u884cSQL:{}", name, endTime - startTime, effect, sql);
            }
            return effect;
        }
        catch (SQLException e) {
            this.logger.warn("[SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25]\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)name, (Object)sql);
            throw e;
        }
    }

    private static interface UpdateExecutor {
        public int executeUpdate() throws SQLException;
    }
}

