/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.ColumnTypeMapping;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.generator.IDGenerator;
import cn.schoolwow.quickdao.domain.generator.SnowflakeIdGenerator;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickdao.handler.EntityHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.sql.DataSource;

public class QuickDAOConfig {
    public DataSource dataSource;
    public Map<String, String> packageNameMap = new HashMap<String, String>();
    public Map<Class, String> entityClassMap = new HashMap<Class, String>();
    public List<Class> ignoreClassList;
    public List<String> ignorePackageNameList;
    public Predicate<Class> predicate;
    public boolean openForeignKey;
    public boolean autoCreateTable = true;
    public boolean autoCreateProperty = true;
    public boolean autoUpdateProperty;
    public boolean autoDeleteTableAndProperty;
    public IdStrategy idStrategy;
    public IDGenerator idGenerator = new SnowflakeIdGenerator();
    public String databaseName;
    public String charset;
    public String engine;
    public ColumnTypeMapping columnTypeMapping;
    public int perBatchCommit = 1000;
    public Function<Property, Object> insertColumnValueFunction;
    public Function<Property, Object> updateColumnValueFunction;
    public volatile boolean lazyLoad;
    public volatile boolean initialized;
    public final Map<String, Entity> entityMap = new HashMap<String, Entity>();
    public final ConcurrentHashMap<String, String> sqlCache = new ConcurrentHashMap();
    public volatile List<Entity> dbEntityList;
    public List<Entity> visualTableList;
    public DatabaseProvider databaseProvider;
    public DAO dao;
    public EntityHandler entityHandler;
    public ReentrantLock sqliteLock = new ReentrantLock();

    public Entity getEntityByClassName(String className) {
        if (this.entityMap.containsKey(className)) {
            return this.entityMap.get(className);
        }
        throw new IllegalArgumentException("\u626b\u63cf\u5b9e\u4f53\u7c7b\u5217\u8868\u4e2d\u4e0d\u5305\u542b\u8be5\u5b9e\u4f53\u7c7b!\u7c7b\u540d:" + className);
    }

    public Entity getDbEntityByTableName(String tableName) {
        for (Entity entity : this.dbEntityList) {
            if (!entity.tableName.equals(tableName)) continue;
            return entity;
        }
        throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
    }

    public String toString() {
        return "\n{\n\u6570\u636e\u6e90:" + this.dataSource + "\n\u5f85\u626b\u63cf\u5305\u540d:" + this.packageNameMap + "\n\u5f85\u626b\u63cf\u7c7b:" + this.entityClassMap + "\n\u8981\u5ffd\u7565\u7684\u7c7b:" + this.ignoreClassList + "\n\u8981\u5ffd\u7565\u7684\u5305\u540d:" + this.ignorePackageNameList + "\n\u51fd\u6570\u5f0f\u63a5\u53e3\u8fc7\u6ee4\u7c7b:" + this.predicate + "\n\u662f\u5426\u5f00\u542f\u5916\u952e\u7ea6\u675f:" + this.openForeignKey + "\n\u662f\u5426\u81ea\u52a8\u5efa\u8868:" + this.autoCreateTable + "\n\u662f\u5426\u81ea\u52a8\u65b0\u589e\u5c5e\u6027:" + this.autoCreateProperty + "\n\u5168\u5c40Id\u751f\u6210\u7b56\u7565:" + (Object)((Object)this.idStrategy) + "\n\u5168\u5c40Id\u751f\u6210\u5668\u5b9e\u4f8b:" + this.idGenerator + "\n\u5f53\u524d\u6570\u636e\u5e93\u540d\u79f0:" + this.databaseName + "\n\u5168\u5c40\u8868\u7f16\u7801\u683c\u5f0f:" + this.charset + "\n\u5168\u5c40\u8868\u5f15\u64ce:" + this.engine + "\n\u5168\u5c40\u7c7b\u578b\u8f6c\u6362:" + this.columnTypeMapping + "\n\u626b\u63cf\u540e\u7684\u5b9e\u4f53\u7c7b\u4fe1\u606f\u4e2a\u6570:" + this.entityMap.size() + "\nSQL\u8bed\u53e5\u7f13\u5b58\u4e2a\u6570:" + this.sqlCache.size() + "\n\u6570\u636e\u5e93\u83b7\u53d6\u7684\u8868\u4e2a\u6570:" + (null == this.dbEntityList ? "\u65e0\u4fe1\u606f" : Integer.valueOf(this.dbEntityList.size())) + "\n\u865a\u62df\u8868(dual\u7b49):" + this.visualTableList + "\n\u6570\u636e\u5e93\u7c7b\u578b:" + this.databaseProvider.name() + "\n}\n";
    }
}

