/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.query;

import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.query.CompositQuery;
import cn.schoolwow.quickdao.query.condition.AbstractCondition;
import cn.schoolwow.quickdao.query.condition.Condition;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;

public class AbstractCompositQuery
implements CompositQuery {
    private QuickDAOConfig quickDAOConfig;

    public AbstractCompositQuery(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public <T> Condition<T> query(Class<T> clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u5b9e\u4f53\u7c7b:" + clazz.getName() + "!");
        }
        return this.query(entity);
    }

    @Override
    public Condition query(String tableName) {
        for (Entity entity : this.quickDAOConfig.dbEntityList) {
            if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
            return this.query(entity);
        }
        for (Entity entity : this.quickDAOConfig.visualTableList) {
            if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
            return this.query(entity);
        }
        throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u8868\u540d:" + tableName + "!");
    }

    @Override
    public Condition query(Condition condition) {
        Query fromQuery = ((AbstractCondition)condition).query;
        condition.execute();
        Entity entity = new Entity();
        entity.clazz = JSONObject.class;
        entity.properties = new ArrayList<Property>();
        AbstractCondition condition1 = (AbstractCondition)this.query(entity);
        condition1.query.fromQuery = fromQuery;
        String tableName = condition1.query.dqlBuilder.getArraySQL(fromQuery).toString();
        entity.escapeTableName = entity.tableName = "( " + tableName + ")";
        return condition1;
    }

    private Condition query(Entity entity) {
        Query query = new Query();
        query.entity = entity;
        query.dqlBuilder = this.quickDAOConfig.databaseProvider.getDQLBuilderInstance(this.quickDAOConfig);
        query.quickDAOConfig = this.quickDAOConfig;
        return this.quickDAOConfig.databaseProvider.getConditionInstance(query);
    }
}

