/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.query.response;

import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.query.response.Response;
import cn.schoolwow.quickdao.util.ResponseUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractResponse<T>
implements Response<T> {
    private Logger logger = LoggerFactory.getLogger(AbstractResponse.class);
    public Query query;

    public AbstractResponse(Query query) {
        this.query = query;
    }

    @Override
    public long count() {
        long count = 0L;
        this.query.parameterIndex = 1;
        try {
            ConnectionExecutorItem connectionExecutorItem = this.query.dqlBuilder.count(this.query);
            ResultSet resultSet = this.query.dqlBuilder.connectionExecutor.executeQuery(connectionExecutorItem);
            if (resultSet.next()) {
                count = resultSet.getLong(1);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        this.query.parameterIndex = 1;
        return count;
    }

    @Override
    public int insert() {
        int effect = 0;
        try {
            if (null != this.query.insertArray) {
                ConnectionExecutorItem[] connectionExecutorItems = this.query.dqlBuilder.insertArray(this.query);
                for (int i = 0; i < connectionExecutorItems.length; ++i) {
                    if ((effect += this.query.dqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItems[i])) > 0) {
                        this.setGeneratedKeys(this.query.insertArray.getJSONObject(i), connectionExecutorItems[i].preparedStatement);
                    }
                    connectionExecutorItems[i].preparedStatement.close();
                }
                this.query.dqlBuilder.connectionExecutor.connection.commit();
            } else {
                ConnectionExecutorItem connectionExecutorItem = this.query.dqlBuilder.insert(this.query);
                effect = this.query.dqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
                if (effect > 0 && null != this.query.insertValue) {
                    this.setGeneratedKeys(this.query.insertValue, connectionExecutorItem.preparedStatement);
                }
                connectionExecutorItem.preparedStatement.close();
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return effect;
    }

    @Override
    public int insertBatch() {
        int effect = 0;
        int perBatchCommit = Math.max(this.query.perBatchCommit, this.query.quickDAOConfig.perBatchCommit);
        try {
            this.query.dqlBuilder.connectionExecutor.connection.setAutoCommit(false);
            for (int i = 0; i < this.query.insertArray.size(); i += perBatchCommit) {
                ConnectionExecutorItem connectionExecutorItem = this.query.dqlBuilder.insertArrayBatch(this.query, i, Math.min(i + perBatchCommit, this.query.insertArray.size()));
                effect = this.query.dqlBuilder.connectionExecutor.executeBatchUpdate(connectionExecutorItem);
            }
            return effect;
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public int update() {
        int count = 0;
        try {
            ConnectionExecutorItem connectionExecutorItem = this.query.dqlBuilder.update(this.query);
            count = this.query.dqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
            connectionExecutorItem.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return count;
    }

    @Override
    public int delete() {
        int count = 0;
        try {
            ConnectionExecutorItem connectionExecutorItem = this.query.dqlBuilder.delete(this.query);
            count = this.query.dqlBuilder.connectionExecutor.executeUpdate(connectionExecutorItem);
            connectionExecutorItem.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return count;
    }

    @Override
    public T getOne() {
        List list = this.getList();
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public <E> E getOne(Class<E> clazz) {
        List<E> list = this.getList(clazz);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <E> E getSingleColumn(Class<E> clazz) {
        List<E> list = this.getSingleColumnList(clazz);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <E> List<E> getSingleColumnList(Class<E> clazz) {
        try {
            JSONArray array = new JSONArray(this.query.dqlBuilder.getResultSetRowCount(this.query));
            ConnectionExecutorItem connectionExecutorItem = this.query.dqlBuilder.getArray(this.query);
            ResultSet resultSet = this.query.dqlBuilder.connectionExecutor.executeQuery(connectionExecutorItem);
            while (resultSet.next()) {
                array.add(resultSet.getObject(1));
            }
            resultSet.close();
            connectionExecutorItem.preparedStatement.close();
            return array.toJavaList(clazz);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public List getList() {
        return this.getList(this.query.entity.clazz);
    }

    @Override
    public <E> List<E> getList(Class<E> clazz) {
        return this.getArray().toJavaList(clazz);
    }

    @Override
    public PageVo<T> getPagingList() {
        return this.getPagingList(this.query.entity.clazz);
    }

    @Override
    public <E> PageVo<E> getPagingList(Class<E> clazz) {
        this.query.pageVo.setList(this.getArray().toJavaList(clazz));
        this.setPageVo();
        return this.query.pageVo;
    }

    @Override
    public JSONObject getObject() {
        JSONArray array = this.getArray();
        if (null == array || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0);
    }

    @Override
    public JSONArray getArray() {
        JSONArray array = null;
        try {
            array = new JSONArray(this.query.dqlBuilder.getResultSetRowCount(this.query));
            ConnectionExecutorItem connectionExecutorItem = this.query.dqlBuilder.getArray(this.query);
            ResultSet resultSet = this.query.dqlBuilder.connectionExecutor.executeQuery(connectionExecutorItem);
            if (this.query.column.length() > 0) {
                if (null == this.query.columnTypeMapping) {
                    this.query.columnTypeMapping = this.query.quickDAOConfig.columnTypeMapping;
                }
                ResultSetMetaData metaData = resultSet.getMetaData();
                Property[] properties = new Property[metaData.getColumnCount()];
                for (int i = 1; i <= properties.length; ++i) {
                    Class type;
                    properties[i - 1] = new Property();
                    properties[i - 1].columnLabel = metaData.getColumnLabel(i);
                    properties[i - 1].column = metaData.getColumnName(i);
                    properties[i - 1].columnType = metaData.getColumnTypeName(i);
                    properties[i - 1].className = metaData.getColumnClassName(i);
                    if (null == this.query.columnTypeMapping || null == (type = this.query.columnTypeMapping.columnMappingType(properties[i - 1]))) continue;
                    properties[i - 1].clazz = type;
                }
                while (resultSet.next()) {
                    JSONObject o = new JSONObject(true);
                    for (int i = 1; i <= properties.length; ++i) {
                        if (null == properties[i - 1].clazz) {
                            o.put(properties[i - 1].columnLabel, resultSet.getObject(i));
                            continue;
                        }
                        o.put(properties[i - 1].columnLabel, resultSet.getObject(i, properties[i - 1].clazz));
                    }
                    array.add(o);
                }
            } else {
                while (resultSet.next()) {
                    JSONObject o = ResponseUtil.getObject(this.query.entity, this.query.excludeColumnList, this.query.tableAliasName, resultSet, this.query.quickDAOConfig.databaseProvider);
                    if (this.query.compositField) {
                        this.getCompositObject(resultSet, o);
                    }
                    array.add(o);
                }
            }
            resultSet.close();
            connectionExecutorItem.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return array;
    }

    public String toString() {
        return this.query.toString();
    }

    private void getCompositObject(ResultSet resultSet, JSONObject o) throws SQLException {
        for (SubQuery subQuery : this.query.subQueryList) {
            if (null == subQuery.compositField || subQuery.compositField.isEmpty()) continue;
            JSONObject subObject = ResponseUtil.getObject(subQuery.entity, subQuery.excludeColumnList, subQuery.tableAliasName, resultSet, this.query.quickDAOConfig.databaseProvider);
            SubQuery parentSubQuery = subQuery.parentSubQuery;
            if (parentSubQuery == null) {
                o.put(subQuery.compositField, (Object)subObject);
                continue;
            }
            ArrayList<String> fieldNames = new ArrayList<String>();
            while (parentSubQuery != null) {
                fieldNames.add(parentSubQuery.compositField);
                parentSubQuery = parentSubQuery.parentSubQuery;
            }
            JSONObject oo = o;
            for (int i = fieldNames.size() - 1; i >= 0; --i) {
                oo = oo.getJSONObject((String)fieldNames.get(i));
            }
            oo.put(subQuery.compositField, (Object)subObject);
        }
    }

    private void setPageVo() {
        if (this.query.pageVo == null) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528page()\u51fd\u6570!");
        }
        this.query.pageVo.setTotalSize(this.count());
        this.query.pageVo.setTotalPage((int)(this.query.pageVo.getTotalSize() / (long)this.query.pageVo.getPageSize() + (long)(this.query.pageVo.getTotalSize() % (long)this.query.pageVo.getPageSize() > 0L ? 1 : 0)));
        this.query.pageVo.setHasMore(this.query.pageVo.getCurrentPage() < this.query.pageVo.getTotalPage());
    }

    private void setGeneratedKeys(JSONObject insertObject, PreparedStatement preparedStatement) throws SQLException {
        ResultSet rs = null;
        rs = preparedStatement.getGeneratedKeys();
        if (rs.next()) {
            insertObject.put("generatedKeys", (Object)rs.getString(1));
        }
        rs.close();
    }
}

