/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns;

import cn.schoolwow.quickdns.config.QuickDNSConfig;
import cn.schoolwow.quickdns.config.QuickDNSServerConfig;
import cn.schoolwow.quickdns.domain.QuickDNSConfigProperties;
import cn.schoolwow.quickdns.install.InstallServerCommand;
import cn.schoolwow.quickdns.util.CommonUtil;
import cn.schoolwow.quickserver.QuickServer;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static Logger logger = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) throws IOException, ParseException, InterruptedException {
        Options options = Application.getOptions();
        DefaultParser commandLineParser = new DefaultParser();
        CommandLine commandLine = commandLineParser.parse(options, args, true);
        Path configFilePath = Paths.get(System.getProperty("user.dir") + "/config.json", new String[0]);
        if (Files.notExists(configFilePath, new LinkOption[0])) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            int port = 54321;
            for (int i = 0; i < 100 && CommonUtil.hasPortUsed("0.0.0.0", port); ++i) {
                ++port;
            }
            if (commandLine.hasOption("p")) {
                port = Integer.parseInt(commandLine.getOptionValue("p"));
            }
            InstallServerCommand.startInstallServer(port, countDownLatch);
            countDownLatch.await();
        }
        Application.readConfigFile();
        QuickServer quickServer = QuickServer.newInstance().port(QuickDNSServerConfig.quickDNSConfigProperties.webListenPort).register(QuickDNSConfig.class).keepAlive(false);
        String mode = System.getProperty("mode");
        if ("dev".equalsIgnoreCase(mode)) {
            quickServer.staticResourcePath(System.getProperty("user.dir") + "/src/main/resources/static/quickdns");
        } else {
            quickServer.staticResourcePathPrefix("/static/quickdns");
        }
        quickServer.start();
    }

    public static void readConfigFile() throws IOException {
        Path configFilePath = Paths.get(System.getProperty("user.dir") + "/config.json", new String[0]);
        if (Files.notExists(configFilePath, new LinkOption[0])) {
            logger.warn("[\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728]{}", (Object)configFilePath);
            return;
        }
        logger.info("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6]\u8def\u5f84:{}", (Object)configFilePath);
        String content = new String(Files.readAllBytes(configFilePath), StandardCharsets.UTF_8);
        QuickDNSServerConfig.quickDNSConfigProperties = JSON.parseObject(content).toJavaObject(QuickDNSConfigProperties.class);
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("help", "show help");
        options.addOption(Option.builder("i").argName("install mode").longOpt("install").desc("start install mode").build());
        options.addOption(Option.builder("p").argName("install listen port").hasArg(true).type(Integer.class).longOpt("port").desc("specify install listen port").build());
        options.addOption(Option.builder("v").argName("version").longOpt("version").desc("current version").build());
        return options;
    }
}

