/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.controller;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdns.dns.DNSHandler;
import cn.schoolwow.quickdns.entity.DNSBlockFile;
import cn.schoolwow.quickdns.service.DNSBlockFileService;
import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.controller.annotation.RequestBody;
import cn.schoolwow.quickserver.controller.annotation.RequestMapping;
import cn.schoolwow.quickserver.controller.annotation.RequestParam;
import cn.schoolwow.quickserver.controller.annotation.RestController;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Component;

@Component
@RestController
@RequestMapping(value="/blockFile")
@DependsOn(value={"DNSServer"})
public class DNSBlockFileController {
    @Resource
    private DAO dao;
    @Resource
    private DNSBlockFileService dnsBlockFileService;

    @PostConstruct
    public void postConstruct() throws IOException {
        List<DNSBlockFile> dnsBlockFileList = this.dao.query(DNSBlockFile.class).addQuery("enable", 1).execute().getList();
        for (DNSBlockFile dnsBlockFile : dnsBlockFileList) {
            this.dnsBlockFileService.scheduleDNSBlockFileCronTask(dnsBlockFile);
        }
    }

    @RequestMapping(value="/list")
    public JSONObject list(@RequestParam(name="page", required=false, defaultValue="1") int page, @RequestParam(name="pageSize", required=false, defaultValue="10") int pageSize) {
        Condition<DNSBlockFile> condition = this.dao.query(DNSBlockFile.class).page(page, pageSize).orderByDesc("createdTime");
        PageVo<DNSBlockFile> dnsBlockFilePageVo = condition.execute().getPagingList();
        JSONObject o = new JSONObject();
        o.put("list", (Object)dnsBlockFilePageVo.getList());
        o.put("total", (Object)dnsBlockFilePageVo.getTotalSize());
        return o;
    }

    @RequestMapping(value="/create", method={RequestMethod.POST})
    public DNSBlockFile create(@RequestBody DNSBlockFile dnsBlockFile) throws IOException {
        CronExpression.parse(dnsBlockFile.getCron());
        QuickHttp.connect(dnsBlockFile.getUrl()).execute();
        this.dao.insert(dnsBlockFile);
        return dnsBlockFile;
    }

    @RequestMapping(value="/update", method={RequestMethod.POST})
    public DNSBlockFile update(@RequestBody DNSBlockFile dnsBlockFile) throws IOException {
        CronExpression.parse(dnsBlockFile.getCron());
        this.dao.updatePartColumn(dnsBlockFile, "cron");
        return dnsBlockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value="/enable", method={RequestMethod.GET})
    public void enableDNSFileBlock(@RequestParam(name="id") long id, @RequestParam(name="enable") int enable) throws IOException {
        DNSBlockFile dnsBlockFile = this.dao.fetch(DNSBlockFile.class, id);
        if (null == dnsBlockFile) {
            throw new IllegalArgumentException("\u8bf7\u6c42DNS\u5c4f\u853d\u8bb0\u5f55\u4e0d\u5b58\u5728!id:" + id);
        }
        dnsBlockFile.setEnable(enable);
        if (dnsBlockFile.getEnable() > 0) {
            this.dnsBlockFileService.scheduleDNSBlockFileCronTask(dnsBlockFile);
        } else {
            this.dnsBlockFileService.cancelDNSBlockFileCronTask(dnsBlockFile);
            Map<String, List<String>> map = DNSHandler.dnsBlockCache;
            synchronized (map) {
                DNSHandler.dnsBlockCache.remove(dnsBlockFile.getUrl());
            }
        }
        this.dao.update(dnsBlockFile);
    }

    @RequestMapping(value="/manualUpdate", method={RequestMethod.GET})
    public int manualUpdate(@RequestParam(name="id") long id) throws IOException {
        DNSBlockFile dnsBlockFile = this.dao.fetch(DNSBlockFile.class, id);
        if (null == dnsBlockFile) {
            throw new IllegalArgumentException("\u8bf7\u6c42DNS\u5c4f\u853d\u8bb0\u5f55\u4e0d\u5b58\u5728!id:" + id);
        }
        if (dnsBlockFile.getEnable() == 0) {
            throw new IllegalArgumentException("\u8bf7\u5148\u542f\u7528\u8be5\u8bb0\u5f55\u540e\u518d\u8fdb\u884c\u66f4\u65b0!");
        }
        this.dnsBlockFileService.updateDNSBlockFileCache(dnsBlockFile);
        this.dao.update(dnsBlockFile);
        return dnsBlockFile.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value="/delete", method={RequestMethod.POST})
    public int delete(@RequestParam(name="id") String id) {
        List<Object> urls = new ArrayList<String>();
        int effect = 0;
        if (id.contains(",")) {
            Condition<DNSBlockFile> condition = this.dao.query(DNSBlockFile.class).addInQuery("id", id);
            urls = condition.clone().addColumn("url").execute().getSingleColumnList(String.class);
            effect = condition.execute().delete();
        } else {
            DNSBlockFile dnsBlockFile = this.dao.fetch(DNSBlockFile.class, Long.parseLong(id));
            urls.add(dnsBlockFile.getUrl());
            effect = this.dao.delete(DNSBlockFile.class, Long.parseLong(id));
        }
        Map<String, List<String>> map = DNSHandler.dnsBlockCache;
        synchronized (map) {
            for (String string : urls) {
                DNSHandler.dnsBlockCache.remove(string);
            }
        }
        return effect;
    }
}

