/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.controller;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdns.dns.DNSHandler;
import cn.schoolwow.quickdns.dns.domain.DNSPacket;
import cn.schoolwow.quickdns.dns.domain.DNSRequest;
import cn.schoolwow.quickdns.domain.DNSHandleRequest;
import cn.schoolwow.quickdns.domain.DNSHandleResponse;
import cn.schoolwow.quickdns.entity.QueryRecord;
import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.controller.annotation.RequestBody;
import cn.schoolwow.quickserver.controller.annotation.RequestMapping;
import cn.schoolwow.quickserver.controller.annotation.RequestParam;
import cn.schoolwow.quickserver.controller.annotation.RestController;
import cn.schoolwow.quickserver.request.HttpRequest;
import cn.schoolwow.quickserver.response.HttpResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@RestController
@RequestMapping(value="/dns-query")
public class DNSOverHttpsController {
    private Logger logger = LoggerFactory.getLogger(DNSOverHttpsController.class);
    @Resource
    private DNSHandler dnsHandler;
    @Resource
    private DAO dao;

    @RequestMapping(value="", method={RequestMethod.GET})
    public byte[] getDNSQuery(@RequestParam(name="dns") String dns, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        dns = new String(Base64.getDecoder().decode(dns), StandardCharsets.UTF_8);
        return this.handleDNSOverHttp(dns, httpRequest, httpResponse);
    }

    @RequestMapping(value="", method={RequestMethod.POST})
    public byte[] postDNSQuery(@RequestBody String dns, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        return this.handleDNSOverHttp(dns, httpRequest, httpResponse);
    }

    private byte[] handleDNSOverHttp(String dns, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        byte[] dnsRequestBytes = dns.getBytes(StandardCharsets.UTF_8);
        DNSRequest dnsRequest = DNSPacket.readDNSRequest(dnsRequestBytes);
        this.logger.info("[\u63a5\u6536\u5230DNS\u67e5\u8be2\u8bf7\u6c42]\u8bf7\u6c42\u65b9\u5f0f:DoH,\u95ee\u9898:{},\u5934\u90e8:{}", (Object)Arrays.toString(dnsRequest.questions), (Object)dnsRequest.header);
        dnsRequest.header.authorityResourceRecordCount = 0;
        dnsRequest.header.additionalResourceRecordCount = 0;
        DNSHandleRequest dnsHandleRequest = new DNSHandleRequest();
        dnsHandleRequest.dnsRequest = dnsRequest;
        dnsHandleRequest.requestIp = httpRequest.ip();
        DNSHandleResponse dnsHandleResponse = this.dnsHandler.handleDNS(dnsHandleRequest);
        for (QueryRecord queryRecord : dnsHandleResponse.queryRecordList) {
            queryRecord.setRequestType(1);
        }
        this.dao.insertIgnore(dnsHandleResponse.queryRecordList);
        if (dnsHandleResponse.dnsResponse.answers.size() > 0) {
            httpResponse.setHeader("Cache-Control", "max-age=" + dnsHandleResponse.dnsResponse.answers.get((int)0).TTL);
        }
        httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpResponse.setHeader("Header", "strict-transport-security");
        httpResponse.setContentType("application/dns-message");
        byte[] bytes = DNSPacket.writeDNSResponse(dnsHandleResponse.dnsResponse);
        return bytes;
    }
}

