/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.controller;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdns.dns.DNSServerUtil;
import cn.schoolwow.quickdns.entity.DNSRecord;
import cn.schoolwow.quickdns.util.ValidateUtil;
import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.controller.annotation.RequestBody;
import cn.schoolwow.quickserver.controller.annotation.RequestMapping;
import cn.schoolwow.quickserver.controller.annotation.RequestParam;
import cn.schoolwow.quickserver.controller.annotation.RequestPart;
import cn.schoolwow.quickserver.controller.annotation.RestController;
import cn.schoolwow.quickserver.domain.MultipartFile;
import cn.schoolwow.quickserver.response.HttpResponse;
import cn.schoolwow.quickserver.response.HttpStatus;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@RestController
@RequestMapping(value="/record")
public class DNSRecordController {
    @Resource
    private DAO dao;

    @RequestMapping(value="/list")
    public JSONObject list(@RequestParam(name="type", required=false, defaultValue="") String type, @RequestParam(name="host", required=false, defaultValue="") String host, @RequestParam(name="value", required=false, defaultValue="") String value, @RequestParam(name="page", required=false, defaultValue="1") int page, @RequestParam(name="pageSize", required=false, defaultValue="10") int pageSize) {
        Condition<DNSRecord> condition = this.dao.query(DNSRecord.class).page(page, pageSize).orderByDesc("createdTime");
        if (!type.isEmpty()) {
            condition.addQuery("type", type);
        }
        if (!host.isEmpty()) {
            condition.addLikeQuery("host", "%" + host + "%");
        }
        if (!value.isEmpty()) {
            condition.addLikeQuery("value", "%" + value + "%");
        }
        PageVo<DNSRecord> dnsRecordPageVo = condition.execute().getPagingList();
        JSONObject o = new JSONObject();
        o.put("list", (Object)dnsRecordPageVo.getList());
        o.put("total", (Object)dnsRecordPageVo.getTotalSize());
        return o;
    }

    @RequestMapping(value="/create", method={RequestMethod.POST})
    public DNSRecord create(@RequestBody DNSRecord dnsRecord) {
        ValidateUtil.validateDNSRecord(dnsRecord);
        if (!dnsRecord.getValue().startsWith("{") && dnsRecord.getValue().contains(",")) {
            String[] values;
            ArrayList<DNSRecord> dnsRecordList = new ArrayList<DNSRecord>();
            for (String value : values = dnsRecord.getValue().split(",")) {
                DNSRecord subDNSRecord = new DNSRecord();
                BeanUtils.copyProperties(dnsRecord, subDNSRecord);
                subDNSRecord.setValue(value);
                if ("PTR".equalsIgnoreCase(dnsRecord.getType())) {
                    subDNSRecord.setValue(DNSServerUtil.reversePTR(value));
                }
                dnsRecordList.add(subDNSRecord);
            }
            this.dao.insertIgnore(dnsRecordList);
        } else {
            if ("PTR".equalsIgnoreCase(dnsRecord.getType())) {
                dnsRecord.setValue(DNSServerUtil.reversePTR(dnsRecord.getValue()));
            }
            this.dao.insert(dnsRecord);
        }
        return dnsRecord;
    }

    @RequestMapping(value="/update", method={RequestMethod.POST})
    public DNSRecord update(@RequestBody DNSRecord dnsRecord) {
        this.dao.update(dnsRecord);
        return dnsRecord;
    }

    @RequestMapping(value="/delete", method={RequestMethod.POST})
    public int delete(@RequestParam(name="id") String id) {
        int effect = 0;
        effect = id.contains(",") ? this.dao.query(DNSRecord.class).addInQuery("id", id).execute().delete() : this.dao.delete(DNSRecord.class, Long.parseLong(id));
        return effect;
    }

    @RequestMapping(value="/exportAsJSON", method={RequestMethod.GET})
    public void exportAsJSON(@RequestParam(name="ids", required=false) String ids, HttpResponse httpResponse) throws IOException {
        ArrayList<DNSRecord> dnsRecordList = new ArrayList<DNSRecord>();
        if (null != ids && !ids.isEmpty()) {
            dnsRecordList.addAll(this.dao.query(DNSRecord.class).addInQuery("id", ids).execute().getList());
        } else {
            dnsRecordList.addAll(this.dao.query(DNSRecord.class).execute().getList());
        }
        httpResponse.status(HttpStatus.OK);
        httpResponse.setHeader("Content-Disposition", "attachment; filename=\"QuickDNS_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss")) + ".json\"");
        httpResponse.setHeader("Content-Type", "application/octet-stream");
        httpResponse.getOutputStream().write(JSON.toJSONString(dnsRecordList).getBytes(StandardCharsets.UTF_8));
    }

    @RequestMapping(value="/importAsJSON", method={RequestMethod.POST})
    public String importAsJSON(@RequestPart(name="file") MultipartFile multipartFile) throws IOException {
        byte[] bytes = multipartFile.bytes;
        String content = new String(bytes, StandardCharsets.UTF_8);
        JSONArray array = JSON.parseArray(content);
        int effect = this.dao.insertIgnore(array.toJavaList(DNSRecord.class));
        return effect + "";
    }
}

