/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdns.controller;

import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.domain.PageVo;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdns.entity.QueryRecord;
import cn.schoolwow.quickserver.controller.RequestMethod;
import cn.schoolwow.quickserver.controller.annotation.RequestMapping;
import cn.schoolwow.quickserver.controller.annotation.RequestParam;
import cn.schoolwow.quickserver.controller.annotation.RestController;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
@RestController
@RequestMapping(value="/query")
public class QueryRecordController {
    @Resource
    private DAO dao;

    @RequestMapping(value="/list", method={RequestMethod.GET})
    public JSONObject list(@RequestParam(name="requestIp", required=false, defaultValue="") String requestIp, @RequestParam(name="type", required=false, defaultValue="") String type, @RequestParam(name="host", required=false, defaultValue="") String host, @RequestParam(name="rcode", required=false, defaultValue="") Integer rcode, @RequestParam(name="handleType", required=false, defaultValue="") Integer handleType, @RequestParam(name="requestType", required=false, defaultValue="") Integer requestType, @RequestParam(name="answer", required=false, defaultValue="") String answer, @RequestParam(name="page", required=false, defaultValue="1") int page, @RequestParam(name="pageSize", required=false, defaultValue="10") int pageSize) {
        Condition<QueryRecord> condition = this.dao.query(QueryRecord.class).page(page, pageSize).compositField().orderByDesc("queryTime");
        if (!requestIp.isEmpty()) {
            condition.addLikeQuery("requestIp", "%" + requestIp + "%");
        }
        if (!type.isEmpty()) {
            condition.addQuery("type", type);
        }
        if (!host.isEmpty()) {
            condition.addLikeQuery("host", "%" + host + "%");
        }
        if (null != rcode && rcode >= 0) {
            condition.addQuery("rcode", rcode);
        }
        if (null != handleType && handleType >= 0) {
            condition.addQuery("handleType", handleType);
        }
        if (null != requestType && requestType >= 0) {
            condition.addQuery("requestType", requestType);
        }
        if (!answer.isEmpty()) {
            condition.addLikeQuery("answer", "%" + answer + "%");
        }
        PageVo<QueryRecord> queryRecordPageVo = condition.execute().getPagingList();
        JSONObject o = new JSONObject();
        o.put("list", (Object)queryRecordPageVo.getList());
        o.put("total", (Object)queryRecordPageVo.getTotalSize());
        return o;
    }
}

